/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.ds.aho_corasick;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kr.co.shineware.ds.aho_corasick.FindContext;
import kr.co.shineware.ds.aho_corasick.model.AhoCorasickNode;

public class AhoCorasickDictionary<V> {
    private AhoCorasickNode<V> root = new AhoCorasickNode();

    public AhoCorasickDictionary() {
        this.root.setDepth(0);
    }

    public void save(String filename) {
        this.root.save(filename);
    }

    public void load(String filename) {
        this.root.load(filename);
    }

    public void save(File file) {
        this.root.save(file);
    }

    public void load(File file) {
        this.root.load(file);
    }

    public void load(InputStream inputStream) {
        this.root.load(inputStream);
    }

    public void put(String keys, V value) {
        this.put(keys.toCharArray(), value);
    }

    private void put(char[] keys, V value) {
        AhoCorasickNode<V> currentNode = this.root;
        for (int i = 0; i < keys.length; ++i) {
            char key = keys[i];
            AhoCorasickNode<V>[] children = currentNode.getChildren();
            if (children == null) {
                children = new AhoCorasickNode[1];
                AhoCorasickNode<V> initNode = new AhoCorasickNode<V>();
                initNode.setParent(currentNode);
                initNode.setDepth(i + 1);
                initNode.setKey(key);
                children[0] = initNode;
                currentNode.setChildren(children);
                currentNode = currentNode.getChildren()[0];
                continue;
            }
            int idx = this.retrieveNode(children, key);
            if (idx == -1) {
                int head = 0;
                int tail = children.length - 1;
                idx = 0;
                while (head <= tail) {
                    idx = (head + tail) / 2;
                    if (children[idx].getKey() < key) {
                        head = idx + 1;
                        continue;
                    }
                    if (children[idx].getKey() > key) {
                        tail = idx - 1;
                        continue;
                    }
                    if (children[idx].getKey() != key) continue;
                }
                AhoCorasickNode[] newArray = new AhoCorasickNode[children.length + 1];
                System.arraycopy(children, 0, newArray, 0, head);
                newArray[head] = new AhoCorasickNode();
                newArray[head].setParent(currentNode);
                newArray[head].setDepth(i + 1);
                newArray[head].setKey(key);
                System.arraycopy(children, head, newArray, head + 1, children.length - head);
                currentNode.setChildren(newArray);
                idx = head;
            }
            currentNode = currentNode.getChildren()[idx];
        }
        currentNode.setValue(value);
    }

    private int retrieveNode(AhoCorasickNode<V>[] children, char key) {
        int head = 0;
        int tail = children.length - 1;
        int idx = 0;
        while (head <= tail) {
            idx = (head + tail) / 2;
            if (children[idx].getKey() < key) {
                head = idx + 1;
                continue;
            }
            if (children[idx].getKey() > key) {
                tail = idx - 1;
                continue;
            }
            if (children[idx].getKey() != key) continue;
            return idx;
        }
        return -1;
    }

    public V getValue(String keys) {
        return this.getValue(keys.toCharArray());
    }

    public V getValue(char[] keys) {
        AhoCorasickNode<V> node = this.root;
        for (int i = 0; i < keys.length; ++i) {
            char key = keys[i];
            AhoCorasickNode<V>[] children = node.getChildren();
            if (children == null) {
                return null;
            }
            int idx = this.retrieveNode(children, key);
            if (idx == -1) {
                return null;
            }
            node = children[idx];
        }
        return node.getValue();
    }

    public boolean hasChild(char[] keys) {
        AhoCorasickNode<V> node = this.root;
        for (int i = 0; i < keys.length; ++i) {
            char key = keys[i];
            AhoCorasickNode<V>[] children = node.getChildren();
            if (children == null) {
                return false;
            }
            int idx = this.retrieveNode(children, key);
            if (idx == -1) {
                return false;
            }
            node = children[idx];
        }
        return node.getChildren() != null;
    }

    public Map<String, V> get(FindContext<V> context, char key) {
        HashMap<String, V> resultMap;
        block7: {
            int idx;
            AhoCorasickNode<V>[] children;
            resultMap = new HashMap<String, V>();
            while (true) {
                if ((children = context.getCurrentChildren()) == null) {
                    AhoCorasickNode<V> currentNode = context.getCurrentFailNode();
                    if (currentNode == null) {
                        return new HashMap();
                    }
                    context.setCurrentNode(currentNode);
                    continue;
                }
                idx = this.retrieveNode(children, key);
                if (idx != -1) break;
                if (context.getCurrentNode() != this.root) {
                    context.setCurrentNode(context.getCurrentFailNode());
                    continue;
                }
                break block7;
                break;
            }
            AhoCorasickNode<V> childNode = children[idx];
            if (childNode.getValue() != null) {
                resultMap.put(this.getKeyFromNode(childNode), childNode.getValue());
            }
            while (childNode.getFailNode() != null) {
                if (childNode.getFailNode().getValue() != null) {
                    resultMap.put(this.getKeyFromNode(childNode.getFailNode()), childNode.getFailNode().getValue());
                }
                childNode = childNode.getFailNode();
            }
            context.setCurrentNode(children[idx]);
        }
        return resultMap;
    }

    private String getKeyFromNode(AhoCorasickNode<V> childNode) {
        String key = "";
        for (AhoCorasickNode<V> currentNode = childNode; currentNode != this.root; currentNode = currentNode.getParent()) {
            key = currentNode.getKey() + key;
        }
        return key;
    }

    public FindContext<V> newFindContext() {
        return new FindContext<V>(this.root);
    }

    public Map<String, V> get(String keys) {
        return this.get(this.newFindContext(), keys);
    }

    public Map<String, V> get(char[] keys) {
        return this.get(this.newFindContext(), keys);
    }

    public Map<String, V> get(char key) {
        return this.get(this.newFindContext(), key);
    }

    public Map<String, V> get(FindContext<V> context, String keys) {
        return this.get(context, keys.toCharArray());
    }

    public Map<String, V> get(FindContext<V> context, char[] keys) {
        HashMap<String, V> resultMap = new HashMap<String, V>();
        for (int i = 0; i < keys.length; ++i) {
            resultMap.putAll(this.get(context, keys[i]));
        }
        return resultMap;
    }

    private void printNodeAndValue(AhoCorasickNode<V> childNode) {
        String key = "";
        for (AhoCorasickNode<V> currentNode = childNode; currentNode != this.root; currentNode = currentNode.getParent()) {
            key = currentNode.getKey() + key;
        }
        System.out.println("key : " + key);
        System.out.println("value : " + childNode.getValue());
    }

    public void buildFailLink() {
        AhoCorasickNode currentNode = this.root;
        LinkedList<AhoCorasickNode<V>> queue = new LinkedList<AhoCorasickNode<V>>();
        queue.clear();
        queue.add(currentNode);
        while (!queue.isEmpty()) {
            currentNode = (AhoCorasickNode)queue.remove();
            this.linkFailNode(currentNode);
            if (currentNode.getChildren() == null || currentNode.getChildren().length == 0) continue;
            this.insertNodes(queue, currentNode.getChildren());
        }
    }

    private void linkFailNode(AhoCorasickNode<V> currentNode) {
        if (currentNode != this.root) {
            if (currentNode.getParent() == this.root) {
                currentNode.setFailNode(this.root);
            } else {
                int idx;
                AhoCorasickNode<V> travaseNode = currentNode.getParent().getFailNode();
                while (travaseNode != this.root) {
                    if (travaseNode.getChildren() == null) {
                        travaseNode = travaseNode.getFailNode();
                        continue;
                    }
                    idx = this.retrieveNode(travaseNode.getChildren(), currentNode.getKey());
                    if (idx != -1) {
                        currentNode.setFailNode(travaseNode.getChildren()[idx]);
                        break;
                    }
                    travaseNode = travaseNode.getFailNode();
                }
                if (currentNode.getFailNode() == null) {
                    idx = this.retrieveNode(this.root.getChildren(), currentNode.getKey());
                    if (idx != -1) {
                        AhoCorasickNode<V> rootChildNode = this.root.getChildren()[idx];
                        currentNode.setFailNode(rootChildNode);
                    } else {
                        currentNode.setFailNode(this.root);
                    }
                }
            }
        }
    }

    public void travaseNodes() {
        List keyList;
        AhoCorasickNode currentNode = this.root;
        LinkedList<AhoCorasickNode<V>> queue = new LinkedList<AhoCorasickNode<V>>();
        queue.clear();
        queue.add(currentNode);
        HashMap<Integer, List<AhoCorasickNode<V>>> depthKeyMap = new HashMap<Integer, List<AhoCorasickNode<V>>>();
        while (!queue.isEmpty()) {
            currentNode = (AhoCorasickNode)queue.remove();
            this.logNode(depthKeyMap, currentNode);
            if (currentNode.getChildren() == null || currentNode.getChildren().length == 0) continue;
            this.insertNodes(queue, currentNode.getChildren());
        }
        int i = 0;
        while ((keyList = (List)depthKeyMap.get(i)) != null) {
            String keys = "";
            for (AhoCorasickNode ahoCorasickNode : keyList) {
                String failNode = "";
                if (ahoCorasickNode.getDepth() != 0) {
                    failNode = "(" + ahoCorasickNode.getFailNode().getDepth() + ":" + ahoCorasickNode.getFailNode().getKey() + ")";
                }
                keys = keys + ahoCorasickNode.getKey() + failNode + ", ";
            }
            System.out.println("[" + i + "]" + keys);
            ++i;
        }
    }

    private void logNode(Map<Integer, List<AhoCorasickNode<V>>> depthKeyMap, AhoCorasickNode<V> currentNode) {
        List<AhoCorasickNode<V>> keyList = depthKeyMap.get(currentNode.getDepth());
        if (keyList == null) {
            keyList = new ArrayList<AhoCorasickNode<V>>();
        }
        keyList.add(currentNode);
        depthKeyMap.put(currentNode.getDepth(), keyList);
    }

    private void insertNodes(Queue<AhoCorasickNode<V>> queue, AhoCorasickNode<V>[] ahoCorasickNodes) {
        for (AhoCorasickNode<V> ahoCorasickNode : ahoCorasickNodes) {
            queue.add(ahoCorasickNode);
        }
    }
}

