/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import android.media.AudioFormat;
import android.media.AudioTrack;
import androidx.annotation.RequiresApi;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0017J\b\u0010\f\u001a\u00020\tH\u0017J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0017J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0017J(\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0017J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0016J(\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0017J(\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0017J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020(2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0016J(\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020(2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/webrtc/audio/AudioTrackInterceptor;", "Landroid/media/AudioTrack;", "originalTrack", "samplesReadyCallback", "Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;", "(Landroid/media/AudioTrack;Lorg/webrtc/audio/JavaAudioDeviceModule$SamplesReadyCallback;)V", "flush", "", "getAudioFormat", "", "getAudioSessionId", "getBufferCapacityInFrames", "getBufferSizeInFrames", "getChannelConfiguration", "getChannelCount", "getFormat", "Landroid/media/AudioFormat;", "getPlayState", "getPlaybackHeadPosition", "getPlaybackRate", "getSampleRate", "getState", "getStreamType", "getUnderrunCount", "pause", "play", "release", "stop", "write", "audioData", "Ljava/nio/ByteBuffer;", "sizeInBytes", "writeMode", "timestamp", "", "", "offsetInBytes", "", "offsetInFloats", "sizeInFloats", "", "offsetInShorts", "sizeInShorts", "com.github.shenbengit.WebRTCExtension"})
public final class AudioTrackInterceptor
extends AudioTrack {
    @NotNull
    private AudioTrack originalTrack;
    @NotNull
    private JavaAudioDeviceModule.SamplesReadyCallback samplesReadyCallback;

    public AudioTrackInterceptor(@NotNull AudioTrack originalTrack, @NotNull JavaAudioDeviceModule.SamplesReadyCallback samplesReadyCallback) {
        Intrinsics.checkNotNullParameter((Object)originalTrack, (String)"originalTrack");
        Intrinsics.checkNotNullParameter((Object)samplesReadyCallback, (String)"samplesReadyCallback");
        super(0, 44100, 4, 2, 8192, 1);
        this.originalTrack = originalTrack;
        this.samplesReadyCallback = samplesReadyCallback;
    }

    public int getState() {
        return this.originalTrack.getState();
    }

    public void play() {
        this.originalTrack.play();
    }

    public int getPlayState() {
        return this.originalTrack.getPlayState();
    }

    public void stop() {
        this.originalTrack.stop();
    }

    @RequiresApi(value=24)
    public int getUnderrunCount() {
        return this.originalTrack.getUnderrunCount();
    }

    public int getAudioSessionId() {
        return this.originalTrack.getAudioSessionId();
    }

    public int getChannelCount() {
        return this.originalTrack.getChannelCount();
    }

    public int getSampleRate() {
        return this.originalTrack.getSampleRate();
    }

    @RequiresApi(value=24)
    public int getBufferCapacityInFrames() {
        return this.originalTrack.getBufferCapacityInFrames();
    }

    public int getAudioFormat() {
        return this.originalTrack.getAudioFormat();
    }

    @RequiresApi(value=23)
    public int getBufferSizeInFrames() {
        return this.originalTrack.getBufferSizeInFrames();
    }

    public void pause() {
        this.originalTrack.pause();
    }

    public void release() {
        this.originalTrack.release();
    }

    public int getPlaybackHeadPosition() {
        return this.originalTrack.getPlaybackHeadPosition();
    }

    @RequiresApi(value=23)
    @NotNull
    public AudioFormat getFormat() {
        AudioFormat audioFormat = this.originalTrack.getFormat();
        Intrinsics.checkNotNullExpressionValue((Object)audioFormat, (String)"originalTrack.format");
        return audioFormat;
    }

    public int getPlaybackRate() {
        return this.originalTrack.getPlaybackRate();
    }

    public int getStreamType() {
        return this.originalTrack.getStreamType();
    }

    public int getChannelConfiguration() {
        return this.originalTrack.getChannelConfiguration();
    }

    public void flush() {
        this.originalTrack.flush();
    }

    public int write(@NotNull byte[] audioData, int offsetInBytes, int sizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        int write = this.originalTrack.write(audioData, offsetInBytes, sizeInBytes);
        if (write == sizeInBytes) {
            byte[] byArray = audioData;
            int n = offsetInBytes + sizeInBytes;
            boolean bl = false;
            byte[] bytes = ArraysKt.copyOfRange((byte[])byArray, (int)offsetInBytes, (int)n);
            this.samplesReadyCallback.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(this.originalTrack.getAudioFormat(), this.originalTrack.getChannelCount(), this.originalTrack.getSampleRate(), bytes));
        }
        return write;
    }

    @RequiresApi(value=21)
    public int write(@NotNull ByteBuffer audioData, int sizeInBytes, int writeMode) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        int position = audioData.position();
        int from = audioData.isDirect() ? position : audioData.arrayOffset() + position;
        int write = this.originalTrack.write(audioData, sizeInBytes, writeMode);
        if (write == sizeInBytes) {
            byte[] byArray = audioData.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"audioData.array()");
            int n = from + sizeInBytes;
            boolean bl = false;
            byte[] bytes = ArraysKt.copyOfRange((byte[])byArray, (int)from, (int)n);
            this.samplesReadyCallback.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(this.originalTrack.getAudioFormat(), this.originalTrack.getChannelCount(), this.originalTrack.getSampleRate(), bytes));
        }
        return write;
    }

    public int write(@NotNull short[] audioData, int offsetInShorts, int sizeInShorts) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        return this.originalTrack.write(audioData, offsetInShorts, sizeInShorts);
    }

    @RequiresApi(value=23)
    public int write(@NotNull byte[] audioData, int offsetInBytes, int sizeInBytes, int writeMode) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        return this.originalTrack.write(audioData, offsetInBytes, sizeInBytes, writeMode);
    }

    @RequiresApi(value=23)
    public int write(@NotNull ByteBuffer audioData, int sizeInBytes, int writeMode, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        return this.originalTrack.write(audioData, sizeInBytes, writeMode, timestamp);
    }

    @RequiresApi(value=21)
    public int write(@NotNull float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        return this.originalTrack.write(audioData, offsetInFloats, sizeInFloats, writeMode);
    }

    @RequiresApi(value=23)
    public int write(@NotNull short[] audioData, int offsetInShorts, int sizeInShorts, int writeMode) {
        Intrinsics.checkNotNullParameter((Object)audioData, (String)"audioData");
        return this.originalTrack.write(audioData, offsetInShorts, sizeInShorts, writeMode);
    }
}

