/*
 * Decompiled with CFR 0.152.
 */
package com.cooltechworks.views.shimmer;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.cooltechworks.views.shimmer.R;
import com.cooltechworks.views.shimmer.ShimmerAdapter;

public class ShimmerRecyclerView
extends RecyclerView {
    private ShimmerAdapter mShimmerAdapter;
    private RecyclerView.LayoutManager mShimmerLayoutManager;
    private RecyclerView.LayoutManager mActualLayoutManager;
    private RecyclerView.Adapter mActualAdapter;
    private int mLayoutReference = R.layout.layout_sample_view;
    private boolean mCanScroll;
    private LayoutMangerType mLayoutMangerType = LayoutMangerType.LINEAR_VERTICAL;
    private int mGridCount = 2;

    public ShimmerRecyclerView(Context context) {
        super(context);
        this.init(null);
    }

    public ShimmerRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ShimmerRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        this.mShimmerAdapter = new ShimmerAdapter();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ShimmerRecyclerView, 0, 0);
        try {
            if (a.hasValue(R.styleable.ShimmerRecyclerView_demo_layout)) {
                this.setDemoLayoutReference(a.getResourceId(R.styleable.ShimmerRecyclerView_demo_layout, R.layout.layout_sample_view));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_demo_child_count)) {
                this.setDemoChildCount(a.getInteger(R.styleable.ShimmerRecyclerView_demo_child_count, 1));
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_demo_layout_manager_type)) {
                int value = a.getInteger(R.styleable.ShimmerRecyclerView_demo_layout_manager_type, 0);
                switch (value) {
                    case 1: {
                        this.setDemoLayoutManager(LayoutMangerType.LINEAR_HORIZONTAL);
                        break;
                    }
                    case 2: {
                        this.setDemoLayoutManager(LayoutMangerType.GRID);
                        break;
                    }
                    default: {
                        this.setDemoLayoutManager(LayoutMangerType.LINEAR_VERTICAL);
                    }
                }
            }
            if (a.hasValue(R.styleable.ShimmerRecyclerView_demo_grid_child_count)) {
                this.setGridChildCount(a.getInteger(R.styleable.ShimmerRecyclerView_demo_grid_child_count, 2));
            }
        }
        finally {
            a.recycle();
        }
        this.showShimmerAdapter();
    }

    public void setGridChildCount(int count) {
        this.mGridCount = count;
    }

    public void setDemoLayoutManager(LayoutMangerType type) {
        this.mLayoutMangerType = type;
    }

    public void setDemoChildCount(int count) {
        this.mShimmerAdapter.setMinItemCount(count);
    }

    public void showShimmerAdapter() {
        this.mCanScroll = false;
        if (this.mShimmerLayoutManager == null) {
            this.initShimmerManager();
        }
        this.setLayoutManager(this.mShimmerLayoutManager);
        this.setAdapter(this.mShimmerAdapter);
    }

    private void initShimmerManager() {
        switch (this.mLayoutMangerType) {
            case LINEAR_VERTICAL: {
                this.mShimmerLayoutManager = new LinearLayoutManager(this.getContext()){

                    public boolean canScrollVertically() {
                        return ShimmerRecyclerView.this.mCanScroll;
                    }
                };
                break;
            }
            case LINEAR_HORIZONTAL: {
                this.mShimmerLayoutManager = new LinearLayoutManager(this.getContext(), 0, false){

                    public boolean canScrollHorizontally() {
                        return ShimmerRecyclerView.this.mCanScroll;
                    }
                };
                break;
            }
            case GRID: {
                this.mShimmerLayoutManager = new GridLayoutManager(this.getContext(), this.mGridCount){

                    public boolean canScrollVertically() {
                        return ShimmerRecyclerView.this.mCanScroll;
                    }
                };
            }
        }
    }

    public void hideShimmerAdapter() {
        this.mCanScroll = true;
        this.setLayoutManager(this.mActualLayoutManager);
        this.setAdapter(this.mActualAdapter);
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        if (manager == null) {
            this.mActualLayoutManager = null;
        } else if (manager != this.mShimmerLayoutManager) {
            this.mActualLayoutManager = manager;
        }
        super.setLayoutManager(manager);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            this.mActualAdapter = null;
        } else if (adapter != this.mShimmerAdapter) {
            this.mActualAdapter = adapter;
        }
        super.setAdapter(adapter);
    }

    public int getLayoutReference() {
        return this.mLayoutReference;
    }

    public void setDemoLayoutReference(int mLayoutReference) {
        this.mLayoutReference = mLayoutReference;
        this.mShimmerAdapter.setLayoutReference(this.getLayoutReference());
    }

    public static enum LayoutMangerType {
        LINEAR_VERTICAL,
        LINEAR_HORIZONTAL,
        GRID;

    }
}

