/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.helper;

import com.power.common.model.EnumDictionary;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDataDictionary;
import com.power.doc.model.ApiParam;
import com.power.doc.model.CustomField;
import com.power.doc.model.DocJavaField;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParamsBuildHelper {
    public static List<ApiParam> buildParams(String className, String pre, int level, String isRequired, boolean isResp, Map<String, String> registryClasses, ProjectDocConfigBuilder projectBuilder, Set<String> groupClasses, int pid, boolean jsonRequest) {
        HashMap<String, String> genericMap = new HashMap<String, String>(10);
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        int nextLevel = level + 1;
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (level > apiConfig.getRecursionLimit()) {
            return paramList;
        }
        if (registryClasses.containsKey(className) && level > registryClasses.size()) {
            return paramList;
        }
        Map<String, CustomField> responseFieldMap = projectBuilder.getCustomRespFieldMap();
        boolean skipTransientField = apiConfig.isSkipTransientField();
        boolean isShowJavaType = projectBuilder.getApiConfig().getShowJavaType();
        boolean requestFieldToUnderline = projectBuilder.getApiConfig().isRequestFieldToUnderline();
        boolean responseFieldToUnderline = projectBuilder.getApiConfig().isResponseFieldToUnderline();
        boolean displayActualType = projectBuilder.getApiConfig().isDisplayActualType();
        registryClasses.put(className, className);
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = projectBuilder.getClassByName(simpleName);
        if (Objects.isNull(globGicName) || globGicName.length < 1) {
            JavaClass superJavaClass;
            JavaClass javaClass = superJavaClass = cls != null ? cls.getSuperJavaClass() : null;
            if (superJavaClass != null && !"Object".equals(superJavaClass.getSimpleName())) {
                globGicName = DocClassUtil.getSimpleGicName(superJavaClass.getGenericFullyQualifiedName());
            }
        }
        JavaClassUtil.genericParamMap(genericMap, cls, globGicName);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>());
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            String processedType = isShowJavaType ? simpleName : DocClassUtil.processTypeNameForParams(simpleName.toLowerCase());
            paramList.addAll(ParamsBuildHelper.primitiveReturnRespComment(processedType));
        } else if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            if (!JavaClassValidateUtil.isCollection(globGicName[0])) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicName, pre, nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest));
            }
        } else if (JavaClassValidateUtil.isMap(simpleName)) {
            paramList.addAll(ParamsBuildHelper.buildMapParam(globGicName, pre, level, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest, nextLevel));
        } else if ("java.lang.Object".equals(className)) {
            ApiParam param = ApiParam.of().setId(pid + 1).setField(pre + "any object").setType("object").setPid(pid);
            if (StringUtil.isEmpty((String)isRequired)) {
                param.setDesc("any object.").setVersion("-");
            } else {
                param.setDesc("any object.").setRequired(false).setVersion("-");
            }
            paramList.add(param);
        } else if (JavaClassValidateUtil.isReactor(simpleName)) {
            if (globGicName.length > 0) {
                paramList.addAll(ParamsBuildHelper.buildParams(globGicName[0], pre, nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest));
            }
        } else {
            Map<String, String> ignoreFields = JavaClassUtil.getClassJsonIgnoreFields(cls);
            block0: for (DocJavaField docField : fields) {
                int fieldPid;
                String processedType;
                ApiParam param;
                CustomField customRequestField;
                String fieldName;
                JavaField field = docField.getJavaField();
                String maxLength = JavaFieldUtil.getParamMaxlength(field.getAnnotations());
                if (field.isTransient() && skipTransientField || ignoreFields.containsKey(fieldName = docField.getFieldName())) continue;
                String subTypeName = docField.getFullyQualifiedName();
                if (responseFieldToUnderline && isResp || requestFieldToUnderline && !isResp) {
                    fieldName = StringUtil.camelToUnderline((String)fieldName);
                }
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = docField.getGenericCanonicalName();
                List<JavaAnnotation> javaAnnotations = docField.getAnnotations();
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field, docField);
                String since = "-";
                if (!isResp) {
                    if (tagsMap.containsKey("ignore")) continue;
                    if (tagsMap.containsKey("since")) {
                        since = tagsMap.get("since");
                    }
                } else if (tagsMap.containsKey("since")) {
                    since = tagsMap.get("since");
                }
                boolean strRequired = false;
                int annotationCounter = 0;
                CustomField customResponseField = responseFieldMap.get(simpleName + "." + fieldName);
                if (customResponseField != null && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName()) && customResponseField.isIgnore() && isResp || (customRequestField = projectBuilder.getCustomReqFieldMap().get(simpleName + "." + fieldName)) != null && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && customRequestField.isIgnore() && !isResp) continue;
                for (JavaAnnotation annotation : javaAnnotations) {
                    AnnotationValue value;
                    String simpleAnnotationName = annotation.getType().getValue();
                    if ("JsonProperty".equalsIgnoreCase(simpleAnnotationName) && Objects.nonNull(value = annotation.getProperty("access")) && ("JsonProperty.Access.READ_ONLY".equals(value.getParameterValue()) && !isResp || "JsonProperty.Access.WRITE_ONLY".equals(value.getParameterValue()) && isResp) || "JsonIgnore".equals(simpleAnnotationName)) continue block0;
                    if ("JSONField".equals(simpleAnnotationName)) {
                        AnnotationValue serialize = annotation.getProperty("serialize");
                        AnnotationValue deserialize = annotation.getProperty("deserialize");
                        if (!isResp && Objects.nonNull(serialize) && Boolean.FALSE.toString().equals(serialize.toString()) || isResp && Objects.nonNull(deserialize) && Boolean.FALSE.toString().equals(deserialize.toString())) continue block0;
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if ("JsonProperty".equals(simpleAnnotationName)) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                        continue;
                    }
                    if ("Null".equals(simpleAnnotationName) && !isResp) {
                        Set<String> groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                        for (String string : groupClassList) {
                            if (!groupClasses.contains(string)) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (!JavaClassValidateUtil.isJSR303Required(simpleAnnotationName) || isResp) continue;
                    ++annotationCounter;
                    boolean hasGroup = false;
                    Set<String> groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                    for (String javaClass3 : groupClassList) {
                        if (!groupClasses.contains(javaClass3)) continue;
                        hasGroup = true;
                    }
                    if (hasGroup) {
                        strRequired = true;
                        continue;
                    }
                    if (!CollectionUtil.isEmpty(groupClasses)) continue;
                    strRequired = true;
                }
                String fieldValue = "";
                if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                    fieldValue = tagsMap.get("mock");
                    if (!(DocUtil.javaPrimaryType(typeSimpleName) || JavaClassValidateUtil.isCollection(subTypeName) || JavaClassValidateUtil.isMap(subTypeName) || JavaClassValidateUtil.isArray(subTypeName))) {
                        fieldValue = DocUtil.handleJsonStr(fieldValue);
                    }
                }
                if (annotationCounter < 1 && tagsMap.containsKey("required")) {
                    strRequired = true;
                }
                if (Objects.nonNull(customResponseField) && isResp && Objects.nonNull(customResponseField.getValue()) && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName())) {
                    fieldValue = String.valueOf(customResponseField.getValue());
                }
                if (Objects.nonNull(customRequestField) && !isResp && Objects.nonNull(customRequestField.getValue()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName())) {
                    fieldValue = String.valueOf(customRequestField.getValue());
                }
                if (customRequestField != null && !isResp && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && customRequestField.isRequire()) {
                    strRequired = true;
                }
                String comment = "";
                if (null != customRequestField && StringUtil.isNotEmpty((String)customRequestField.getDesc()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && !isResp) {
                    comment = customRequestField.getDesc();
                }
                if (null != customResponseField && StringUtil.isNotEmpty((String)customResponseField.getDesc()) && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName()) && isResp) {
                    comment = customResponseField.getDesc();
                }
                if (null != customRequestField && StringUtil.isNotEmpty((String)customRequestField.getReplaceName()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && !isResp) {
                    fieldName = customRequestField.getReplaceName();
                }
                if (null != customResponseField && StringUtil.isNotEmpty((String)customResponseField.getReplaceName()) && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName()) && isResp) {
                    fieldName = customResponseField.getReplaceName();
                }
                if (StringUtils.isBlank((CharSequence)comment)) {
                    comment = docField.getComment();
                }
                if (JavaClassValidateUtil.isFile(fieldGicName)) {
                    param = ApiParam.of().setField(pre + fieldName).setType("file").setClassName(className).setPid(pid).setId(paramList.size() + pid + 1).setMaxLength(maxLength).setDesc(comment).setRequired(Boolean.parseBoolean(isRequired)).setVersion(since);
                    if (fieldGicName.contains("[]") || fieldGicName.endsWith(">")) {
                        comment = comment + "(array of file)";
                        param.setType("file");
                        param.setDesc(comment);
                        param.setHasItems(true);
                    }
                    paramList.add(param);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    if (StringUtil.isEmpty((String)fieldValue)) {
                        fieldValue = DocUtil.getValByTypeAndFieldName(subTypeName, field.getName());
                    }
                    param = ApiParam.of().setClassName(className).setField(pre + fieldName);
                    param.setPid(pid).setMaxLength(maxLength).setValue(fieldValue);
                    String processedType2 = isShowJavaType ? subTypeName : DocClassUtil.processTypeNameForParams(subTypeName.toLowerCase());
                    param.setType(processedType2);
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                        continue;
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, "No comments found.", since, strRequired);
                    continue;
                }
                String appendComment = "";
                if (displayActualType) {
                    if (globGicName.length > 0) {
                        String gicName;
                        String string = gicName = genericMap.get(subTypeName) != null ? (String)genericMap.get(subTypeName) : globGicName[0];
                        if (!simpleName.equals(gicName)) {
                            appendComment = " (ActualType: " + JavaClassUtil.getClassSimpleName(gicName) + ")";
                        }
                    }
                    if (Objects.nonNull(docField.getActualJavaType())) {
                        appendComment = " (ActualType: " + JavaClassUtil.getClassSimpleName(docField.getActualJavaType()) + ")";
                    }
                }
                StringBuilder preBuilder = new StringBuilder();
                for (int j = 0; j < level; ++j) {
                    preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                preBuilder.append("\u2514\u2500");
                ApiParam apiParam = ApiParam.of().setField(pre + fieldName).setClassName(className).setPid(pid).setMaxLength(maxLength);
                if (typeSimpleName.length() == 1) {
                    String gicName = "java.lang.Object";
                    if (Objects.nonNull(genericMap.get(typeSimpleName))) {
                        gicName = (String)genericMap.get(subTypeName);
                    } else if (globGicName.length > 0) {
                        gicName = globGicName[0];
                    }
                    processedType = JavaClassValidateUtil.isPrimitive(gicName) ? DocClassUtil.processTypeNameForParams(gicName) : DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                } else {
                    processedType = isShowJavaType ? typeSimpleName : DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                }
                apiParam.setType(processedType);
                JavaClass javaClass = field.getType();
                if (javaClass.isEnum()) {
                    comment = comment + ParamsBuildHelper.handleEnumComment(javaClass, projectBuilder);
                    apiParam.setType("enum");
                    List methods = javaClass.getMethods();
                    int index = 0;
                    block5: for (JavaMethod method : methods) {
                        List javaAnnotationList = method.getAnnotations();
                        for (JavaAnnotation annotation : javaAnnotationList) {
                            if (!annotation.getType().getValue().contains("JsonValue")) continue;
                            break block5;
                        }
                        if (CollectionUtil.isEmpty(javaAnnotations) && index < 1) break;
                        ++index;
                    }
                    Object value = JavaClassUtil.getEnumValue(javaClass, !jsonRequest);
                    apiParam.setValue(String.valueOf(value));
                    apiParam.setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                    apiParam.setEnumInfo(JavaClassUtil.getEnumInfo(javaClass, projectBuilder));
                    if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                        apiParam.setValue(tagsMap.get("mock"));
                    }
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, comment + appendComment, since, strRequired);
                        continue;
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, "No comments found." + appendComment, since, strRequired);
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName) || JavaClassValidateUtil.isArray(subTypeName)) {
                    String gName;
                    String[] gNameArr;
                    apiParam.setType("array");
                    if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                        apiParam.setValue(fieldValue);
                    }
                    if (globGicName.length > 0 && "java.util.List".equals(fieldGicName)) {
                        fieldGicName = fieldGicName + "<" + "java.lang.Object" + ">";
                    }
                    if (JavaClassValidateUtil.isArray(subTypeName)) {
                        fieldGicName = fieldGicName.substring(0, fieldGicName.lastIndexOf("["));
                        fieldGicName = "java.util.List<" + fieldGicName + ">";
                    }
                    if ((gNameArr = DocClassUtil.getSimpleGicName(fieldGicName)).length == 0) continue;
                    if (gNameArr.length > 0) {
                        String gName2 = DocClassUtil.getSimpleGicName(fieldGicName)[0];
                        JavaClass javaClass1 = projectBuilder.getJavaProjectBuilder().getClassByName(gName2);
                        comment = comment + ParamsBuildHelper.handleEnumComment(javaClass1, projectBuilder);
                    }
                    if (JavaClassValidateUtil.isPrimitive(gName = gNameArr[0])) {
                        String builder = DocUtil.jsonValueByType(gName) + "," + DocUtil.jsonValueByType(gName);
                        if (StringUtil.isEmpty((String)fieldValue)) {
                            apiParam.setValue(DocUtil.handleJsonStr(builder));
                        } else {
                            apiParam.setValue(fieldValue);
                        }
                        if (StringUtil.isNotEmpty((String)comment)) {
                            ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, comment + appendComment, since, strRequired);
                            continue;
                        }
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, "No comments found." + appendComment, since, strRequired);
                        continue;
                    }
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, comment + appendComment, since, strRequired);
                    } else {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, "No comments found." + appendComment, since, strRequired);
                    }
                    fieldPid = paramList.size() + pid;
                    if (!simpleName.equals(gName)) {
                        JavaClass arraySubClass = projectBuilder.getJavaProjectBuilder().getClassByName(gName);
                        if (arraySubClass.isEnum()) {
                            Object value = JavaClassUtil.getEnumValue(arraySubClass, Boolean.FALSE);
                            StringBuilder sb = new StringBuilder();
                            sb.append("[\"").append(value).append("\"]");
                            apiParam.setValue(sb.toString()).setEnumInfo(JavaClassUtil.getEnumInfo(arraySubClass, projectBuilder)).setEnumValues(JavaClassUtil.getEnumValues(arraySubClass));
                            continue;
                        }
                        if (gName.length() == 1) {
                            String gicName;
                            int len = globGicName.length;
                            if (len < 1 || JavaClassValidateUtil.isPrimitive(gicName = genericMap.get(gName) != null ? (String)genericMap.get(gName) : globGicName[0]) || simpleName.equals(gicName)) continue;
                            paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                            continue;
                        }
                        paramList.addAll(ParamsBuildHelper.buildParams(gName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                        continue;
                    }
                    apiParam.setSelfReferenceLoop(true);
                    continue;
                }
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    String valType;
                    if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                        apiParam.setType("map");
                        apiParam.setValue(fieldValue);
                    }
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, comment + appendComment, since, strRequired);
                    } else {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, "No comments found." + appendComment, since, strRequired);
                    }
                    fieldPid = paramList.size() + pid;
                    String gNameTemp = fieldGicName;
                    String string = valType = DocClassUtil.getMapKeyValueType(gNameTemp).length == 0 ? gNameTemp : DocClassUtil.getMapKeyValueType(gNameTemp)[1];
                    if (JavaClassValidateUtil.isMap(gNameTemp) || "java.lang.Object".equals(valType)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setId(fieldPid + 1).setPid(fieldPid).setClassName(className).setMaxLength(maxLength).setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    if (JavaClassValidateUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = (String)genericMap.get(valType);
                        if (JavaClassValidateUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(valType, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                    continue;
                }
                if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) {
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, comment + appendComment, since, strRequired);
                    } else {
                        ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, "No comments found." + appendComment, since, strRequired);
                    }
                    boolean isGenerics = docField.getJavaField().getType().getFullyQualifiedName().length() == 1;
                    fieldPid = paramList.size() + pid;
                    if (isGenerics && "java.lang.Object".equals(subTypeName) && StringUtil.isNotEmpty((String)field.getComment())) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setId(fieldPid + 1).setPid(pid).setClassName(className).setMaxLength(maxLength).setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    if (simpleName.equals(className)) continue;
                    if (globGicName.length > 0) {
                        String gicName = genericMap.get(subTypeName) != null ? (String)genericMap.get(subTypeName) : globGicName[0];
                        String simple = DocClassUtil.getSimpleName(gicName);
                        if (JavaClassValidateUtil.isPrimitive(simple)) continue;
                        if (gicName.contains("<")) {
                            if (JavaClassValidateUtil.isCollection(simple)) {
                                apiParam.setType("array");
                                String gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                if (JavaClassValidateUtil.isPrimitive(gName)) continue;
                                paramList.addAll(ParamsBuildHelper.buildParams(gName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                                continue;
                            }
                            paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                            continue;
                        }
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(subTypeName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
                    continue;
                }
                if (simpleName.equals(subTypeName)) continue;
                if (StringUtil.isNotEmpty((String)comment)) {
                    ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, comment + appendComment, since, strRequired);
                } else {
                    ParamsBuildHelper.commonHandleParam(paramList, apiParam, isRequired, "No comments found." + appendComment, since, strRequired);
                }
                fieldGicName = DocUtil.formatFieldTypeGicName(genericMap, globGicName, fieldGicName);
                fieldPid = paramList.size() + pid;
                paramList.addAll(ParamsBuildHelper.buildParams(fieldGicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest));
            }
        }
        return paramList;
    }

    private static List<ApiParam> buildMapParam(String[] globGicName, String pre, int level, String isRequired, boolean isResp, Map<String, String> registryClasses, ProjectDocConfigBuilder projectBuilder, Set<String> groupClasses, int pid, boolean jsonRequest, int nextLevel) {
        if (globGicName.length != 2) {
            return Collections.emptyList();
        }
        String mapKeySimpleName = DocClassUtil.getSimpleName(globGicName[0]);
        String valueSimpleName = DocClassUtil.getSimpleName(globGicName[1]);
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (JavaClassValidateUtil.isPrimitive(mapKeySimpleName)) {
            boolean isShowJavaType = projectBuilder.getApiConfig().getShowJavaType();
            String valueSimpleNameType = isShowJavaType ? valueSimpleName : DocClassUtil.processTypeNameForParams(valueSimpleName.toLowerCase());
            ApiParam apiParam = ApiParam.of().setField(pre + "mapKey").setType(valueSimpleNameType).setClassName(valueSimpleName).setDesc(Optional.ofNullable(projectBuilder.getClassByName(valueSimpleName)).map(JavaAnnotatedElement::getComment).orElse("A map key.")).setVersion("-").setPid(pid).setId(++pid);
            paramList.addAll(Collections.singletonList(apiParam));
        }
        if (JavaClassValidateUtil.isPrimitive(valueSimpleName)) {
            return paramList;
        }
        StringBuilder preBuilder = new StringBuilder();
        for (int j = 0; j < level; ++j) {
            preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        preBuilder.append("\u2514\u2500");
        paramList.addAll(ParamsBuildHelper.buildParams(globGicName[1], preBuilder.toString(), ++nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest));
        return paramList;
    }

    public static String dictionaryListComment(List<EnumDictionary> enumDataDict) {
        return enumDataDict.stream().map(apiDataDictionary -> apiDataDictionary.getName() + "-(\"" + apiDataDictionary.getValue() + "\",\"" + apiDataDictionary.getDesc() + "\")").collect(Collectors.joining(","));
    }

    public static List<ApiParam> primitiveReturnRespComment(String typeName) {
        StringBuilder comments = new StringBuilder();
        comments.append("Return ").append(typeName).append(".");
        ApiParam apiParam = ApiParam.of().setField("-").setType(typeName).setDesc(comments.toString()).setVersion("-");
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        paramList.add(apiParam);
        return paramList;
    }

    private static void commonHandleParam(List<ApiParam> paramList, ApiParam param, String isRequired, String comment, String since, boolean strRequired) {
        if (StringUtil.isEmpty((String)isRequired)) {
            param.setDesc(comment).setVersion(since);
        } else {
            param.setDesc(comment).setVersion(since).setRequired(strRequired);
        }
        param.setId(paramList.size() + param.getPid() + 1);
        paramList.add(param);
    }

    private static String handleEnumComment(JavaClass javaClass, ProjectDocConfigBuilder projectBuilder) {
        String comment = "";
        if (!javaClass.isEnum()) {
            return comment;
        }
        String enumComments = javaClass.getComment();
        if (projectBuilder.getApiConfig().getInlineEnum().booleanValue()) {
            ApiDataDictionary dataDictionary = projectBuilder.getApiConfig().getDataDictionary(javaClass.getCanonicalName());
            if (Objects.isNull(dataDictionary)) {
                comment = comment + "<br/>" + JavaClassUtil.getEnumParams(javaClass);
            } else {
                Class<?> enumClass = dataDictionary.getEnumClass();
                if (enumClass.isInterface()) {
                    ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
                    try {
                        enumClass = classLoader.loadClass(javaClass.getFullyQualifiedName());
                    }
                    catch (ClassNotFoundException e) {
                        return comment;
                    }
                }
                comment = comment + "[enum:" + ParamsBuildHelper.dictionaryListComment(dataDictionary.getEnumDataDict(enumClass)) + "]";
            }
        } else {
            if (StringUtil.isNotEmpty((String)enumComments)) {
                comment = comment + "(See: " + enumComments + ")";
            }
            comment = StringUtil.removeQuotes((String)comment);
        }
        return comment;
    }
}

