/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.constants.DocValidatorAnnotationEnum;
import com.power.doc.model.DocJavaField;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.AnnotationValueList;
import com.thoughtworks.qdox.model.expression.TypeRef;
import com.thoughtworks.qdox.model.impl.DefaultJavaField;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JavaClassUtil {
    public static List<DocJavaField> getFields(JavaClass cls1, int counter, Map<String, DocJavaField> addedFields) {
        HashMap<String, JavaType> actualJavaTypes = new HashMap<String, JavaType>(10);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls1, counter, addedFields, actualJavaTypes);
        fields.stream().filter(f -> f.getGenericCanonicalName() != null).forEach(f -> actualJavaTypes.entrySet().stream().filter(e -> f.getGenericCanonicalName().equals(e.getKey())).forEach(e -> f.setGenericCanonicalName(f.getGenericCanonicalName().replace((CharSequence)e.getKey(), ((JavaType)e.getValue()).getGenericCanonicalName())).setFullyQualifiedName(f.getFullyQualifiedName().replace((CharSequence)e.getKey(), ((JavaType)e.getValue()).getFullyQualifiedName())).setActualJavaType(((JavaType)e.getValue()).getFullyQualifiedName())));
        return fields;
    }

    private static List<DocJavaField> getFields(JavaClass cls1, int counter, Map<String, DocJavaField> addedFields, Map<String, JavaType> actualJavaTypes) {
        String methodName;
        ArrayList<DocJavaField> fieldList = new ArrayList<DocJavaField>();
        if (null == cls1) {
            return fieldList;
        }
        if ("Object".equals(cls1.getSimpleName()) || "Timestamp".equals(cls1.getSimpleName()) || "Date".equals(cls1.getSimpleName()) || "Locale".equals(cls1.getSimpleName()) || "ClassLoader".equals(cls1.getSimpleName()) || JavaClassValidateUtil.isMap(cls1.getFullyQualifiedName()) || cls1.isEnum() || "Serializable".equals(cls1.getSimpleName()) || "ZonedDateTime".equals(cls1.getSimpleName())) {
            return fieldList;
        }
        String className = cls1.getFullyQualifiedName();
        if (cls1.isInterface() && !JavaClassValidateUtil.isCollection(className) && !JavaClassValidateUtil.isMap(className)) {
            List methods = cls1.getMethods();
            for (Object javaMethod : methods) {
                methodName = javaMethod.getName();
                int paramSize = javaMethod.getParameters().size();
                boolean enable = false;
                if (methodName.startsWith("get") && !"get".equals(methodName) && paramSize == 0) {
                    methodName = StringUtil.firstToLowerCase((String)methodName.substring(3));
                    enable = true;
                } else if (methodName.startsWith("is") && !"is".equals(methodName) && paramSize == 0) {
                    methodName = StringUtil.firstToLowerCase((String)methodName.substring(2));
                    enable = true;
                }
                if (!enable || addedFields.containsKey(methodName)) continue;
                String comment = javaMethod.getComment();
                DefaultJavaField javaField = new DefaultJavaField(javaMethod.getReturns(), methodName);
                DocJavaField docJavaField = DocJavaField.builder().setFieldName(methodName).setJavaField((JavaField)javaField).setComment(comment).setDocletTags(javaMethod.getTags()).setAnnotations(javaMethod.getAnnotations()).setFullyQualifiedName(javaField.getType().getFullyQualifiedName()).setGenericCanonicalName(javaField.getType().getGenericCanonicalName());
                addedFields.put(methodName, docJavaField);
            }
        }
        if (actualJavaTypes == null) {
            actualJavaTypes = new HashMap<String, JavaType>(10);
        }
        if (!cls1.isEnum()) {
            Object javaMethod;
            JavaClass parentClass = cls1.getSuperJavaClass();
            JavaClassUtil.getFields(parentClass, counter, addedFields, actualJavaTypes);
            Iterator implClasses = cls1.getImplements();
            javaMethod = implClasses.iterator();
            while (javaMethod.hasNext()) {
                JavaType type = (JavaType)javaMethod.next();
                JavaClass javaClass = (JavaClass)type;
                JavaClassUtil.getFields(javaClass, counter, addedFields, actualJavaTypes);
            }
        }
        actualJavaTypes.putAll(JavaClassUtil.getActualTypesMap(cls1));
        List javaMethods = cls1.getMethods();
        for (JavaMethod method : javaMethods) {
            methodName = method.getName();
            if (method.getAnnotations().size() < 1) continue;
            int paramSize = method.getParameters().size();
            if (methodName.startsWith("get") && !"get".equals(methodName) && paramSize == 0) {
                methodName = StringUtil.firstToLowerCase((String)methodName.substring(3));
            } else if (methodName.startsWith("is") && !"is".equals(methodName) && paramSize == 0) {
                methodName = StringUtil.firstToLowerCase((String)methodName.substring(2));
            }
            if (!addedFields.containsKey(methodName)) continue;
            String comment = method.getComment();
            if (Objects.isNull(comment)) {
                comment = addedFields.get(methodName).getComment();
            }
            DocJavaField docJavaField = addedFields.get(methodName);
            docJavaField.setAnnotations(method.getAnnotations());
            docJavaField.setComment(comment);
            docJavaField.setFieldName(methodName);
            addedFields.put(methodName, docJavaField);
        }
        if (!cls1.isInterface()) {
            for (JavaField javaField : cls1.getFields()) {
                String fieldName = javaField.getName();
                String subTypeName = javaField.getType().getFullyQualifiedName();
                if (javaField.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName)) continue;
                if (fieldName.startsWith("is") && "boolean".equals(subTypeName)) {
                    fieldName = StringUtil.firstToLowerCase((String)fieldName.substring(2));
                }
                DocJavaField docJavaField = DocJavaField.builder();
                boolean typeChecked = false;
                String gicName = javaField.getType().getGenericCanonicalName();
                String actualType = null;
                if (JavaClassValidateUtil.isCollection(subTypeName) && !JavaClassValidateUtil.isCollection(gicName)) {
                    String[] gNameArr = DocClassUtil.getSimpleGicName(gicName);
                    actualType = JavaClassUtil.getClassSimpleName(gNameArr[0]);
                    docJavaField.setArray(true);
                    typeChecked = true;
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName) && !typeChecked) {
                    docJavaField.setPrimitive(true);
                    typeChecked = true;
                }
                if (JavaClassValidateUtil.isFile(subTypeName) && !typeChecked) {
                    docJavaField.setFile(true);
                    typeChecked = true;
                }
                if (javaField.getType().isEnum() && !typeChecked) {
                    docJavaField.setEnum(true);
                }
                docJavaField.setComment(javaField.getComment()).setJavaField(javaField).setFullyQualifiedName(subTypeName).setGenericCanonicalName(gicName).setActualJavaType(actualType).setAnnotations(javaField.getAnnotations()).setFieldName(fieldName);
                if (addedFields.containsKey(fieldName)) {
                    addedFields.put(fieldName, docJavaField);
                    continue;
                }
                addedFields.put(fieldName, docJavaField);
            }
        }
        List parentFieldList = addedFields.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        fieldList.addAll(parentFieldList);
        return fieldList;
    }

    public static Object getEnumValue(JavaClass javaClass, boolean formDataEnum) {
        List javaFields = javaClass.getEnumConstants();
        List methodList = javaClass.getMethods();
        String methodName = null;
        block0: for (JavaMethod method : methodList) {
            List annotations = method.getAnnotations();
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if (!"JsonValue".equals(annotationName) && !"JsonCreator".equals(annotationName)) continue;
                methodName = method.getName();
                continue block0;
            }
        }
        String value = null;
        int index = 0;
        for (JavaField javaField : javaFields) {
            String simpleName = javaField.getType().getSimpleName();
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("\"").append(javaField.getName()).append("\"").toString();
            if (formDataEnum) {
                value = valueBuilder.toString();
                return value;
            }
            if (!JavaClassValidateUtil.isPrimitive(simpleName) && index < 1) {
                value = CollectionUtil.isNotEmpty((Collection)javaField.getEnumConstantArguments()) && Objects.nonNull(methodName) ? javaField.getEnumConstantArguments().get(0) : valueBuilder.toString();
            }
            ++index;
        }
        return value;
    }

    public static String getEnumParams(JavaClass javaClass) {
        List javaFields = javaClass.getEnumConstants();
        StringBuilder stringBuilder = new StringBuilder();
        for (JavaField javaField : javaFields) {
            List exceptions = javaField.getEnumConstantArguments();
            stringBuilder.append(javaField.getName());
            if (CollectionUtil.isNotEmpty((Collection)exceptions)) {
                stringBuilder.append(" -(");
                for (int i = 0; i < exceptions.size(); ++i) {
                    stringBuilder.append(exceptions.get(i));
                    if (i == exceptions.size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
            }
            stringBuilder.append("<br/>");
        }
        return stringBuilder.toString();
    }

    public static List<String> getEnumValues(JavaClass javaClass) {
        List javaFields = javaClass.getEnumConstants();
        ArrayList<String> enums = new ArrayList<String>();
        for (JavaField javaField : javaFields) {
            enums.add(javaField.getName());
        }
        return enums;
    }

    public static String getAnnotationSimpleName(String annotationName) {
        return JavaClassUtil.getClassSimpleName(annotationName);
    }

    public static String getClassSimpleName(String className) {
        int index;
        if (className.contains(".")) {
            if (className.contains("<")) {
                className = className.substring(0, className.indexOf("<"));
            }
            index = className.lastIndexOf(".");
            className = className.substring(index + 1);
        }
        if (className.contains("[")) {
            index = className.indexOf("[");
            className = className.substring(0, index);
        }
        return className;
    }

    public static JavaType getActualType(JavaClass javaClass) {
        return JavaClassUtil.getActualTypes((JavaType)javaClass).get(0);
    }

    public static List<JavaType> getActualTypes(JavaType javaType) {
        if (Objects.isNull(javaType)) {
            return new ArrayList<JavaType>(0);
        }
        String typeName = javaType.getGenericFullyQualifiedName();
        if (typeName.contains("<")) {
            return ((JavaParameterizedType)javaType).getActualTypeArguments();
        }
        return new ArrayList<JavaType>(0);
    }

    public static Map<String, JavaType> getActualTypesMap(JavaClass javaClass) {
        HashMap<String, JavaType> genericMap = new HashMap<String, JavaType>(10);
        List variables = javaClass.getTypeParameters();
        if (variables.size() < 1) {
            return genericMap;
        }
        List<JavaType> javaTypes = JavaClassUtil.getActualTypes((JavaType)javaClass);
        for (int i = 0; i < variables.size(); ++i) {
            if (javaTypes.size() <= 0) continue;
            genericMap.put(((JavaTypeVariable)variables.get(i)).getName(), javaTypes.get(i));
        }
        return genericMap;
    }

    public static List<String> getParamGroupJavaClass(List<JavaAnnotation> annotations) {
        if (CollectionUtil.isEmpty(annotations)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> javaClassList = new ArrayList<String>();
        List<String> validates = DocValidatorAnnotationEnum.listValidatorAnnotations();
        for (JavaAnnotation javaAnnotation : annotations) {
            List<AnnotationValue> annotationValueList = JavaClassUtil.getAnnotationValues(validates, javaAnnotation);
            JavaClassUtil.addGroupClass(annotationValueList, javaClassList);
        }
        return javaClassList;
    }

    public static List<String> getParamGroupJavaClass(JavaAnnotation javaAnnotation) {
        if (Objects.isNull(javaAnnotation)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> javaClassList = new ArrayList<String>();
        List<String> validates = DocValidatorAnnotationEnum.listValidatorAnnotations();
        List<AnnotationValue> annotationValueList = JavaClassUtil.getAnnotationValues(validates, javaAnnotation);
        JavaClassUtil.addGroupClass(annotationValueList, javaClassList);
        String simpleAnnotationName = javaAnnotation.getType().getValue();
        if (javaClassList.size() == 0 && JavaClassValidateUtil.isJSR303Required(simpleAnnotationName)) {
            javaClassList.add("javax.validation.groups.Default");
        }
        return javaClassList;
    }

    public static String getClassTagsValue(JavaClass cls, String tagName, boolean checkComments) {
        if (StringUtil.isNotEmpty((String)tagName)) {
            StringBuilder result = new StringBuilder();
            List tags = cls.getTags();
            for (int i = 0; i < tags.size(); ++i) {
                if (!tagName.equals(((DocletTag)tags.get(i)).getName())) continue;
                String value = ((DocletTag)tags.get(i)).getValue();
                if (StringUtil.isEmpty((String)value) && checkComments) {
                    throw new RuntimeException("ERROR: #" + cls.getName() + "() - bad @" + tagName + " javadoc from " + cls.getName() + ", must be add comment if you use it.");
                }
                if (!tagName.equals(((DocletTag)tags.get(i)).getName())) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(value);
            }
            return result.toString();
        }
        return "";
    }

    public static Map<String, String> getFinalFieldValue(Class<?> clazz) throws IllegalAccessException {
        String className = JavaClassUtil.getClassSimpleName(clazz.getName());
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, String> constants = new HashMap<String, String>();
        for (Field field : fields) {
            boolean isFinal = Modifier.isFinal(field.getModifiers());
            if (!isFinal) continue;
            String name = field.getName();
            constants.put(className + "." + name, String.valueOf(field.get(null)));
        }
        return constants;
    }

    private static void addGroupClass(List<AnnotationValue> annotationValueList, List<String> javaClassList) {
        if (CollectionUtil.isEmpty(annotationValueList)) {
            return;
        }
        for (AnnotationValue annotationValue : annotationValueList) {
            TypeRef typeRef = (TypeRef)annotationValue;
            DefaultJavaParameterizedType annotationValueType = (DefaultJavaParameterizedType)typeRef.getType();
            javaClassList.add(annotationValueType.getGenericCanonicalName());
        }
    }

    private static List<AnnotationValue> getAnnotationValues(List<String> validates, JavaAnnotation javaAnnotation) {
        List<Object> annotationValueList = new ArrayList<AnnotationValue>();
        String simpleName = javaAnnotation.getType().getValue();
        if (simpleName.equalsIgnoreCase("Validated")) {
            if (Objects.nonNull(javaAnnotation.getProperty("value"))) {
                AnnotationValue v = javaAnnotation.getProperty("value");
                if (v instanceof AnnotationValueList) {
                    annotationValueList = ((AnnotationValueList)v).getValueList();
                }
                if (v instanceof TypeRef) {
                    annotationValueList.add(v);
                }
            }
        } else if (validates.contains(simpleName) && Objects.nonNull(javaAnnotation.getProperty("groups"))) {
            AnnotationValue v = javaAnnotation.getProperty("groups");
            if (v instanceof AnnotationValueList) {
                annotationValueList = ((AnnotationValueList)v).getValueList();
            }
            if (v instanceof TypeRef) {
                annotationValueList.add(v);
            }
        }
        return annotationValueList;
    }

    public static void genericParamMap(Map<String, String> genericMap, JavaClass cls, String[] globGicName) {
        if (Objects.nonNull(cls) && Objects.nonNull(cls.getTypeParameters())) {
            List variables = cls.getTypeParameters();
            for (int i = 0; i < cls.getTypeParameters().size() && i < globGicName.length; ++i) {
                genericMap.put(((JavaTypeVariable)variables.get(i)).getName(), globGicName[i]);
            }
        }
    }

    public static String javaTypeFormat(String returnType) {
        if (returnType.contains("?")) {
            return returnType.replaceAll("[?\\s]", "").replaceAll("extends", "");
        }
        return returnType;
    }

    public static boolean isTargetChildClass(String sourceClass, String targetClass) {
        try {
            if (sourceClass.equals(targetClass)) {
                return true;
            }
            for (Class<?> c = Class.forName(sourceClass); c != null; c = c.getSuperclass()) {
                if (!c.getName().equals(targetClass)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            e.getMessage();
            return false;
        }
        return false;
    }

    public static Map<String, String> getClassJsonIgnoreFields(JavaClass cls) {
        if (cls == null) {
            return Collections.EMPTY_MAP;
        }
        List classAnnotation = cls.getAnnotations();
        HashMap<String, String> ignoreFields = new HashMap<String, String>();
        for (JavaAnnotation annotation : classAnnotation) {
            String simpleAnnotationName = annotation.getType().getValue();
            if ("JsonIgnoreProperties".equalsIgnoreCase(simpleAnnotationName)) {
                return JavaClassUtil.getJsonIgnoresProp(annotation, "value");
            }
            if (!"JSONType".equals(simpleAnnotationName)) continue;
            return JavaClassUtil.getJsonIgnoresProp(annotation, "ignores");
        }
        return ignoreFields;
    }

    public static Map<String, String> getJsonIgnoresProp(JavaAnnotation annotation, String propName) {
        HashMap<String, String> ignoreFields = new HashMap<String, String>();
        Object ignoresObject = annotation.getNamedParameter(propName);
        if (Objects.isNull(ignoresObject)) {
            return ignoreFields;
        }
        if (ignoresObject instanceof String) {
            String prop = StringUtil.removeQuotes((String)ignoresObject.toString());
            ignoreFields.put(prop, null);
            return ignoreFields;
        }
        LinkedList ignorePropList = (LinkedList)ignoresObject;
        for (String str : ignorePropList) {
            String prop = StringUtil.removeQuotes((String)str);
            ignoreFields.put(prop, null);
        }
        return ignoreFields;
    }
}

