/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.JavaMethodDoc;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class RpcDocBuildTemplate
implements IDocBuildTemplate<RpcApiDoc> {
    private final AtomicInteger atomicInteger = new AtomicInteger(1);

    @Override
    public List<RpcApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        ArrayList<RpcApiDoc> apiDocList = new ArrayList<RpcApiDoc>();
        int order = 0;
        boolean setCustomOrder = false;
        for (JavaClass cls : projectBuilder.getJavaProjectBuilder().getClasses()) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls.getCanonicalName())) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.checkDubboInterface(cls) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonnegativeInteger((String)strOrder)) {
                order = Integer.parseInt(strOrder);
                setCustomOrder = true;
            }
            List<JavaMethodDoc> apiMethodDocs = this.buildServiceMethod(cls, apiConfig, projectBuilder);
            this.handleJavaApiDoc(cls, apiDocList, apiMethodDocs, order, projectBuilder);
        }
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(RpcApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    @Override
    public RpcApiDoc getSingleApiData(ProjectDocConfigBuilder projectBuilder, String apiClassName) {
        return null;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }

    private List<JavaMethodDoc> buildServiceMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        List methods = cls.getMethods();
        ArrayList<JavaMethodDoc> methodDocList = new ArrayList<JavaMethodDoc>(methods.size());
        int methodOrder = 0;
        for (JavaMethod method : methods) {
            if (method.isPrivate()) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            boolean deprecated = false;
            List annotations = method.getAnnotations();
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getName();
                if (!"Deprecated".equals(annotationName)) continue;
                deprecated = true;
            }
            if (Objects.nonNull(method.getTagByName("deprecated"))) {
                deprecated = true;
            }
            ++methodOrder;
            JavaMethodDoc apiMethodDoc = new JavaMethodDoc();
            String methodDefine = this.methodDefinition(method);
            String scapeMethod = methodDefine.replaceAll("<", "&lt;");
            scapeMethod = scapeMethod.replaceAll(">", "&gt;");
            apiMethodDoc.setMethodDefinition(methodDefine);
            apiMethodDoc.setEscapeMethodDefinition(scapeMethod);
            apiMethodDoc.setOrder(methodOrder);
            apiMethodDoc.setDesc(DocUtil.getEscapeAndCleanComment(method.getComment()));
            apiMethodDoc.setName(method.getName());
            String methodUid = DocUtil.generateId(clazName + method.getName());
            apiMethodDoc.setMethodId(methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            String authorValue = DocUtil.getNormalTagComments(method, "author", cls.getName());
            if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(authorValue);
            }
            apiMethodDoc.setDetail(apiNoteValue != null ? apiNoteValue : "");
            if (Objects.nonNull(method.getTagByName("ignore"))) continue;
            apiMethodDoc.setDeprecated(deprecated);
            List<ApiParam> requestParams = this.requestParams(method, projectBuilder);
            List<ApiParam> responseParams = this.buildReturnApiParams(DocJavaMethod.builder().setJavaMethod(method), projectBuilder);
            if (apiConfig.isParamsDataToTree()) {
                apiMethodDoc.setRequestParams(ApiParamTreeUtil.apiParamToTree(requestParams));
                apiMethodDoc.setResponseParams(ApiParamTreeUtil.apiParamToTree(responseParams));
            } else {
                apiMethodDoc.setRequestParams(requestParams);
                apiMethodDoc.setResponseParams(responseParams);
            }
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private List<ApiParam> requestParams(JavaMethod javaMethod, ProjectDocConfigBuilder builder) {
        boolean isStrict = builder.getApiConfig().isStrict();
        boolean isShowJavaType = builder.getApiConfig().getShowJavaType();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = DocUtil.getParamsComments(javaMethod, "param", className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            return null;
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        for (JavaParameter parameter : parameterList) {
            ApiParam param;
            String[] gicNameArr;
            String paramName = parameter.getName();
            String typeName = parameter.getType().getGenericCanonicalName();
            String simpleName = parameter.getType().getValue().toLowerCase();
            String fullTypeName = parameter.getType().getFullyQualifiedName();
            String paramPre = paramName + ".";
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            String comment = this.paramCommentResolve(paramTagMap.get(paramName));
            String mockValue = JavaFieldUtil.createMockValue(paramTagMap, paramName, typeName, typeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            List<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations);
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                String gicName;
                if (JavaClassValidateUtil.isCollection(typeName)) {
                    typeName = typeName + "<T>";
                }
                if (JavaClassValidateUtil.isArray(gicName = (gicNameArr = DocClassUtil.getSimpleGicName(typeName))[0])) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String processedType = isShowJavaType ? JavaClassUtil.getClassSimpleName(typeName) : DocClassUtil.processTypeNameForParams(simpleName);
                    ApiParam param2 = ApiParam.of().setField(paramName).setDesc(comment + "   (children type : " + gicName + ")").setType(processedType);
                    paramList.add(param2);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                param = ApiParam.of().setField(paramName).setType(JavaClassUtil.getClassSimpleName(typeName)).setDesc(comment).setMaxLength(JavaFieldUtil.getParamMaxlength(parameter.getAnnotations())).setValue(mockValue).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType(typeName).setDesc(comment).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
                continue;
            }
            if (javaClass.isEnum()) {
                param = ApiParam.of().setField(paramName).setType("Enum").setDesc(comment).setVersion("-");
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
        }
        return paramList;
    }

    private boolean checkDubboInterface(JavaClass cls) {
        if ("org.apache.dubbo.rpc.protocol.rest.integration.swagger.DubboSwaggerApiListingResource".equals(cls.getCanonicalName())) {
            return false;
        }
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getCanonicalName();
            if (!"org.apache.dubbo.config.annotation.Service".equals(name) && !"org.apache.dubbo.config.annotation.DubboService".equals(name) && !"com.alibaba.dubbo.config.annotation.Service".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"dubbo".equals(value)) continue;
            return true;
        }
        return false;
    }

    private void handleJavaApiDoc(JavaClass cls, List<RpcApiDoc> apiDocList, List<JavaMethodDoc> apiMethodDocs, int order, ProjectDocConfigBuilder builder) {
        String className = cls.getCanonicalName();
        String shortName = cls.getName();
        String comment = cls.getComment();
        List javaTypes = cls.getImplements();
        if (javaTypes.size() >= 1 && !cls.isInterface()) {
            JavaType javaType = (JavaType)javaTypes.get(0);
            shortName = className = javaType.getCanonicalName();
            JavaClass javaClass = builder.getClassByName(className);
            if (StringUtil.isEmpty((String)comment) && Objects.nonNull(javaClass)) {
                comment = javaClass.getComment();
            }
        }
        RpcApiDoc apiDoc = new RpcApiDoc();
        apiDoc.setOrder(order);
        apiDoc.setName(className);
        apiDoc.setShortName(shortName);
        apiDoc.setAlias(className);
        apiDoc.setUri(builder.getServerUrl() + "/" + className);
        apiDoc.setProtocol("dubbo");
        if (builder.getApiConfig().isMd5EncryptedHtmlName()) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        apiDoc.setDesc(DocUtil.getEscapeAndCleanComment(comment));
        apiDoc.setList(apiMethodDocs);
        List docletTags = cls.getTags();
        ArrayList<String> authorList = new ArrayList<String>();
        for (DocletTag docletTag : docletTags) {
            String name = docletTag.getName();
            if ("version".equals(name)) {
                apiDoc.setVersion(docletTag.getValue());
            }
            if (!"author".equals(name)) continue;
            authorList.add(docletTag.getValue());
        }
        apiDoc.setAuthor(String.join((CharSequence)", ", authorList));
        apiDocList.add(apiDoc);
    }

    private String methodDefinition(JavaMethod method) {
        String[] arrays;
        StringBuilder methodBuilder = new StringBuilder();
        JavaType returnType = method.getReturnType();
        String simpleReturn = returnType.getCanonicalName();
        String returnClass = returnType.getGenericCanonicalName();
        returnClass = returnClass.replace(simpleReturn, JavaClassUtil.getClassSimpleName(simpleReturn));
        for (String str : arrays = DocClassUtil.getSimpleGicName(returnClass)) {
            String[] generics;
            if (str.contains("[")) {
                str = str.substring(0, str.indexOf("["));
            }
            for (String generic : generics = str.split("[<,]")) {
                if (generic.contains("extends")) {
                    String className = generic.substring(generic.lastIndexOf(" ") + 1);
                    returnClass = returnClass.replace(className, JavaClassUtil.getClassSimpleName(className));
                }
                if (generic.length() == 1 || generic.contains("extends")) continue;
                returnClass = returnClass.replaceAll(generic, JavaClassUtil.getClassSimpleName(generic));
            }
        }
        methodBuilder.append(returnClass).append(" ");
        ArrayList<String> params = new ArrayList<String>();
        List parameters = method.getParameters();
        for (JavaParameter parameter : parameters) {
            params.add(parameter.getType().getGenericValue() + " " + parameter.getName());
        }
        methodBuilder.append(method.getName()).append("(").append(String.join((CharSequence)", ", params)).append(")");
        return methodBuilder.toString();
    }
}

