/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpringMVCRequestMappingHandler {
    public RequestMapping handle(ProjectDocConfigBuilder projectBuilder, String controllerBaseUrl, JavaMethod method, Map<String, String> constantsMap) {
        List annotations = method.getAnnotations();
        String methodType = null;
        String shortUrl = null;
        String mediaType = null;
        String serverUrl = projectBuilder.getServerUrl();
        String contextPath = projectBuilder.getApiConfig().getPathPrefix();
        boolean deprecated = false;
        for (Object annotation : annotations) {
            String string = annotation.getType().getName();
            Object produces = annotation.getNamedParameter("produces");
            if (Objects.nonNull(produces)) {
                mediaType = produces.toString();
            }
            if ("Deprecated".equals(string)) {
                deprecated = true;
            }
            if ("RequestMapping".equals(string) || "org.springframework.web.bind.annotation.RequestMapping".equals(string)) {
                shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
                Object nameParam = annotation.getNamedParameter("method");
                if (Objects.nonNull(nameParam)) {
                    methodType = nameParam.toString();
                    methodType = DocUtil.handleHttpMethod(methodType);
                    continue;
                }
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("GetMapping".equals(string) || "org.springframework.web.bind.annotation.GetMapping".equals(string)) {
                shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("PostMapping".equals(string) || "org.springframework.web.bind.annotation.PostMapping".equals(string)) {
                shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
                methodType = Methods.POST.getValue();
                continue;
            }
            if ("PutMapping".equals(string) || "org.springframework.web.bind.annotation.PutMapping".equals(string)) {
                shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
                methodType = Methods.PUT.getValue();
                continue;
            }
            if ("PatchMapping".equals(string) || "org.springframework.web.bind.annotation.PatchMapping".equals(string)) {
                shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
                methodType = Methods.PATCH.getValue();
                continue;
            }
            if (!"DeleteMapping".equals(string) && !"org.springframework.web.bind.annotation.DeleteMapping".equals(string)) continue;
            shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
            methodType = Methods.DELETE.getValue();
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            deprecated = true;
        }
        if (Objects.nonNull(shortUrl)) {
            String url;
            if (Objects.nonNull(method.getTagByName("ignore"))) {
                return null;
            }
            List<String> urls = DocUtil.split(shortUrl = StringUtil.removeQuotes(shortUrl));
            if (urls.size() > 1) {
                url = DocUrlUtil.getMvcUrls(serverUrl, contextPath + "/" + controllerBaseUrl, urls);
                shortUrl = DocUrlUtil.getMvcUrls("", contextPath + "/" + controllerBaseUrl, urls);
            } else {
                url = String.join((CharSequence)"/", serverUrl, contextPath, controllerBaseUrl, shortUrl);
                shortUrl = String.join((CharSequence)"/", "/", contextPath, controllerBaseUrl, shortUrl);
            }
            for (Map.Entry entry : constantsMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                url = SpringMVCRequestMappingHandler.delConstantsUrl(url, key, value);
                shortUrl = SpringMVCRequestMappingHandler.delConstantsUrl(shortUrl, key, value);
            }
            String urlSuffix = projectBuilder.getApiConfig().getUrlSuffix();
            if (StringUtil.isNotEmpty((String)urlSuffix)) {
                url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url)) + urlSuffix;
                shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl)) + urlSuffix;
            } else {
                url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url));
                shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl));
            }
            return RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setUrl(url).setShortUrl(shortUrl).setDeprecated(deprecated);
        }
        return null;
    }

    public static String delConstantsUrl(String url, String replaceKey, String replaceValue) {
        String[] pathWords;
        url = StringUtil.trim((String)url);
        url = url.replace("+", "");
        url = UrlUtil.simplifyUrl((String)url);
        for (String word : pathWords = url.split("/")) {
            if (!word.equals(replaceKey)) continue;
            url = url.replace(replaceKey, replaceValue);
            return url;
        }
        return url;
    }
}

