/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JsonUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OpenApiBuilder {
    private static final String PATH_REGEX = "[/{};\\t+]";

    public static void buildOpenApi(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        OpenApiBuilder.openApiCreate(config, configBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        OpenApiBuilder.openApiCreate(config, configBuilder);
    }

    private static void openApiCreate(ApiConfig config, ProjectDocConfigBuilder configBuilder) {
        config.setParamsDataToTree(true);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        HashMap<String, Object> json = new HashMap<String, Object>(8);
        json.put("openapi", "3.0.3");
        json.put("info", OpenApiBuilder.buildInfo(config));
        json.put("servers", OpenApiBuilder.buildServers(config));
        json.put("paths", OpenApiBuilder.buildPaths(apiDocList));
        json.put("components", OpenApiBuilder.buildComponentsSchema(apiDocList));
        String filePath = config.getOutPath();
        filePath = filePath + "/openapi.json";
        String data = JsonUtil.toPrettyJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "Project Name is Null." : apiConfig.getProjectName());
        infoMap.put("version", "1.0.0");
        return infoMap;
    }

    private static List<Map<String, Object>> buildServers(ApiConfig config) {
        ArrayList<Map<String, Object>> serverList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> serverMap = new HashMap<String, String>(8);
        serverMap.put("url", config.getServerUrl() == null ? "" : config.getServerUrl());
        serverList.add(serverMap);
        return serverList;
    }

    private static Map<String, Object> buildPaths(List<ApiDoc> apiDocList) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>(500);
        apiDocList.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String url = method.getPath().replace("//", "/");
                Map<String, Object> request = OpenApiBuilder.buildPathUrls(method, a);
                if (!pathMap.containsKey(url)) {
                    pathMap.put(url, request);
                } else {
                    Map oldRequest = (Map)pathMap.get(url);
                    oldRequest.putAll(request);
                }
            });
        });
        return pathMap;
    }

    private static Map<String, Object> buildPathUrls(ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put(apiMethodDoc.getType().toLowerCase(), OpenApiBuilder.buildPathUrlsRequest(apiMethodDoc, apiDoc));
        return request;
    }

    private static Map<String, Object> buildPathUrlsRequest(ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        request.put("description", apiMethodDoc.getDetail());
        if (StringUtil.isNotEmpty((String)apiMethodDoc.getGroup())) {
            request.put("tags", new String[]{apiMethodDoc.getGroup()});
        } else {
            request.put("tags", new String[]{apiDoc.getDesc()});
        }
        request.put("requestBody", OpenApiBuilder.buildRequestBody(apiMethodDoc));
        request.put("parameters", OpenApiBuilder.buildParameters(apiMethodDoc));
        request.put("responses", OpenApiBuilder.buildResponses(apiMethodDoc));
        request.put("deprecated", apiMethodDoc.isDeprecated());
        request.put("operationId", apiMethodDoc.getMethodId());
        return request;
    }

    private static Map<String, Object> buildRequestBody(ApiMethodDoc apiMethodDoc) {
        boolean isPost;
        HashMap<String, Object> requestBody = new HashMap<String, Object>(8);
        boolean bl = isPost = apiMethodDoc.getType().equals(Methods.POST.getValue()) || apiMethodDoc.getType().equals(Methods.PUT.getValue()) || apiMethodDoc.getType().equals(Methods.PATCH.getValue());
        if (isPost) {
            requestBody.put("content", OpenApiBuilder.buildContent(apiMethodDoc, false));
            return requestBody;
        }
        return null;
    }

    private static Map<String, Object> buildContent(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        String contentType = apiMethodDoc.getContentType();
        if (isRep) {
            contentType = "*/*";
        }
        content.put(contentType, OpenApiBuilder.buildContentBody(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildContentBody(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        if (Objects.nonNull(apiMethodDoc.getReturnSchema()) && isRep) {
            content.put("schema", apiMethodDoc.getReturnSchema());
        } else if (!isRep && apiMethodDoc.getContentType().equals("multipart/form-data")) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", "object");
            LinkedHashMap properties = new LinkedHashMap();
            for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("type", apiParam.getType());
                detail.put("description", apiParam.getDesc());
                detail.put("example", DocUtil.handleJsonStr(apiParam.getValue()));
                if ("file".equals(apiParam.getType())) {
                    detail.remove("example");
                    if (apiParam.isHasItems()) {
                        detail.put("type", "array");
                        HashMap<String, String> items = new HashMap<String, String>();
                        items.put("type", "string");
                        items.put("format", "binary");
                        detail.put("items", items);
                    } else {
                        detail.put("format", "binary");
                        detail.put("type", "string");
                    }
                }
                properties.put(apiParam.getField(), detail);
            }
            map.put("properties", properties);
            content.put("schema", map);
        } else if (!isRep && Objects.nonNull(apiMethodDoc.getRequestSchema())) {
            content.put("schema", apiMethodDoc.getRequestSchema());
        } else {
            content.put("schema", OpenApiBuilder.buildBodySchema(apiMethodDoc, isRep));
        }
        content.put("examples", OpenApiBuilder.buildBodyExample(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildBodySchema(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        HashMap<String, String> innerScheme = new HashMap<String, String>(10);
        String responseRef = "#/components/schemas/" + apiMethodDoc.getPath().replaceAll(PATH_REGEX, "_") + "response";
        String requestRef = "#/components/schemas/" + apiMethodDoc.getPath().replaceAll(PATH_REGEX, "_") + "request";
        if (apiMethodDoc.isListParam()) {
            schema.put("type", "array");
            if (isRep) {
                innerScheme.put("$ref", responseRef);
            } else {
                innerScheme.put("$ref", requestRef);
            }
            schema.put("items", innerScheme);
        } else if (isRep) {
            schema.put("$ref", responseRef);
        } else {
            schema.put("$ref", requestRef);
        }
        return schema;
    }

    private static Map<String, Object> buildBodyExample(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("json", OpenApiBuilder.buildExampleData(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildExampleData(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("summary", "test data");
        if (!isRep) {
            content.put("value", StringUtil.isEmpty((String)apiMethodDoc.getRequestExample().getJsonBody()) ? apiMethodDoc.getRequestExample().getExampleBody() : apiMethodDoc.getRequestExample().getJsonBody());
        } else {
            content.put("value", apiMethodDoc.getResponseUsage());
        }
        return content;
    }

    private static List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        List<ApiParam> children;
        Map<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            parameters = OpenApiBuilder.getStringParams(apiParam);
            parameters.put("in", "path");
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        if (!apiMethodDoc.getContentType().equals("multipart/form-data")) {
            for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
                parameters = OpenApiBuilder.getStringParams(apiParam);
                parameters.put("in", "query");
                children = apiParam.getChildren();
                if (!CollectionUtil.isEmpty(children)) continue;
                parametersList.add(parameters);
            }
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqParam header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", header.getName());
                parameters.put("description", header.getDesc());
                parameters.put("required", header.isRequired());
                parameters.put("example", header.getValue());
                parameters.put("schema", OpenApiBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    private static Map<String, Object> getStringParams(ApiParam apiParam) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(20);
        parameters.put("name", apiParam.getField());
        parameters.put("description", apiParam.getDesc());
        parameters.put("required", apiParam.isRequired());
        parameters.put("example", StringUtil.removeQuotes((String)apiParam.getValue()));
        parameters.put("schema", OpenApiBuilder.buildParametersSchema(apiParam));
        return parameters;
    }

    private static Map<String, Object> buildParametersSchema(ApiParam apiParam) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        schema.put("type", openApiType);
        if ("object".equals(openApiType) || "string".equals(openApiType)) {
            if ("file".equals(apiParam.getType())) {
                schema.put("format", "binary");
            } else if ("enum".equals(apiParam.getType())) {
                schema.put("enum", apiParam.getEnumValues());
            } else if ("array".equals(apiParam.getType())) {
                schema.put("type", "array");
                schema.put("items", new HashMap());
            }
        } else {
            schema.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        return schema;
    }

    private static Map<String, Object> buildParametersSchema(ApiReqParam header) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(header.getType());
        schema.put("type", openApiType);
        schema.put("format", "int16".equals(header.getType()) ? "int32" : header.getType());
        return schema;
    }

    private static Map<String, Object> buildResponses(ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> response = new HashMap<String, Object>(10);
        response.put("200", OpenApiBuilder.buildResponsesBody(apiMethodDoc));
        return response;
    }

    private static Map<String, Object> buildResponsesBody(ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "OK");
        responseBody.put("content", OpenApiBuilder.buildContent(apiMethodDoc, true));
        return responseBody;
    }

    private static Map<String, Object> buildComponentsSchema(List<ApiDoc> apiDocs) {
        HashMap<String, Object> schemas = new HashMap<String, Object>(4);
        HashMap component = new HashMap();
        apiDocs.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String requestSchema = method.getPath().replaceAll(PATH_REGEX, "_") + "request";
                List<ApiParam> requestParams = method.getRequestParams();
                if (CollectionUtil.isNotEmpty(requestParams)) {
                    Map<String, Object> prop = OpenApiBuilder.buildProperties(requestParams, requestSchema);
                    if (Objects.nonNull(prop) && prop.size() > 0) {
                        component.put(requestSchema, OpenApiBuilder.buildProperties(requestParams, requestSchema));
                    }
                } else {
                    component.put(requestSchema, new HashMap(0));
                }
                List<ApiParam> responseParams = method.getResponseParams();
                String schemaName = method.getPath().replaceAll(PATH_REGEX, "_") + "response";
                component.put(schemaName, OpenApiBuilder.buildProperties(responseParams, schemaName));
            });
        });
        schemas.put("schemas", component);
        return schemas;
    }

    private static Map<String, Object> buildProperties(List<ApiParam> apiParam, String schemaName) {
        HashMap<String, Object> component = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> propertiesData = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> requiredList = new ArrayList<String>();
        if (apiParam != null) {
            int paramsSize = apiParam.size();
            for (ApiParam param : apiParam) {
                if (param.isRequired()) {
                    requiredList.add(param.getField());
                }
                if (param.getType().equals("map") && paramsSize == 1 || param.isQueryParam() || param.isPathParam()) continue;
                String field = param.getField();
                propertiesData.put(field, OpenApiBuilder.buildPropertiesData(param, schemaName));
            }
            if (!propertiesData.isEmpty()) {
                component.put("properties", propertiesData);
            }
            if (!CollectionUtil.isEmpty(requiredList)) {
                component.put("required", requiredList);
            }
            return component;
        }
        return null;
    }

    private static Map<String, Object> buildPropertiesData(ApiParam apiParam, String schemaName) {
        HashMap<String, Object> propertiesData = new HashMap<String, Object>();
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        propertiesData.put("description", apiParam.getDesc());
        if (!"object".equals(openApiType)) {
            propertiesData.put("type", openApiType);
            propertiesData.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        if ("map".equals(apiParam.getType())) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(map data)");
        }
        if ("object".equals(apiParam.getType()) && apiParam.getChildren() != null) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(object)");
            propertiesData.put("properties", OpenApiBuilder.buildProperties(apiParam.getChildren(), schemaName).get("properties"));
            propertiesData.put("requires", OpenApiBuilder.buildProperties(apiParam.getChildren(), schemaName).get("requires"));
        }
        if ("array".equals(apiParam.getType())) {
            if (CollectionUtil.isNotEmpty(apiParam.getChildren())) {
                propertiesData.put("type", "array");
                propertiesData.put("items", OpenApiBuilder.buildProperties(apiParam.getChildren(), schemaName));
            } else {
                propertiesData.put("type", "array");
                HashMap<String, String> ref = new HashMap<String, String>();
                ref.put("$ref", "#/components/schemas/" + schemaName);
                propertiesData.put("items", ref);
            }
        }
        if ("file".equals(apiParam.getType())) {
            propertiesData.put("type", "string");
            propertiesData.put("format", "binary");
        }
        return propertiesData;
    }
}

