/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.doc.builder.BaseDocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.HighlightStyle;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiAllData;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiDocDict;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beetl.core.Template;

public class DocBuilderTemplate
extends BaseDocBuilderTemplate {
    private static long now = System.currentTimeMillis();

    public ApiAllData getApiData(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        ApiAllData apiAllData = new ApiAllData();
        apiAllData.setProjectName(config.getProjectName());
        apiAllData.setProjectId(DocUtil.generateId(config.getProjectName()));
        apiAllData.setLanguage(config.getLanguage().getCode());
        apiAllData.setApiDocList(this.listOfApiData(config, javaProjectBuilder));
        apiAllData.setErrorCodeList(DocUtil.errorCodeDictToList(config));
        apiAllData.setRevisionLogs(config.getRevisionLogs());
        apiAllData.setApiDocDictList(DocUtil.buildDictionary(config, javaProjectBuilder));
        return apiAllData;
    }

    public void buildApiDoc(List<ApiDoc> apiDocList, ApiConfig config, String template, String fileExtension) {
        FileUtil.mkdirs((String)config.getOutPath());
        for (ApiDoc doc : apiDocList) {
            Template mapper = BeetlTemplateUtil.getByName(template);
            mapper.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
            mapper.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
            mapper.binding(TemplateVariable.LIST.getVariable(), doc.getList());
            mapper.binding(TemplateVariable.REQUEST_EXAMPLE.getVariable(), (Object)config.isRequestExample());
            mapper.binding(TemplateVariable.RESPONSE_EXAMPLE.getVariable(), (Object)config.isResponseExample());
            FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + doc.getName() + fileExtension));
        }
    }

    public void buildAllInOne(List<ApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName) {
        this.buildDoc(apiDocList, config, javaProjectBuilder, template, outPutFileName, null, null);
    }

    public void buildDoc(List<ApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName, ApiDoc apiDoc, String index) {
        String outPath = config.getOutPath();
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        FileUtil.mkdirs((String)outPath);
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config);
        Template tpl = BeetlTemplateUtil.getByName(template);
        String style = config.getStyle();
        tpl.binding(TemplateVariable.STYLE.getVariable(), (Object)style);
        tpl.binding(TemplateVariable.HIGH_LIGHT_CSS_LINK.getVariable(), (Object)config.getHighlightStyleLink());
        tpl.binding(TemplateVariable.BACKGROUND.getVariable(), (Object)HighlightStyle.getBackgroundColor(style));
        tpl.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        tpl.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), errorCodeList);
        tpl.binding(TemplateVariable.VERSION_LIST.getVariable(), config.getRevisionLogs());
        tpl.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        tpl.binding(TemplateVariable.INDEX_ALIAS.getVariable(), (Object)index);
        tpl.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        tpl.binding(TemplateVariable.PROJECT_NAME.getVariable(), (Object)config.getProjectName());
        tpl.binding(TemplateVariable.REQUEST_EXAMPLE.getVariable(), (Object)config.isRequestExample());
        tpl.binding(TemplateVariable.RESPONSE_EXAMPLE.getVariable(), (Object)config.isResponseExample());
        tpl.binding(TemplateVariable.DISPLAY_REQUEST_PARAMS.getVariable(), (Object)config.isRequestParamsTable());
        tpl.binding(TemplateVariable.DISPLAY_RESPONSE_PARAMS.getVariable(), (Object)config.isResponseParamsTable());
        this.setCssCDN(config, tpl);
        this.setDirectoryLanguageVariable(config, tpl);
        List<ApiDocDict> apiDocDictList = DocUtil.buildDictionary(config, javaProjectBuilder);
        tpl.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
        boolean onlyHasDefaultGroup = apiDocList.stream().allMatch(doc -> Objects.equals("default", doc.getGroup()));
        int codeIndex = 0;
        if (onlyHasDefaultGroup) {
            if (apiDocList.size() > 0) {
                codeIndex = apiDocList.get(0).getChildrenApiDocs().size();
            }
        } else {
            codeIndex = apiDocList.size();
        }
        tpl.binding(TemplateVariable.API_DOC_LIST_ONLY_HAS_DEFAULT_GROUP.getVariable(), (Object)onlyHasDefaultGroup);
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            tpl.binding(TemplateVariable.ERROR_CODE_ORDER.getVariable(), (Object)(++codeIndex));
        }
        if (CollectionUtil.isNotEmpty(apiDocDictList)) {
            tpl.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(++codeIndex));
        }
        if (Objects.nonNull(apiDoc)) {
            tpl.binding(TemplateVariable.DESC.getVariable(), (Object)apiDoc.getDesc());
            tpl.binding(TemplateVariable.ORDER.getVariable(), (Object)apiDoc.order);
            tpl.binding(TemplateVariable.LIST.getVariable(), apiDoc.getList());
        }
        FileUtil.nioWriteFile((String)tpl.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildSearchJs(ApiConfig config, JavaProjectBuilder javaProjectBuilder, List<ApiDoc> apiDocList, String template) {
        List<ApiDocDict> apiDocDictList;
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config);
        Template tpl = BeetlTemplateUtil.getByName(template);
        ArrayList<ApiDoc> apiDocs = new ArrayList<ApiDoc>();
        for (ApiDoc apiDoc1 : apiDocList) {
            apiDoc1.setOrder(apiDocs.size() + 1);
            apiDocs.add(apiDoc1);
        }
        boolean isOnlyDefaultGroup = apiDocList.size() == 1;
        Map<String, String> titleMap = this.setDirectoryLanguageVariable(config, tpl);
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            ApiDoc apiDoc1 = new ApiDoc();
            int codeIndex = 0;
            if (isOnlyDefaultGroup) {
                if (apiDocs.size() > 0) {
                    codeIndex = ((ApiDoc)apiDocs.get(0)).getChildrenApiDocs().size();
                }
            } else {
                codeIndex = apiDocList.size();
            }
            apiDoc1.setOrder(codeIndex + 1);
            apiDoc1.setDesc(titleMap.get(TemplateVariable.ERROR_LIST_TITLE.getVariable()));
            apiDoc1.setList(new ArrayList<ApiMethodDoc>(0));
            apiDoc1.setLink("error_code_list");
            apiDoc1.setAlias("error");
            apiDoc1.setGroup(apiDoc1.getDesc());
            if (isOnlyDefaultGroup) {
                ((ApiDoc)apiDocs.get(0)).getChildrenApiDocs().add(apiDoc1);
            } else {
                apiDocs.add(apiDoc1);
            }
        }
        if (CollectionUtil.isNotEmpty(apiDocDictList = DocUtil.buildDictionary(config, javaProjectBuilder))) {
            ApiDoc apiDoc1 = new ApiDoc();
            int codeIndex = 0;
            if (isOnlyDefaultGroup) {
                if (apiDocs.size() > 0) {
                    codeIndex = ((ApiDoc)apiDocs.get(0)).getChildrenApiDocs().size();
                }
            } else {
                codeIndex = apiDocList.size();
            }
            apiDoc1.setOrder(codeIndex + 1);
            apiDoc1.setLink("dict_list");
            apiDoc1.setAlias("dict");
            apiDoc1.setDesc(titleMap.get(TemplateVariable.DICT_LIST_TITLE.getVariable()));
            apiDoc1.setGroup(apiDoc1.getDesc());
            ArrayList<ApiMethodDoc> methodDocs = new ArrayList<ApiMethodDoc>();
            ArrayList<ApiDoc> childrenApiDocs = new ArrayList<ApiDoc>();
            for (ApiDocDict apiDocDict : apiDocDictList) {
                ApiMethodDoc methodDoc = new ApiMethodDoc();
                methodDoc.setOrder(apiDocDict.getOrder());
                methodDoc.setDesc(apiDocDict.getTitle());
                methodDocs.add(methodDoc);
                ApiDoc childrenApiDoc = new ApiDoc();
                childrenApiDoc.setOrder(apiDocDict.getOrder());
                childrenApiDoc.setAlias(apiDocDict.getTitle());
                childrenApiDoc.setDesc(apiDocDict.getTitle());
                childrenApiDoc.setName(apiDocDict.getTitle());
                childrenApiDoc.setList(new ArrayList<ApiMethodDoc>(0));
                childrenApiDocs.add(childrenApiDoc);
            }
            apiDoc1.setChildrenApiDocs(childrenApiDocs);
            apiDoc1.setList(methodDocs);
            if (isOnlyDefaultGroup) {
                if (apiDocs.size() > 0) {
                    ((ApiDoc)apiDocs.get(0)).getChildrenApiDocs().add(apiDoc1);
                }
            } else {
                apiDocs.add(apiDoc1);
            }
        }
        tpl.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocs);
        FileUtil.nioWriteFile((String)tpl.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "search.js"));
    }

    public void buildErrorCodeDoc(ApiConfig config, String template, String outPutFileName) {
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        Template tpl = BeetlTemplateUtil.getByName(template);
        this.setCssCDN(config, tpl);
        tpl.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        tpl.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
        FileUtil.nioWriteFile((String)tpl.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildErrorCodeDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder, List<ApiDoc> apiDocList, String template, String outPutFileName, String indexAlias) {
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        Template errorTemplate = BeetlTemplateUtil.getByName(template);
        errorTemplate.binding(TemplateVariable.PROJECT_NAME.getVariable(), (Object)config.getProjectName());
        String style = config.getStyle();
        errorTemplate.binding(TemplateVariable.HIGH_LIGHT_CSS_LINK.getVariable(), (Object)config.getHighlightStyleLink());
        errorTemplate.binding(TemplateVariable.STYLE.getVariable(), (Object)style);
        if (CollectionUtil.isEmpty(errorCodeList)) {
            errorTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 1));
        } else {
            errorTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 2));
        }
        this.setCssCDN(config, errorTemplate);
        List<ApiDocDict> apiDocDictList = DocUtil.buildDictionary(config, javaProjectBuilder);
        errorTemplate.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        errorTemplate.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        errorTemplate.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
        errorTemplate.binding(TemplateVariable.INDEX_ALIAS.getVariable(), (Object)indexAlias);
        errorTemplate.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        errorTemplate.binding(TemplateVariable.BACKGROUND.getVariable(), (Object)HighlightStyle.getBackgroundColor(style));
        errorTemplate.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), errorCodeList);
        this.setDirectoryLanguageVariable(config, errorTemplate);
        FileUtil.nioWriteFile((String)errorTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildDirectoryDataDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder, List<ApiDoc> apiDocList, String template, String outPutFileName, String indexAlias) {
        List<ApiDocDict> directoryList = DocUtil.buildDictionary(config, javaProjectBuilder);
        Template mapper = BeetlTemplateUtil.getByName(template);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        mapper.binding(TemplateVariable.PROJECT_NAME.getVariable(), (Object)config.getProjectName());
        String style = config.getStyle();
        mapper.binding(TemplateVariable.HIGH_LIGHT_CSS_LINK.getVariable(), (Object)config.getHighlightStyleLink());
        mapper.binding(TemplateVariable.STYLE.getVariable(), (Object)style);
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config);
        this.setCssCDN(config, mapper);
        if (DocLanguage.CHINESE.equals((Object)config.getLanguage())) {
            mapper.binding(TemplateVariable.CSS_CND.getVariable(), (Object)"https://fonts.googleapis.cnpmjs.org");
        } else {
            mapper.binding(TemplateVariable.CSS_CND.getVariable(), (Object)"https://fonts.googleapis.com");
        }
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            mapper.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 2));
        } else {
            mapper.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 1));
        }
        mapper.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        mapper.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        mapper.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        mapper.binding(TemplateVariable.INDEX_ALIAS.getVariable(), (Object)indexAlias);
        mapper.binding(TemplateVariable.BACKGROUND.getVariable(), (Object)HighlightStyle.getBackgroundColor(style));
        mapper.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), errorCodeList);
        this.setDirectoryLanguageVariable(config, mapper);
        mapper.binding(TemplateVariable.DICT_LIST.getVariable(), directoryList);
        FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildDirectoryDataDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName) {
        List<ApiDocDict> directoryList = DocUtil.buildDictionary(config, javaProjectBuilder);
        Template mapper = BeetlTemplateUtil.getByName(template);
        this.setDirectoryLanguageVariable(config, mapper);
        this.setCssCDN(config, mapper);
        String strTime = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
        mapper.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        mapper.binding(TemplateVariable.DICT_LIST.getVariable(), directoryList);
        FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildSingleApi(ProjectDocConfigBuilder projectBuilder, String controllerName, String template, String fileExtension) {
        ApiConfig config = projectBuilder.getApiConfig();
        FileUtil.mkdirs((String)config.getOutPath());
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        ApiDoc doc = (ApiDoc)docBuildTemplate.getSingleApiData(projectBuilder, controllerName);
        Template mapper = BeetlTemplateUtil.getByName(template);
        mapper.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
        mapper.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
        mapper.binding(TemplateVariable.LIST.getVariable(), doc.getList());
        FileUtil.writeFileNotAppend((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + doc.getName() + fileExtension));
    }

    private List<ApiDoc> listOfApiData(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        this.checkAndInitForGetApiData(config);
        config.setMd5EncryptedHtmlName(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        return docBuildTemplate.getApiData(configBuilder);
    }
}

