/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.Base64Util;
import com.power.common.util.HexUtil;
import com.power.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtil {
    private static final String KEY_ALGORITHM = "AES";

    public static byte[] decryptByCBC(byte[] content, byte[] key, byte[] initVector) {
        return AESUtil.decryptByCBC(content, key, initVector, "AES/CBC/PKCS5Padding");
    }

    public static byte[] decryptByCBC(byte[] content, byte[] key, byte[] initVector, String padding) {
        try {
            return AESUtil.doFinal(content, key, initVector, 2, padding);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("AES CBC decrypt error");
        }
    }

    public static byte[] encryptByCBC(byte[] content, byte[] key, byte[] initVector) {
        return AESUtil.encryptByCBC(content, key, initVector, "AES/CBC/PKCS5Padding");
    }

    public static byte[] encryptByCBC(byte[] content, byte[] key, byte[] initVector, String padding) {
        try {
            return AESUtil.doFinal(content, key, initVector, 1, padding);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("AES CBC encrypt error");
        }
    }

    public static byte[] decryptByECB(byte[] content, byte[] key) {
        return AESUtil.decryptByECB(content, key, "AES/ECB/PKCS5Padding");
    }

    public static byte[] decryptByECB(byte[] content, byte[] key, String padding) {
        try {
            return AESUtil.doFinalECB(content, key, 2, padding);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("Aes decrypt error");
        }
    }

    public static byte[] encryptByECB(byte[] content, byte[] key) {
        return AESUtil.encryptByECB(content, key, "AES/ECB/PKCS5Padding");
    }

    public static byte[] encryptByECB(byte[] content, byte[] key, String padding) {
        try {
            return AESUtil.doFinalECB(content, key, 1, padding);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("Aes encrypt error");
        }
    }

    public static String decodeByCBC(String content, String key, String initVector) {
        return AESUtil.decodeByCBC(content, key, initVector, "AES/CBC/PKCS5Padding");
    }

    public static String decodeByCBC(String content, String key, String initVector, String padding) {
        AESUtil.checkParamsOfCBC(content, key, initVector);
        byte[] decryptFrom = HexUtil.hexStr2ByteArr(content);
        byte[] decryptResult = AESUtil.decryptByCBC(decryptFrom, key.getBytes(), initVector.getBytes(), padding);
        return new String(decryptResult);
    }

    public static String decodeByCBCBase64(String content, String key, String initVector, String padding) {
        AESUtil.checkParamsOfCBC(content, key, initVector);
        byte[] decryptFrom = Base64Util.decryptBASE64(content);
        byte[] decryptResult = AESUtil.decryptByCBC(decryptFrom, key.getBytes(), initVector.getBytes(), padding);
        return new String(decryptResult);
    }

    public static String encodeByCBC(String content, String key, String initVector) {
        return AESUtil.encodeByCBC(content, key, initVector, "AES/CBC/PKCS5Padding");
    }

    public static String encodeByCBC(String content, String key, String initVector, String padding) {
        return AESUtil.encodeByCBC(content, key, initVector, padding, false);
    }

    public static String encodeByCBCBase64(String content, String key, String initVector, String padding) {
        return AESUtil.encodeByCBC(content, key, initVector, padding, true);
    }

    public static String encodeByECB(String content, String key) {
        return AESUtil.encodeByECB(content, key, "AES/ECB/PKCS5Padding");
    }

    public static String encodeByECB(String content, String key, String padding) {
        AESUtil.checkContentAndKey(content, key);
        try {
            byte[] encrypted = AESUtil.encryptByECB(content.getBytes("utf-8"), key.getBytes("utf-8"), padding);
            return Base64Util.encryptToString(encrypted);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeByECB(String content, String key) {
        AESUtil.checkContentAndKey(content, key);
        try {
            byte[] result = AESUtil.decryptByECB(Base64Util.decryptBASE64(content), key.getBytes("utf-8"));
            return new String(result, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static byte[] doFinalECB(byte[] content, byte[] key, int mode, String padding) throws GeneralSecurityException {
        SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(padding);
        cipher.init(mode, keySpec);
        return cipher.doFinal(content);
    }

    private static byte[] doFinal(byte[] content, byte[] key, byte[] initVector, int mode, String padding) throws GeneralSecurityException {
        SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(initVector);
        Cipher cipher = Cipher.getInstance(padding);
        cipher.init(mode, (Key)keySpec, iv);
        return cipher.doFinal(content);
    }

    private static void checkParamsOfCBC(String content, String key, String initVector) {
        AESUtil.checkContentAndKey(content, key);
        if (StringUtil.isEmpty(initVector)) {
            throw new NullPointerException("The init Vector can't be null or empty.");
        }
    }

    private static String encodeByCBC(String content, String key, String initVector, String padding, boolean base64) {
        AESUtil.checkParamsOfCBC(content, key, initVector);
        byte[] encryptResult = null;
        try {
            encryptResult = AESUtil.encryptByCBC(content.getBytes("utf-8"), key.getBytes(), initVector.getBytes(), padding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return base64 ? new String(Base64.encodeBase64((byte[])encryptResult)) : HexUtil.byteArr2HexStr(encryptResult);
    }

    private static void checkContentAndKey(String content, String key) {
        if (StringUtil.isEmpty(content)) {
            throw new NullPointerException("The string to be encrypted cannot be null.");
        }
        if (StringUtil.isEmpty(key)) {
            throw new NullPointerException("The key can't be null or empty.");
        }
        if (key.length() != 16) {
            throw new RuntimeException("The length of key must be 16 while use AES CBC mode.");
        }
    }

    private static SecretKeySpec getSecretKey(String key) {
        try {
            return new SecretKeySpec(key.getBytes("utf-8"), KEY_ALGORITHM);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

