/*
 * Decompiled with CFR 0.152.
 */
package com.buildware.widget.indeterm;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatRadioButton;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import com.buildware.widget.indeterm.IndeterminateCheckable;
import com.buildware.widget.indeterm.IndeterminateSavedState;
import com.buildware.widget.indeterm.R;
import com.buildware.widget.indeterm.Utils;

public class IndeterminateRadioButton
extends AppCompatRadioButton
implements IndeterminateCheckable {
    private static final int[] INDETERMINATE_STATE_SET = new int[]{R.attr.state_indeterminate};
    private boolean mIndeterminate;
    private boolean mBroadcasting;
    private OnStateChangedListener mOnStateChangedListener;

    public IndeterminateRadioButton(Context context) {
        this(context, null);
    }

    public IndeterminateRadioButton(Context context, AttributeSet attrs) {
        this(context, attrs, 16842878);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndeterminateRadioButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setButtonDrawable(Utils.tintDrawable((View)this, R.drawable.btn_radio));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IndeterminateCheckable);
        try {
            boolean indeterminate = a.getBoolean(R.styleable.IndeterminateCheckable_indeterminate, false);
            if (indeterminate) {
                this.setState(null);
            }
        }
        finally {
            a.recycle();
        }
    }

    public void toggle() {
        if (this.mIndeterminate) {
            this.setChecked(true);
        } else {
            super.toggle();
        }
    }

    public void setChecked(boolean checked) {
        boolean checkedChanged = this.isChecked() != checked;
        super.setChecked(checked);
        boolean wasIndeterminate = this.isIndeterminate();
        this.setIndeterminateImpl(false, false);
        if (wasIndeterminate || checkedChanged) {
            this.notifyStateListener();
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.setIndeterminateImpl(indeterminate, true);
    }

    private void setIndeterminateImpl(boolean indeterminate, boolean notify) {
        if (this.mIndeterminate != indeterminate) {
            this.mIndeterminate = indeterminate;
            this.refreshDrawableState();
            if (notify) {
                this.notifyStateListener();
            }
        }
    }

    @Override
    @ViewDebug.ExportedProperty
    public Boolean getState() {
        return this.mIndeterminate ? null : Boolean.valueOf(this.isChecked());
    }

    @Override
    public void setState(Boolean state) {
        if (state != null) {
            this.setChecked(state);
        } else {
            this.setIndeterminate(true);
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.mOnStateChangedListener = listener;
    }

    public CharSequence getAccessibilityClassName() {
        return IndeterminateRadioButton.class.getName();
    }

    private void notifyStateListener() {
        if (this.mBroadcasting) {
            return;
        }
        this.mBroadcasting = true;
        if (this.mOnStateChangedListener != null) {
            this.mOnStateChangedListener.onStateChanged(this, this.getState());
        }
        this.mBroadcasting = false;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.getState() == null) {
            IndeterminateRadioButton.mergeDrawableStates((int[])drawableState, (int[])INDETERMINATE_STATE_SET);
        }
        return drawableState;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        IndeterminateSavedState ss = new IndeterminateSavedState(superState);
        ss.indeterminate = this.mIndeterminate;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        IndeterminateSavedState ss = (IndeterminateSavedState)state;
        this.mBroadcasting = true;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mBroadcasting = false;
        this.mIndeterminate = ss.indeterminate;
        if (this.mIndeterminate || this.isChecked()) {
            this.notifyStateListener();
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(IndeterminateRadioButton var1, @Nullable Boolean var2);
    }
}

