/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import org.spatialite.Cursor;
import org.spatialite.database.SQLiteCursor;
import org.spatialite.database.SQLiteCursorDriver;
import org.spatialite.database.SQLiteDatabase;
import org.spatialite.database.SQLiteQuery;

public class SQLiteDirectCursorDriver
implements SQLiteCursorDriver {
    private String mEditTable;
    private SQLiteDatabase mDatabase;
    private Cursor mCursor;
    private String mSql;
    private SQLiteQuery mQuery;

    public SQLiteDirectCursorDriver(SQLiteDatabase db, String sql, String editTable) {
        this.mDatabase = db;
        this.mEditTable = editTable;
        this.mSql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor query(SQLiteDatabase.CursorFactory factory, String[] selectionArgs) {
        try (SQLiteQuery query = new SQLiteQuery(this.mDatabase, this.mSql, 0, selectionArgs);){
            int numArgs = selectionArgs == null ? 0 : selectionArgs.length;
            for (int i = 0; i < numArgs; ++i) {
                query.bindString(i + 1, selectionArgs[i]);
            }
            this.mCursor = factory == null ? new SQLiteCursor(this.mDatabase, this, this.mEditTable, query) : factory.newCursor(this.mDatabase, this, this.mEditTable, query);
            this.mQuery = query;
            query = null;
            Cursor cursor = this.mCursor;
            return cursor;
        }
    }

    @Override
    public void cursorClosed() {
        this.mCursor = null;
    }

    @Override
    public void setBindArguments(String[] bindArgs) {
        int numArgs = bindArgs.length;
        for (int i = 0; i < numArgs; ++i) {
            this.mQuery.bindString(i + 1, bindArgs[i]);
        }
    }

    @Override
    public void cursorDeactivated() {
    }

    @Override
    public void cursorRequeried(android.database.Cursor cursor) {
    }

    public String toString() {
        return "SQLiteDirectCursorDriver: " + this.mSql;
    }
}

