/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import android.util.Log;
import java.util.ArrayList;
import org.spatialite.database.SQLiteDatabase;

public final class SQLiteDebug {
    public static final boolean DEBUG_SQL_STATEMENTS = Log.isLoggable((String)"SQLiteStatements", (int)2);
    public static final boolean DEBUG_SQL_TIME = Log.isLoggable((String)"SQLiteTime", (int)2);
    public static final boolean DEBUG_SQL_CACHE = Log.isLoggable((String)"SQLiteCompiledSql", (int)2);
    public static final boolean DEBUG_ACTIVE_CURSOR_FINALIZATION = Log.isLoggable((String)"SQLiteCursorClosing", (int)2);
    public static final boolean DEBUG_LOCK_TIME_TRACKING = Log.isLoggable((String)"SQLiteLockTime", (int)2);
    public static final boolean DEBUG_LOCK_TIME_TRACKING_STACK_TRACE = Log.isLoggable((String)"SQLiteLockStackTrace", (int)2);
    private static int sNumActiveCursorsFinalized = 0;

    public static PagerStats getDatabaseInfo() {
        PagerStats stats = new PagerStats();
        SQLiteDebug.getPagerStats(stats);
        stats.dbStats = SQLiteDatabase.getDbStats();
        return stats;
    }

    public static native void getPagerStats(PagerStats var0);

    public static native long getHeapSize();

    public static native long getHeapAllocatedSize();

    public static native long getHeapFreeSize();

    public static native void getHeapDirtyPages(int[] var0);

    public static int getNumActiveCursorsFinalized() {
        return sNumActiveCursorsFinalized;
    }

    static synchronized void notifyActiveCursorFinalized() {
        ++sNumActiveCursorsFinalized;
    }

    public static class DbStats {
        public String dbName;
        public long pageSize;
        public long dbSize;
        public int lookaside;

        public DbStats(String dbName, long pageCount, long pageSize, int lookaside) {
            this.dbName = dbName;
            this.pageSize = pageSize;
            this.dbSize = pageCount * pageSize / 1024L;
            this.lookaside = lookaside;
        }
    }

    public static class PagerStats {
        @Deprecated
        public long totalBytes;
        @Deprecated
        public long referencedBytes;
        @Deprecated
        public long databaseBytes;
        @Deprecated
        public int numPagers;
        public int memoryUsed;
        public int pageCacheOverflo;
        public int largestMemAlloc;
        public ArrayList<DbStats> dbStats;
    }
}

