/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.netty.server;

import com.yuyenews.easy.netty.server.EasyServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyServer {
    private static Logger log = LoggerFactory.getLogger(EasyServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(int portNumber) {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
            b.channel(NioServerSocketChannel.class);
            b.childHandler((ChannelHandler)new EasyServerInitializer());
            ChannelFuture f = b.bind(portNumber).sync();
            log.info("\u542f\u52a8\u7ed3\u675f");
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            log.error("\u542f\u52a8netty\u62a5\u9519", (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

