/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.scheduler.crond;

import com.github.seratch.taskun.scheduler.crond.Crontab;
import com.github.seratch.taskun.scheduler.crond.RawCrontabLine;
import java.util.ArrayList;
import java.util.List;

class CrontabRepository {
    private List<Crontab> crontabLines = new ArrayList<Crontab>();

    public CrontabRepository(List<Crontab> crontabLines) {
        this.crontabLines = crontabLines;
    }

    public List<Crontab> getCrontabLines() {
        return this.crontabLines;
    }

    public Crontab find(Crontab crontab) {
        for (Crontab each : this.crontabLines) {
            if (!each.rawLine.equals(crontab.rawLine)) continue;
            return crontab;
        }
        return null;
    }

    public void add(Crontab crontab) {
        RawCrontabLine line;
        if (!(crontab == null || (line = crontab.rawLine) == null || line.toString().startsWith("#") || line.toString().equals("") || this.isAlreadyRegistered(crontab))) {
            this.crontabLines.add(crontab);
        }
    }

    public void remove(Crontab crontab) {
        RawCrontabLine line = crontab.rawLine;
        if (this.isAlreadyRegistered(crontab)) {
            Crontab found = new CrontabRepository(this.crontabLines).find(crontab);
            this.crontabLines.remove(found);
        }
    }

    public void replace(Crontab before, Crontab after) {
        if (this.isAlreadyRegistered(before)) {
            this.remove(before);
        }
        this.add(after);
    }

    public boolean isAlreadyRegistered(Crontab crontab) {
        for (Crontab each : this.crontabLines) {
            if (!each.rawLine.equals(crontab.rawLine)) continue;
            return true;
        }
        return false;
    }
}

