/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.scheduler.crond;

import com.github.seratch.taskun.inject.TaskunInjector;
import com.github.seratch.taskun.logging.TaskunLog;
import com.github.seratch.taskun.logging.TaskunLogUtilLoggerImpl;
import com.github.seratch.taskun.scheduler.CurrentServer;
import com.github.seratch.taskun.scheduler.config.TaskunConfig;
import com.github.seratch.taskun.scheduler.crond.Crontab;
import com.github.seratch.taskun.scheduler.crond.CrontabParser;
import com.github.seratch.taskun.scheduler.crond.CrontabRepository;
import com.github.seratch.taskun.scheduler.crond.RawCrontabLine;
import com.github.seratch.taskun.util.CalendarUtil;
import com.github.seratch.taskun.util.IOCloser;
import com.github.seratch.taskun.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CronInvocation
implements Runnable {
    static final String DEFAULT_CRONTAB_FILENAME = "crontab.txt";
    static final String LOG_PREFIX = "[Crond] ";
    private boolean isInitialized = false;
    private ScheduledExecutorService executorService;
    private TaskunInjector taskunInjector;
    private CrontabRepository crontabRepos = new CrontabRepository(new ArrayList<Crontab>());
    private long previousCheckedTimeMillis = 0L;
    private String thisServerNameIfGiven;
    private String thisServerHostname;
    private CrontabParser parser;
    private Class<? extends TaskunLog> logImplClass = TaskunLogUtilLoggerImpl.class;
    private TaskunLog taskunLog = this.getLog(CronInvocation.class.getCanonicalName());

    TaskunLog getLog() {
        return this.getLog(CronInvocation.class.getCanonicalName());
    }

    TaskunLog getLog(String name) {
        try {
            return this.logImplClass.getConstructor(String.class).newInstance(name);
        }
        catch (Throwable t) {
            return new TaskunLogUtilLoggerImpl(name);
        }
    }

    @Override
    public void run() {
        this.loggingAtEachInvocation("[Crond] Previous : " + new Date(this.previousCheckedTimeMillis).toString() + " (" + this.previousCheckedTimeMillis + ")");
        if (!this.isInitialized) {
            throw new IllegalStateException("Need to initialize CronInvocation!");
        }
        Calendar current = CalendarUtil.getCurrentTime();
        this.loggingAtEachInvocation("[Crond] Current  : " + current.getTime().toString() + " (" + current.getTimeInMillis() + ")");
        long currentCheckTime = current.getTimeInMillis();
        for (Crontab crontab : this.crontabRepos.getCrontabLines()) {
            if (crontab.isIntervalInvocation) continue;
            if (crontab.namedServers != null) {
                boolean isHostToWork = false;
                for (String name : crontab.namedServers) {
                    if (!this.thisServerNameIfGiven.equals(name)) continue;
                    isHostToWork = true;
                    break;
                }
                if (!isHostToWork) continue;
            }
            this.loggingAtEachInvocation("[Crond] Scheduled : " + crontab.rawLine + " (Next:" + new Date(crontab.nextInvocationTime).toString() + ")");
            if (crontab.nextInvocationTime <= this.previousCheckedTimeMillis || crontab.nextInvocationTime > currentCheckTime) continue;
            try {
                Runnable instance = this.getCommandWorker(crontab);
                long multiplicity = crontab.multiplicity;
                long initialDelay = crontab.initialIntervalSeconds * 1000L;
                int i = 0;
                while ((long)i < multiplicity) {
                    this.executorService.schedule(instance, initialDelay += 100L, TimeUnit.MILLISECONDS);
                    this.loggingAtEachInvocation("[Crond] >> Invoked : " + crontab.commandClassName);
                    ++i;
                }
                crontab.nextInvocationTime = this.parser.getNextInvocationTime(current, crontab);
                this.loggingAtEachInvocation("[Crond] >> Renewed : " + crontab.rawLine + "(Next:" + new Date(crontab.nextInvocationTime).toString() + ")");
            }
            catch (Exception e) {
                this.taskunLog.error(this.getClass().getCanonicalName() + " failed to execute scheduled task : " + crontab.commandClassName);
                this.taskunLog.debug(this.getClass().getCanonicalName() + " failed to execute scheduled task : " + crontab.commandClassName, e);
            }
        }
        this.previousCheckedTimeMillis = currentCheckTime;
    }

    Runnable getCommandWorker(Crontab crontabLine) throws Exception {
        final Class<?> clazz = Class.forName(crontabLine.commandClassName.toString());
        Runnable instance = null;
        try {
            instance = new Runnable(){

                @Override
                public void run() {
                    Runnable runnable = null;
                    try {
                        runnable = (Runnable)CronInvocation.this.taskunInjector.inject(clazz);
                    }
                    catch (Exception e) {
                        CronInvocation.this.getLog().error("Failed to create " + clazz.getCanonicalName() + " instance because " + e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        CronInvocation.this.getLog().error("Failed to invoke " + clazz.getCanonicalName() + " because " + e.getMessage(), e);
                    }
                }
            };
        }
        catch (Exception e) {
            this.taskunLog.debug("Command class load failed! class name : " + clazz.getCanonicalName());
        }
        if (instance == null) {
            instance = new Runnable(){

                @Override
                public void run() {
                    Runnable runnable = null;
                    try {
                        runnable = (Runnable)clazz.newInstance();
                    }
                    catch (Exception e) {
                        CronInvocation.this.getLog().error("Failed to create " + clazz.getCanonicalName() + " instance because " + e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        CronInvocation.this.getLog().error("Failed to invoke " + clazz.getCanonicalName() + " because " + e.getMessage(), e);
                    }
                }
            };
        }
        return instance;
    }

    public void initialize(TaskunInjector taskunInjector, ScheduledExecutorService executorService) {
        this.initialize(taskunInjector, executorService, DEFAULT_CRONTAB_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(TaskunInjector taskunInjector, ScheduledExecutorService executorService, String crontabFilepath) {
        BufferedReader br;
        InputStream is;
        block18: {
            this.taskunInjector = taskunInjector;
            TaskunConfig config = taskunInjector.getTaskunConfig();
            if (config != null) {
                this.logImplClass = config.getLogImplClass();
                this.taskunLog = this.getLog();
            }
            this.parser = new CrontabParser(this.logImplClass);
            this.executorService = executorService;
            is = null;
            br = null;
            is = this.getClass().getClassLoader().getResourceAsStream(crontabFilepath);
            if (is != null) break block18;
            this.taskunLog.info("Skipped the crontab scheduing because " + crontabFilepath + " did not found.");
            IOCloser.close(is);
            IOCloser.close(br);
            this.isInitialized = true;
            this.taskunLog.info("----------------------------------------");
            return;
        }
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String lineString = null;
            while ((lineString = br.readLine()) != null) {
                this.crontabRepos.add(this.parser.parseLine(new RawCrontabLine(lineString)));
            }
            this.thisServerHostname = CurrentServer.getHostname();
            this.thisServerNameIfGiven = CurrentServer.getServerName(taskunInjector.getTaskunConfig());
            if (StringUtil.isEmpty(this.thisServerNameIfGiven)) {
                this.thisServerNameIfGiven = this.thisServerHostname;
            }
            ArrayList<Crontab> newList = new ArrayList<Crontab>();
            this.taskunLog.info("----- Taskun scheduler initialized -----");
            this.taskunLog.info("Working at " + this.thisServerNameIfGiven + "(" + this.thisServerHostname + ")");
            for (Crontab crontab : this.crontabRepos.getCrontabLines()) {
                if (crontab.isIntervalInvocation) {
                    try {
                        if (crontab.namedServers != null) {
                            boolean isHostToWork = false;
                            for (String name : crontab.namedServers) {
                                if (!this.thisServerNameIfGiven.equals(name)) continue;
                                isHostToWork = true;
                                break;
                            }
                            if (!isHostToWork) continue;
                        }
                        Runnable command = this.getCommandWorker(crontab);
                        long multiplicity = crontab.multiplicity;
                        long initialDelay = crontab.initialIntervalSeconds * 1000L;
                        long delay = crontab.intervalSeconds * 1000L;
                        int i = 0;
                        while ((long)i < multiplicity) {
                            executorService.scheduleAtFixedRate(command, initialDelay += 100L, delay, TimeUnit.MILLISECONDS);
                            ++i;
                        }
                        this.taskunLog.info("Interval invocation : " + crontab.intervalSeconds + "sec," + crontab.commandClassName + "," + crontab.multiplicity);
                    }
                    catch (Exception e) {
                        this.taskunLog.error(this.getClass().getCanonicalName() + " failed to execute scheduled task : " + crontab.commandClassName);
                        this.taskunLog.debug(this.getClass().getCanonicalName() + " failed to execute scheduled task : " + crontab.commandClassName, e);
                    }
                    continue;
                }
                newList.add(crontab);
            }
            this.crontabRepos = new CrontabRepository(newList);
            for (Crontab crontab : this.crontabRepos.getCrontabLines()) {
                try {
                    Class.forName(crontab.commandClassName.toString());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Crontab file load error! (cannot load command class : " + crontab.commandClassName + ")");
                }
                this.taskunLog.info("Crontab invocation : " + crontab.rawLine);
            }
        }
        catch (IOException e) {
            try {
                this.taskunLog.error("Cannot read crontab.txt because of " + e.getLocalizedMessage());
                this.taskunLog.debug("Cannot read crontab.txt because of " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                IOCloser.close(is);
                IOCloser.close(br);
                this.isInitialized = true;
                this.taskunLog.info("----------------------------------------");
                throw throwable;
            }
            IOCloser.close(is);
            IOCloser.close(br);
            this.isInitialized = true;
            this.taskunLog.info("----------------------------------------");
        }
        IOCloser.close(is);
        IOCloser.close(br);
        this.isInitialized = true;
        this.taskunLog.info("----------------------------------------");
    }

    public void addCrontabLine(RawCrontabLine line) {
        this.crontabRepos.add(this.parser.parseLine(line));
    }

    void loggingAtEachInvocation(String message) {
        boolean isEnabled = this.taskunInjector.getTaskunConfig().enableLoggingForEachCrondInvocation;
        if (isEnabled) {
            this.taskunLog.info(message);
        }
    }

    public List<RawCrontabLine> getCurrentRawCrontabLines() {
        String serverName = null;
        try {
            serverName = CurrentServer.getServerName(this.taskunInjector.getTaskunConfig());
        }
        catch (Exception e) {
            this.taskunLog.error("Cannot get working server", e);
        }
        ArrayList<RawCrontabLine> currentRawContabLines = new ArrayList<RawCrontabLine>();
        for (Crontab crontab : this.crontabRepos.getCrontabLines()) {
            if (!crontab.isServerToInvoke(serverName)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(crontab.commandClassName);
            sb.append(",");
            if (crontab.isIntervalInvocation) {
                sb.append("interval:");
                sb.append(crontab.intervalSeconds);
                sb.append("sec");
            } else {
                sb.append("next:");
                sb.append(CalendarUtil.toYYYYMMDDHHMISS(CalendarUtil.getCalendar(crontab.nextInvocationTime)));
            }
            currentRawContabLines.add(new RawCrontabLine(sb.toString()));
        }
        return currentRawContabLines;
    }

    public long getPreviousCheckedTimeMillis() {
        return this.previousCheckedTimeMillis;
    }
}

