/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.logging;

import com.github.seratch.taskun.logging.TaskunLog;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskunLogUtilLoggerImpl
implements TaskunLog {
    private String name;
    private Logger _log;

    ClassNameAndMethodName getClassNameAndMethodName() {
        StackTraceElement frame;
        int stackDepth;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (stackDepth = 0; stackDepth < stack.length && !(frame = stack[stackDepth]).getClassName().equals("java.util.logging.Logger"); ++stackDepth) {
        }
        while (stackDepth < stack.length) {
            frame = stack[stackDepth];
            if (!frame.getClassName().equals("java.util.logging.Logger")) {
                return new ClassNameAndMethodName(frame.getClassName(), frame.getMethodName());
            }
            ++stackDepth;
        }
        return new ClassNameAndMethodName("", "");
    }

    public TaskunLogUtilLoggerImpl() {
        this._log = Logger.getAnonymousLogger();
    }

    public TaskunLogUtilLoggerImpl(Class<?> clazz) {
        this.name = clazz.getCanonicalName();
        this._log = Logger.getLogger(this.name);
    }

    public TaskunLogUtilLoggerImpl(String name) {
        this.name = name;
        this._log = Logger.getLogger(name);
    }

    @Override
    public void debug(String message) {
        this._log.fine(message);
    }

    @Override
    public void debug(String message, Throwable t) {
        ClassNameAndMethodName names = this.getClassNameAndMethodName();
        this._log.logp(Level.FINE, names.className, names.methodName, message, t);
    }

    @Override
    public void info(String message) {
        this._log.info(message);
    }

    @Override
    public void info(String message, Throwable t) {
        ClassNameAndMethodName names = this.getClassNameAndMethodName();
        this._log.logp(Level.INFO, names.className, names.methodName, message, t);
    }

    @Override
    public void warn(String message) {
        ClassNameAndMethodName names = this.getClassNameAndMethodName();
        this._log.logp(Level.WARNING, names.className, names.methodName, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        ClassNameAndMethodName names = this.getClassNameAndMethodName();
        this._log.logp(Level.WARNING, names.className, names.methodName, message, t);
    }

    @Override
    public void error(String message) {
        ClassNameAndMethodName names = this.getClassNameAndMethodName();
        this._log.logp(Level.SEVERE, names.className, names.methodName, message);
    }

    @Override
    public void error(String message, Throwable t) {
        ClassNameAndMethodName names = this.getClassNameAndMethodName();
        this._log.logp(Level.SEVERE, names.className, names.methodName, message, t);
    }

    static class ClassNameAndMethodName {
        public String className;
        public String methodName;

        ClassNameAndMethodName(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }
    }
}

