/*
 * Decompiled with CFR 0.152.
 */
package reaktor.scct;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import reaktor.scct.IO;
import scala.Function1;
import scala.Serializable;
import scala.io.Source$;
import scala.runtime.BoxedUnit;

public abstract class IO$class {
    public static Object withInputStream(IO $this, InputStream in, Function1 func) {
        try {
            return func.apply((Object)in);
        }
        finally {
            in.close();
        }
    }

    public static Object withOutputStream(IO $this, OutputStream out, Function1 func) {
        try {
            return func.apply((Object)out);
        }
        finally {
            out.close();
        }
    }

    public static Object read(IO $this, File file, Function1 func) {
        return $this.withInputStream(new FileInputStream(file), new Serializable($this, func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final T apply(FileInputStream in) {
                return (T)this.func$1.apply((Object)in);
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public static void write(IO $this, File file, Function1 func) {
        $this.withOutputStream(new FileOutputStream(file), new Serializable($this, func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$2;

            public final void apply(FileOutputStream out) {
                this.func$2.apply((Object)out);
            }
            {
                this.func$2 = func$2;
            }
        });
    }

    public static Object readObjects(IO $this, File file, Function1 func) {
        return $this.read(file, new Serializable($this, func){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IO $outer;
            private final Function1 func$3;

            public final T apply(InputStream in) {
                return (T)this.func$3.apply((Object)new IO.ClassLoaderedObjectInputStream(this.$outer, in, this.$outer.getClass().getClassLoader()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.func$3 = func$3;
            }
        });
    }

    public static void writeObjects(IO $this, File file, Function1 func) {
        $this.write(file, (Function1<OutputStream, BoxedUnit>)new Serializable($this, func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$4;

            public final void apply(OutputStream out) {
                this.func$4.apply((Object)new ObjectOutputStream(out));
            }
            {
                this.func$4 = func$4;
            }
        });
    }

    public static void write(IO $this, File file, byte[] content) {
        $this.write(file, (Function1<OutputStream, BoxedUnit>)new Serializable($this, content){
            public static final long serialVersionUID = 0L;
            private final byte[] content$1;

            public final void apply(OutputStream x$1) {
                x$1.write(this.content$1);
            }
            {
                this.content$1 = content$1;
            }
        });
    }

    public static String readResource(IO $this, String resourceName) {
        return (String)$this.withInputStream($this.getClass().getResourceAsStream(resourceName), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(InputStream in) {
                return Source$.MODULE$.fromInputStream(in, "utf-8").mkString();
            }
        });
    }

    public static byte[] readResourceBytes(IO $this, String resourceName) {
        return (byte[])$this.withInputStream($this.getClass().getResourceAsStream(resourceName), new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IO $outer;

            public final byte[] apply(InputStream in) {
                return IO$class.reaktor$scct$IO$$toBytes(this.$outer, in);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] reaktor$scct$IO$$toBytes(IO $this, InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IO$class.transfer($this, in, out, new byte[8192]);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        out.close();
        return out.toByteArray();
    }

    private static OutputStream transfer(IO $this, InputStream in, OutputStream out, byte[] buffer) {
        int count;
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        return out;
    }

    public static String relativePath(IO $this, File f, File to) {
        return to.toURI().relativize(f.toURI()).toString();
    }

    public static void $init$(IO $this) {
    }
}

