/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.xtooltip;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.LruCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lit/sephiroth/android/library/xtooltip/Typefaces;", "", "()V", "FONT_CACHE", "Landroid/util/LruCache;", "", "Landroid/graphics/Typeface;", "get", "c", "Landroid/content/Context;", "assetPath", "xtooltip_release"})
public final class Typefaces {
    private static final LruCache<String, Typeface> FONT_CACHE;
    public static final Typefaces INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Typeface get(@NotNull Context c, @NotNull String assetPath) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)assetPath, (String)"assetPath");
        LruCache<String, Typeface> lruCache = FONT_CACHE;
        synchronized (lruCache) {
            Typeface typeface;
            block6: {
                typeface = (Typeface)FONT_CACHE.get((Object)assetPath);
                if (typeface != null) break block6;
                try {
                    typeface = Typeface.createFromAsset((AssetManager)c.getAssets(), (String)assetPath);
                    FONT_CACHE.put((Object)assetPath, (Object)typeface);
                }
                catch (Exception e) {
                    Timber.e((String)("Could not get typeface '" + assetPath + "' because " + e.getMessage()), (Object[])new Object[0]);
                    Typeface typeface2 = null;
                    return typeface2;
                }
            }
            Typeface typeface3 = typeface;
            return typeface3;
        }
    }

    private Typefaces() {
    }

    static {
        Typefaces typefaces;
        INSTANCE = typefaces = new Typefaces();
        FONT_CACHE = new LruCache(4);
    }
}

