/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.numberpicker;

import android.content.res.Resources;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import it.sephiroth.android.library.numberpicker.NumberPicker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\b \u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH&J\u0018\u0010.\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0016J\r\u0010/\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020\tH\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00062"}, d2={"Lit/sephiroth/android/library/numberpicker/Tracker;", "", "numberPicker", "Lit/sephiroth/android/library/numberpicker/NumberPicker;", "maxDistance", "", "orientation", "callback", "Lkotlin/Function1;", "", "(Lit/sephiroth/android/library/numberpicker/NumberPicker;IILkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function1;", "downPosition", "", "getDownPosition$numberpicker_release", "()F", "setDownPosition$numberpicker_release", "(F)V", "initialValue", "getInitialValue$numberpicker_release", "()I", "setInitialValue$numberpicker_release", "(I)V", "getMaxDistance", "minDistance", "getMinDistance", "setMinDistance", "minPoint", "Landroid/graphics/PointF;", "getMinPoint$numberpicker_release", "()Landroid/graphics/PointF;", "setMinPoint$numberpicker_release", "(Landroid/graphics/PointF;)V", "getNumberPicker", "()Lit/sephiroth/android/library/numberpicker/NumberPicker;", "getOrientation", "started", "", "getStarted$numberpicker_release", "()Z", "setStarted$numberpicker_release", "(Z)V", "addMovement", "x", "y", "begin", "calcDistance", "calcDistance$numberpicker_release", "end", "numberpicker_release"})
public abstract class Tracker {
    private boolean started;
    private int initialValue;
    private float downPosition;
    @NotNull
    private PointF minPoint;
    private float minDistance;
    @NotNull
    private final NumberPicker numberPicker;
    private final int maxDistance;
    private final int orientation;
    @NotNull
    private final Function1<Integer, Unit> callback;

    public final boolean getStarted$numberpicker_release() {
        return this.started;
    }

    public final void setStarted$numberpicker_release(boolean bl) {
        this.started = bl;
    }

    public final int getInitialValue$numberpicker_release() {
        return this.initialValue;
    }

    public final void setInitialValue$numberpicker_release(int n) {
        this.initialValue = n;
    }

    public final float getDownPosition$numberpicker_release() {
        return this.downPosition;
    }

    public final void setDownPosition$numberpicker_release(float f) {
        this.downPosition = f;
    }

    @NotNull
    public final PointF getMinPoint$numberpicker_release() {
        return this.minPoint;
    }

    public final void setMinPoint$numberpicker_release(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.minPoint = pointF;
    }

    public void begin(float x, float y) {
        Timber.i((String)("begin(" + x + ", " + y + ')'), (Object[])new Object[0]);
        this.calcDistance$numberpicker_release();
        this.downPosition = this.orientation == 1 ? -y : x;
        this.minPoint.set(-this.minDistance, -this.minDistance);
        this.initialValue = this.numberPicker.getProgress();
        this.started = true;
    }

    public abstract void addMovement(float var1, float var2);

    public void end() {
        Timber.i((String)"end()", (Object[])new Object[0]);
        this.started = false;
    }

    public final float getMinDistance() {
        return this.minDistance;
    }

    public final void setMinDistance(float f) {
        this.minDistance = f;
    }

    public final void calcDistance$numberpicker_release() {
        float f;
        Tracker tracker;
        Timber.i((String)("maxDistance: " + this.maxDistance), (Object[])new Object[0]);
        int[] loc = new int[]{0, 0};
        Resources resources = this.numberPicker.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"numberPicker.resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        this.numberPicker.getLocationOnScreen(loc);
        loc[0] = loc[0] + this.numberPicker.getWidth() / 2;
        loc[1] = loc[1] + this.numberPicker.getHeight() / 2;
        Tracker tracker2 = this;
        if (this.orientation == 1) {
            int n;
            int n2 = this.maxDistance;
            int n3 = loc[1];
            int n4 = metrics.heightPixels - loc[1];
            Tracker tracker3 = tracker2;
            n3 = n = Math.min(n3, n4);
            n = Math.min(n2, n3);
            tracker = tracker3;
            f = n;
        } else {
            int n;
            int n5 = this.maxDistance;
            int n6 = loc[0];
            int n7 = metrics.widthPixels - loc[0];
            Tracker tracker4 = tracker2;
            n6 = n = Math.min(n6, n7);
            n = Math.min(n5, n6);
            tracker = tracker4;
            f = n;
        }
        tracker.minDistance = f;
    }

    @NotNull
    public final NumberPicker getNumberPicker() {
        return this.numberPicker;
    }

    public final int getMaxDistance() {
        return this.maxDistance;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final Function1<Integer, Unit> getCallback() {
        return this.callback;
    }

    public Tracker(@NotNull NumberPicker numberPicker, int maxDistance, int orientation, @NotNull Function1<? super Integer, Unit> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)numberPicker), (String)"numberPicker");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        this.numberPicker = numberPicker;
        this.maxDistance = maxDistance;
        this.orientation = orientation;
        this.callback = callback2;
        this.minPoint = new PointF(0.0f, 0.0f);
    }
}

