/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.GeometryKt;
import it.sephiroth.android.library.uigestures.UIDiscreteGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0001TB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010?\u001a\u00020@H\u0002J@\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020!H\u0002J\u0010\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020KH\u0014J\b\u0010L\u001a\u00020@H\u0002J\u0010\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020\u0001H\u0016J\u0010\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020@H\u0014J\b\u0010S\u001a\u00020@H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u000bR\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u000bR\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000bR\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u001a\u0010&\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000bR\u001a\u0010)\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\t\"\u0004\b+\u0010\u000bR\u001a\u0010,\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\t\"\u0004\b.\u0010\u000bR\u001e\u00100\u001a\u00020!2\u0006\u0010/\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010#R\u001e\u00102\u001a\u00020!2\u0006\u0010/\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010#R$\u00104\u001a\u00020!2\u0006\u0010/\u001a\u00020!@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010#\"\u0004\b6\u00107R$\u00108\u001a\u00020!2\u0006\u0010/\u001a\u00020!@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010#\"\u0004\b:\u00107R\u001e\u0010;\u001a\u00020!2\u0006\u0010/\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010#R\u001e\u0010=\u001a\u00020!2\u0006\u0010/\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010#\u00a8\u0006U"}, d2={"Lit/sephiroth/android/library/uigestures/UISwipeGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIDiscreteGestureRecognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "direction", "", "getDirection", "()I", "setDirection", "(I)V", "mDown", "", "mDownFocusLocation", "Landroid/graphics/PointF;", "mLastFocusLocation", "mStarted", "mVelocityTracker", "Landroid/view/VelocityTracker;", "maximumTouchFlingTime", "getMaximumTouchFlingTime", "setMaximumTouchFlingTime", "maximumTouchSlopTime", "getMaximumTouchSlopTime", "setMaximumTouchSlopTime", "minimumSwipeDistance", "getMinimumSwipeDistance", "setMinimumSwipeDistance", "numberOfTouchesRequired", "getNumberOfTouchesRequired", "setNumberOfTouchesRequired", "relativeScrollX", "", "getRelativeScrollX", "()F", "relativeScrollY", "getRelativeScrollY", "scaledMaximumFlingVelocity", "getScaledMaximumFlingVelocity", "setScaledMaximumFlingVelocity", "scaledMinimumFlingVelocity", "getScaledMinimumFlingVelocity", "setScaledMinimumFlingVelocity", "scaledTouchSlop", "getScaledTouchSlop", "setScaledTouchSlop", "<set-?>", "scrollX", "getScrollX", "scrollY", "getScrollY", "translationX", "getTranslationX", "setTranslationX$uigesturerecognizer_release", "(F)V", "translationY", "getTranslationY", "setTranslationY$uigesturerecognizer_release", "xVelocity", "getXVelocity", "yVelocity", "getYVelocity", "fireActionEventIfCanRecognizeSimultaneously", "", "getTouchDirection", "x1", "y1", "x2", "y2", "velocityX", "velocityY", "distanceThreshold", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "onStateChanged", "recognizer", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UISwipeGestureRecognizer
extends UIGestureRecognizer
implements UIDiscreteGestureRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int scaledMinimumFlingVelocity;
    private int scaledMaximumFlingVelocity;
    private int direction;
    private int numberOfTouchesRequired;
    private float scrollX;
    private float scrollY;
    private float translationX;
    private float translationY;
    private float yVelocity;
    private float xVelocity;
    private int scaledTouchSlop;
    private int minimumSwipeDistance;
    private int maximumTouchSlopTime;
    private int maximumTouchFlingTime;
    private boolean mDown;
    private boolean mStarted;
    @NotNull
    private final PointF mLastFocusLocation;
    @NotNull
    private final PointF mDownFocusLocation;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private static final int MESSAGE_RESET = 4;
    public static final int RIGHT = 2;
    public static final int LEFT = 4;
    public static final int UP = 8;
    public static final int DOWN = 16;
    public static final int MAXIMUM_TOUCH_SLOP_TIME = 150;
    public static final int MAXIMUM_TOUCH_FLING_TIME = 300;

    public UISwipeGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.direction = 2;
        this.numberOfTouchesRequired = 1;
        this.maximumTouchSlopTime = 150;
        this.maximumTouchFlingTime = 300;
        this.mLastFocusLocation = new PointF();
        this.mDownFocusLocation = new PointF();
        this.mStarted = false;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.scaledTouchSlop = configuration.getScaledTouchSlop();
        this.scaledMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.scaledMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.minimumSwipeDistance = (int)((float)this.scaledTouchSlop * 3.0f);
        if (UIGestureRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "scaledTouchSlop: " + this.scaledTouchSlop);
            this.logMessage(4, "minimumSwipeDistance: " + this.minimumSwipeDistance);
            this.logMessage(4, "scaledMinimumFlingVelocity: " + this.scaledMinimumFlingVelocity);
            this.logMessage(4, "scaledMaximumFlingVelocity: " + this.scaledMaximumFlingVelocity);
        }
    }

    public final int getScaledMinimumFlingVelocity() {
        return this.scaledMinimumFlingVelocity;
    }

    public final void setScaledMinimumFlingVelocity(int n) {
        this.scaledMinimumFlingVelocity = n;
    }

    public final int getScaledMaximumFlingVelocity() {
        return this.scaledMaximumFlingVelocity;
    }

    public final void setScaledMaximumFlingVelocity(int n) {
        this.scaledMaximumFlingVelocity = n;
    }

    public final int getDirection() {
        return this.direction;
    }

    public final void setDirection(int n) {
        this.direction = n;
    }

    public final int getNumberOfTouchesRequired() {
        return this.numberOfTouchesRequired;
    }

    public final void setNumberOfTouchesRequired(int n) {
        this.numberOfTouchesRequired = n;
    }

    public final float getScrollX() {
        return this.scrollX;
    }

    public final float getScrollY() {
        return this.scrollY;
    }

    public final float getRelativeScrollX() {
        return -this.scrollX;
    }

    public final float getRelativeScrollY() {
        return -this.scrollY;
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX$uigesturerecognizer_release(float f) {
        this.translationX = f;
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY$uigesturerecognizer_release(float f) {
        this.translationY = f;
    }

    public final float getYVelocity() {
        return this.yVelocity;
    }

    public final float getXVelocity() {
        return this.xVelocity;
    }

    public final int getScaledTouchSlop() {
        return this.scaledTouchSlop;
    }

    public final void setScaledTouchSlop(int n) {
        this.scaledTouchSlop = n;
    }

    public final int getMinimumSwipeDistance() {
        return this.minimumSwipeDistance;
    }

    public final void setMinimumSwipeDistance(int n) {
        this.minimumSwipeDistance = n;
    }

    public final int getMaximumTouchSlopTime() {
        return this.maximumTouchSlopTime;
    }

    public final void setMaximumTouchSlopTime(int n) {
        this.maximumTouchSlopTime = n;
    }

    public final int getMaximumTouchFlingTime() {
        return this.maximumTouchFlingTime;
    }

    public final void setMaximumTouchFlingTime(int n) {
        this.maximumTouchFlingTime = n;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg.what == 4) {
            this.handleReset();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    private final void handleReset() {
        this.mStarted = false;
        this.setBeginFiringEvents(false);
        this.setState(UIGestureRecognizer.State.Possible);
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{4};
        this.removeMessages(nArray);
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Ended) {
            this.removeMessages();
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
            if (!this.mDown) {
                this.mStarted = false;
                this.setState(UIGestureRecognizer.State.Possible);
            }
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.mStarted && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Ended})) {
                this.mStarted = false;
                this.setBeginFiringEvents(false);
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
            }
        }
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
        Intrinsics.checkNotNull((Object)uIGestureRecognizerDelegate);
        if (uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.addMovement(event);
        }
        switch (action) {
            case 5: {
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                if (this.getState() != UIGestureRecognizer.State.Possible || this.mStarted || this.getNumberOfTouches() <= this.numberOfTouchesRequired) break;
                this.setState(UIGestureRecognizer.State.Failed);
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 6: {
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                VelocityTracker velocityTracker2 = this.mVelocityTracker;
                if (velocityTracker2 != null) {
                    velocityTracker2.computeCurrentVelocity(1000, (float)this.scaledMaximumFlingVelocity);
                }
                int upIndex = event.getActionIndex();
                int id1 = event.getPointerId(upIndex);
                VelocityTracker velocityTracker3 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker3);
                float x1 = velocityTracker3.getXVelocity(id1);
                VelocityTracker velocityTracker4 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker4);
                float y1 = velocityTracker4.getYVelocity(id1);
                int n = this.getNumberOfTouches();
                for (int i = 0; i < n; ++i) {
                    if (i == upIndex) continue;
                    int id2 = event.getPointerId(i);
                    VelocityTracker velocityTracker5 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker5);
                    float x = x1 * velocityTracker5.getXVelocity(id2);
                    VelocityTracker velocityTracker6 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker6);
                    float y = y1 * velocityTracker6.getYVelocity(id2);
                    float dot = x + y;
                    if (!(dot < 0.0f)) continue;
                    VelocityTracker velocityTracker7 = this.mVelocityTracker;
                    if (velocityTracker7 == null) break;
                    velocityTracker7.clear();
                    break;
                }
                if (this.getState() != UIGestureRecognizer.State.Possible || this.mStarted || this.getNumberOfTouches() >= this.numberOfTouchesRequired) break;
                this.setState(UIGestureRecognizer.State.Failed);
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 0: {
                Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) break;
                this.mStarted = false;
                this.mDown = true;
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                VelocityTracker velocityTracker8 = this.mVelocityTracker;
                if (velocityTracker8 != null) {
                    velocityTracker8.clear();
                }
                this.setBeginFiringEvents(false);
                int[] upIndex = new int[]{4};
                this.removeMessages(upIndex);
                this.setState(UIGestureRecognizer.State.Possible);
                break;
            }
            case 2: {
                this.scrollX = this.mLastFocusLocation.x - this.getMCurrentLocation().x;
                this.scrollY = this.mLastFocusLocation.y - this.getMCurrentLocation().y;
                VelocityTracker velocityTracker9 = this.mVelocityTracker;
                if (velocityTracker9 != null) {
                    velocityTracker9.computeCurrentVelocity(1000, (float)this.scaledMaximumFlingVelocity);
                }
                VelocityTracker velocityTracker10 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker10);
                this.yVelocity = velocityTracker10.getYVelocity();
                VelocityTracker velocityTracker11 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker11);
                this.xVelocity = velocityTracker11.getXVelocity();
                if (this.getState() != UIGestureRecognizer.State.Possible) break;
                float distance = GeometryKt.distance(this.getMCurrentLocation(), this.mDownFocusLocation);
                this.logMessage(4, "started: " + this.mStarted + ", distance: " + distance + ", slop: " + this.scaledTouchSlop);
                if (!this.mStarted) {
                    if (!(distance > (float)this.scaledTouchSlop)) break;
                    this.translationX -= this.scrollX;
                    this.translationY -= this.scrollY;
                    this.mLastFocusLocation.set(this.getMCurrentLocation());
                    this.mStarted = true;
                    if (this.getNumberOfTouches() == this.numberOfTouchesRequired) {
                        long time = event.getEventTime() - event.getDownTime();
                        this.logMessage(2, "time: " + time + ", maximumTouchSlopTime: " + this.maximumTouchSlopTime);
                        if (time > (long)this.maximumTouchSlopTime) {
                            this.logMessage(5, "passed too much time 1 (" + time + " > " + this.maximumTouchSlopTime + ")");
                            this.mStarted = false;
                            this.setBeginFiringEvents(false);
                            this.setState(UIGestureRecognizer.State.Failed);
                            break;
                        }
                        int direction = this.getTouchDirection(this.mDownFocusLocation.x, this.mDownFocusLocation.y, this.getMCurrentLocation().x, this.getMCurrentLocation().y, this.xVelocity, this.yVelocity, 0.0f);
                        this.logMessage(2, "(1) direction: " + direction);
                        if (!(this.xVelocity == 0.0f) || !(this.yVelocity == 0.0f)) {
                            if (direction == -1 || (this.direction & direction) == 0) {
                                this.logMessage(5, "invalid direction: " + direction);
                                this.mStarted = false;
                                this.setBeginFiringEvents(false);
                                this.setState(UIGestureRecognizer.State.Failed);
                                break;
                            }
                            this.logMessage(3, "direction accepted: " + (this.direction & direction));
                            this.mStarted = true;
                            break;
                        }
                        this.logMessage(5, "velocity is still 0, waiting for the next event...");
                        this.mDownFocusLocation.set(this.getMCurrentLocation());
                        this.mStarted = false;
                        break;
                    }
                    this.logMessage(5, "invalid number of touches (" + this.getNumberOfTouches() + " != " + this.numberOfTouchesRequired + ")");
                    this.mStarted = false;
                    this.setBeginFiringEvents(false);
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                long time = event.getEventTime() - event.getDownTime();
                if (time > (long)this.maximumTouchFlingTime) {
                    this.logMessage(5, "passed too much time 2 (" + time + " > " + this.maximumTouchFlingTime + ")");
                    this.mStarted = false;
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                int direction = this.getTouchDirection(this.mDownFocusLocation.x, this.mDownFocusLocation.y, this.getMCurrentLocation().x, this.getMCurrentLocation().y, this.xVelocity, this.yVelocity, this.minimumSwipeDistance);
                if (direction == -1) break;
                if ((this.direction & direction) != 0) {
                    Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    Boolean bl = function1 != null && (function1 = function1.getShouldBegin()) != null ? (Boolean)function1.invoke((Object)this) : null;
                    Intrinsics.checkNotNull(bl);
                    if (bl.booleanValue()) {
                        this.setState(UIGestureRecognizer.State.Ended);
                        if (this.getRequireFailureOf() == null) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            break;
                        }
                        UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                        Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                        if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            break;
                        }
                        UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                        Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed};
                        if (uIGestureRecognizer2.inState(stateArray)) {
                            this.mStarted = false;
                            this.setBeginFiringEvents(false);
                            this.setState(UIGestureRecognizer.State.Failed);
                            break;
                        }
                        this.logMessage(3, "waiting...");
                        this.listenForOtherStateChanges();
                        this.setBeginFiringEvents(false);
                        break;
                    }
                    this.setState(UIGestureRecognizer.State.Failed);
                    this.mStarted = false;
                    this.setBeginFiringEvents(false);
                    break;
                }
                this.mStarted = false;
                this.setBeginFiringEvents(false);
                this.setState(UIGestureRecognizer.State.Failed);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker12 = this.mVelocityTracker;
                if (velocityTracker12 != null) {
                    velocityTracker12.addMovement(event);
                }
                if (this.mVelocityTracker != null) {
                    VelocityTracker velocityTracker13 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker13);
                    velocityTracker13.recycle();
                    this.mVelocityTracker = null;
                }
                this.mDown = false;
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 3: {
                if (this.mVelocityTracker != null) {
                    VelocityTracker velocityTracker14 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker14);
                    velocityTracker14.recycle();
                    this.mVelocityTracker = null;
                }
                this.mDown = false;
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.getMHandler().sendEmptyMessage(4);
            }
        }
        return this.getCancelsTouchesInView();
    }

    private final int getTouchDirection(float x1, float y1, float x2, float y2, float velocityX, float velocityY, float distanceThreshold) {
        float diffY = y2 - y1;
        float diffX = x2 - x1;
        if (UIGestureRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "getTouchDirection");
            this.logMessage(2, "diff: " + diffX + ", " + diffY + ", distanceThreshold: " + distanceThreshold);
            this.logMessage(2, "velocity: " + velocityX + ", " + velocityY + ", scaledMinimumFlingVelocity: " + this.scaledMinimumFlingVelocity + ", scaledMaximumFlingVelocity: " + this.scaledMaximumFlingVelocity);
        }
        if (Math.abs(diffX) > Math.abs(diffY)) {
            if (Math.abs(diffX) > distanceThreshold && Math.abs(velocityX) > (float)this.scaledMinimumFlingVelocity) {
                return diffX > 0.0f ? 2 : 4;
            }
        } else if (Math.abs(diffY) > distanceThreshold && Math.abs(velocityY) > (float)this.scaledMinimumFlingVelocity) {
            return diffY > 0.0f ? 16 : 8;
        }
        return -1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lit/sephiroth/android/library/uigestures/UISwipeGestureRecognizer$Companion;", "", "()V", "DOWN", "", "LEFT", "MAXIMUM_TOUCH_FLING_TIME", "MAXIMUM_TOUCH_SLOP_TIME", "MESSAGE_RESET", "RIGHT", "UP", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

