/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.UIDiscreteGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;

public final class UITapGestureRecognizer
extends UIGestureRecognizer
implements UIDiscreteGestureRecognizer {
    private static final int MESSAGE_FAILED = 1;
    private static final int MESSAGE_RESET = 2;
    private static final int MESSAGE_POINTER_UP = 3;
    private static final int MESSAGE_LONG_PRESS = 4;
    private static final String TAG = UITapGestureRecognizer.class.getSimpleName();
    private final int mDoubleTapTouchSlopSquare;
    private int mTouchesRequired = 1;
    private int mTapsRequired = 1;
    private boolean mAlwaysInTapRegion;
    private float mDownFocusX;
    private float mDownFocusY;
    private int mTouchSlopSquare;
    private boolean mStarted = false;
    private int mNumTaps = 0;
    private int mNumTouches = 0;
    private long mTapTimeout;
    private final PointF mCurrentLocation = new PointF();

    public UITapGestureRecognizer(@Nullable Context context) {
        super(context);
        int doubleTapTouchSlop;
        int touchSlop;
        if (context == null) {
            doubleTapTouchSlop = touchSlop = ViewConfiguration.getTouchSlop();
        } else {
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            touchSlop = configuration.getScaledTouchSlop();
            doubleTapTouchSlop = 8;
        }
        this.mTapTimeout = ViewConfiguration.getTapTimeout();
        this.mTouchSlopSquare = touchSlop * touchSlop;
        this.mDoubleTapTouchSlopSquare = doubleTapTouchSlop * doubleTapTouchSlop;
    }

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                this.logMessage(4, "handleMessage(MESSAGE_RESET)", new Object[0]);
                this.handleReset();
                break;
            }
            case 1: {
                this.logMessage(4, "handleMessage(MESSAGE_FAILED)", new Object[0]);
                this.handleFailed();
                break;
            }
            case 3: {
                this.logMessage(4, "handleMessage(MESSAGE_POINTER_UP)", new Object[0]);
                this.mNumTouches = msg.arg1;
                break;
            }
            case 4: {
                this.logMessage(4, "handleMessage(MESSAGE_LONG_PRESS)", new Object[0]);
                this.handleFailed();
                break;
            }
        }
    }

    public void setTapTimeout(long mTapTimeout) {
        this.mTapTimeout = mTapTimeout;
    }

    public void setNumberOfTapsRequired(int value) {
        this.mTapsRequired = value;
    }

    public void setNumberOfTouchesRequired(int value) {
        this.mTouchesRequired = value;
    }

    @Override
    public void onStateChanged(@NonNull UIGestureRecognizer recognizer) {
        if (sDebug) {
            this.logMessage(2, "onStateChanged(%s): %s", new Object[]{recognizer, recognizer.getState()});
            this.logMessage(2, "this.state: %s", new Object[]{this.getState()});
            this.logMessage(2, "mStarted: %s", this.mStarted);
        }
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Ended) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
            this.postReset();
        } else if (recognizer.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended) && this.mStarted && this.inState(UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Ended)) {
            this.stopListenForOtherStateChanges();
            this.removeMessages();
            this.setState(UIGestureRecognizer.State.Failed);
            this.mStarted = false;
        }
    }

    @Override
    public int getNumberOfTouches() {
        return this.mNumTouches;
    }

    @Override
    protected boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (!this.isEnabled()) {
            return false;
        }
        int action = ev.getAction();
        int count = ev.getPointerCount();
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        this.mCurrentLocation.set(focusX, focusY);
        switch (action & 0xFF) {
            case 0: {
                this.removeMessages();
                this.mAlwaysInTapRegion = true;
                this.mNumTouches = count;
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                if (!this.mStarted) {
                    this.stopListenForOtherStateChanges();
                    this.mNumTaps = 0;
                    this.mStarted = true;
                }
                this.mHandler.sendEmptyMessageDelayed(4, this.mTapTimeout);
                ++this.mNumTaps;
                this.mDownFocusX = focusX;
                this.mDownFocusY = focusY;
                break;
            }
            case 5: {
                if (this.getState() != UIGestureRecognizer.State.Possible || !this.mStarted) break;
                this.removeMessages(3);
                this.mNumTouches = count;
                if (this.mNumTouches > 1 && this.mNumTouches > this.mTouchesRequired) {
                    this.setState(UIGestureRecognizer.State.Failed);
                }
                this.mDownFocusX = focusX;
                this.mDownFocusY = focusY;
                break;
            }
            case 6: {
                if (this.getState() != UIGestureRecognizer.State.Possible || !this.mStarted) break;
                this.removeMessages(1, 2, 3);
                this.mDownFocusX = focusX;
                this.mDownFocusY = focusY;
                Message message = this.mHandler.obtainMessage(3);
                message.arg1 = this.mNumTouches - 1;
                this.mHandler.sendMessageDelayed(message, TAP_TIMEOUT);
                break;
            }
            case 2: {
                int slop;
                if (this.getState() != UIGestureRecognizer.State.Possible || !this.mStarted || !this.mAlwaysInTapRegion) break;
                int deltaX = (int)(focusX - this.mDownFocusX);
                int deltaY = (int)(focusY - this.mDownFocusY);
                int distance = deltaX * deltaX + deltaY * deltaY;
                int n = slop = this.mTapsRequired > 1 ? this.mDoubleTapTouchSlopSquare : this.mTouchSlopSquare;
                if (distance <= slop) break;
                this.logMessage(5, "moved too much!", new Object[0]);
                this.mAlwaysInTapRegion = false;
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
                break;
            }
            case 1: {
                this.removeMessages(2, 3, 4);
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    if (this.mNumTouches != this.mTouchesRequired) {
                        this.handleFailed();
                        break;
                    }
                    if (this.mNumTaps < this.mTapsRequired) {
                        this.delayedFail();
                        break;
                    }
                    if (this.getDelegate().shouldBegin(this)) {
                        this.setState(UIGestureRecognizer.State.Ended);
                        if (null == this.getRequireFailureOf()) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            this.postReset();
                        } else if (this.getRequireFailureOf().getState() == UIGestureRecognizer.State.Failed) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            this.postReset();
                        } else if (this.getRequireFailureOf().inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed)) {
                            this.setState(UIGestureRecognizer.State.Failed);
                        } else {
                            this.listenForOtherStateChanges();
                            this.logMessage(3, "waiting...", new Object[0]);
                        }
                    } else {
                        this.setState(UIGestureRecognizer.State.Failed);
                    }
                    this.mStarted = false;
                    break;
                }
                this.handleReset();
                break;
            }
            case 3: {
                this.removeMessages();
                this.mStarted = false;
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.postReset();
                break;
            }
        }
        return this.getCancelsTouchesInView();
    }

    private void fireActionEventIfCanRecognizeSimultaneously() {
        if (this.getDelegate().shouldRecognizeSimultaneouslyWithGestureRecognizer(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    @Override
    protected boolean hasBeganFiringEvents() {
        return super.hasBeganFiringEvents() && this.inState(UIGestureRecognizer.State.Ended);
    }

    @Override
    protected void removeMessages() {
        this.removeMessages(1, 2, 3, 4);
    }

    private void postReset() {
        this.mHandler.sendEmptyMessage(2);
    }

    private void delayedFail() {
        this.mHandler.sendEmptyMessageDelayed(1, DOUBLE_TAP_TIMEOUT);
    }

    private void handleFailed() {
        this.setState(UIGestureRecognizer.State.Failed);
        this.setBeginFiringEvents(false);
        this.removeMessages();
        this.mStarted = false;
    }

    private void handleReset() {
        this.setState(UIGestureRecognizer.State.Possible);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
    }

    @Override
    public float getCurrentLocationX() {
        return this.mCurrentLocation.x;
    }

    @Override
    public float getCurrentLocationY() {
        return this.mCurrentLocation.y;
    }
}

