/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.UIDiscreteGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;

public class UISwipeGestureRecognizer
extends UIGestureRecognizer
implements UIDiscreteGestureRecognizer {
    private static final int MESSAGE_RESET = 4;
    public static final int RIGHT = 2;
    public static final int LEFT = 4;
    public static final int UP = 8;
    public static final int DOWN = 16;
    private static final int SWIPE_THRESHOLD = 100;
    private static final int SWIPE_VELOCITY_THRESHOLD = 100;
    public static final int MAXIMUM_TOUCH_SLOP_TIME = 150;
    public static final int MAXIMUM_TOUCH_FLING_TIME = 300;
    private int mTouchSlopSquare;
    private int mMaximumFlingVelocity;
    private boolean mStarted = false;
    private int mDirection = 2;
    private int mNumberOfTouchesRequired = 1;
    private float mLastFocusX;
    private float mLastFocusY;
    private float mDownFocusX;
    private float mDownFocusY;
    private VelocityTracker mVelocityTracker;
    private float scrollX;
    private float scrollY;
    private float mTranslationX;
    private float mTranslationY;
    private float mVelocityY;
    private float mVelocityX;
    private final PointF mCurrentLocation;
    private long mDownTime;
    private int mTouches = 0;
    private boolean mDown;

    public UISwipeGestureRecognizer(@NonNull Context context) {
        super(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        int touchSlop = configuration.getScaledTouchSlop();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mTouchSlopSquare = touchSlop * touchSlop;
        this.mCurrentLocation = new PointF();
    }

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 4: {
                this.mStarted = false;
                this.setBeginFiringEvents(false);
                this.setState(UIGestureRecognizer.State.Possible);
                break;
            }
        }
    }

    @Override
    protected void removeMessages() {
        this.removeMessages(4);
    }

    @Override
    public int getNumberOfTouches() {
        return this.mTouches;
    }

    @Override
    public void onStateChanged(@NonNull UIGestureRecognizer recognizer) {
        this.logMessage(2, "onStateChanged(%s, %s)", new Object[]{recognizer, recognizer.getState()});
        this.logMessage(2, "started: %b, state: %s", new Object[]{this.mStarted, this.getState()});
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Ended) {
            this.removeMessages();
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
            if (!this.mDown) {
                this.mStarted = false;
                this.setState(UIGestureRecognizer.State.Possible);
            }
        } else if (recognizer.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended) && this.mStarted && this.inState(UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Ended)) {
            this.mStarted = false;
            this.setBeginFiringEvents(false);
            this.stopListenForOtherStateChanges();
            this.removeMessages();
            this.setState(UIGestureRecognizer.State.Failed);
        }
    }

    private void fireActionEventIfCanRecognizeSimultaneously() {
        if (this.getDelegate().shouldRecognizeSimultaneouslyWithGestureRecognizer(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setNumberOfTouchesRequired(int value) {
        this.mNumberOfTouchesRequired = value;
    }

    public int getNumberOfTouchesRequired() {
        return this.mNumberOfTouchesRequired;
    }

    @Override
    protected boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (!this.isEnabled()) {
            return false;
        }
        int action = ev.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        boolean pointerUp = (action & 0xFF) == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = ev.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        this.mCurrentLocation.x = focusX;
        this.mCurrentLocation.y = focusY;
        this.mTouches = pointerUp ? count - 1 : count;
        switch (action & 0xFF) {
            case 5: {
                this.mLastFocusX = focusX;
                this.mLastFocusY = focusY;
                if (this.getState() != UIGestureRecognizer.State.Possible || this.mStarted || count <= this.mNumberOfTouchesRequired) break;
                this.setState(UIGestureRecognizer.State.Failed);
                this.removeMessages(4);
                break;
            }
            case 6: {
                this.mLastFocusX = focusX;
                this.mLastFocusY = focusY;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                int upIndex = ev.getActionIndex();
                int id1 = ev.getPointerId(upIndex);
                float x1 = this.mVelocityTracker.getXVelocity(id1);
                float y1 = this.mVelocityTracker.getYVelocity(id1);
                for (int i = 0; i < count; ++i) {
                    float y;
                    int id2;
                    float x;
                    float dot;
                    if (i == upIndex || !((dot = (x = x1 * this.mVelocityTracker.getXVelocity(id2 = ev.getPointerId(i))) + (y = y1 * this.mVelocityTracker.getYVelocity(id2))) < 0.0f)) continue;
                    this.mVelocityTracker.clear();
                    break;
                }
                if (this.getState() != UIGestureRecognizer.State.Possible || this.mStarted || count - 1 >= this.mNumberOfTouchesRequired) break;
                this.setState(UIGestureRecognizer.State.Failed);
                this.removeMessages(4);
                break;
            }
            case 0: {
                this.mStarted = false;
                this.mDown = true;
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.mDownTime = ev.getEventTime();
                this.mVelocityTracker.clear();
                this.setBeginFiringEvents(false);
                this.removeMessages(4);
                this.setState(UIGestureRecognizer.State.Possible);
                break;
            }
            case 2: {
                this.scrollX = this.mLastFocusX - focusX;
                this.scrollY = this.mLastFocusY - focusY;
                if (this.getState() != UIGestureRecognizer.State.Possible) break;
                int deltaX = (int)(focusX - this.mDownFocusX);
                int deltaY = (int)(focusY - this.mDownFocusY);
                int distance = deltaX * deltaX + deltaY * deltaY;
                if (!this.mStarted) {
                    if (distance <= this.mTouchSlopSquare) break;
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                    this.mVelocityY = this.mVelocityTracker.getYVelocity();
                    this.mVelocityX = this.mVelocityTracker.getXVelocity();
                    this.mTranslationX -= this.scrollX;
                    this.mTranslationY -= this.scrollY;
                    this.mLastFocusX = focusX;
                    this.mLastFocusY = focusY;
                    this.mStarted = true;
                    if (count == this.mNumberOfTouchesRequired) {
                        long time = ev.getEventTime() - ev.getDownTime();
                        if (time > 150L) {
                            this.logMessage(5, "passed too much time", new Object[0]);
                            this.mStarted = false;
                            this.setBeginFiringEvents(false);
                            this.setState(UIGestureRecognizer.State.Failed);
                            break;
                        }
                        int direction = this.getTouchDirection(this.mDownFocusX, this.mDownFocusY, focusX, focusY, this.mVelocityX, this.mVelocityY, 0.0f);
                        this.logMessage(2, "time: " + (ev.getEventTime() - this.mDownTime) + " or " + (ev.getEventTime() - ev.getDownTime()), new Object[0]);
                        this.logMessage(2, "direction: " + direction, new Object[0]);
                        if (direction == -1 || (this.mDirection & direction) == 0) {
                            this.mStarted = false;
                            this.setBeginFiringEvents(false);
                            this.setState(UIGestureRecognizer.State.Failed);
                            break;
                        }
                        this.logMessage(3, "direction accepted: " + (this.mDirection & direction), new Object[0]);
                        this.mStarted = true;
                        break;
                    }
                    this.mStarted = false;
                    this.setBeginFiringEvents(false);
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                this.mVelocityY = this.mVelocityTracker.getYVelocity();
                this.mVelocityX = this.mVelocityTracker.getXVelocity();
                long time = ev.getEventTime() - ev.getDownTime();
                if (time > 300L) {
                    this.mStarted = false;
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                int direction = this.getTouchDirection(this.mDownFocusX, this.mDownFocusY, focusX, focusY, this.mVelocityX, this.mVelocityY, 100.0f);
                if (direction == -1) break;
                if ((this.mDirection & direction) != 0) {
                    if (this.getDelegate().shouldBegin(this)) {
                        this.setState(UIGestureRecognizer.State.Ended);
                        if (null == this.getRequireFailureOf()) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            break;
                        }
                        if (this.getRequireFailureOf().getState() == UIGestureRecognizer.State.Failed) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            break;
                        }
                        if (this.getRequireFailureOf().inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed)) {
                            this.mStarted = false;
                            this.setBeginFiringEvents(false);
                            this.setState(UIGestureRecognizer.State.Failed);
                            break;
                        }
                        this.logMessage(3, "waiting...", new Object[0]);
                        this.listenForOtherStateChanges();
                        this.setBeginFiringEvents(false);
                        break;
                    }
                    this.setState(UIGestureRecognizer.State.Failed);
                    this.mStarted = false;
                    this.setBeginFiringEvents(false);
                    break;
                }
                this.mStarted = false;
                this.setBeginFiringEvents(false);
                this.setState(UIGestureRecognizer.State.Failed);
                break;
            }
            case 1: {
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mDown = false;
                this.removeMessages(4);
                break;
            }
            case 3: {
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mDown = false;
                this.removeMessages(4);
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.mHandler.sendEmptyMessage(4);
                break;
            }
        }
        return this.getCancelsTouchesInView();
    }

    private int getTouchDirection(float x1, float y1, float x2, float y2, float velocityX, float velocityY, float distanceThreshold) {
        float diffY = y2 - y1;
        float diffX = x2 - x1;
        this.logMessage(2, "diff: %gx%g", Float.valueOf(diffX), Float.valueOf(diffY));
        this.logMessage(2, "velocity: %gx%g", Float.valueOf(velocityX), Float.valueOf(velocityY));
        if (Math.abs(diffX) > Math.abs(diffY)) {
            if (Math.abs(diffX) > distanceThreshold && Math.abs(velocityX) > 100.0f) {
                if (diffX > 0.0f) {
                    return 2;
                }
                return 4;
            }
        } else if (Math.abs(diffY) > distanceThreshold && Math.abs(velocityY) > 100.0f) {
            if (diffY > 0.0f) {
                return 16;
            }
            return 8;
        }
        return -1;
    }

    public float getXVelocity() {
        return this.mVelocityX;
    }

    public float getYVelocity() {
        return this.mVelocityY;
    }

    public void setTranslationX(float mTranslationX) {
        this.mTranslationX = mTranslationX;
    }

    public void setTranslationY(float mTranslationY) {
        this.mTranslationY = mTranslationY;
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public float getScrollX() {
        return -this.scrollX;
    }

    public float getScrollY() {
        return -this.scrollY;
    }

    @Override
    public float getCurrentLocationX() {
        return this.mCurrentLocation.x;
    }

    @Override
    public float getCurrentLocationY() {
        return this.mCurrentLocation.y;
    }
}

