/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.os.Message;
import android.view.MotionEvent;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005JH\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001fH\u0002J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u00020-H\u0002J\b\u00102\u001a\u00020\u0007H\u0016J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0001H\u0016J\u0010\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\fH\u0016J\b\u00107\u001a\u00020-H\u0014J\b\u00108\u001a\u00020-H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lit/sephiroth/android/library/uigestures/UIRotateGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIContinuousRecognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mDown", "", "mInitialRotation", "", "mPreviousAngle", "mPreviousEvent", "Landroid/view/MotionEvent;", "mPtrID1", "", "mPtrID2", "mStarted", "mValid", "rotationInDegrees", "getRotationInDegrees", "()D", "<set-?>", "rotationInRadians", "getRotationInRadians", "rotationThreshold", "getRotationThreshold", "setRotationThreshold", "(D)V", "velocity", "getVelocity", "x1", "", "x2", "y1", "y2", "angleBetweenLines", "fX", "fY", "sX", "sY", "nfX", "nfY", "nsX", "nsY", "fireActionEventIfCanRecognizeSimultaneously", "", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onStateChanged", "recognizer", "onTouchEvent", "event", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UIRotateGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double rotationThreshold;
    private double rotationInRadians;
    private double mInitialRotation;
    private double mPreviousAngle;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private double velocity;
    private boolean mValid;
    private boolean mStarted;
    private boolean mDown;
    private int mPtrID1;
    private int mPtrID2;
    @Nullable
    private MotionEvent mPreviousEvent;
    private static final int MESSAGE_RESET = 1;
    private static final int INVALID_POINTER_ID = -1;
    private static final double ROTATION_SLOP = 0.008;

    public UIRotateGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.rotationThreshold = 0.008;
        this.mPtrID1 = -1;
        this.mPtrID2 = -1;
        this.velocity = 0.0;
    }

    public final double getRotationThreshold() {
        return this.rotationThreshold;
    }

    public final void setRotationThreshold(double d) {
        this.rotationThreshold = d;
    }

    public final double getRotationInRadians() {
        return this.rotationInRadians;
    }

    public final double getVelocity() {
        return this.velocity;
    }

    public final double getRotationInDegrees() {
        double angle = Math.toDegrees(this.rotationInRadians) % (double)360;
        if (angle < -180.0) {
            angle += 360.0;
        }
        if (angle > 180.0) {
            angle -= 360.0;
        }
        return angle;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg.what == 1) {
            this.handleReset();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    private final void handleReset() {
        this.setState(UIGestureRecognizer.State.Possible);
        this.mInitialRotation = 0.0;
        this.setBeginFiringEvents(false);
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Possible}) && this.mStarted) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
            }
        }
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended};
        if (this.inState(stateArray)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else {
            UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
            Intrinsics.checkNotNull((Object)uIGestureRecognizerDelegate);
            if (uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) {
                this.setBeginFiringEvents(true);
                this.fireActionEvent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        switch (action) {
            case 0: {
                Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) {
                    return this.getCancelsTouchesInView();
                }
                this.mValid = false;
                this.mStarted = false;
                this.mDown = true;
                this.mInitialRotation = 0.0;
                this.stopListenForOtherStateChanges();
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                break;
            }
            case 5: {
                if (this.mDown && this.getNumberOfTouches() == 2 && this.getState() != UIGestureRecognizer.State.Failed) {
                    this.mPtrID1 = event.getPointerId(0);
                    this.mPtrID2 = event.getPointerId(1);
                    this.x1 = event.getX(event.findPointerIndex(this.mPtrID1));
                    this.y1 = event.getY(event.findPointerIndex(this.mPtrID1));
                    this.x2 = event.getX(event.findPointerIndex(this.mPtrID2));
                    this.y2 = event.getY(event.findPointerIndex(this.mPtrID2));
                    this.mValid = true;
                } else {
                    this.mValid = false;
                }
                this.mInitialRotation = 0.0;
                this.mStarted = false;
                break;
            }
            case 6: {
                if (this.mDown && this.getNumberOfTouches() == 2 && this.getState() != UIGestureRecognizer.State.Failed) {
                    int pointerIndex = (event.getAction() & 0xFF00) >> 8;
                    int pointerId = event.getPointerId(pointerIndex);
                    boolean found = false;
                    int n = event.getPointerCount();
                    for (int i = 0; i < n; ++i) {
                        int id = event.getPointerId(i);
                        if (id == pointerId) continue;
                        if (!found) {
                            this.mPtrID1 = id;
                        } else {
                            this.mPtrID2 = id;
                        }
                        found = true;
                    }
                    this.x1 = event.getX(event.findPointerIndex(this.mPtrID1));
                    this.y1 = event.getY(event.findPointerIndex(this.mPtrID1));
                    this.x2 = event.getX(event.findPointerIndex(this.mPtrID2));
                    this.y2 = event.getY(event.findPointerIndex(this.mPtrID2));
                    this.mValid = true;
                } else {
                    this.mValid = false;
                }
                this.mStarted = false;
                this.mInitialRotation = 0.0;
                break;
            }
            case 1: {
                UIGestureRecognizer.State[] pointerIndex;
                this.mValid = false;
                this.mStarted = false;
                this.mDown = false;
                this.mPreviousAngle = 0.0;
                this.mInitialRotation = 0.0;
                this.velocity = 0.0;
                if (this.mPreviousEvent != null) {
                    MotionEvent motionEvent = this.mPreviousEvent;
                    Intrinsics.checkNotNull((Object)motionEvent);
                    motionEvent.recycle();
                    this.mPreviousEvent = null;
                }
                if (!this.inState(pointerIndex = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed})) break;
                boolean began = this.hasBeganFiringEvents();
                this.setState(UIGestureRecognizer.State.Ended);
                if (began) {
                    this.fireActionEvent();
                }
                this.getMHandler().sendEmptyMessage(1);
                break;
            }
            case 2: {
                if (!this.mValid || this.getState() == UIGestureRecognizer.State.Failed) break;
                float nx1 = event.getX(event.findPointerIndex(this.mPtrID1));
                float ny1 = event.getY(event.findPointerIndex(this.mPtrID1));
                float nx2 = event.getX(event.findPointerIndex(this.mPtrID2));
                float ny2 = event.getY(event.findPointerIndex(this.mPtrID2));
                if (!this.mStarted && this.mDown) {
                    this.mInitialRotation += this.angleBetweenLines(this.x2, this.y2, this.x1, this.y1, nx2, ny2, nx1, ny1);
                    this.logMessage(4, "mInitialRotation, " + this.mInitialRotation + ", " + this.rotationThreshold);
                    if (Math.abs(this.mInitialRotation) > this.rotationThreshold) {
                        this.mStarted = true;
                        Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                        Boolean bl = function1 != null && (function1 = function1.getShouldBegin()) != null ? (Boolean)function1.invoke((Object)this) : null;
                        Intrinsics.checkNotNull(bl);
                        if (bl.booleanValue()) {
                            this.setState(UIGestureRecognizer.State.Began);
                            if (this.getRequireFailureOf() == null) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                            } else {
                                UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                                Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                                if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                                    this.fireActionEventIfCanRecognizeSimultaneously();
                                } else {
                                    UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                                    Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                                    UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed};
                                    if (uIGestureRecognizer2.inState(stateArray)) {
                                        this.setState(UIGestureRecognizer.State.Failed);
                                    } else {
                                        this.listenForOtherStateChanges();
                                        this.setBeginFiringEvents(false);
                                        this.logMessage(3, "waiting...");
                                    }
                                }
                            }
                        } else {
                            this.setState(UIGestureRecognizer.State.Failed);
                        }
                    }
                } else if (this.mStarted && this.mDown) {
                    this.rotationInRadians = this.angleBetweenLines(this.x2, this.y2, this.x1, this.y1, nx2, ny2, nx1, ny1);
                    if (this.getState() == UIGestureRecognizer.State.Began) {
                        if (this.hasBeganFiringEvents()) {
                            this.setState(UIGestureRecognizer.State.Changed);
                            this.fireActionEvent();
                        }
                    } else if (this.getState() == UIGestureRecognizer.State.Changed) {
                        this.setState(UIGestureRecognizer.State.Changed);
                        this.fireActionEvent();
                    }
                }
                MotionEvent motionEvent = this.mPreviousEvent;
                if (motionEvent != null) {
                    MotionEvent it = motionEvent;
                    boolean bl = false;
                    double diff = Math.max(this.rotationInRadians, this.mPreviousAngle) - Math.min(this.rotationInRadians, this.mPreviousAngle);
                    long time = event.getEventTime() - it.getEventTime();
                    this.velocity = time > 0L ? (double)((long)1000 / time) * diff : 0.0;
                    it.recycle();
                }
                this.x1 = event.getX(event.findPointerIndex(this.mPtrID1));
                this.y1 = event.getY(event.findPointerIndex(this.mPtrID1));
                this.x2 = event.getX(event.findPointerIndex(this.mPtrID2));
                this.y2 = event.getY(event.findPointerIndex(this.mPtrID2));
                this.mPreviousEvent = MotionEvent.obtain((MotionEvent)event);
                this.mPreviousAngle = this.rotationInRadians;
                break;
            }
            case 3: {
                this.mPtrID1 = -1;
                this.mPtrID2 = -1;
                this.mValid = false;
                this.mStarted = false;
                this.mDown = false;
                this.mPreviousAngle = 0.0;
                this.velocity = 0.0;
                if (this.mPreviousEvent != null) {
                    MotionEvent motionEvent = this.mPreviousEvent;
                    Intrinsics.checkNotNull((Object)motionEvent);
                    motionEvent.recycle();
                    this.mPreviousEvent = null;
                }
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.getMHandler().sendEmptyMessage(1);
            }
        }
        return this.getCancelsTouchesInView();
    }

    private final double angleBetweenLines(float fX, float fY, float sX, float sY, float nfX, float nfY, float nsX, float nsY) {
        double angle1 = (float)Math.atan2(fY - sY, fX - sX);
        double angle2 = (float)Math.atan2(nfY - nsY, nfX - nsX);
        return angle1 >= 0.0 && angle2 >= 0.0 || angle1 < 0.0 && angle2 < 0.0 ? angle2 - angle1 : (angle2 < 0.0 ? angle1 + angle2 : angle2 + angle1);
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{1};
        this.removeMessages(nArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lit/sephiroth/android/library/uigestures/UIRotateGestureRecognizer$Companion;", "", "()V", "INVALID_POINTER_ID", "", "MESSAGE_RESET", "ROTATION_SLOP", "", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

