/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import it.sephiroth.android.library.uigestures.ScaleGestureDetector;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001FB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002052\u0006\u00107\u001a\u000208H\u0014J\b\u00109\u001a\u000205H\u0002J\b\u0010:\u001a\u00020\u0014H\u0016J\u0010\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u001eH\u0016J\u0010\u0010>\u001a\u0002052\u0006\u0010<\u001a\u00020\u001eH\u0016J\u0010\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020\u0001H\u0016J\u0010\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u000205H\u0014J\b\u0010E\u001a\u000205H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\u0012\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u00020 8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0011\u0010'\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\nR\u0011\u0010)\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\nR\u001e\u0010,\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\nR\u0011\u0010.\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\nR\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006G"}, d2={"Lit/sephiroth/android/library/uigestures/UIPinchGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIContinuousRecognizer;", "Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$OnScaleGestureListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentLocationX", "", "getCurrentLocationX", "()F", "currentLocationY", "getCurrentLocationY", "currentSpan", "getCurrentSpan", "currentSpanX", "getCurrentSpanX", "currentSpanY", "getCurrentSpanY", "value", "", "isQuickScaleEnabled", "()Z", "setQuickScaleEnabled", "(Z)V", "isStylusScaleEnabled", "isStylusScaleEnabled$annotations", "()V", "setStylusScaleEnabled", "mScaleGestureDetector", "Lit/sephiroth/android/library/uigestures/ScaleGestureDetector;", "numberOfTouches", "", "getNumberOfTouches", "()I", "setNumberOfTouches", "(I)V", "previousSpan", "getPreviousSpan", "previousSpanX", "getPreviousSpanX", "previousSpanY", "getPreviousSpanY", "<set-?>", "scale", "getScale", "scaleFactor", "getScaleFactor", "timeDelta", "", "getTimeDelta", "()J", "fireActionEventIfCanRecognizeSimultaneously", "", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onScale", "detector", "onScaleBegin", "onScaleEnd", "onStateChanged", "recognizer", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UIPinchGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer,
ScaleGestureDetector.OnScaleGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScaleGestureDetector mScaleGestureDetector;
    private float scale;
    private int numberOfTouches;
    private static final int MESSAGE_RESET = 1;

    public UIPinchGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this, new Handler(Looper.getMainLooper()));
        this.setQuickScaleEnabled(Build.VERSION.SDK_INT >= 19);
    }

    public final float getScale() {
        return this.scale;
    }

    @Override
    public int getNumberOfTouches() {
        return this.mScaleGestureDetector.getNumberOfTouches();
    }

    public void setNumberOfTouches(int n) {
        this.numberOfTouches = n;
    }

    public final float getScaleFactor() {
        return this.mScaleGestureDetector.getScaleFactor();
    }

    @Override
    public float getCurrentLocationX() {
        return this.mScaleGestureDetector.getFocusX();
    }

    @Override
    public float getCurrentLocationY() {
        return this.mScaleGestureDetector.getFocusY();
    }

    public final float getCurrentSpan() {
        return this.mScaleGestureDetector.getCurrentSpan();
    }

    public final float getCurrentSpanX() {
        return this.mScaleGestureDetector.getCurrentSpanX();
    }

    public final float getCurrentSpanY() {
        return this.mScaleGestureDetector.getCurrentSpanY();
    }

    public final float getPreviousSpan() {
        return this.mScaleGestureDetector.getPreviousSpan();
    }

    public final float getPreviousSpanX() {
        return this.mScaleGestureDetector.getPreviousSpanX();
    }

    public final float getPreviousSpanY() {
        return this.mScaleGestureDetector.getPreviousSpanY();
    }

    public final long getTimeDelta() {
        return this.mScaleGestureDetector.getTimeDelta();
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg.what == 1) {
            this.handleReset();
        }
    }

    private final void handleReset() {
        this.setState(UIGestureRecognizer.State.Possible);
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    public final boolean isQuickScaleEnabled() {
        return Build.VERSION.SDK_INT > 18 ? this.mScaleGestureDetector.isQuickScaleEnabled() : false;
    }

    public final void setQuickScaleEnabled(boolean value) {
        if (Build.VERSION.SDK_INT > 18) {
            this.mScaleGestureDetector.setQuickScaleEnabled(value);
        }
    }

    public final boolean isStylusScaleEnabled() {
        return this.mScaleGestureDetector.isStylusScaleEnabled();
    }

    public final void setStylusScaleEnabled(boolean value) {
        this.mScaleGestureDetector.setStylusScaleEnabled(value);
    }

    public static /* synthetic */ void isStylusScaleEnabled$annotations() {
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (this.isEnabled()) {
            this.mScaleGestureDetector.onTouchEvent(event);
            return this.getCancelsTouchesInView();
        }
        return false;
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began})) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
            }
        }
    }

    @Override
    public boolean onScale(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        if (this.isEnabled()) {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
            if (this.inState(stateArray)) {
                this.scale += detector.getScaleFactor() - 1.0f;
                if (this.getState() == UIGestureRecognizer.State.Began) {
                    if (this.hasBeganFiringEvents()) {
                        this.setState(UIGestureRecognizer.State.Changed);
                        this.fireActionEvent();
                    }
                } else if (this.getState() == UIGestureRecognizer.State.Changed) {
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                }
            }
        }
        return true;
    }

    @Override
    public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.setState(UIGestureRecognizer.State.Possible);
        if (this.isEnabled() && this.getState() == UIGestureRecognizer.State.Possible) {
            Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
            Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
            Intrinsics.checkNotNull(bl);
            if (bl.booleanValue()) {
                this.scale = detector.getScaleFactor();
                Object[] objectArray = new int[]{1};
                this.removeMessages((int[])objectArray);
                Function1<UIGestureRecognizer, Boolean> function12 = this.getDelegate$uigesturerecognizer_release();
                Boolean bl2 = function12 != null && (function12 = function12.getShouldBegin()) != null ? (Boolean)function12.invoke((Object)this) : null;
                Intrinsics.checkNotNull(bl2);
                if (bl2.booleanValue()) {
                    this.setState(UIGestureRecognizer.State.Began);
                    if (this.getRequireFailureOf() == null) {
                        this.fireActionEventIfCanRecognizeSimultaneously();
                    } else {
                        UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                        Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                        if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                        } else {
                            UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                            Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                            objectArray = (Object[])new UIGestureRecognizer.State[3];
                            objectArray[0] = (int)UIGestureRecognizer.State.Began;
                            objectArray[1] = (int)UIGestureRecognizer.State.Ended;
                            objectArray[2] = (int)UIGestureRecognizer.State.Changed;
                            if (uIGestureRecognizer2.inState((UIGestureRecognizer.State[])objectArray)) {
                                this.setState(UIGestureRecognizer.State.Failed);
                            } else {
                                this.listenForOtherStateChanges();
                                this.setBeginFiringEvents(false);
                                this.logMessage(3, "waiting...");
                            }
                        }
                    }
                } else {
                    this.setState(UIGestureRecognizer.State.Failed);
                }
                return this.getCancelsTouchesInView();
            }
        }
        return this.getCancelsTouchesInView();
    }

    @Override
    public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
        if (this.inState(stateArray)) {
            boolean began = this.hasBeganFiringEvents();
            this.setState(UIGestureRecognizer.State.Ended);
            if (began) {
                this.fireActionEvent();
            }
            this.getMHandler().sendEmptyMessage(1);
        }
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended};
        if (this.inState(stateArray)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else {
            UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
            Intrinsics.checkNotNull((Object)uIGestureRecognizerDelegate);
            if (uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) {
                this.setBeginFiringEvents(true);
                this.fireActionEvent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{1};
        this.removeMessages(nArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lit/sephiroth/android/library/uigestures/UIPinchGestureRecognizer$Companion;", "", "()V", "MESSAGE_RESET", "", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

