/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.GeometryKt;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000206H\u0002J\b\u00108\u001a\u000206H\u0002J\b\u00109\u001a\u000206H\u0002J\u0010\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020<H\u0014J\b\u0010=\u001a\u000206H\u0002J\b\u0010>\u001a\u00020\u0017H\u0016J\u0010\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020\u0001H\u0016J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u000206H\u0002J\b\u0010E\u001a\u000206H\u0014J\b\u0010F\u001a\u000206H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\t\"\u0004\b\"\u0010\u000bR\u001a\u0010#\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\t\"\u0004\b%\u0010\u000bR\u001a\u0010&\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000bR\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u001a\u0010/\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\t\"\u0004\b1\u0010\u000bR\u001a\u00102\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\t\"\u0004\b4\u0010\u000b\u00a8\u0006H"}, d2={"Lit/sephiroth/android/library/uigestures/UILongPressGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIContinuousRecognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "allowableMovement", "", "getAllowableMovement", "()I", "setAllowableMovement", "(I)V", "value", "", "doubleTapTimeout", "getDoubleTapTimeout", "()J", "setDoubleTapTimeout", "(J)V", "longPressTimeout", "getLongPressTimeout", "setLongPressTimeout", "mAlwaysInTapRegion", "", "mBegan", "mDownFocusLocation", "Landroid/graphics/PointF;", "mNumTaps", "mPreviousTapLocation", "mStartLocation", "mStarted", "<set-?>", "numberOfTouches", "getNumberOfTouches", "setNumberOfTouches$uigesturerecognizer_release", "scaledDoubleTapSlop", "getScaledDoubleTapSlop", "setScaledDoubleTapSlop", "scaledTouchSlop", "getScaledTouchSlop", "setScaledTouchSlop", "startLocationX", "", "getStartLocationX", "()F", "startLocationY", "getStartLocationY", "tapsRequired", "getTapsRequired", "setTapsRequired", "touchesRequired", "getTouchesRequired", "setTouchesRequired", "delayedFail", "", "fireActionEventIfCanRecognizeSimultaneously", "handleFailed", "handleLongPress", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onStateChanged", "recognizer", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "postReset", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UILongPressGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long doubleTapTimeout;
    private int numberOfTouches;
    private long longPressTimeout;
    private int touchesRequired;
    private int tapsRequired;
    private boolean mAlwaysInTapRegion;
    private boolean mStarted;
    @NotNull
    private final PointF mStartLocation;
    @NotNull
    private final PointF mDownFocusLocation;
    private int mNumTaps;
    private boolean mBegan;
    @NotNull
    private final PointF mPreviousTapLocation;
    private int allowableMovement;
    private int scaledTouchSlop;
    private int scaledDoubleTapSlop;
    private static final int MESSAGE_FAILED = 1;
    private static final int MESSAGE_RESET = 2;
    private static final int MESSAGE_POINTER_UP = 3;
    private static final int MESSAGE_LONG_PRESS = 4;

    public UILongPressGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.doubleTapTimeout = UIGestureRecognizer.Companion.getDOUBLE_TAP_TIMEOUT();
        this.longPressTimeout = Math.max(UIGestureRecognizer.Companion.getLONG_PRESS_TIMEOUT(), this.doubleTapTimeout);
        this.touchesRequired = 1;
        this.tapsRequired = 1;
        this.mStartLocation = new PointF();
        this.mDownFocusLocation = new PointF();
        this.mNumTaps = 1;
        this.mPreviousTapLocation = new PointF();
        this.mStarted = false;
        this.mBegan = false;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.scaledTouchSlop = configuration.getScaledTouchSlop();
        this.scaledDoubleTapSlop = configuration.getScaledDoubleTapSlop();
        this.allowableMovement = configuration.getScaledTouchSlop();
        if (UIGestureRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "allowableMovement: " + this.allowableMovement);
            this.logMessage(4, "scaledTouchSlop: " + this.scaledTouchSlop);
            this.logMessage(4, "scaledDoubleTapSlop: " + this.scaledDoubleTapSlop);
            this.logMessage(4, "longPressTimeout: " + this.longPressTimeout);
            this.logMessage(4, "doubleTapTimeout: " + this.doubleTapTimeout);
        }
    }

    public final long getDoubleTapTimeout() {
        return this.doubleTapTimeout;
    }

    public final void setDoubleTapTimeout(long value) {
        this.doubleTapTimeout = value;
        if (value > this.longPressTimeout) {
            this.longPressTimeout = value + (long)5;
        }
    }

    @Override
    public int getNumberOfTouches() {
        return this.numberOfTouches;
    }

    public void setNumberOfTouches$uigesturerecognizer_release(int n) {
        this.numberOfTouches = n;
    }

    public final long getLongPressTimeout() {
        return this.longPressTimeout;
    }

    public final void setLongPressTimeout(long l) {
        this.longPressTimeout = l;
    }

    public final int getTouchesRequired() {
        return this.touchesRequired;
    }

    public final void setTouchesRequired(int n) {
        this.touchesRequired = n;
    }

    public final int getTapsRequired() {
        return this.tapsRequired;
    }

    public final void setTapsRequired(int n) {
        this.tapsRequired = n;
    }

    public final float getStartLocationX() {
        return this.mStartLocation.x;
    }

    public final float getStartLocationY() {
        return this.mStartLocation.y;
    }

    public final int getAllowableMovement() {
        return this.allowableMovement;
    }

    public final void setAllowableMovement(int n) {
        this.allowableMovement = n;
    }

    public final int getScaledTouchSlop() {
        return this.scaledTouchSlop;
    }

    public final void setScaledTouchSlop(int n) {
        this.scaledTouchSlop = n;
    }

    public final int getScaledDoubleTapSlop() {
        return this.scaledDoubleTapSlop;
    }

    public final void setScaledDoubleTapSlop(int n) {
        this.scaledDoubleTapSlop = n;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (msg.what) {
            case 2: {
                this.logMessage(4, "handleMessage(MESSAGE_RESET)");
                this.handleReset();
                break;
            }
            case 1: {
                this.logMessage(4, "handleMessage(MESSAGE_FAILED)");
                this.handleFailed();
                break;
            }
            case 3: {
                this.logMessage(4, "handleMessage(MESSAGE_POINTER_UP)");
                this.setNumberOfTouches$uigesturerecognizer_release(msg.arg1);
                break;
            }
            case 4: {
                this.logMessage(4, "handleMessage(MESSAGE_LONG_PRESS)");
                this.handleLongPress();
            }
        }
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        UIGestureRecognizer.State state = recognizer.getState();
        this.logMessage(2, "onStateChanged(" + (state != null ? state.name() : null) + ", started: " + this.mStarted + ")");
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
            if (this.mBegan && this.hasBeganFiringEvents()) {
                this.setState(UIGestureRecognizer.State.Changed);
            }
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.mStarted && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began})) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
                this.setBeginFiringEvents(false);
                this.mStarted = false;
            }
        }
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        int count = event.getPointerCount();
        switch (action & 0xFF) {
            case 0: {
                if (!this.mStarted) {
                    Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) {
                        return this.getCancelsTouchesInView();
                    }
                }
                this.removeMessages();
                this.mAlwaysInTapRegion = true;
                this.setNumberOfTouches$uigesturerecognizer_release(count);
                this.mBegan = false;
                if (!this.mStarted) {
                    this.stopListenForOtherStateChanges();
                    this.setState(UIGestureRecognizer.State.Possible);
                    this.setBeginFiringEvents(false);
                    this.mNumTaps = 1;
                    this.mStarted = true;
                } else {
                    float distance;
                    int n = this.mNumTaps;
                    this.mNumTaps = n + 1;
                    if (this.touchesRequired == 1 && this.tapsRequired > 1 && (distance = GeometryKt.distance(this.getMDownLocation(), this.getMPreviousDownLocation())) > (float)this.scaledDoubleTapSlop) {
                        this.logMessage(2, "distance: " + distance);
                        this.logMessage(5, "second touch too far away (" + distance + " > " + this.scaledDoubleTapSlop + ")");
                        this.handleFailed();
                        return this.getCancelsTouchesInView();
                    }
                }
                this.logMessage(2, "num taps: " + this.mNumTaps + ", tapsRequired: " + this.tapsRequired);
                if (this.mNumTaps == this.tapsRequired) {
                    this.getMHandler().sendEmptyMessageAtTime(4, event.getDownTime() + this.longPressTimeout);
                } else {
                    this.delayedFail();
                }
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                this.mStartLocation.set(this.getMCurrentLocation());
                break;
            }
            case 5: {
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    int[] distance = new int[]{3};
                    this.removeMessages(distance);
                    this.setNumberOfTouches$uigesturerecognizer_release(count);
                    if (this.getNumberOfTouches() > 1) {
                        if (this.getNumberOfTouches() > this.touchesRequired) {
                            this.removeMessages();
                            this.setState(UIGestureRecognizer.State.Failed);
                        } else if (this.getNumberOfTouches() == this.touchesRequired && this.tapsRequired > 1) {
                            if (this.mNumTaps < this.tapsRequired) {
                                this.mPreviousTapLocation.set(this.getMCurrentLocation());
                            } else if (this.mNumTaps == this.tapsRequired && (distance = GeometryKt.distance(this.getMCurrentLocation(), this.mPreviousTapLocation)) > (float)this.scaledDoubleTapSlop) {
                                this.logMessage(5, "distance is " + distance + " > " + this.scaledDoubleTapSlop);
                                this.handleFailed();
                                return this.getCancelsTouchesInView();
                            }
                        }
                    }
                    this.mDownFocusLocation.set(this.getMCurrentLocation());
                    this.computeFocusPoint(event, this.mStartLocation);
                    break;
                }
                UIGestureRecognizer.State[] distance = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
                if (!this.inState(distance) || !this.mStarted) break;
                this.setNumberOfTouches$uigesturerecognizer_release(count);
                break;
            }
            case 6: {
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    int[] distance = new int[]{3};
                    this.removeMessages(distance);
                    this.mDownFocusLocation.set(this.getMCurrentLocation());
                    Message message = this.getMHandler().obtainMessage(3);
                    Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtainMessage(...)");
                    Message message2 = message;
                    message2.arg1 = this.getNumberOfTouches() - 1;
                    this.getMHandler().sendMessageDelayed(message2, UIGestureRecognizer.Companion.getTAP_TIMEOUT());
                    this.computeFocusPoint(event, this.mStartLocation);
                    break;
                }
                UIGestureRecognizer.State[] message2 = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
                if (!this.inState(message2) || this.getNumberOfTouches() - 1 >= this.touchesRequired) break;
                boolean began = this.hasBeganFiringEvents();
                this.setState(UIGestureRecognizer.State.Ended);
                if (began) {
                    this.fireActionEvent();
                }
                this.setBeginFiringEvents(false);
                break;
            }
            case 2: {
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    float distance;
                    if (!this.mAlwaysInTapRegion || !((distance = GeometryKt.distance(this.getMCurrentLocation(), this.mDownFocusLocation)) > (float)this.allowableMovement)) break;
                    this.logMessage(5, "distance: " + distance + ", allowableMovement: " + this.allowableMovement);
                    this.logMessage(5, "moved too much!: " + distance + " > " + this.allowableMovement);
                    this.mAlwaysInTapRegion = false;
                    this.removeMessages();
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                if (this.getState() == UIGestureRecognizer.State.Began) {
                    float distance;
                    if (this.mBegan || !((distance = GeometryKt.distance(this.getMCurrentLocation(), this.mDownFocusLocation)) > (float)this.scaledTouchSlop)) break;
                    this.logMessage(5, "distance: " + distance + ", allowableMovement: " + this.scaledTouchSlop);
                    this.mBegan = true;
                    if (!this.hasBeganFiringEvents()) break;
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                    break;
                }
                if (this.getState() != UIGestureRecognizer.State.Changed) break;
                this.setState(UIGestureRecognizer.State.Changed);
                if (!this.hasBeganFiringEvents()) break;
                this.fireActionEvent();
                break;
            }
            case 1: {
                Object[] distance = new int[]{2, 3, 4};
                this.removeMessages((int[])distance);
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    if (this.getNumberOfTouches() != this.touchesRequired) {
                        this.mStarted = false;
                        this.removeMessages();
                        this.setState(UIGestureRecognizer.State.Failed);
                        this.postReset();
                    } else if (this.mNumTaps < this.tapsRequired) {
                        distance = new int[]{1};
                        this.removeMessages((int[])distance);
                        this.delayedFail();
                    } else {
                        this.mNumTaps = 1;
                        this.mStarted = false;
                        this.removeMessages();
                        this.setState(UIGestureRecognizer.State.Failed);
                    }
                } else {
                    distance = (Object[])new UIGestureRecognizer.State[2];
                    distance[0] = (int)UIGestureRecognizer.State.Began;
                    distance[1] = (int)UIGestureRecognizer.State.Changed;
                    if (this.inState((UIGestureRecognizer.State[])distance)) {
                        this.mNumTaps = 1;
                        this.mStarted = false;
                        boolean began = this.hasBeganFiringEvents();
                        this.setState(UIGestureRecognizer.State.Ended);
                        if (began) {
                            this.fireActionEvent();
                        }
                        this.postReset();
                    } else {
                        this.mStarted = false;
                        this.postReset();
                    }
                }
                this.setBeginFiringEvents(false);
                break;
            }
            case 3: {
                this.removeMessages();
                this.mStarted = false;
                this.mNumTaps = 1;
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.postReset();
            }
        }
        return this.getCancelsTouchesInView();
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{1, 2, 3, 4};
        this.removeMessages(nArray);
    }

    private final void postReset() {
        this.getMHandler().sendEmptyMessage(2);
    }

    private final void delayedFail() {
        this.getMHandler().sendEmptyMessageDelayed(1, this.doubleTapTimeout);
    }

    private final void handleFailed() {
        this.removeMessages();
        this.setState(UIGestureRecognizer.State.Failed);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
    }

    private final void handleReset() {
        this.setState(UIGestureRecognizer.State.Possible);
        this.mStarted = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleLongPress() {
        this.logMessage(4, "handleLongPress");
        int[] nArray = new int[]{1};
        this.removeMessages(nArray);
        if (this.getState() != UIGestureRecognizer.State.Possible) return;
        if (!this.mStarted) return;
        if (this.getNumberOfTouches() == this.touchesRequired) {
            Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
            Boolean bl = function1 != null && (function1 = function1.getShouldBegin()) != null ? (Boolean)function1.invoke((Object)this) : null;
            Intrinsics.checkNotNull(bl);
            if (bl.booleanValue()) {
                this.setState(UIGestureRecognizer.State.Began);
                if (this.getRequireFailureOf() == null) {
                    this.fireActionEventIfCanRecognizeSimultaneously();
                    return;
                }
                UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                    this.fireActionEventIfCanRecognizeSimultaneously();
                    return;
                }
                UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended};
                if (uIGestureRecognizer2.inState(stateArray)) {
                    this.setState(UIGestureRecognizer.State.Failed);
                    this.setBeginFiringEvents(false);
                    this.mStarted = false;
                    this.mNumTaps = 1;
                    return;
                }
                this.listenForOtherStateChanges();
                this.setBeginFiringEvents(false);
                this.logMessage(3, "waiting...");
                return;
            }
        }
        this.setState(UIGestureRecognizer.State.Failed);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
        this.mNumTaps = 1;
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended};
        if (this.inState(stateArray)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else {
            UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
            Intrinsics.checkNotNull((Object)uIGestureRecognizerDelegate);
            if (uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) {
                this.setBeginFiringEvents(true);
                this.fireActionEvent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lit/sephiroth/android/library/uigestures/UILongPressGestureRecognizer$Companion;", "", "()V", "MESSAGE_FAILED", "", "MESSAGE_LONG_PRESS", "MESSAGE_POINTER_UP", "MESSAGE_RESET", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

