/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;

public class UIRotateGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    private static final int MESSAGE_RESET = 1;
    private static final int INVALID_POINTER_ID = -1;
    private static final double ROTATION_SLOP = 0.008;
    private double mRotationSlop = 0.008;
    private float mAngle;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float mPreviousAngle;
    private float mVelocity = 0.0f;
    private boolean mValid;
    private boolean mStarted;
    private int mPtrID1 = -1;
    private int mPtrID2 = -1;
    private MotionEvent mPreviousEvent;
    private final PointF mCurrentLocation = new PointF();
    private int mTouches = 0;

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.stopListenForOtherStateChanges();
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                break;
            }
        }
    }

    public UIRotateGestureRecognizer(@Nullable Context context) {
        super(context);
    }

    @Override
    public int getNumberOfTouches() {
        return this.mTouches;
    }

    public void setRotationThreshold(double value) {
        this.mRotationSlop = value;
    }

    public double getRotationThreshold() {
        return this.mRotationSlop;
    }

    @Override
    public void onStateChanged(@NonNull UIGestureRecognizer recognizer) {
        this.logMessage(2, "onStateChanged(%s, %s)", new Object[]{recognizer, recognizer.getState()});
        this.logMessage(2, "state: %s", new Object[]{this.getState()});
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else if (recognizer.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended) && this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Possible) && this.mStarted) {
            this.stopListenForOtherStateChanges();
            this.removeMessages();
            this.setState(UIGestureRecognizer.State.Failed);
        }
    }

    private void fireActionEventIfCanRecognizeSimultaneously() {
        if (this.inState(UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else if (this.getDelegate().shouldRecognizeSimultaneouslyWithGestureRecognizer(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    @Override
    protected boolean hasBeganFiringEvents() {
        return super.hasBeganFiringEvents() && this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed);
    }

    @Override
    protected boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (!this.isEnabled()) {
            return false;
        }
        int action = ev.getAction();
        int count = ev.getPointerCount();
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        this.mTouches = pointerUp ? count - 1 : count;
        this.mCurrentLocation.set(focusX, focusY);
        switch (action & 0xFF) {
            case 0: {
                this.mValid = false;
                this.mStarted = false;
                this.stopListenForOtherStateChanges();
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                break;
            }
            case 5: {
                if (count == 2 && this.getState() != UIGestureRecognizer.State.Failed) {
                    this.mPtrID1 = ev.getPointerId(0);
                    this.mPtrID2 = ev.getPointerId(1);
                    this.x1 = ev.getX(ev.findPointerIndex(this.mPtrID1));
                    this.y1 = ev.getY(ev.findPointerIndex(this.mPtrID1));
                    this.x2 = ev.getX(ev.findPointerIndex(this.mPtrID2));
                    this.y2 = ev.getY(ev.findPointerIndex(this.mPtrID2));
                    this.mValid = true;
                } else {
                    this.mValid = false;
                }
                this.mStarted = false;
                break;
            }
            case 6: {
                if (--count == 2 && this.getState() != UIGestureRecognizer.State.Failed) {
                    int pointerIndex = (action & 0xFF00) >> 8;
                    int pointerId = ev.getPointerId(pointerIndex);
                    boolean found = false;
                    for (int i = 0; i < ev.getPointerCount(); ++i) {
                        int id = ev.getPointerId(i);
                        if (id == pointerId) continue;
                        if (!found) {
                            this.mPtrID1 = id;
                        } else {
                            this.mPtrID2 = id;
                        }
                        found = true;
                    }
                    this.x1 = ev.getX(ev.findPointerIndex(this.mPtrID1));
                    this.y1 = ev.getY(ev.findPointerIndex(this.mPtrID1));
                    this.x2 = ev.getX(ev.findPointerIndex(this.mPtrID2));
                    this.y2 = ev.getY(ev.findPointerIndex(this.mPtrID2));
                    this.mValid = true;
                } else {
                    this.mValid = false;
                }
                this.mStarted = false;
                break;
            }
            case 1: {
                this.mValid = false;
                this.mStarted = false;
                this.mPreviousAngle = 0.0f;
                this.mVelocity = 0.0f;
                if (null != this.mPreviousEvent) {
                    this.mPreviousEvent.recycle();
                    this.mPreviousEvent = null;
                }
                if (!this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed)) break;
                this.setState(UIGestureRecognizer.State.Ended);
                if (this.hasBeganFiringEvents()) {
                    this.fireActionEvent();
                }
                this.mHandler.sendEmptyMessage(1);
                break;
            }
            case 2: {
                if (!this.mValid || this.getState() == UIGestureRecognizer.State.Failed) break;
                float nx1 = ev.getX(ev.findPointerIndex(this.mPtrID1));
                float ny1 = ev.getY(ev.findPointerIndex(this.mPtrID1));
                float nx2 = ev.getX(ev.findPointerIndex(this.mPtrID2));
                float ny2 = ev.getY(ev.findPointerIndex(this.mPtrID2));
                this.mAngle = this.angleBetweenLines(this.x2, this.y2, this.x1, this.y1, nx2, ny2, nx1, ny1);
                if (!this.mStarted) {
                    if ((double)Math.abs(this.mAngle) > this.mRotationSlop) {
                        this.mStarted = true;
                        if (this.getDelegate().shouldBegin(this)) {
                            this.setState(UIGestureRecognizer.State.Began);
                            if (null == this.getRequireFailureOf()) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                            } else if (this.getRequireFailureOf().getState() == UIGestureRecognizer.State.Failed) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                            } else if (this.getRequireFailureOf().inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed)) {
                                this.setState(UIGestureRecognizer.State.Failed);
                            } else {
                                this.listenForOtherStateChanges();
                                this.setBeginFiringEvents(false);
                                this.logMessage(3, "waiting...", new Object[0]);
                            }
                        } else {
                            this.setState(UIGestureRecognizer.State.Failed);
                        }
                    }
                } else if (this.getState() == UIGestureRecognizer.State.Began) {
                    if (this.hasBeganFiringEvents()) {
                        this.setState(UIGestureRecognizer.State.Changed);
                        this.fireActionEvent();
                    }
                } else if (this.getState() == UIGestureRecognizer.State.Changed) {
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                }
                if (null != this.mPreviousEvent) {
                    float diff = Math.max(this.mAngle, this.mPreviousAngle) - Math.min(this.mAngle, this.mPreviousAngle);
                    long time = ev.getEventTime() - this.mPreviousEvent.getEventTime();
                    this.mVelocity = time > 0L ? (float)(1000L / time) * diff : 0.0f;
                    this.mPreviousEvent.recycle();
                }
                this.x1 = ev.getX(ev.findPointerIndex(this.mPtrID1));
                this.y1 = ev.getY(ev.findPointerIndex(this.mPtrID1));
                this.x2 = ev.getX(ev.findPointerIndex(this.mPtrID2));
                this.y2 = ev.getY(ev.findPointerIndex(this.mPtrID2));
                this.mPreviousEvent = MotionEvent.obtain((MotionEvent)ev);
                this.mPreviousAngle = this.mAngle;
                break;
            }
            case 3: {
                this.mPtrID1 = -1;
                this.mPtrID2 = -1;
                this.mValid = false;
                this.mStarted = false;
                this.mPreviousAngle = 0.0f;
                this.mVelocity = 0.0f;
                if (null != this.mPreviousEvent) {
                    this.mPreviousEvent.recycle();
                    this.mPreviousEvent = null;
                }
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.mHandler.sendEmptyMessage(1);
                break;
            }
        }
        return this.getCancelsTouchesInView();
    }

    public float getRotationInRadians() {
        return this.mAngle;
    }

    public float getRotationInDegrees() {
        float angle = (float)Math.toDegrees(this.mAngle) % 360.0f;
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        if (angle > 180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public float getVelocity() {
        return this.mVelocity;
    }

    private float angleBetweenLines(float fX, float fY, float sX, float sY, float nfX, float nfY, float nsX, float nsY) {
        float angle1 = (float)Math.atan2(fY - sY, fX - sX);
        float angle2 = (float)Math.atan2(nfY - nsY, nfX - nsX);
        return angle1 - angle2;
    }

    @Override
    public float getCurrentLocationX() {
        return this.mCurrentLocation.x;
    }

    @Override
    public float getCurrentLocationY() {
        return this.mCurrentLocation.y;
    }

    @Override
    protected void removeMessages() {
        this.removeMessages(1);
    }
}

