/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;

public class UIPanGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    private static final int MESSAGE_RESET = 4;
    private int mTouchSlopSquare;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private boolean mStarted;
    private float mLastFocusX;
    private float mLastFocusY;
    private float mDownFocusX;
    private float mDownFocusY;
    private VelocityTracker mVelocityTracker;
    private int mMinimumNumberOfTouches = 1;
    private int mMaximumNumberOfTouches = Integer.MAX_VALUE;
    private float scrollX;
    private float scrollY;
    private float mTranslationX;
    private float mTranslationY;
    private float mVelocityY;
    private float mVelocityX;
    private final PointF mCurrentLocation;
    private int mTouches;

    public UIPanGestureRecognizer(@NonNull Context context) {
        super(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        int touchSlop = configuration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mTouchSlopSquare = touchSlop * touchSlop;
        this.mCurrentLocation = new PointF();
    }

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 4: {
                this.mStarted = false;
                this.setBeginFiringEvents(false);
                this.setState(UIGestureRecognizer.State.Possible);
                break;
            }
        }
    }

    @Override
    public int getNumberOfTouches() {
        return this.mTouches;
    }

    public int getMaximumFlingVelocity() {
        return this.mMaximumFlingVelocity;
    }

    public int getMinimumFlingVelocity() {
        return this.mMinimumFlingVelocity;
    }

    public boolean isFling() {
        return this.getState() == UIGestureRecognizer.State.Ended && (Math.abs(this.mVelocityX) > (float)this.mMinimumFlingVelocity || Math.abs(this.mVelocityY) > (float)this.mMinimumFlingVelocity);
    }

    @Override
    public void onStateChanged(@NonNull UIGestureRecognizer recognizer) {
        this.logMessage(2, "onStateChanged(%s, %s)", new Object[]{recognizer, recognizer.getState()});
        this.logMessage(2, "started: %b, state: %s", new Object[]{this.mStarted, this.getState()});
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else if (recognizer.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended) && this.mStarted && this.inState(UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began)) {
            this.stopListenForOtherStateChanges();
            this.removeMessages();
            this.setState(UIGestureRecognizer.State.Failed);
            this.setBeginFiringEvents(false);
            this.mStarted = false;
        }
    }

    public void setMinimumNumberOfTouches(int touches) {
        this.mMinimumNumberOfTouches = touches;
    }

    public int getMinimumNumberOfTouches() {
        return this.mMinimumNumberOfTouches;
    }

    public void setMaximumNumberOfTouches(int touches) {
        this.mMaximumNumberOfTouches = touches;
    }

    public int getMaximumNumberOfTouches() {
        return this.mMaximumNumberOfTouches;
    }

    @Override
    protected boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (!this.isEnabled()) {
            return false;
        }
        int action = ev.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        boolean pointerUp = (action & 0xFF) == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = ev.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        this.mCurrentLocation.x = focusX;
        this.mCurrentLocation.y = focusY;
        this.mTouches = count;
        switch (action & 0xFF) {
            case 5: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                if (this.getState() != UIGestureRecognizer.State.Possible || count <= this.mMaximumNumberOfTouches) break;
                this.setState(UIGestureRecognizer.State.Failed);
                this.removeMessages(4);
                break;
            }
            case 6: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.mTouches = count - 1;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                int upIndex = ev.getActionIndex();
                int id1 = ev.getPointerId(upIndex);
                float x1 = this.mVelocityTracker.getXVelocity(id1);
                float y1 = this.mVelocityTracker.getYVelocity(id1);
                for (int i = 0; i < count; ++i) {
                    float y;
                    int id2;
                    float x;
                    float dot;
                    if (i == upIndex || !((dot = (x = x1 * this.mVelocityTracker.getXVelocity(id2 = ev.getPointerId(i))) + (y = y1 * this.mVelocityTracker.getYVelocity(id2))) < 0.0f)) continue;
                    this.mVelocityTracker.clear();
                    break;
                }
                if (this.getState() != UIGestureRecognizer.State.Possible || count - 1 >= this.mMinimumNumberOfTouches) break;
                this.setState(UIGestureRecognizer.State.Failed);
                this.removeMessages(4);
                break;
            }
            case 0: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.mVelocityTracker.clear();
                this.mVelocityTracker.addMovement(ev);
                this.mStarted = false;
                this.stopListenForOtherStateChanges();
                this.removeMessages(4);
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                break;
            }
            case 2: {
                this.scrollX = this.mLastFocusX - focusX;
                this.scrollY = this.mLastFocusY - focusY;
                this.mVelocityTracker.addMovement(ev);
                if (this.getState() == UIGestureRecognizer.State.Possible && !this.mStarted) {
                    int deltaX = (int)(focusX - this.mDownFocusX);
                    int deltaY = (int)(focusY - this.mDownFocusY);
                    int distance = deltaX * deltaX + deltaY * deltaY;
                    if (distance <= this.mTouchSlopSquare) break;
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                    this.mVelocityY = this.mVelocityTracker.getYVelocity();
                    this.mVelocityX = this.mVelocityTracker.getXVelocity();
                    this.mTranslationX -= this.scrollX;
                    this.mTranslationY -= this.scrollY;
                    this.mLastFocusX = focusX;
                    this.mLastFocusY = focusY;
                    this.mStarted = true;
                    if (count >= this.mMinimumNumberOfTouches && count <= this.mMaximumNumberOfTouches && this.getDelegate().shouldBegin(this)) {
                        this.setState(UIGestureRecognizer.State.Began);
                        if (null == this.getRequireFailureOf()) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            break;
                        }
                        if (this.getRequireFailureOf().getState() == UIGestureRecognizer.State.Failed) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            break;
                        }
                        if (this.getRequireFailureOf().inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed)) {
                            this.setState(UIGestureRecognizer.State.Failed);
                            break;
                        }
                        this.listenForOtherStateChanges();
                        this.setBeginFiringEvents(false);
                        this.logMessage(3, "waiting...", new Object[0]);
                        break;
                    }
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                if (!this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed)) break;
                this.mTranslationX -= this.scrollX;
                this.mTranslationY -= this.scrollY;
                int pointerId = ev.getPointerId(0);
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                this.mVelocityY = this.mVelocityTracker.getYVelocity(pointerId);
                this.mVelocityX = this.mVelocityTracker.getXVelocity(pointerId);
                if (this.hasBeganFiringEvents()) {
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                }
                this.mLastFocusX = focusX;
                this.mLastFocusY = focusY;
                break;
            }
            case 1: {
                if (this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed)) {
                    boolean began = this.hasBeganFiringEvents();
                    this.setState(UIGestureRecognizer.State.Ended);
                    if (began) {
                        this.fireActionEvent();
                    }
                }
                if (this.getState() == UIGestureRecognizer.State.Possible || !this.mStarted) {
                    this.mVelocityY = 0.0f;
                    this.mVelocityX = 0.0f;
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mHandler.sendEmptyMessage(4);
                break;
            }
            case 3: {
                this.removeMessages(4);
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.mHandler.sendEmptyMessage(4);
                break;
            }
        }
        return this.getCancelsTouchesInView();
    }

    private void fireActionEventIfCanRecognizeSimultaneously() {
        if (this.inState(UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else if (this.getDelegate().shouldRecognizeSimultaneouslyWithGestureRecognizer(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    @Override
    protected boolean hasBeganFiringEvents() {
        return super.hasBeganFiringEvents() && this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed);
    }

    public float getXVelocity() {
        return this.mVelocityX;
    }

    public float getYVelocity() {
        return this.mVelocityY;
    }

    public void setTranslationX(float mTranslationX) {
        this.mTranslationX = mTranslationX;
    }

    public void setTranslationY(float mTranslationY) {
        this.mTranslationY = mTranslationY;
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public float getScrollX() {
        return -this.scrollX;
    }

    public float getScrollY() {
        return -this.scrollY;
    }

    @Override
    public float getCurrentLocationX() {
        return this.mCurrentLocation.x;
    }

    @Override
    public float getCurrentLocationY() {
        return this.mCurrentLocation.y;
    }

    @Override
    protected void removeMessages() {
        this.removeMessages(4);
    }
}

