/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class UIGestureRecognizerDelegate {
    private View mView;
    private boolean mEnabled = true;
    private final HashSet<UIGestureRecognizer> mSet = new LinkedHashSet<UIGestureRecognizer>();
    private Callback mCallback;

    public UIGestureRecognizerDelegate(@Nullable Callback callback) {
        this.mCallback = callback;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void addGestureRecognizer(@NonNull UIGestureRecognizer recognizer) {
        recognizer.setDelegate(this);
        this.mSet.add(recognizer);
    }

    public boolean removeGestureRecognizer(@NonNull UIGestureRecognizer recognizer) {
        if (this.mSet.remove(recognizer)) {
            recognizer.setDelegate(null);
            recognizer.clearStateListeners();
            return true;
        }
        return false;
    }

    public void clear() {
        for (UIGestureRecognizer uiGestureRecognizer : this.mSet) {
            uiGestureRecognizer.setDelegate(null);
            uiGestureRecognizer.clearStateListeners();
        }
        this.mSet.clear();
    }

    public boolean onTouchEvent(View view, MotionEvent event) {
        boolean handled = false;
        for (UIGestureRecognizer recognizer : this.mSet) {
            if (this.shouldReceiveTouch(recognizer)) {
                handled |= recognizer.onTouchEvent(event);
                continue;
            }
            handled |= recognizer.onTouchEvent(event);
        }
        return handled;
    }

    public void startListeningView(@NonNull View view) {
        this.stopListeningView();
        this.mView = view;
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                return UIGestureRecognizerDelegate.this.onTouchEvent(v, event);
            }
        });
    }

    public void stopListeningView() {
        if (null != this.mView) {
            this.mView.setOnTouchListener(null);
            this.mView = null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        if (!this.mEnabled) {
            this.stopListeningView();
        } else {
            this.startListeningView(this.mView);
        }
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public boolean shouldRecognizeSimultaneouslyWithGestureRecognizer(UIGestureRecognizer recognizer) {
        Log.i((String)this.getClass().getSimpleName(), (String)("shouldRecognizeSimultaneouslyWithGestureRecognizer(" + recognizer + ")"));
        if (this.mSet.size() == 1) {
            return true;
        }
        boolean result = true;
        for (UIGestureRecognizer other : this.mSet) {
            if (other == recognizer) continue;
            Log.v((String)this.getClass().getSimpleName(), (String)("other: " + other + ", other.began: " + other.hasBeganFiringEvents()));
            if (!other.hasBeganFiringEvents()) continue;
            result &= null != this.mCallback && this.mCallback.shouldRecognizeSimultaneouslyWithGestureRecognizer(recognizer, other);
        }
        Log.v((String)this.getClass().getSimpleName(), (String)("result: " + result));
        return result;
    }

    public boolean shouldBegin(UIGestureRecognizer recognizer) {
        return null == this.mCallback || this.mCallback.shouldBegin(recognizer);
    }

    private boolean shouldRecognizeSimultaneouslyWithGestureRecognizer(UIGestureRecognizer current, UIGestureRecognizer recognizer) {
        return null == this.mCallback || this.mCallback.shouldRecognizeSimultaneouslyWithGestureRecognizer(current, recognizer);
    }

    private boolean shouldReceiveTouch(UIGestureRecognizer recognizer) {
        return null == this.mCallback || this.mCallback.shouldReceiveTouch(recognizer);
    }

    public static interface Callback {
        public boolean shouldBegin(UIGestureRecognizer var1);

        public boolean shouldRecognizeSimultaneouslyWithGestureRecognizer(UIGestureRecognizer var1, UIGestureRecognizer var2);

        public boolean shouldReceiveTouch(UIGestureRecognizer var1);
    }
}

