/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.simplelogger.LoggerFactory;
import it.sephiroth.android.library.uigestures.OnGestureRecognizerStateChangeListener;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public abstract class UIGestureRecognizer
implements OnGestureRecognizerStateChangeListener {
    public static final String VERSION = "1.1.0";
    private static int sId = 0;
    protected static boolean sDebug = false;
    static final long LONG_PRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    static final long TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
    static final long DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    static final int TOUCH_SLOP = 8;
    static final int DOUBLE_TAP_SLOP = 100;
    static final int DOUBLE_TAP_TOUCH_SLOP = 8;
    private final List<OnGestureRecognizerStateChangeListener> mStateListeners = Collections.synchronizedList(new ArrayList());
    private OnActionListener mListener;
    private State mState;
    private boolean mEnabled = true;
    private boolean mBeganFiringEvents;
    private boolean mCancelsTouchesInView = true;
    private UIGestureRecognizerDelegate mDelegate;
    private Object mTag;
    private long mId;
    private UIGestureRecognizer mOtherRecognizer;
    private MotionEvent mLastEvent;
    private WeakReference<Context> mContextRef;
    private final LoggerFactory.Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    protected final GestureHandler mHandler = new GestureHandler(Looper.getMainLooper());

    public UIGestureRecognizer(@Nullable Context context) {
        this.mId = this.generateId();
        this.mContextRef = new WeakReference<Context>(context);
    }

    public Context getContext() {
        return (Context)this.mContextRef.get();
    }

    private long generateId() {
        return sId++;
    }

    protected boolean hasBeganFiringEvents() {
        return this.mBeganFiringEvents;
    }

    protected void setBeginFiringEvents(boolean value) {
        this.mBeganFiringEvents = value;
    }

    protected abstract void removeMessages();

    protected final void removeMessages(int ... messages) {
        for (int message : messages) {
            this.mHandler.removeMessages(message);
        }
    }

    protected final boolean hasMessages(int ... messages) {
        for (int message : messages) {
            if (!this.mHandler.hasMessages(message)) continue;
            return true;
        }
        return false;
    }

    protected void setLastEvent(MotionEvent mLastEvent) {
        if (null != mLastEvent) {
            mLastEvent.recycle();
        }
        this.mLastEvent = mLastEvent;
    }

    public MotionEvent getLastEvent() {
        return this.mLastEvent;
    }

    protected final void setDelegate(UIGestureRecognizerDelegate delegate) {
        this.mDelegate = delegate;
    }

    protected void clearStateListeners() {
        this.mStateListeners.clear();
    }

    protected final UIGestureRecognizerDelegate getDelegate() {
        return this.mDelegate;
    }

    protected final void fireActionEvent() {
        if (null != this.mListener) {
            this.mListener.onGestureRecognized(this);
        }
    }

    protected void addOnStateChangeListenerListener(OnGestureRecognizerStateChangeListener listener) {
        if (!this.mStateListeners.contains(listener)) {
            this.mStateListeners.add(listener);
        }
    }

    protected boolean removeOnStateChangeListenerListener(OnGestureRecognizerStateChangeListener listener) {
        return this.mStateListeners.remove(listener);
    }

    protected boolean hasOnStateChangeListenerListener(OnGestureRecognizerStateChangeListener listener) {
        return this.mStateListeners.contains(listener);
    }

    protected boolean onTouchEvent(MotionEvent event) {
        this.setLastEvent(MotionEvent.obtain((MotionEvent)event));
        return false;
    }

    protected void finalize() throws Throwable {
        if (null != this.mLastEvent) {
            this.mLastEvent.recycle();
        }
        super.finalize();
    }

    protected abstract void handleMessage(Message var1);

    public void setTag(Object mTag) {
        this.mTag = mTag;
        if (sDebug) {
            this.logger.setTag(String.valueOf(mTag));
        }
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setId(long mId) {
        this.mId = mId;
    }

    public static int getId() {
        return sId;
    }

    public void setActionListener(OnActionListener listener) {
        this.mListener = listener;
    }

    public abstract int getNumberOfTouches();

    public abstract float getCurrentLocationX();

    public abstract float getCurrentLocationY();

    public final State getState() {
        return this.mState;
    }

    protected final void setState(State state) {
        this.logMessage(4, "setState: %s", new Object[]{state});
        boolean changed = this.mState != state || state == State.Changed;
        this.mState = state;
        if (changed) {
            ListIterator<OnGestureRecognizerStateChangeListener> iterator = this.mStateListeners.listIterator();
            while (iterator.hasNext()) {
                iterator.next().onStateChanged(this);
            }
        }
    }

    public boolean inState(State ... states) {
        if (null == states || states.length < 1) {
            return false;
        }
        for (State state : states) {
            if (this.mState != state) continue;
            return true;
        }
        return false;
    }

    public final boolean isEnabled() {
        return this.mEnabled;
    }

    public final void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public final void requireFailureOf(@Nullable UIGestureRecognizer other) {
        if (null != this.mOtherRecognizer) {
            this.mOtherRecognizer.removeOnStateChangeListenerListener(this);
        }
        this.mOtherRecognizer = other;
    }

    protected final UIGestureRecognizer getRequireFailureOf() {
        return this.mOtherRecognizer;
    }

    protected final void stopListenForOtherStateChanges() {
        if (null != this.getRequireFailureOf()) {
            this.getRequireFailureOf().removeOnStateChangeListenerListener(this);
        }
    }

    protected final boolean isListeningForOtherStateChanges() {
        return null != this.getRequireFailureOf() && this.getRequireFailureOf().hasOnStateChangeListenerListener(this);
    }

    protected final void listenForOtherStateChanges() {
        if (null != this.getRequireFailureOf()) {
            this.getRequireFailureOf().addOnStateChangeListenerListener(this);
        }
    }

    public final void setCancelsTouchesInView(boolean value) {
        this.mCancelsTouchesInView = value;
    }

    public boolean getCancelsTouchesInView() {
        return this.mCancelsTouchesInView;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[state: " + (Object)((Object)this.getState()) + ", tag:" + this.getTag() + "]";
    }

    public static void setLogEnabled(boolean enabled) {
        sDebug = enabled;
    }

    protected void logMessage(int level, String fmt, Object ... args) {
        if (!sDebug) {
            return;
        }
        switch (level) {
            case 4: {
                this.logger.info(fmt, args);
                break;
            }
            case 3: {
                this.logger.debug(fmt, args);
                break;
            }
            case 6: 
            case 7: {
                this.logger.error(fmt, args);
                break;
            }
            case 5: {
                this.logger.warn(fmt, args);
                break;
            }
            case 2: {
                this.logger.verbose(fmt, args);
                break;
            }
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    protected final class GestureHandler
    extends Handler {
        public GestureHandler(Looper mainLooper) {
            super(mainLooper);
        }

        public void handleMessage(Message msg) {
            UIGestureRecognizer.this.handleMessage(msg);
        }
    }

    public static interface OnActionListener {
        public void onGestureRecognized(@NonNull UIGestureRecognizer var1);
    }

    public static enum State {
        Possible,
        Began,
        Changed,
        Failed,
        Cancelled,
        Ended;

    }
}

