/*
 * Decompiled with CFR 0.152.
 */
package env;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class DriverUtil {
    public static long DEFAULT_WAIT = 20L;
    protected static WebDriver driver;

    public static WebDriver getDefaultDriver() {
        if (driver != null) {
            return driver;
        }
        DesiredCapabilities capabilities = null;
        capabilities = DesiredCapabilities.firefox();
        capabilities.setJavascriptEnabled(true);
        capabilities.setCapability("takesScreenshot", true);
        driver = DriverUtil.chooseDriver(capabilities);
        driver.manage().timeouts().setScriptTimeout(DEFAULT_WAIT, TimeUnit.SECONDS);
        driver.manage().window().maximize();
        return driver;
    }

    private static WebDriver chooseDriver(DesiredCapabilities capabilities) {
        String preferredDriver = System.getProperty("browser", "Firefox");
        boolean headless = System.getProperty("Headless", "true").equals("true");
        switch (preferredDriver.toLowerCase()) {
            case "chrome": {
                ChromeOptions chromeOptions = new ChromeOptions();
                if (headless) {
                    chromeOptions.addArguments(new String[]{"--headless"});
                }
                capabilities.setCapability("chromeOptions", (Object)chromeOptions);
                System.out.println("********************* before driver created");
                ChromeDriver driver = new ChromeDriver();
                System.out.println("********************* after driver created");
                ErrorHandler handler = new ErrorHandler();
                handler.setIncludeServerErrors(false);
                driver.setErrorHandler(handler);
                return driver;
            }
            case "phantomjs": {
                return new PhantomJSDriver((Capabilities)capabilities);
            }
        }
        FirefoxOptions options = new FirefoxOptions();
        if (headless) {
            options.addArguments(new String[]{"-headless", "-safe-mode"});
        }
        capabilities.setCapability("moz:firefoxOptions", (Object)options);
        FirefoxDriver firefox = new FirefoxDriver();
        return firefox;
    }

    public static WebElement waitAndGetElementByCssSelector(WebDriver driver, String selector, int seconds) {
        By selection = By.cssSelector((String)selector);
        return (WebElement)new WebDriverWait(driver, (long)seconds).until((Function)ExpectedConditions.visibilityOfElementLocated((By)selection));
    }

    public static void closeDriver() {
        if (driver != null) {
            try {
                driver.close();
                driver.quit();
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchSessionException noSuchSessionException) {
            }
            catch (SessionNotCreatedException sessionNotCreatedException) {
                // empty catch block
            }
            driver = null;
        }
    }
}

