/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.request;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.request.IRequester;
import com.github.segmentio.stats.AnalyticsStatistics;
import com.github.segmentio.utils.GSONUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingRequester
implements IRequester {
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    protected AnalyticsClient client;
    private Gson gson;
    private CloseableHttpClient httpClient;
    private RequestConfig defaultRequestConfig;

    public BlockingRequester(AnalyticsClient client) {
        this.client = client;
        this.httpClient = HttpClients.createDefault();
        int requestTimeout = client.getOptions().getTimeout();
        this.defaultRequestConfig = RequestConfig.custom().setCookieSpec("best-match").setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setSocketTimeout(requestTimeout).setConnectTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).setProxy(client.getOptions().getProxy()).build();
        this.gson = GSONUtils.BUILDER.create();
    }

    public boolean send(Batch batch) {
        AnalyticsStatistics statistics = this.client.getStatistics();
        try {
            long start = System.currentTimeMillis();
            batch.setSentAt(DateTime.now());
            String json = this.gson.toJson((Object)batch);
            HttpResponse response = this.executeRequest(batch.getWriteKey(), json);
            String responseBody = this.readResponseBody(response);
            int statusCode = response.getStatusLine().getStatusCode();
            long duration = System.currentTimeMillis() - start;
            statistics.updateRequestTime(duration);
            if (statusCode == 200) {
                logger.debug("Successful analytics request. [code = {}]. Response = {}", (Object)statusCode, (Object)responseBody);
                this.succeed(batch, statistics);
                return true;
            }
            logger.error("Failed analytics response [code = {}]. Response = {}", (Object)statusCode, (Object)responseBody);
            this.fail(batch, statistics);
        }
        catch (IOException e) {
            logger.error("Failed analytics response. [error = {}]", (Object)e.getMessage());
            this.fail(batch, statistics);
        }
        return false;
    }

    public HttpResponse executeRequest(String writeKey, String json) throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost(this.client.getOptions().getHost() + "/v1/import");
        post.setConfig(this.defaultRequestConfig);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        post.addHeader("Authorization", "Basic " + Base64.encodeBase64((byte[])(writeKey + ":").getBytes()));
        post.setEntity((HttpEntity)new ByteArrayEntity(json.getBytes("UTF-8")));
        if (logger.isTraceEnabled()) {
            logger.trace("Posting analytics data");
        }
        return this.httpClient.execute((HttpUriRequest)post);
    }

    public String readResponseBody(HttpResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder responseBuilder = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            responseBuilder.append(line);
        }
        String responseBody = responseBuilder.toString();
        return responseBody;
    }

    private void succeed(Batch batch, AnalyticsStatistics statistics) {
        for (BasePayload payload : batch.getBatch()) {
            statistics.updateSuccessful(1.0);
        }
    }

    private void fail(Batch batch, AnalyticsStatistics statistics) {
        for (BasePayload payload : batch.getBatch()) {
            statistics.updateFailed(1.0);
        }
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.error("Error while closing", (Throwable)e);
        }
    }
}

