/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.Config;
import com.github.segmentio.models.Options;
import com.github.segmentio.models.Props;
import com.github.segmentio.models.Traits;
import com.github.segmentio.stats.AnalyticsStatistics;

public class Analytics {
    public static final String VERSION = "1.0.5";
    private static AnalyticsClient defaultClient;

    public static synchronized void initialize(String writeKey) {
        if (defaultClient == null) {
            defaultClient = new AnalyticsClient(writeKey, new Config());
        }
    }

    public static synchronized void initialize(String writeKey, Config options) {
        if (defaultClient == null) {
            defaultClient = new AnalyticsClient(writeKey, options);
        }
    }

    private static synchronized void checkInitialized() {
        if (defaultClient == null) {
            throw new IllegalStateException("Analytics client is not initialized. Please call Analytics.iniitalize(..); before calling identify / track / or flush.");
        }
    }

    public void identify(String userId) {
        this.identify(userId, null, null);
    }

    public void identify(String userId, Traits traits) {
        this.identify(userId, traits, null);
    }

    public void identify(String userId, Traits traits, Options options) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, options);
    }

    public void group(String userId, String groupId, Traits traits) {
        this.group(userId, groupId, traits, null);
    }

    public void group(String userId, String groupId, Traits traits, Options options) {
        Analytics.checkInitialized();
        defaultClient.group(userId, groupId, traits, options);
    }

    public void track(String userId, String event) {
        this.track(userId, event, null, null);
    }

    public void track(String userId, String event, Props properties) {
        this.track(userId, event, properties, null);
    }

    public void track(String userId, String event, Props properties, Options options) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, options);
    }

    public void page(String userId, String name) {
        this.page(userId, name, null, null, null);
    }

    public void page(String userId, String name, Props properties) {
        this.page(userId, name, null, properties, null);
    }

    public void page(String userId, String name, Props properties, Options options) {
        this.page(userId, name, null, properties, options);
    }

    public void page(String userId, String name, String category, Props properties, Options options) {
        Analytics.checkInitialized();
        defaultClient.page(userId, name, category, properties, options);
    }

    public void screen(String userId, String name) {
        this.screen(userId, name, null, null, null);
    }

    public void screen(String userId, String name, Props properties) {
        this.screen(userId, name, null, properties, null);
    }

    public void screen(String userId, String name, Props properties, Options options) {
        this.screen(userId, name, null, properties, options);
    }

    public void screen(String userId, String name, String category, Props properties, Options options) {
        Analytics.checkInitialized();
        defaultClient.screen(userId, name, category, properties, options);
    }

    public void alias(String previousId, String userId) {
        this.alias(previousId, userId, null);
    }

    public void alias(String previousId, String userId, Options options) {
        Analytics.checkInitialized();
        defaultClient.alias(previousId, userId, options);
    }

    public static void flush() {
        Analytics.checkInitialized();
        defaultClient.flush();
    }

    public static void close() {
        Analytics.checkInitialized();
        defaultClient.close();
    }

    public static synchronized AnalyticsStatistics getStatistics() {
        Analytics.checkInitialized();
        return defaultClient.getStatistics();
    }

    public static synchronized AnalyticsClient getDefaultClient() {
        Analytics.checkInitialized();
        return defaultClient;
    }
}

