/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;

public class Config {
    private String host;
    private int maxQueueSize;
    private int timeout;
    private int retries;
    private int backoff;
    private HttpHost proxy;

    public Config() {
        this("https://api.segment.io", 10000, 10000, 2, 1000);
    }

    Config(String host, int maxQueueSize, int timeout, int retries, int backoff) {
        this.setHost(host);
        this.setMaxQueueSize(maxQueueSize);
        this.setTimeout(timeout);
        this.setRetries(retries);
        this.setBackoff(backoff);
    }

    public String getHost() {
        return this.host;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getBackoff() {
        return this.backoff;
    }

    public Config setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("Analytics#option#maxQueueSize must be greater than 0.");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public Config setProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public Config setHost(String host) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Analytics#option#host must be a valid host, like 'https://api.segment.io'.");
        }
        this.host = host;
        return this;
    }

    public Config setTimeout(int timeout) {
        if (timeout < 1000) {
            throw new IllegalArgumentException("Analytics#option#timeout must be at least 1000 milliseconds.");
        }
        this.timeout = timeout;
        return this;
    }

    public Config setRetries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Analytics#option#retries must be greater or equal to 0.");
        }
        this.retries = retries;
        return this;
    }

    public Config setBackoff(int backoff) {
        if (backoff < 0) {
            throw new IllegalArgumentException("Analytics#option#timeout must be greater or equal to 0 milliseconds.");
        }
        this.backoff = backoff;
        return this;
    }
}

