/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.flush;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.flush.IBatchFactory;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.request.IRequester;
import com.github.segmentio.utils.ManualResetEvent;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flusher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    private LinkedBlockingQueue<BasePayload> queue;
    private volatile boolean go;
    private ManualResetEvent idle;
    private AnalyticsClient client;
    private IBatchFactory factory;
    private IRequester requester;

    public Flusher(AnalyticsClient client, IBatchFactory factory, IRequester requester) {
        this.client = client;
        this.factory = factory;
        this.requester = requester;
        this.queue = new LinkedBlockingQueue();
        this.go = true;
        this.idle = new ManualResetEvent(true);
    }

    public void run() {
        while (this.go) {
            LinkedList<BasePayload> current = new LinkedList<BasePayload>();
            do {
                if (this.queue.size() == 0) {
                    this.idle.set();
                }
                BasePayload payload = null;
                try {
                    payload = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while trying to flush analytics queue.", (Throwable)e);
                }
                if (payload == null) continue;
                this.idle.reset();
                current.add(payload);
                this.client.getStatistics().updateQueued(this.queue.size());
            } while (this.go && this.queue.size() > 0 && current.size() < 20);
            if (current.size() > 0) {
                logger.debug("Preparing to send batch.. [ " + current.size() + " items]");
                Batch batch = this.factory.create(current);
                this.client.getStatistics().updateFlushAttempts(1.0);
                this.requester.send(batch);
                logger.debug("Initiated batch request .. [ " + current.size() + " items]");
                current = new LinkedList();
            }
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while sleeping flushing thread.", (Throwable)e);
            }
        }
    }

    public void enqueue(BasePayload payload) {
        int maxQueueSize = this.client.getOptions().getMaxQueueSize();
        int currentQueueSize = this.queue.size();
        if (currentQueueSize <= maxQueueSize) {
            this.queue.add(payload);
            this.client.getStatistics().updateInserted(1.0);
            this.client.getStatistics().updateQueued(this.queue.size());
        } else {
            this.client.getStatistics().updateDropped(1.0);
        }
    }

    public void flush() {
        try {
            this.idle.waitOne();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for the thread to flush.", (Throwable)e);
        }
    }

    public void close() {
        this.go = false;
        this.queue.clear();
    }
}

