/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ConcurrentModificationException;

public class ChangeTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Change currentChange = new Change();

    public void changedSince(Change change) throws ConcurrentModificationException {
        if (this.isChangedSince(change)) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean isChangedSince(Change otherChange) {
        return !this.currentChange.equalsChange(otherChange);
    }

    public Change getCurrent() {
        Change change = this.currentChange;
        change.shared = true;
        return change;
    }

    public void changed() {
        Change change = this.currentChange;
        if (change.shared) {
            change = change.clone();
            change.shared = false;
            change.increment();
            this.currentChange = change;
        }
    }

    public String toString() {
        return "current change: " + this.currentChange;
    }

    public static class Change
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        boolean shared;
        private BigInteger big = BigInteger.ZERO;
        private int small;

        public void increment() {
            if (++this.small == 0) {
                this.big = this.big.add(BigInteger.ONE);
            }
        }

        public boolean equals(Object o) {
            return o instanceof Change && this.equalsChange((Change)o);
        }

        public boolean equalsChange(Change change) {
            return this.small == change.small && this.big.equals(change.big);
        }

        public Change clone() {
            try {
                return (Change)super.clone();
            }
            catch (CloneNotSupportedException cannotHappen) {
                return null;
            }
        }

        public String toString() {
            return this.big + " " + this.small;
        }
    }
}

