/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.AddressStringParameters;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.MACAddressString;
import inet.ipaddr.MACAddressStringParameters;
import inet.ipaddr.format.large.IPAddressLargeDivision;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.IPAddressParseData;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.MACAddressParseData;
import inet.ipaddr.format.validate.MACAddressProvider;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.format.validate.ParsedIPAddress;
import inet.ipaddr.format.validate.ParsedMACAddress;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import inet.ipaddr.ipv6.IPv6AddressStringParameters;
import java.math.BigInteger;

public class Validator
implements HostIdentifierStringValidator {
    private static final int[] extendedChars;
    private static final int[] chars;
    private static final int MAX_HOST_LENGTH = 253;
    private static final int MAX_HOST_SEGMENTS = 127;
    private static final int MAX_LABEL_LENGTH = 63;
    private static final long MAC_MAX_TRIPLE = 0xFFFFFFL;
    private static final long MAC_MAX_QUINTUPLE = 0xFFFFFFFFFFL;
    private static final int MAC_DOUBLE_SEGMENT_DIGIT_COUNT = 6;
    private static final int MAC_EXTENDED_DOUBLE_SEGMENT_DIGIT_COUNT = 10;
    private static final int MAC_SINGLE_SEGMENT_DIGIT_COUNT = 12;
    private static final int MAC_EXTENDED_SINGLE_SEGMENT_DIGIT_COUNT = 16;
    private static final int IPV6_SINGLE_SEGMENT_DIGIT_COUNT = 32;
    private static final int IPV6_BASE85_SINGLE_SEGMENT_DIGIT_COUNT = 20;
    private static final int IPV4_SINGLE_SEGMENT_OCTAL_DIGIT_COUNT = 11;
    private static final int LONG_HEX_DIGITS = 16;
    private static final char IPvFUTURE_UPPERCASE;
    private static final int[] EMPTY_INDICES;
    private static final ParsedHostIdentifierStringQualifier[] PREFIX_CACHE;
    static final IPAddressProvider.MaskCreator[][] MASK_CACHE;
    private static final IPAddressProvider.LoopbackCreator LOOPBACK_CACHE;
    private static final ParsedHost DEFAULT_EMPTY_HOST;
    private static final IPAddressStringParameters DEFAULT_PREFIX_OPTIONS;
    public static final HostIdentifierStringValidator VALIDATOR;
    private static final IPAddressStringParameters DEFAULT_UNC_OPTS;
    private static final IPAddressStringParameters REVERSE_DNS_IPV4_OPTS;
    private static final IPAddressStringParameters REVERSE_DNS_IPV6_OPTS;
    private static final BigInteger[] BASE_85_POWERS;
    private static final BigInteger LOW_BITS_MASK;
    private static final long[] MAX_VALUES;
    private static final int[][] MAX_IPv4_STRING_LEN;

    private Validator() {
    }

    @Override
    public ParsedHost validateHost(HostName fromHost) throws HostNameException {
        return Validator.validateHostImpl(fromHost);
    }

    @Override
    public IPAddressProvider validateAddress(IPAddressString fromString) throws AddressStringException {
        String str = fromString.toString();
        IPAddressStringParameters validationOptions = fromString.getValidationOptions();
        ParsedIPAddress pa = new ParsedIPAddress(fromString, str, validationOptions);
        Validator.validateIPAddress(validationOptions, str, 0, str.length(), pa, false);
        return Validator.chooseProvider(fromString, str, validationOptions, pa, Validator.parseAddressQualifier(str, validationOptions, null, pa, str.length()));
    }

    @Override
    public MACAddressProvider validateAddress(MACAddressString fromString) throws AddressStringException {
        String str = fromString.toString();
        MACAddressStringParameters validationOptions = fromString.getValidationOptions();
        ParsedMACAddress pa = new ParsedMACAddress(fromString, str);
        Validator.validateMACAddress(validationOptions, str, 0, str.length(), pa);
        AddressParseData addressParseData = pa.getAddressParseData();
        if (addressParseData.isProvidingEmpty()) {
            return MACAddressProvider.EMPTY_PROVIDER;
        }
        if (addressParseData.isAll()) {
            return MACAddressProvider.getAllProvider(validationOptions);
        }
        Validator.checkSegments(fromString.toString(), fromString.getValidationOptions(), pa);
        return pa;
    }

    private static void validateIPAddress(IPAddressStringParameters validationOptions, CharSequence str, int strStartIndex, int strEndIndex, IPAddressParseData parseData, boolean isEmbeddedIPv4) throws AddressStringException {
        Validator.validateAddress(validationOptions, null, str, strStartIndex, strEndIndex, parseData, null, isEmbeddedIPv4);
    }

    private static void validateMACAddress(MACAddressStringParameters validationOptions, String str, int strStartIndex, int strEndIndex, MACAddressParseData parseData) throws AddressStringException {
        Validator.validateAddress(null, validationOptions, str, strStartIndex, strEndIndex, null, parseData, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validateAddress(IPAddressStringParameters validationOptions, MACAddressStringParameters macOptions, CharSequence str, int strStartIndex, int strEndIndex, IPAddressParseData ipAddressParseData, MACAddressParseData macAddressParseData, boolean isEmbeddedIPv4) throws AddressStringException {
        boolean isBase85;
        AddressParseData parseData;
        boolean isMac = macAddressParseData != null;
        IPv6AddressStringParameters ipv6SpecificOptions = null;
        IPv4AddressStringParameters ipv4SpecificOptions = null;
        MACAddressStringParameters.MACAddressStringFormatParameters macSpecificOptions = null;
        MACAddressParseData.MACFormat macFormat = null;
        if (isMac) {
            MACAddressStringParameters mACAddressStringParameters = macOptions;
            MACAddressStringParameters.MACAddressStringFormatParameters mACAddressStringFormatParameters = macSpecificOptions = macOptions.getFormatParameters();
            parseData = macAddressParseData.getAddressParseData();
            isBase85 = false;
        } else {
            IPAddressStringParameters iPAddressStringParameters = validationOptions;
            Object var10_17 = null;
            parseData = ipAddressParseData.getAddressParseData();
            ipv6SpecificOptions = validationOptions.getIPv6Parameters();
            isBase85 = ipv6SpecificOptions.allowBase85;
            ipv4SpecificOptions = validationOptions.getIPv4Parameters();
        }
        int index = strStartIndex;
        int[] charArray = chars;
        int frontWildcardCount = 0;
        int wildcardCount = 0;
        int singleWildcardCount = 0;
        int leadingZeroCount = 0;
        int digitCount = 0;
        int frontSingleWildcardCount = 0;
        int frontLeadingZeroCount = 0;
        int frontDigitCount = 0;
        int frontHexDelimiterIndex = -1;
        int hexDelimiterIndex = -1;
        int rangeWildcardIndex = -1;
        int lastSeparatorIndex = -1;
        int extendedRangeWildcardIndex = -1;
        int extendedCharacterIndex = -1;
        boolean isDoubleSegment = false;
        boolean isSingleSegment = false;
        boolean isSingleIPv6Hex = false;
        boolean uppercase = false;
        boolean notDecimal = false;
        boolean notOctal = false;
        boolean frontUppercase = false;
        boolean frontNotDecimal = false;
        boolean frontNotOctal = false;
        boolean firstSegmentDashedRange = false;
        boolean atEnd = false;
        boolean frontIsStandardRange = false;
        boolean isStandard = false;
        long currentFrontValueHex = 0L;
        long currentValueHex = 0L;
        boolean checkCharCounts = true;
        boolean isZoneChar = false;
        boolean isRangeChar = false;
        boolean isDashedRangeChar = false;
        boolean isSpace = false;
        boolean isJustZero = false;
        boolean isSingleWildcard = false;
        long extendedValue = 0L;
        while (true) {
            int currentChar;
            block285: {
                boolean endOfHexSegment;
                boolean frontEmpty;
                void var10_19;
                int segCount;
                block284: {
                    IPAddress.IPVersion version;
                    if (index >= strEndIndex) {
                        if (index != strEndIndex) return;
                        boolean bl = true;
                        atEnd = bl;
                        if (!bl) return;
                    }
                    if (atEnd) {
                        boolean isSegmented;
                        parseData.setAddressEndIndex(index);
                        int totalDigits = leadingZeroCount + digitCount;
                        version = null;
                        boolean bl = isMac ? macFormat != null : (isSegmented = (version = ipAddressParseData.getProviderIPVersion()) != null);
                        if (isSegmented) {
                            if (isMac) {
                                currentChar = macFormat.getSeparator();
                                isDoubleSegment = parseData.getSegmentCount() == 1 && currentChar == 45;
                                macAddressParseData.setDoubleSegment(isDoubleSegment);
                                if (isDoubleSegment) {
                                    macAddressParseData.setExtended(totalDigits == 10);
                                }
                            } else if (version.isIPv4()) {
                                currentChar = 46;
                            } else {
                                if (index == lastSeparatorIndex + 1) {
                                    if (index != parseData.getConsecutiveSeparatorIndex() + 2) throw new AddressStringException(str, "ipaddress.error.cannot.end.with.single.separator");
                                    return;
                                }
                                if (ipAddressParseData.isProvidingMixedIPv6()) return;
                                currentChar = 58;
                            }
                        } else {
                            void var14_15;
                            int totalCharacterCount = index - strStartIndex;
                            if (totalCharacterCount == 0) {
                                if (!isMac && ipAddressParseData.hasPrefixSeparator()) {
                                    if (!validationOptions.allowPrefixOnly) {
                                        throw new AddressStringException(str, "ipaddress.error.prefix.only");
                                    }
                                } else if (!var14_15.allowEmpty) {
                                    throw new AddressStringException(str, "ipaddress.error.empty");
                                }
                                parseData.setEmpty(true);
                                return;
                            }
                            if (wildcardCount == totalCharacterCount) {
                                if (singleWildcardCount > 0) throw new AddressStringException(str, index, true);
                                if (rangeWildcardIndex >= 0) throw new AddressStringException(str, index, true);
                                if (leadingZeroCount > 0) throw new AddressStringException(str, index, true);
                                if (digitCount > 0) throw new AddressStringException(str, index, true);
                                if (hexDelimiterIndex >= 0) {
                                    throw new AddressStringException(str, index, true);
                                }
                                if (!var14_15.allowAll) {
                                    throw new AddressStringException(str, "ipaddress.error.all");
                                }
                                parseData.setHasWildcard(true);
                                parseData.setAll(true);
                                return;
                            }
                            if (isMac) {
                                int frontTotalDigits = frontLeadingZeroCount + frontDigitCount;
                                if (((totalDigits == 6 || totalDigits == 10) && (frontTotalDigits == 6 || frontWildcardCount > 0) || frontTotalDigits == 6 && wildcardCount > 0 || frontWildcardCount > 0 && wildcardCount > 0) && !firstSegmentDashedRange) {
                                    MACAddressStringParameters.AddressSize addressSize = macOptions.addressSize;
                                    if (addressSize == MACAddressStringParameters.AddressSize.EUI64 && totalDigits == 6) {
                                        throw new AddressStringException(str, "ipaddress.error.too.few.segments");
                                    }
                                    if (addressSize == MACAddressStringParameters.AddressSize.MAC && totalDigits == 10) {
                                        throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                                    }
                                    if (!macOptions.allowSingleDashed) {
                                        throw new AddressStringException(str, "ipaddress.mac.error.format");
                                    }
                                    isDoubleSegment = true;
                                    macAddressParseData.setDoubleSegment(true);
                                    macAddressParseData.setExtended(totalDigits == 10);
                                    currentChar = 45;
                                    checkCharCounts = false;
                                } else if (frontWildcardCount > 0 || wildcardCount > 0) {
                                    if (!macOptions.allowSingleDashed) {
                                        throw new AddressStringException(str, "ipaddress.mac.error.format");
                                    }
                                    currentChar = 45;
                                } else {
                                    boolean is12Digits;
                                    if (!var14_15.allowSingleSegment) {
                                        throw new AddressStringException(str, "ipaddress.error.single.segment");
                                    }
                                    boolean bl2 = is12Digits = totalDigits == 12;
                                    if (!is12Digits) {
                                        if (totalDigits != 16) throw new AddressStringException("ipaddress.error.too.few.segments.digit.count");
                                    }
                                    if (rangeWildcardIndex >= 0 && frontTotalDigits != (is12Digits ? 12 : 16)) {
                                        throw new AddressStringException("ipaddress.error.front.digit.count");
                                    }
                                    isSingleSegment = true;
                                    parseData.setSingleSegment(true);
                                    macAddressParseData.setExtended(!is12Digits);
                                    currentChar = 58;
                                    checkCharCounts = false;
                                }
                            } else {
                                if (!var14_15.allowSingleSegment) {
                                    throw new AddressStringException(str, "ipaddress.error.single.segment");
                                }
                                if (totalDigits == 32) {
                                    int frontTotalDigits;
                                    if (rangeWildcardIndex >= 0 && (frontTotalDigits = frontLeadingZeroCount + frontDigitCount) != 32) {
                                        throw new AddressStringException("ipaddress.error.front.digit.count");
                                    }
                                    isSingleIPv6Hex = true;
                                    isSingleSegment = true;
                                    parseData.setSingleSegment(true);
                                    currentChar = 58;
                                    checkCharCounts = false;
                                } else {
                                    if (isBase85) {
                                        if (extendedRangeWildcardIndex < 0) {
                                            if (totalCharacterCount == 20) {
                                                if (!validationOptions.allowIPv6) {
                                                    throw new AddressStringException(str, "ipaddress.error.ipv6");
                                                }
                                                ipAddressParseData.setVersion(IPAddress.IPVersion.IPV6);
                                                BigInteger val = Validator.parseBig85(str, strStartIndex, strEndIndex);
                                                long value = val.and(LOW_BITS_MASK).longValue();
                                                BigInteger shift64 = val.shiftRight(64);
                                                extendedValue = shift64.longValue();
                                                BigInteger shiftMore = shift64.shiftRight(64);
                                                if (!shiftMore.equals(BigInteger.ZERO)) {
                                                    throw new AddressStringException(str, "ipaddress.error.address.too.large");
                                                }
                                                parseData.initSegmentData(1);
                                                parseData.incrementSegmentCount();
                                                Validator.assignAttributes(strStartIndex, strEndIndex, parseData, 0, 16, strStartIndex);
                                                parseData.setValue(0, 2, value, 4, value, 6, extendedValue, 8, extendedValue);
                                                ipAddressParseData.setBase85(true);
                                                return;
                                            }
                                        } else if (totalCharacterCount == 41) {
                                            if (!validationOptions.allowIPv6) {
                                                throw new AddressStringException(str, "ipaddress.error.ipv6");
                                            }
                                            ipAddressParseData.setVersion(IPAddress.IPVersion.IPV6);
                                            int frontEndIndex = strStartIndex + 20;
                                            BigInteger val = Validator.parseBig85(str, strStartIndex, frontEndIndex);
                                            BigInteger val2 = Validator.parseBig85(str, frontEndIndex + 1, strEndIndex);
                                            long value = val.and(LOW_BITS_MASK).longValue();
                                            BigInteger shift64 = val.shiftRight(64);
                                            extendedValue = shift64.longValue();
                                            BigInteger shiftMore = shift64.shiftRight(64);
                                            long value2 = val2.and(LOW_BITS_MASK).longValue();
                                            shift64 = val2.shiftRight(64);
                                            long extendedValue2 = shift64.longValue();
                                            shiftMore = shift64.shiftRight(64);
                                            if (!shiftMore.equals(BigInteger.ZERO)) {
                                                throw new AddressStringException(str, "ipaddress.error.address.too.large");
                                            }
                                            if (val.compareTo(val2) > 0) {
                                                throw new AddressStringException(str, "ipaddress.error.invalidRange");
                                            }
                                            parseData.incrementSegmentCount();
                                            parseData.initSegmentData(1);
                                            Validator.assignAttributes(strStartIndex, frontEndIndex, frontEndIndex + 1, strEndIndex, parseData, 0, strStartIndex, frontEndIndex + 1, 16, 16);
                                            parseData.setValue(0, 2, value, 4, value2, 6, extendedValue, 8, extendedValue2);
                                            ipAddressParseData.setBase85(true);
                                            return;
                                        }
                                    }
                                    if (digitCount > 11) throw new AddressStringException("ipaddress.error.too.few.segments.digit.count");
                                    if (rangeWildcardIndex >= 0 && frontDigitCount > 11) {
                                        throw new AddressStringException("ipaddress.error.front.digit.count");
                                    }
                                    currentChar = 46;
                                }
                            }
                        }
                    } else {
                        currentChar = str.charAt(index);
                    }
                    if (currentChar <= 57 && currentChar >= 48) {
                        if (currentChar == 48) {
                            if (digitCount > 0) {
                                ++digitCount;
                                currentValueHex <<= 4;
                            } else {
                                ++leadingZeroCount;
                            }
                        } else {
                            ++digitCount;
                            currentValueHex = currentValueHex << 4 | (long)charArray[currentChar];
                            if (currentChar >= 56) {
                                notOctal = true;
                            }
                        }
                        ++index;
                        continue;
                    }
                    if (currentChar >= 97 && currentChar <= 102) {
                        ++digitCount;
                        ++index;
                        currentValueHex = currentValueHex << 4 | (long)charArray[currentChar];
                        notDecimal = true;
                        notOctal = true;
                        continue;
                    }
                    if (currentChar == 46) {
                        int maxChars;
                        segCount = parseData.getSegmentCount();
                        version = null;
                        if (!isMac && (version = ipAddressParseData.getProviderIPVersion()) != null && version.isIPv6()) {
                            boolean isNotExpandable;
                            if (extendedCharacterIndex >= 0) {
                                throw new AddressStringException(str, extendedCharacterIndex);
                            }
                            isBase85 = false;
                            if (!ipv6SpecificOptions.allowMixed) {
                                throw new AddressStringException(str, "ipaddress.error.no.mixed");
                            }
                            int totalSegmentCount = segCount + 2;
                            if (totalSegmentCount > 8) {
                                throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                            }
                            if (wildcardCount > 0) {
                                parseData.setHasWildcard(true);
                            }
                            boolean bl = isNotExpandable = wildcardCount > 0 && parseData.getConsecutiveSeparatorIndex() < 0;
                            if (isNotExpandable && totalSegmentCount < 8 && ipv6SpecificOptions.allowWildcardedSeparator) {
                                parseData.setFlag(segCount, 1, true);
                                parseData.setValue(segCount, 4, 65535L);
                                parseData.incrementSegmentCount();
                            }
                            IPAddressStringParameters mixedOptions = ipv6SpecificOptions.getMixedParameters();
                            ParsedIPAddress pa = new ParsedIPAddress(null, str, mixedOptions);
                            Validator.validateIPAddress(mixedOptions, str, lastSeparatorIndex + 1, strEndIndex, pa, true);
                            pa.clearQualifier();
                            Validator.checkSegments(str, mixedOptions, pa);
                            ipAddressParseData.setMixedParsedAddress(pa);
                            index = pa.getAddressParseData().getAddressEndIndex();
                            continue;
                        }
                        if (isMac) {
                            if (segCount == 0) {
                                if (!macOptions.allowDotted) {
                                    throw new AddressStringException(str, "ipaddress.mac.error.format");
                                }
                                macFormat = MACAddressParseData.MACFormat.DOTTED;
                                macAddressParseData.setFormat(macFormat);
                                parseData.initSegmentData(4);
                            } else {
                                if (macFormat != MACAddressParseData.MACFormat.DOTTED) {
                                    throw new AddressStringException(str, "ipaddress.mac.error.mix.format.characters.at.index", index);
                                }
                                if (segCount >= (macOptions.addressSize == MACAddressStringParameters.AddressSize.MAC ? 3 : 4)) {
                                    throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                                }
                            }
                            maxChars = 4;
                        } else {
                            if (extendedCharacterIndex >= 0) {
                                throw new AddressStringException(str, extendedCharacterIndex);
                            }
                            isBase85 = false;
                            if (!validationOptions.allowIPv4) {
                                throw new AddressStringException(str, "ipaddress.error.ipv4");
                            }
                            ipAddressParseData.setVersion(IPAddress.IPVersion.IPV4);
                            IPv4AddressStringParameters iPv4AddressStringParameters = ipv4SpecificOptions;
                            if (segCount == 0) {
                                parseData.initSegmentData(4);
                            } else if (segCount >= 4) {
                                throw new AddressStringException(str, "ipaddress.error.ipv4.too.many.segments");
                            }
                            maxChars = Validator.getMaxIPv4StringLength(3, 8);
                        }
                        if (wildcardCount > 0) {
                            if (!var10_19.rangeOptions.allowsWildcard()) {
                                throw new AddressStringException(str, "ipaddress.error.no.wildcard");
                            }
                            if (singleWildcardCount > 0) throw new AddressStringException(str, index, true);
                            if (rangeWildcardIndex >= 0) throw new AddressStringException(str, index, true);
                            if (leadingZeroCount > 0) throw new AddressStringException(str, index, true);
                            if (digitCount > 0) throw new AddressStringException(str, index, true);
                            if (hexDelimiterIndex >= 0) {
                                throw new AddressStringException(str, index, true);
                            }
                            parseData.setHasWildcard(true);
                            parseData.setFlag(segCount, 1, true);
                            parseData.setValue(segCount, 4, isMac ? 65535L : 255L);
                            int startIndex = index - wildcardCount;
                            Validator.assignAttributes(startIndex, index, parseData, segCount, startIndex);
                            wildcardCount = 0;
                        } else {
                            int radix;
                            long value;
                            int startIndex = index - digitCount;
                            int leadingZeroStartIndex = startIndex - leadingZeroCount;
                            if (digitCount == 0) {
                                boolean noLeadingZeros;
                                boolean bl = noLeadingZeros = leadingZeroCount == 0;
                                if (noLeadingZeros && rangeWildcardIndex >= 0 && hexDelimiterIndex < 0) {
                                    if (isMac) {
                                        value = 65535L;
                                        radix = 16;
                                    } else {
                                        value = 255L;
                                        radix = 10;
                                    }
                                } else {
                                    if (noLeadingZeros) {
                                        throw new AddressStringException(str, "ipaddress.error.empty.segment.at.index", index);
                                    }
                                    value = 0L;
                                    isJustZero = true;
                                    --startIndex;
                                    if (hexDelimiterIndex >= 0) {
                                        if (isMac) {
                                            throw new AddressStringException(str, hexDelimiterIndex);
                                        }
                                        if (!ipv4SpecificOptions.inet_aton_hex) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                                        }
                                        radix = 16;
                                        hexDelimiterIndex = -1;
                                    } else if (isMac) {
                                        if (leadingZeroCount > 0 && !var10_19.allowLeadingZeros) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                        }
                                        if (!var10_19.allowUnlimitedLeadingZeros && leadingZeroCount > maxChars) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                                        }
                                        if (!macSpecificOptions.allowShortSegments && leadingZeroCount < 2) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", leadingZeroStartIndex);
                                        }
                                        radix = 16;
                                    } else if (leadingZeroCount > 0 && ipv4SpecificOptions.inet_aton_octal) {
                                        radix = 8;
                                    } else {
                                        if (leadingZeroCount > 0) {
                                            if (!var10_19.allowLeadingZeros) {
                                                throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                            }
                                            ipAddressParseData.setHasIPv4LeadingZeros(true);
                                        }
                                        radix = 10;
                                    }
                                    --leadingZeroCount;
                                    parseData.setFlag(segCount, 4, true);
                                    Validator.assignAttributes(startIndex, index, parseData, segCount, radix, leadingZeroStartIndex);
                                }
                            } else {
                                if (digitCount > maxChars) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                                }
                                boolean bl = isSingleWildcard = singleWildcardCount > 0;
                                if (isMac || hexDelimiterIndex >= 0) {
                                    if (isMac) {
                                        int totalDigits = digitCount + leadingZeroCount;
                                        if (hexDelimiterIndex >= 0) {
                                            throw new AddressStringException(str, hexDelimiterIndex);
                                        }
                                        if (leadingZeroCount > 0 && !var10_19.allowLeadingZeros) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                        }
                                        if (!var10_19.allowUnlimitedLeadingZeros && totalDigits > maxChars) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                                        }
                                        if (!macSpecificOptions.allowShortSegments && totalDigits < 2) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", leadingZeroStartIndex);
                                        }
                                    } else {
                                        if (!ipv4SpecificOptions.inet_aton_hex) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                                        }
                                        ipAddressParseData.set_has_inet_aton_value(true);
                                    }
                                    radix = 16;
                                    if (isSingleWildcard) {
                                        if (rangeWildcardIndex >= 0) {
                                            throw new AddressStringException(str, index, true);
                                        }
                                        Validator.assignSingleWildcard16(currentValueHex, str, startIndex, index, singleWildcardCount, parseData, segCount, leadingZeroStartIndex, (AddressStringParameters.AddressStringFormatParameters)var10_19);
                                        value = 0L;
                                    } else {
                                        value = currentValueHex;
                                    }
                                    hexDelimiterIndex = -1;
                                    notDecimal = false;
                                    notOctal = false;
                                } else {
                                    boolean isOctal;
                                    boolean bl3 = isOctal = leadingZeroCount > 0 && ipv4SpecificOptions.inet_aton_octal;
                                    if (isOctal) {
                                        if (notOctal) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.octal.digit");
                                        }
                                        ipAddressParseData.set_has_inet_aton_value(true);
                                        radix = 8;
                                        if (isSingleWildcard) {
                                            if (rangeWildcardIndex >= 0) {
                                                throw new AddressStringException(str, index, true);
                                            }
                                            Validator.switchSingleWildcard8(currentValueHex, str, startIndex, index, singleWildcardCount, parseData, segCount, leadingZeroStartIndex, (AddressStringParameters.AddressStringFormatParameters)var10_19);
                                            value = 0L;
                                        } else {
                                            value = Validator.switchValue8(currentValueHex, index - startIndex);
                                        }
                                    } else {
                                        if (notDecimal) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.decimal.digit");
                                        }
                                        if (leadingZeroCount > 0) {
                                            if (!var10_19.allowLeadingZeros) {
                                                throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                            }
                                            ipAddressParseData.setHasIPv4LeadingZeros(true);
                                        }
                                        radix = 10;
                                        if (isSingleWildcard) {
                                            if (rangeWildcardIndex >= 0) {
                                                throw new AddressStringException(str, index, true);
                                            }
                                            Validator.switchSingleWildcard10(currentValueHex, str, startIndex, index, singleWildcardCount, parseData, segCount, leadingZeroStartIndex, ipv4SpecificOptions);
                                            value = 0L;
                                        } else {
                                            value = Validator.switchValue10(currentValueHex, index - startIndex);
                                            isStandard = true;
                                        }
                                    }
                                }
                                digitCount = 0;
                                currentValueHex = 0L;
                            }
                            if (rangeWildcardIndex >= 0) {
                                int frontRadix;
                                long front;
                                int frontStartIndex = rangeWildcardIndex - frontDigitCount;
                                int frontEndIndex = rangeWildcardIndex;
                                int frontLeadingZeroStartIndex = frontStartIndex - frontLeadingZeroCount;
                                if (!var10_19.rangeOptions.allowsRangeSeparator()) {
                                    throw new AddressStringException(str, "ipaddress.error.no.range");
                                }
                                if (!var10_19.allowLeadingZeros && frontLeadingZeroCount > 0) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                }
                                if (frontDigitCount > maxChars) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", frontLeadingZeroStartIndex);
                                }
                                boolean bl = frontEmpty = frontStartIndex == frontEndIndex;
                                if (isMac || frontHexDelimiterIndex >= 0) {
                                    if (isMac) {
                                        if (frontHexDelimiterIndex >= 0) {
                                            throw new AddressStringException(str, frontHexDelimiterIndex);
                                        }
                                        if (!macSpecificOptions.allowShortSegments && frontDigitCount + frontLeadingZeroCount < 2) {
                                            throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", frontLeadingZeroStartIndex);
                                        }
                                        front = !frontEmpty ? currentFrontValueHex : 0L;
                                    } else {
                                        if (!ipv4SpecificOptions.inet_aton_hex) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                                        }
                                        ipAddressParseData.set_has_inet_aton_value(true);
                                        front = !frontEmpty ? currentFrontValueHex : 0L;
                                    }
                                    frontRadix = 16;
                                } else {
                                    boolean frontIsOctal;
                                    boolean bl4 = frontIsOctal = frontLeadingZeroCount > 0 && frontHexDelimiterIndex < 0 && ipv4SpecificOptions.inet_aton_octal;
                                    if (frontIsOctal) {
                                        if (frontNotOctal) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.octal.digit");
                                        }
                                        ipAddressParseData.set_has_inet_aton_value(true);
                                        front = Validator.switchValue8(currentFrontValueHex, frontEndIndex - frontStartIndex);
                                        frontRadix = 8;
                                    } else {
                                        if (frontNotDecimal) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.decimal.digit");
                                        }
                                        if (frontLeadingZeroCount == 0) {
                                            if (!frontEmpty) {
                                                parseData.setFlag(segCount, 4, true);
                                                if (isStandard && leadingZeroCount == 0) {
                                                    parseData.setFlag(segCount, 8, true);
                                                }
                                            }
                                        } else {
                                            ipAddressParseData.setHasIPv4LeadingZeros(true);
                                        }
                                        front = !frontEmpty ? Validator.switchValue10(currentFrontValueHex, frontEndIndex - frontStartIndex) : 0L;
                                        frontRadix = 10;
                                    }
                                }
                                if (front > value) {
                                    throw new AddressStringException(str, "ipaddress.error.invalidRange");
                                }
                                if (isJustZero) {
                                    isJustZero = false;
                                } else {
                                    Validator.assignAttributes(frontStartIndex, frontEndIndex, startIndex, index, parseData, segCount, frontLeadingZeroStartIndex, leadingZeroStartIndex, frontRadix, radix);
                                    parseData.setValue(segCount, 2, front, 4, value);
                                }
                                frontSingleWildcardCount = 0;
                                frontWildcardCount = 0;
                                frontLeadingZeroCount = 0;
                                frontDigitCount = 0;
                                frontUppercase = false;
                                frontNotDecimal = false;
                                frontNotOctal = false;
                                frontHexDelimiterIndex = -1;
                                currentFrontValueHex = 0L;
                                isStandard = false;
                                isSingleWildcard = false;
                                singleWildcardCount = 0;
                                rangeWildcardIndex = -1;
                            } else if (isJustZero) {
                                isJustZero = false;
                            } else if (isSingleWildcard) {
                                isSingleWildcard = false;
                                singleWildcardCount = 0;
                            } else {
                                if (isStandard) {
                                    parseData.setFlag(segCount, 4, true);
                                    isStandard = false;
                                }
                                Validator.assignAttributes(startIndex, index, parseData, segCount, radix, leadingZeroStartIndex);
                                parseData.setValue(segCount, 2, value, 4, value);
                            }
                            leadingZeroCount = 0;
                        }
                        parseData.incrementSegmentCount();
                        lastSeparatorIndex = index++;
                        continue;
                    }
                    endOfHexSegment = currentChar == 58;
                    if (endOfHexSegment || (isRangeChar = currentChar == 45) || isMac && (isDashedRangeChar = currentChar == 124)) break block284;
                    isSpace = currentChar == 32;
                    endOfHexSegment = isSpace;
                    if (!isSpace) break block285;
                }
                if (!endOfHexSegment) {
                    if (isMac) {
                        if (macFormat == null) {
                            if (rangeWildcardIndex >= 0 && !firstSegmentDashedRange) {
                                if (frontHexDelimiterIndex >= 0) {
                                    throw new AddressStringException(str, frontHexDelimiterIndex);
                                }
                                if (hexDelimiterIndex >= 0) {
                                    throw new AddressStringException(str, hexDelimiterIndex);
                                }
                                if (!macOptions.allowDashed) {
                                    throw new AddressStringException(str, "ipaddress.mac.error.format");
                                }
                                macFormat = MACAddressParseData.MACFormat.DASHED;
                                macAddressParseData.setFormat(macFormat);
                                checkCharCounts = false;
                                parseData.initSegmentData(8);
                                if (frontWildcardCount > 0) {
                                    if (!var10_19.rangeOptions.allowsWildcard()) {
                                        throw new AddressStringException(str, "ipaddress.error.no.wildcard");
                                    }
                                    if (frontSingleWildcardCount > 0) throw new AddressStringException(str, rangeWildcardIndex, true);
                                    if (frontLeadingZeroCount > 0) throw new AddressStringException(str, rangeWildcardIndex, true);
                                    if (frontDigitCount > 0) throw new AddressStringException(str, rangeWildcardIndex, true);
                                    if (frontHexDelimiterIndex >= 0) {
                                        throw new AddressStringException(str, rangeWildcardIndex, true);
                                    }
                                    parseData.setHasWildcard(true);
                                    parseData.setFlag(0, 1, true);
                                    if (isDoubleSegment || digitCount + leadingZeroCount == 6) {
                                        parseData.setValue(0, 4, 0xFFFFFFL);
                                    } else {
                                        parseData.setValue(0, 4, 255L);
                                    }
                                    int startIndex = rangeWildcardIndex - frontWildcardCount;
                                    Validator.assignAttributes(startIndex, rangeWildcardIndex, parseData, 0, startIndex);
                                    frontWildcardCount = 0;
                                    rangeWildcardIndex = -1;
                                } else {
                                    if (!var10_19.allowLeadingZeros && frontLeadingZeroCount > 0) {
                                        throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                    }
                                    long value = 0L;
                                    int startIndex = rangeWildcardIndex - frontDigitCount;
                                    int leadingZeroStartIndex = startIndex - frontLeadingZeroCount;
                                    int endIndex = rangeWildcardIndex;
                                    if (frontSingleWildcardCount > 0) {
                                        Validator.assignSingleWildcard16(currentFrontValueHex, str, startIndex, endIndex, singleWildcardCount, parseData, 0, leadingZeroStartIndex, (AddressStringParameters.AddressStringFormatParameters)var10_19);
                                    } else {
                                        value = currentFrontValueHex;
                                        if (!uppercase) {
                                            parseData.setFlag(0, 4, true);
                                        }
                                        Validator.assignAttributes(startIndex, endIndex, parseData, 0, 16, leadingZeroStartIndex);
                                        parseData.setValue(0, 2, value, 4, value);
                                    }
                                    frontSingleWildcardCount = 0;
                                    frontWildcardCount = 0;
                                    frontLeadingZeroCount = 0;
                                    frontDigitCount = 0;
                                    frontUppercase = false;
                                    frontNotDecimal = false;
                                    frontNotOctal = false;
                                    rangeWildcardIndex = -1;
                                    frontHexDelimiterIndex = -1;
                                    currentFrontValueHex = 0L;
                                }
                                parseData.incrementSegmentCount();
                                endOfHexSegment = isRangeChar;
                            } else if (isDashedRangeChar) {
                                firstSegmentDashedRange = true;
                            } else {
                                endOfHexSegment = firstSegmentDashedRange;
                            }
                        } else if (macFormat == MACAddressParseData.MACFormat.DASHED) {
                            endOfHexSegment = isRangeChar;
                        } else if (isDashedRangeChar) {
                            throw new AddressStringException(str, index);
                        }
                    }
                    isDashedRangeChar = false;
                    if (!endOfHexSegment) {
                        if (extendedCharacterIndex < 0) {
                            if (rangeWildcardIndex >= 0) {
                                if (!isBase85) throw new AddressStringException(str, index, true);
                                if (extendedCharacterIndex < 0) {
                                    extendedCharacterIndex = index;
                                }
                            } else {
                                rangeWildcardIndex = index;
                                frontIsStandardRange = isRangeChar;
                                frontDigitCount = digitCount;
                                frontLeadingZeroCount = leadingZeroCount;
                                if (frontDigitCount == 0 && frontLeadingZeroCount != 0) {
                                    ++frontDigitCount;
                                    --frontLeadingZeroCount;
                                }
                                frontNotOctal = notOctal;
                                frontNotDecimal = notDecimal;
                                frontUppercase = uppercase;
                                frontHexDelimiterIndex = hexDelimiterIndex;
                                frontWildcardCount = wildcardCount;
                                frontSingleWildcardCount = singleWildcardCount;
                                currentFrontValueHex = currentValueHex;
                                digitCount = 0;
                                leadingZeroCount = 0;
                                uppercase = false;
                                notDecimal = false;
                                notOctal = false;
                                hexDelimiterIndex = -1;
                                singleWildcardCount = 0;
                                wildcardCount = 0;
                                currentValueHex = 0L;
                            }
                        }
                        ++index;
                    }
                }
                if (endOfHexSegment) {
                    int maxChars;
                    if (hexDelimiterIndex >= 0) {
                        if (!isSingleSegment) {
                            throw new AddressStringException(str, hexDelimiterIndex);
                        }
                        hexDelimiterIndex = -1;
                    }
                    segCount = parseData.getSegmentCount();
                    if (isMac) {
                        if (segCount == 0) {
                            if (isSingleSegment) {
                                parseData.initSegmentData(1);
                            } else {
                                if (isRangeChar) {
                                    if (!macOptions.allowDashed) throw new AddressStringException(str, "ipaddress.mac.error.format");
                                } else if (isSpace) {
                                    if (!macOptions.allowSpaceDelimited) throw new AddressStringException(str, "ipaddress.mac.error.format");
                                } else if (!macOptions.allowColonDelimited) {
                                    throw new AddressStringException(str, "ipaddress.mac.error.format");
                                }
                                if (isRangeChar) {
                                    macFormat = MACAddressParseData.MACFormat.DASHED;
                                    macAddressParseData.setFormat(macFormat);
                                    checkCharCounts = false;
                                } else {
                                    macFormat = isSpace ? MACAddressParseData.MACFormat.SPACE_DELIMITED : MACAddressParseData.MACFormat.COLON_DELIMITED;
                                    macAddressParseData.setFormat(macFormat);
                                }
                                parseData.initSegmentData(8);
                            }
                        } else {
                            if (isRangeChar ? macFormat != MACAddressParseData.MACFormat.DASHED : macFormat != (isSpace ? MACAddressParseData.MACFormat.SPACE_DELIMITED : MACAddressParseData.MACFormat.COLON_DELIMITED)) {
                                throw new AddressStringException(str, "ipaddress.mac.error.mix.format.characters.at.index", index);
                            }
                            if (segCount >= (macOptions.addressSize == MACAddressStringParameters.AddressSize.MAC ? 6 : 8)) {
                                throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                            }
                        }
                        maxChars = 2;
                    } else {
                        if (extendedCharacterIndex >= 0) {
                            throw new AddressStringException(str, extendedCharacterIndex);
                        }
                        isBase85 = false;
                        if (segCount == 0) {
                            parseData.initSegmentData(isSingleSegment ? 1 : 8);
                        } else {
                            if (segCount >= 8) {
                                throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                            }
                            IPAddress.IPVersion version = ipAddressParseData.getProviderIPVersion();
                            if (version == null) throw new AddressStringException(str, "ipaddress.error.ipv6.separator");
                            if (version.isIPv4()) {
                                throw new AddressStringException(str, "ipaddress.error.ipv6.separator");
                            }
                        }
                        if (!validationOptions.allowIPv6) {
                            throw new AddressStringException(str, "ipaddress.error.ipv6");
                        }
                        ipAddressParseData.setVersion(IPAddress.IPVersion.IPV6);
                        IPv6AddressStringParameters iPv6AddressStringParameters = ipv6SpecificOptions;
                        maxChars = 4;
                    }
                    if (wildcardCount > 0) {
                        if (!var10_19.rangeOptions.allowsWildcard()) {
                            throw new AddressStringException(str, "ipaddress.error.no.wildcard");
                        }
                        if (singleWildcardCount > 0) throw new AddressStringException(str, index, true);
                        if (rangeWildcardIndex >= 0) throw new AddressStringException(str, index, true);
                        if (leadingZeroCount > 0) throw new AddressStringException(str, index, true);
                        if (digitCount > 0) {
                            throw new AddressStringException(str, index, true);
                        }
                        parseData.setHasWildcard(true);
                        parseData.setFlag(segCount, 1, true);
                        parseData.setValue(segCount, 4, isMac ? (isDoubleSegment ? 0xFFFFFFL : 255L) : 65535L);
                        int startIndex = index - wildcardCount;
                        Validator.assignAttributes(startIndex, index, parseData, segCount, startIndex);
                        parseData.incrementSegmentCount();
                        wildcardCount = 0;
                    } else if (index == strStartIndex) {
                        if (isMac) {
                            throw new AddressStringException(str, "ipaddress.error.empty.segment.at.index", index);
                        }
                        if (index + 1 == strEndIndex) {
                            throw new AddressStringException(str, "ipaddress.error.too.few.segments");
                        }
                        if (str.charAt(index + 1) != ':') {
                            throw new AddressStringException(str, "ipaddress.error.ipv6.cannot.start.with.single.separator");
                        }
                    } else if (index == lastSeparatorIndex + 1) {
                        if (isMac) {
                            throw new AddressStringException(str, "ipaddress.error.empty.segment.at.index", index);
                        }
                        if (parseData.getConsecutiveSeparatorIndex() >= 0) {
                            throw new AddressStringException(str, "ipaddress.error.ipv6.ambiguous");
                        }
                        parseData.setConsecutiveSeparatorSegmentIndex(segCount);
                        parseData.setConsecutiveSeparatorIndex(index - 1);
                        Validator.assignAttributes(index, index, parseData, segCount, index);
                        parseData.incrementSegmentCount();
                    } else {
                        long value;
                        if (!var10_19.allowLeadingZeros && leadingZeroCount > 0) {
                            throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                        }
                        int startIndex = index - digitCount;
                        int leadingZeroStartIndex = startIndex - leadingZeroCount;
                        if (checkCharCounts && !var10_19.allowUnlimitedLeadingZeros && digitCount + leadingZeroCount > maxChars) {
                            throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                        }
                        if (isMac && !macSpecificOptions.allowShortSegments && digitCount + leadingZeroCount < 2) {
                            throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", leadingZeroStartIndex);
                        }
                        if (digitCount == 0) {
                            if (rangeWildcardIndex >= 0 && leadingZeroCount == 0) {
                                value = isMac ? 255L : 65535L;
                            } else {
                                --leadingZeroCount;
                                isJustZero = true;
                                parseData.setFlag(segCount, 4, true);
                                Validator.assignAttributes(--startIndex, index, parseData, segCount, leadingZeroStartIndex);
                                value = 0L;
                            }
                        } else {
                            if (checkCharCounts && digitCount > maxChars) {
                                throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                            }
                            isSingleWildcard = singleWildcardCount > 0;
                            if (isSingleWildcard) {
                                if (rangeWildcardIndex >= 0) {
                                    throw new AddressStringException(str, index, true);
                                }
                                if (isSingleIPv6Hex) {
                                    Validator.parseSingleSegmentSingleWildcard16(currentValueHex, str, startIndex, index, singleWildcardCount, parseData, segCount, leadingZeroStartIndex, (AddressStringParameters.AddressStringFormatParameters)var10_19);
                                } else {
                                    Validator.assignSingleWildcard16(currentValueHex, str, startIndex, index, singleWildcardCount, parseData, segCount, leadingZeroStartIndex, (AddressStringParameters.AddressStringFormatParameters)var10_19);
                                }
                                value = 0L;
                            } else {
                                if (isSingleIPv6Hex) {
                                    int midIndex = index - 16;
                                    if (startIndex < midIndex) {
                                        extendedValue = Validator.parseLong16(str, startIndex, midIndex);
                                        value = Validator.parseLong16(str, midIndex, index);
                                    } else {
                                        value = currentValueHex;
                                    }
                                } else {
                                    value = currentValueHex;
                                }
                                isStandard = !uppercase;
                            }
                            uppercase = false;
                            notDecimal = false;
                            notOctal = false;
                            digitCount = 0;
                            currentValueHex = 0L;
                        }
                        if (rangeWildcardIndex >= 0) {
                            long front;
                            long extendedFront;
                            int frontStartIndex = rangeWildcardIndex - frontDigitCount;
                            int frontEndIndex = rangeWildcardIndex;
                            int frontLeadingZeroStartIndex = frontStartIndex - frontLeadingZeroCount;
                            int frontTotalDigitCount = frontDigitCount + frontLeadingZeroCount;
                            if (!var10_19.rangeOptions.allowsRangeSeparator()) {
                                throw new AddressStringException(str, "ipaddress.error.no.range");
                            }
                            if (frontHexDelimiterIndex >= 0 && !isSingleSegment) {
                                throw new AddressStringException(str, frontHexDelimiterIndex);
                            }
                            if (!var10_19.allowLeadingZeros && frontLeadingZeroCount > 0) {
                                throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                            }
                            if (isMac && !macSpecificOptions.allowShortSegments && frontTotalDigitCount < 2) {
                                throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", frontLeadingZeroStartIndex);
                            }
                            if (checkCharCounts) {
                                if (frontDigitCount > maxChars) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", frontLeadingZeroStartIndex);
                                }
                                if (!var10_19.allowUnlimitedLeadingZeros && frontTotalDigitCount > maxChars) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", frontLeadingZeroStartIndex);
                                }
                            }
                            if (isSingleIPv6Hex) {
                                frontEmpty = false;
                                int frontMidIndex = frontEndIndex - 16;
                                extendedFront = Validator.parseLong16(str, frontStartIndex, frontMidIndex);
                                front = Validator.parseLong16(str, frontMidIndex, frontEndIndex);
                            } else {
                                frontEmpty = frontStartIndex == frontEndIndex;
                                front = !frontEmpty ? currentFrontValueHex : 0L;
                                extendedFront = 0L;
                                if (front > value) {
                                    throw new AddressStringException(str, "ipaddress.error.invalidRange");
                                }
                            }
                            if (isJustZero) {
                                isJustZero = false;
                            } else {
                                if (!frontUppercase && frontLeadingZeroCount == 0 && !frontEmpty) {
                                    if (isStandard && leadingZeroCount == 0 && frontIsStandardRange) {
                                        parseData.setFlag(segCount, 4, true);
                                        parseData.setFlag(segCount, 8, true);
                                    } else {
                                        parseData.setFlag(segCount, 4, true);
                                    }
                                }
                                Validator.assignAttributes(frontStartIndex, frontEndIndex, startIndex, index, parseData, segCount, frontLeadingZeroStartIndex, leadingZeroStartIndex, 16, 16);
                                if (isSingleIPv6Hex) {
                                    parseData.setValue(segCount, 2, front, 4, value, 6, extendedFront, 8, extendedValue);
                                } else {
                                    parseData.setValue(segCount, 2, front, 4, value);
                                }
                            }
                            frontSingleWildcardCount = 0;
                            frontWildcardCount = 0;
                            frontLeadingZeroCount = 0;
                            frontDigitCount = 0;
                            frontUppercase = false;
                            frontNotDecimal = false;
                            frontNotOctal = false;
                            frontHexDelimiterIndex = -1;
                            currentFrontValueHex = 0L;
                            isStandard = false;
                            isSingleWildcard = false;
                            singleWildcardCount = 0;
                            rangeWildcardIndex = -1;
                        } else if (isJustZero) {
                            isJustZero = false;
                        } else if (isSingleWildcard) {
                            isSingleWildcard = false;
                            singleWildcardCount = 0;
                        } else {
                            if (isStandard) {
                                parseData.setFlag(segCount, 4, true);
                                isStandard = false;
                            }
                            Validator.assignAttributes(startIndex, index, parseData, segCount, 16, leadingZeroStartIndex);
                            if (isSingleIPv6Hex) {
                                parseData.setValue(segCount, 2, value, 4, value, 6, extendedValue, 8, extendedValue);
                            } else {
                                parseData.setValue(segCount, 2, value, 4, value);
                            }
                        }
                        parseData.incrementSegmentCount();
                        leadingZeroCount = 0;
                    }
                    lastSeparatorIndex = index++;
                    endOfHexSegment = false;
                    isSpace = false;
                }
                isRangeChar = false;
                continue;
            }
            if (currentChar >= 65 && currentChar <= 70) {
                ++digitCount;
                ++index;
                currentValueHex = currentValueHex << 4 | (long)charArray[currentChar];
                uppercase = true;
                notDecimal = true;
                notOctal = true;
                continue;
            }
            if (currentChar == 47) {
                if (isMac) {
                    throw new AddressStringException(str, index);
                }
                strEndIndex = index;
                ipAddressParseData.setHasPrefixSeparator(true);
                ipAddressParseData.setQualifierIndex(index + 1);
                continue;
            }
            if (currentChar == 42 || (isZoneChar = currentChar == 37)) {
                if (isZoneChar && !isMac && ipv6SpecificOptions.allowZone && (parseData.getSegmentCount() > 0 && (isEmbeddedIPv4 || ipAddressParseData.getProviderIPVersion() == IPAddress.IPVersion.IPV6) || leadingZeroCount + digitCount == 32 && (rangeWildcardIndex < 0 || frontLeadingZeroCount + frontDigitCount == 32) || wildcardCount == index)) {
                    if (extendedCharacterIndex >= 0) {
                        throw new AddressStringException(str, extendedCharacterIndex);
                    }
                    isBase85 = false;
                    strEndIndex = index;
                    ipAddressParseData.setZoned(true);
                    ipAddressParseData.setQualifierIndex(index + 1);
                } else {
                    ++wildcardCount;
                    ++index;
                }
                isZoneChar = false;
                continue;
            }
            if (currentChar == 95) {
                ++digitCount;
                ++index;
                ++singleWildcardCount;
                continue;
            }
            if (currentChar == 120) {
                if (digitCount > 0 || leadingZeroCount != 1 || hexDelimiterIndex >= 0 || singleWildcardCount > 0) {
                    if (!isBase85) throw new AddressStringException(str, index, true);
                    if (extendedCharacterIndex < 0) {
                        extendedCharacterIndex = index;
                    }
                } else {
                    hexDelimiterIndex = index;
                    leadingZeroCount = 0;
                }
                ++index;
                continue;
            }
            if (currentChar == 187) {
                int base85TotalDigits;
                if (!isBase85) throw new AddressStringException(str, index);
                if (extendedCharacterIndex < 0) {
                    extendedCharacterIndex = index;
                }
                if ((base85TotalDigits = index - strStartIndex) != 20) throw new AddressStringException(str, extendedCharacterIndex);
                extendedRangeWildcardIndex = index++;
                continue;
            }
            if (currentChar == 167) {
                if (!isBase85) throw new AddressStringException(str, index);
                if (isMac) throw new AddressStringException(str, index);
                if (!ipv6SpecificOptions.allowZone) throw new AddressStringException(str, index);
                strEndIndex = index;
                ipAddressParseData.setZoned(true);
                ipAddressParseData.setBase85Zoned(true);
                ipAddressParseData.setQualifierIndex(index + 1);
                continue;
            }
            if (!isBase85) throw new AddressStringException(str, index);
            if (currentChar < 0) throw new AddressStringException(str, index);
            if (currentChar > extendedChars.length - 1) {
                throw new AddressStringException(str, index);
            }
            int val = extendedChars[currentChar];
            if (val == 0) {
                throw new AddressStringException(str, index);
            }
            if (extendedCharacterIndex < 0) {
                extendedCharacterIndex = index;
            }
            ++index;
        }
    }

    private static void checkSegments(String fullAddr, MACAddressStringParameters validationOptions, ParsedMACAddress parseData) throws AddressStringException {
        MACAddressParseData.MACFormat format = parseData.getFormat();
        if (format != null) {
            AddressParseData addressParseData = parseData.getAddressParseData();
            boolean hasWildcardSeparator = addressParseData.hasWildcard() && validationOptions.getFormatParameters().allowWildcardedSeparator;
            int segCount = addressParseData.getSegmentCount();
            if (format == MACAddressParseData.MACFormat.DOTTED) {
                if (segCount <= 3 && validationOptions.addressSize != MACAddressStringParameters.AddressSize.EUI64) {
                    if (!hasWildcardSeparator && segCount != 3) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                } else {
                    if (!hasWildcardSeparator && segCount < 4) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                    parseData.setExtended(true);
                }
            } else if (segCount > 2) {
                if (segCount <= 6 && validationOptions.addressSize != MACAddressStringParameters.AddressSize.EUI64) {
                    if (!hasWildcardSeparator && segCount != 6) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                } else {
                    if (!hasWildcardSeparator && segCount < 8) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                    parseData.setExtended(true);
                }
                if (parseData.getFormat() == MACAddressParseData.MACFormat.DASHED) {
                    int max = 255;
                    int maxChars = 2;
                    for (int i = 0; i < segCount; ++i) {
                        Validator.checkMaxValues(fullAddr, addressParseData, i, validationOptions.getFormatParameters(), max, maxChars, maxChars);
                    }
                }
            } else {
                if (parseData.getFormat() == MACAddressParseData.MACFormat.DASHED) {
                    if (parseData.isDoubleSegment()) {
                        MACAddressStringParameters.MACAddressStringFormatParameters params = validationOptions.getFormatParameters();
                        Validator.checkMaxValues(fullAddr, addressParseData, 0, params, 0xFFFFFFL, 6L, 6L);
                        if (parseData.isExtended()) {
                            Validator.checkMaxValues(fullAddr, addressParseData, 1, params, 0xFFFFFFFFFFL, 10L, 10L);
                        } else {
                            Validator.checkMaxValues(fullAddr, addressParseData, 1, params, 0xFFFFFFL, 6L, 6L);
                        }
                    }
                } else if (!hasWildcardSeparator) {
                    throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                }
                if (validationOptions.addressSize == MACAddressStringParameters.AddressSize.EUI64) {
                    parseData.setExtended(true);
                }
            }
        }
    }

    private static IPAddressProvider chooseProvider(HostIdentifierString originator, CharSequence fullAddr, IPAddressStringParameters validationOptions, ParsedIPAddress parseData, ParsedHostIdentifierStringQualifier qualifier) throws AddressStringException {
        IPAddress.IPVersion version = parseData.getProviderIPVersion();
        if (version == null) {
            version = qualifier.inferVersion(validationOptions);
            IPAddress.IPVersion optionsVersion = validationOptions.inferVersion();
            if (version == null) {
                version = optionsVersion;
                parseData.setVersion(version);
            } else if (optionsVersion != null && !version.equals((Object)optionsVersion)) {
                throw new AddressStringException(fullAddr, version == IPAddress.IPVersion.IPV6 ? "ipaddress.error.ipv6" : "ipaddress.error.ipv4");
            }
            AddressParseData addressParseData = parseData.getAddressParseData();
            if (addressParseData.isProvidingEmpty()) {
                Integer networkPrefixLength = qualifier.getNetworkPrefixLength();
                if (networkPrefixLength != null) {
                    int prefLen = networkPrefixLength;
                    if (validationOptions == IPAddressString.DEFAULT_VALIDATION_OPTIONS && networkPrefixLength <= 128) {
                        IPAddressProvider.MaskCreator result;
                        int index = version == null ? 0 : (version.isIPv4() ? 1 : 2);
                        IPAddressProvider.MaskCreator[] cached = MASK_CACHE[index];
                        if (cached == null) {
                            cached = new IPAddressProvider.MaskCreator[129];
                            Validator.MASK_CACHE[index] = cached;
                        }
                        if ((result = cached[prefLen]) == null) {
                            cached[prefLen] = result = new IPAddressProvider.MaskCreator(networkPrefixLength, version, IPAddressString.DEFAULT_VALIDATION_OPTIONS);
                        }
                        return result;
                    }
                    return new IPAddressProvider.MaskCreator(networkPrefixLength, version, validationOptions);
                }
                if (validationOptions.emptyIsLoopback) {
                    if (validationOptions == IPAddressString.DEFAULT_VALIDATION_OPTIONS) {
                        return LOOPBACK_CACHE;
                    }
                    return new IPAddressProvider.LoopbackCreator(validationOptions);
                }
                return IPAddressProvider.EMPTY_PROVIDER;
            }
            return new IPAddressProvider.AllCreator(qualifier, version, originator, validationOptions);
        }
        if (parseData.isZoned() && version.isIPv4()) {
            throw new AddressStringException(fullAddr, "ipaddress.error.only.ipv6.has.zone");
        }
        parseData.setQualifier(qualifier);
        Validator.checkSegments(fullAddr, validationOptions, parseData);
        return parseData;
    }

    private static void checkMaxValues(CharSequence fullAddr, AddressParseData parseData, int segmentIndex, AddressStringParameters.AddressStringFormatParameters params, long maxValue, long maxDigitCount, long maxUpperDigitCount) throws AddressStringException {
        int lowerRadix = parseData.getRadix(segmentIndex, 0);
        if (parseData.getFlag(segmentIndex, 2)) {
            if (parseData.getValue(segmentIndex, 2) > maxValue) {
                throw new AddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.large");
            }
            if (parseData.getValue(segmentIndex, 4) > maxValue) {
                parseData.setValue(segmentIndex, 4, maxValue);
            }
            if (!params.allowUnlimitedLeadingZeros && (long)(parseData.getIndex(segmentIndex, 12) - parseData.getIndex(segmentIndex, 10) - Validator.getStringPrefixCharCount(lowerRadix)) > maxDigitCount) {
                throw new AddressStringException(fullAddr, "ipaddress.error.segment.too.long");
            }
        } else {
            if (parseData.getValue(segmentIndex, 4) > maxValue) {
                throw new AddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.large");
            }
            int upperRadix = parseData.getRadix(segmentIndex, 16);
            if (!params.allowUnlimitedLeadingZeros) {
                if ((long)(parseData.getIndex(segmentIndex, 12) - parseData.getIndex(segmentIndex, 10) - Validator.getStringPrefixCharCount(lowerRadix)) > maxDigitCount) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.segment.too.long");
                }
                if ((long)(parseData.getIndex(segmentIndex, 15) - parseData.getIndex(segmentIndex, 13) - Validator.getStringPrefixCharCount(upperRadix)) > maxUpperDigitCount) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.segment.too.long");
                }
            }
        }
    }

    private static void checkSegments(CharSequence fullAddr, IPAddressStringParameters validationOptions, IPAddressParseData parseData) throws AddressStringException {
        AddressParseData addressParseData = parseData.getAddressParseData();
        int segCount = addressParseData.getSegmentCount();
        IPAddress.IPVersion version = parseData.getProviderIPVersion();
        if (version.isIPv4()) {
            boolean hasWildcardSeparator;
            int missingCount = 4 - segCount;
            IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
            boolean bl = hasWildcardSeparator = addressParseData.hasWildcard() && ipv4Options.allowWildcardedSeparator;
            if (missingCount > 0 && segCount > 1) {
                if (ipv4Options.inet_aton_joinedSegments) {
                    parseData.set_inet_aton_joined(true);
                } else if (!hasWildcardSeparator) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.ipv4.too.few.segments");
                }
            }
            long oneSegmentMax = Validator.getMaxIPv4Value(1);
            for (int i = 0; i < segCount; ++i) {
                int maxUpperDigits;
                int maxDigits;
                long max;
                int lowerRadix = addressParseData.getRadix(i, 0);
                int upperRadix = addressParseData.getRadix(i, 16);
                if (i == segCount - 1 && missingCount > 0 && ipv4Options.inet_aton_joinedSegments) {
                    max = Validator.getMaxIPv4Value(missingCount + 1);
                    maxDigits = Validator.getMaxIPv4StringLength(missingCount, lowerRadix);
                    maxUpperDigits = upperRadix != lowerRadix ? Validator.getMaxIPv4StringLength(missingCount, upperRadix) : maxDigits;
                } else {
                    max = oneSegmentMax;
                    maxDigits = Validator.getMaxIPv4StringLength(0, lowerRadix);
                    maxUpperDigits = upperRadix != lowerRadix ? Validator.getMaxIPv4StringLength(0, upperRadix) : maxDigits;
                }
                Validator.checkMaxValues(fullAddr, addressParseData, i, ipv4Options, max, maxDigits, maxUpperDigits);
            }
        } else {
            boolean hasWildcardSeparator;
            int totalSegmentCount = segCount;
            if (parseData.isProvidingMixedIPv6()) {
                totalSegmentCount += 2;
            }
            boolean bl = hasWildcardSeparator = addressParseData.hasWildcard() && validationOptions.getIPv6Parameters().allowWildcardedSeparator;
            if (!hasWildcardSeparator && totalSegmentCount != 1 && totalSegmentCount < 8 && !parseData.isCompressed()) {
                throw new AddressStringException(fullAddr, "ipaddress.error.too.few.segments");
            }
        }
    }

    @Override
    public int validatePrefix(CharSequence fullAddr, IPAddress.IPVersion version) throws AddressStringException {
        return Validator.validatePrefixImpl(fullAddr, version);
    }

    static int validatePrefixImpl(CharSequence fullAddr, IPAddress.IPVersion version) throws AddressStringException {
        ParsedHostIdentifierStringQualifier qualifier = Validator.validatePrefix(fullAddr, null, DEFAULT_PREFIX_OPTIONS, null, 0, fullAddr.length(), version);
        if (qualifier == null) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.invalidCIDRPrefix");
        }
        return qualifier.getNetworkPrefixLength();
    }

    private static ParsedHostIdentifierStringQualifier parsePortOrService(CharSequence fullAddr, CharSequence zone, HostNameParameters validationOptions, int index, int endIndex) throws AddressStringException {
        boolean isPort = true;
        boolean hasLetter = false;
        int digitCount = 0;
        int charCount = 0;
        int lastHyphen = -1;
        boolean isAll = false;
        for (int i = index; i < endIndex; ++i) {
            char c = fullAddr.charAt(i);
            if (c >= '1' && c <= '9') {
                ++digitCount;
                ++charCount;
                continue;
            }
            if (c == '0') {
                if (digitCount > 0) {
                    ++digitCount;
                }
                ++charCount;
                continue;
            }
            isPort = false;
            boolean isHyphen = false;
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || (isHyphen = c == '-') || (isAll = c == '*')) {
                if (isHyphen) {
                    if (i == index) {
                        throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalid.service.hyphen.start");
                    }
                    if (i - 1 == lastHyphen) {
                        throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalid.service.hyphen.consecutive");
                    }
                    if (i == endIndex - 1) {
                        throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalid.service.hyphen.end");
                    }
                    lastHyphen = i;
                } else {
                    if (isAll) {
                        if (i > index) {
                            throw new AddressStringException((CharSequence)fullAddr.toString(), i, true);
                        }
                        if (i + 1 < endIndex) {
                            throw new AddressStringException((CharSequence)fullAddr.toString(), i + 1, true);
                        }
                        hasLetter = true;
                        ++charCount;
                        break;
                    }
                    hasLetter = true;
                }
                ++charCount;
                continue;
            }
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalid.port.service", i);
        }
        if (isPort) {
            if (!validationOptions.allowPort) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.port");
            }
            if (digitCount == 0) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalidPort.no.digits");
            }
            if (digitCount > 5) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalidPort.too.large");
            }
            int result = Validator.parse10(fullAddr, index, endIndex);
            if (result > 65535) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalidPort.too.large");
            }
            return new ParsedHostIdentifierStringQualifier(zone, Validator.cachePorts(result));
        }
        if (!validationOptions.allowService) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.service");
        }
        if (charCount == 0) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalidService.no.chars");
        }
        if (charCount > 15) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalidService.too.long");
        }
        if (!hasLetter) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.invalidService.no.letter");
        }
        CharSequence service = fullAddr.subSequence(index, endIndex);
        return new ParsedHostIdentifierStringQualifier(zone, service);
    }

    private static ParsedHostIdentifierStringQualifier parseValidatedPrefix(int result, CharSequence fullAddr, CharSequence zone, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, int index, int endIndex, int digitCount, int leadingZeros, IPAddress.IPVersion ipVersion) throws AddressStringException {
        boolean tryCache;
        boolean allowPrefixesBeyondAddressSize;
        boolean asIPv4;
        if (digitCount == 0) {
            --leadingZeros;
            ++digitCount;
        }
        boolean bl = asIPv4 = ipVersion != null && ipVersion.isIPv4();
        if (asIPv4) {
            if (leadingZeros > 0 && !validationOptions.getIPv4Parameters().allowPrefixLengthLeadingZeros) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.ipv4.prefix.leading.zeros");
            }
            allowPrefixesBeyondAddressSize = validationOptions.getIPv4Parameters().allowPrefixesBeyondAddressSize;
            if (!allowPrefixesBeyondAddressSize && result > 32) {
                if (validationOptions.allowSingleSegment) {
                    return null;
                }
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.prefixSize");
            }
            tryCache = result < PREFIX_CACHE.length;
        } else {
            if (leadingZeros > 0 && !validationOptions.getIPv6Parameters().allowPrefixLengthLeadingZeros) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.ipv6.prefix.leading.zeros");
            }
            allowPrefixesBeyondAddressSize = validationOptions.getIPv6Parameters().allowPrefixesBeyondAddressSize;
            if (!allowPrefixesBeyondAddressSize && result > 128) {
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.prefixSize");
            }
            boolean bl2 = tryCache = zone == null && result < PREFIX_CACHE.length;
        }
        if (tryCache) {
            ParsedHostIdentifierStringQualifier qual = PREFIX_CACHE[result];
            if (qual == null) {
                qual = Validator.PREFIX_CACHE[result] = new ParsedHostIdentifierStringQualifier(Validator.cacheBits(result), null);
            }
            return qual;
        }
        return new ParsedHostIdentifierStringQualifier(Validator.cacheBits(result), zone);
    }

    private static Integer cacheBits(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    private static Integer cachePorts(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    private static ParsedHostIdentifierStringQualifier validatePrefix(CharSequence fullAddr, CharSequence zone, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        if (index == fullAddr.length()) {
            return null;
        }
        boolean isPrefix = true;
        int prefixEndIndex = endIndex;
        int leadingZeros = 0;
        int digitCount = 0;
        int result = 0;
        int[] charArray = chars;
        ParsedHostIdentifierStringQualifier portQualifier = null;
        for (int i = index; i < endIndex; ++i) {
            char c = fullAddr.charAt(i);
            if (c >= '1' && c <= '9') {
                ++digitCount;
                result = result * 10 + charArray[c];
                continue;
            }
            if (c == '0') {
                if (digitCount > 0) {
                    ++digitCount;
                    result *= 10;
                    continue;
                }
                ++leadingZeros;
                continue;
            }
            if (c == ':' && hostValidationOptions != null && (hostValidationOptions.allowPort || hostValidationOptions.allowService) && i > index) {
                try {
                    portQualifier = Validator.parsePortOrService(fullAddr, zone, hostValidationOptions, i + 1, endIndex);
                    prefixEndIndex = i;
                    break;
                }
                catch (AddressStringException e) {
                    return null;
                }
            }
            isPrefix = false;
            break;
        }
        if (isPrefix) {
            ParsedHostIdentifierStringQualifier prefixQualifier = Validator.parseValidatedPrefix(result, fullAddr, zone, validationOptions, hostValidationOptions, index, prefixEndIndex, digitCount, leadingZeros, ipVersion);
            if (portQualifier != null) {
                portQualifier.mergePrefix(prefixQualifier);
                return portQualifier;
            }
            return prefixQualifier;
        }
        return null;
    }

    private static ParsedHostIdentifierStringQualifier parseAddressQualifier(CharSequence fullAddr, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, IPAddressParseData ipAddressParseData, int endIndex) throws AddressStringException {
        int qualifierIndex = ipAddressParseData.getQualifierIndex();
        boolean addressIsEmpty = ipAddressParseData.getAddressParseData().isProvidingEmpty();
        IPAddress.IPVersion ipVersion = ipAddressParseData.getProviderIPVersion();
        if (ipAddressParseData.hasPrefixSeparator()) {
            return Validator.parsePrefix(fullAddr, null, validationOptions, hostValidationOptions, addressIsEmpty, qualifierIndex, endIndex, ipVersion);
        }
        if (ipAddressParseData.isZoned()) {
            if (ipAddressParseData.isBase85Zoned() && !ipAddressParseData.isProvidingBase85IPv6()) {
                throw new AddressStringException(fullAddr, qualifierIndex - 1);
            }
            if (addressIsEmpty) {
                throw new AddressStringException(fullAddr, "ipaddress.error.only.zone");
            }
            return Validator.parseZone(fullAddr, validationOptions, addressIsEmpty, qualifierIndex, endIndex, ipVersion);
        }
        return ParsedHost.NO_QUALIFIER;
    }

    private static ParsedHostIdentifierStringQualifier parseHostAddressQualifier(CharSequence fullAddr, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, boolean isPrefixed, boolean hasPort, IPAddressParseData ipAddressParseData, int qualifierIndex, int endIndex) throws AddressStringException {
        boolean addressIsEmpty = ipAddressParseData.getAddressParseData().isProvidingEmpty();
        IPAddress.IPVersion ipVersion = ipAddressParseData.getProviderIPVersion();
        if (isPrefixed) {
            return Validator.parsePrefix(fullAddr, null, validationOptions, hostValidationOptions, addressIsEmpty, qualifierIndex, endIndex, ipVersion);
        }
        if (ipAddressParseData.isZoned()) {
            if (addressIsEmpty) {
                throw new AddressStringException(fullAddr, "ipaddress.error.only.zone");
            }
            return Validator.parseEncodedZone(fullAddr, validationOptions, addressIsEmpty, qualifierIndex, endIndex, ipVersion);
        }
        if (hasPort) {
            return Validator.parsePortOrService(fullAddr, null, hostValidationOptions, qualifierIndex, endIndex);
        }
        return ParsedHost.NO_QUALIFIER;
    }

    private static ParsedHostIdentifierStringQualifier parsePrefix(CharSequence fullAddr, CharSequence zone, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, boolean addressIsEmpty, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        ParsedHostIdentifierStringQualifier qualifier;
        if (validationOptions.allowPrefix && (qualifier = Validator.validatePrefix(fullAddr, zone, validationOptions, hostValidationOptions, index, endIndex, ipVersion)) != null) {
            return qualifier;
        }
        if (addressIsEmpty) {
            throw new AddressStringException(fullAddr, "ipaddress.error.invalid.mask.address.empty");
        }
        if (validationOptions.allowMask) {
            try {
                IPAddressStringParameters maskOptions = Validator.toMaskOptions(validationOptions, ipVersion);
                ParsedIPAddress pa = new ParsedIPAddress(null, fullAddr, maskOptions);
                Validator.validateIPAddress(maskOptions, fullAddr, index, endIndex, pa, false);
                AddressParseData maskParseData = pa.getAddressParseData();
                if (maskParseData.isProvidingEmpty()) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.invalid.mask.empty");
                }
                if (maskParseData.isAll()) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.invalid.mask.wildcard");
                }
                Validator.checkSegments(fullAddr, maskOptions, pa);
                int maskEndIndex = maskParseData.getAddressEndIndex();
                if (maskEndIndex != endIndex) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.invalid.mask.extra.chars", maskEndIndex + 1);
                }
                IPAddress.IPVersion maskVersion = pa.getProviderIPVersion();
                if (maskVersion.isIPv4() && maskParseData.getSegmentCount() == 1 && !maskParseData.hasWildcard() && !validationOptions.getIPv4Parameters().inet_aton_single_segment_mask) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.mask.single.segment");
                }
                if (ipVersion != null && (maskVersion.isIPv4() != ipVersion.isIPv4() || maskVersion.isIPv6() != ipVersion.isIPv6())) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.ipMismatch");
                }
                return new ParsedHostIdentifierStringQualifier(pa, zone);
            }
            catch (AddressStringException e) {
                throw new AddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask", e);
            }
        }
        throw new AddressStringException(fullAddr, validationOptions.allowPrefix ? "ipaddress.error.invalidCIDRPrefixOrMask" : "ipaddress.error.CIDRNotAllowed");
    }

    private static ParsedHostIdentifierStringQualifier parseHostNameQualifier(CharSequence fullAddr, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, boolean isPrefixed, boolean isPort, boolean addressIsEmpty, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        if (isPrefixed) {
            return Validator.parsePrefix(fullAddr, null, validationOptions, hostValidationOptions, addressIsEmpty, index, endIndex, ipVersion);
        }
        if (isPort) {
            return Validator.parsePortOrService(fullAddr, null, hostValidationOptions, index, endIndex);
        }
        return ParsedHost.NO_QUALIFIER;
    }

    public static int validateZone(CharSequence zone) {
        for (int i = 0; i < zone.length(); ++i) {
            char c = zone.charAt(i);
            if (c == '/') {
                return i;
            }
            if (c != ':') continue;
            return i;
        }
        return -1;
    }

    public static boolean isReserved(char c) {
        boolean isUnreserved = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '.' || c == '_' || c == '~';
        return !isUnreserved;
    }

    private static ParsedHostIdentifierStringQualifier parseZone(CharSequence fullAddr, IPAddressStringParameters validationOptions, boolean addressIsEmpty, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        for (int i = index; i < endIndex; ++i) {
            char c = fullAddr.charAt(i);
            if (c == '/') {
                CharSequence zone = fullAddr.subSequence(index, i);
                return Validator.parsePrefix(fullAddr, zone, validationOptions, null, addressIsEmpty, i + 1, endIndex, ipVersion);
            }
            if (c != ':') continue;
            throw new AddressStringException(fullAddr, "ipaddress.error.invalid.zone", i);
        }
        return new ParsedHostIdentifierStringQualifier(fullAddr.subSequence(index, endIndex));
    }

    private static ParsedHostIdentifierStringQualifier parseEncodedZone(CharSequence fullAddr, IPAddressStringParameters validationOptions, boolean addressIsEmpty, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        CharSequence result = null;
        for (int i = index; i < endIndex; ++i) {
            char c = fullAddr.charAt(i);
            if (c == '%') {
                if (i + 2 >= endIndex) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.invalid.zone.encoding", i);
                }
                if (result == null) {
                    result = new StringBuilder(endIndex - index);
                    ((StringBuilder)result).append(fullAddr, index, i);
                }
                int[] charArray = chars;
                c = (char)(charArray[fullAddr.charAt(++i)] << 4);
                c = (char)(c | charArray[fullAddr.charAt(++i)]);
            } else {
                if (c == '/') {
                    CharSequence zone = result != null ? result : fullAddr.subSequence(index, i);
                    return Validator.parsePrefix(fullAddr, zone, validationOptions, null, addressIsEmpty, i + 1, endIndex, ipVersion);
                }
                if (Validator.isReserved(c)) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.invalid.zone", i);
                }
            }
            if (result == null) continue;
            ((StringBuilder)result).append(c);
        }
        if (result == null) {
            return new ParsedHostIdentifierStringQualifier(fullAddr.subSequence(index, endIndex));
        }
        return new ParsedHostIdentifierStringQualifier(result);
    }

    private static IPAddressStringParameters toMaskOptions(IPAddressStringParameters validationOptions, IPAddress.IPVersion ipVersion) {
        IPAddressStringParameters.Builder builder = null;
        if (ipVersion == null || ipVersion.isIPv6()) {
            IPv6AddressStringParameters ipv6Options = validationOptions.getIPv6Parameters();
            if (!ipv6Options.rangeOptions.isNoRange()) {
                builder = validationOptions.toBuilder();
                builder.getIPv6AddressParametersBuilder().setRangeOptions(AddressStringParameters.RangeParameters.NO_RANGE);
            }
            if (ipv6Options.allowMixed && !ipv6Options.getMixedParameters().getIPv4Parameters().rangeOptions.isNoRange()) {
                if (builder == null) {
                    builder = validationOptions.toBuilder();
                }
                builder.getIPv6AddressParametersBuilder().setRangeOptions(AddressStringParameters.RangeParameters.NO_RANGE);
            }
        }
        if (ipVersion == null || ipVersion.isIPv4()) {
            IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
            if (!ipv4Options.rangeOptions.isNoRange()) {
                if (builder == null) {
                    builder = validationOptions.toBuilder();
                }
                builder.getIPv4AddressParametersBuilder().setRangeOptions(AddressStringParameters.RangeParameters.NO_RANGE);
            }
        }
        if (validationOptions.allowAll) {
            if (builder == null) {
                builder = validationOptions.toBuilder();
            }
            builder.allowAll(false);
        }
        IPAddressStringParameters maskOptions = builder == null ? validationOptions : builder.toParams();
        return maskOptions;
    }

    private static void assignAttributes(int frontStart, int frontEnd, int start, int end, AddressParseData parseData, int parsedSegIndex, int frontLeadingZeroStartIndex, int leadingZeroStartIndex) {
        parseData.setIndex(parsedSegIndex, 10, frontLeadingZeroStartIndex, 11, frontStart, 12, frontEnd, 13, leadingZeroStartIndex, 14, start, 15, end);
    }

    private static void assignAttributes(int frontStart, int frontEnd, int start, int end, AddressParseData parseData, int parsedSegIndex, int frontLeadingZeroStartIndex, int leadingZeroStartIndex, int frontRadix, int radix) {
        parseData.setRadix(parsedSegIndex, 0, frontRadix, 16, radix);
        Validator.assignAttributes(frontStart, frontEnd, start, end, parseData, parsedSegIndex, frontLeadingZeroStartIndex, leadingZeroStartIndex);
    }

    private static void assignAttributes(int start, int end, AddressParseData parseData, int parsedSegIndex, int leadingZeroStartIndex) {
        parseData.setIndex(parsedSegIndex, 13, leadingZeroStartIndex, 10, leadingZeroStartIndex, 14, start, 11, start, 15, end, 12, end);
    }

    private static void assignAttributes(int start, int end, AddressParseData parseData, int parsedSegIndex, int radix, int leadingZeroStartIndex) {
        parseData.setRadix(parsedSegIndex, 0, radix, 16, radix);
        Validator.assignAttributes(start, end, parseData, parsedSegIndex, leadingZeroStartIndex);
    }

    private static void assignSingleWildcardAttributes(CharSequence str, int start, int end, int digitsEnd, int numSingleWildcards, AddressParseData parseData, int parsedSegIndex, int radix, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        if (!options.rangeOptions.allowsSingleWildcard()) {
            throw new AddressStringException(str, "ipaddress.error.no.single.wildcard");
        }
        for (int k = digitsEnd; k < end; ++k) {
            if (str.charAt(k) == '_') continue;
            throw new AddressStringException(str, "ipaddress.error.single.wildcard.order");
        }
        parseData.setFlag(parsedSegIndex, 2, true);
        Validator.assignAttributes(start, end, parseData, parsedSegIndex, radix, leadingZeroStartIndex);
    }

    private static void switchSingleWildcard10(long currentValueHex, CharSequence s, int start, int end, int numSingleWildcards, AddressParseData parseData, int parsedSegIndex, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, parseData, parsedSegIndex, 10, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.switchValue10(currentValueHex, digitsEnd - start) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower *= 10L) + 9L;
                break;
            }
            case 2: {
                upper = (lower *= 100L) + 99L;
                break;
            }
            case 3: {
                upper = (lower *= 1000L) + 999L;
                break;
            }
            default: {
                long power = (long)Math.pow(10.0, numSingleWildcards);
                upper = (lower *= power) + power - 1L;
            }
        }
        parseData.setValue(parsedSegIndex, 2, lower, 4, upper);
    }

    private static void switchSingleWildcard8(long currentValueHex, CharSequence s, int start, int end, int numSingleWildcards, AddressParseData parseData, int parsedSegIndex, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, parseData, parsedSegIndex, 8, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.switchValue8(currentValueHex, digitsEnd - start) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower <<= 3) | 7L;
                break;
            }
            case 2: {
                upper = (lower <<= 6) | 0x3FL;
                break;
            }
            case 3: {
                upper = (lower <<= 9) | 0x1FFL;
                break;
            }
            default: {
                int shift = numSingleWildcards * 3;
                upper = (lower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        parseData.setValue(parsedSegIndex, 2, lower, 4, upper);
    }

    private static void assignSingleWildcard16(long currentValueHex, CharSequence s, int start, int end, int numSingleWildcards, AddressParseData parseData, int parsedSegIndex, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, parseData, parsedSegIndex, 16, leadingZeroStartIndex, options);
        int shift = numSingleWildcards << 2;
        long upper = (currentValueHex <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        parseData.setValue(parsedSegIndex, 2, currentValueHex, 4, upper);
    }

    private static void parseSingleSegmentSingleWildcard16(long currentValueHex, CharSequence s, int start, int end, int numSingleWildcards, AddressParseData parseData, int parsedSegIndex, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        long extendedUpper;
        long extendedLower;
        long upper;
        long lower;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, parseData, parsedSegIndex, 16, leadingZeroStartIndex, options);
        if (numSingleWildcards < 16) {
            int midIndex = end - 16;
            lower = Validator.parseLong16(s, midIndex, digitsEnd);
            int shift = numSingleWildcards << 2;
            upper = (lower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
            extendedUpper = extendedLower = Validator.parseLong16(s, start, midIndex);
        } else if (numSingleWildcards == 16) {
            lower = 0L;
            upper = -1L;
            extendedUpper = extendedLower = currentValueHex;
        } else {
            lower = 0L;
            upper = -1L;
            extendedLower = currentValueHex;
            int shift = numSingleWildcards - 16 << 2;
            extendedUpper = (extendedLower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        }
        parseData.setValue(parsedSegIndex, 2, lower, 4, upper, 6, extendedLower, 8, extendedUpper);
    }

    private static long getMaxIPv4Value(int segmentCount) {
        return MAX_VALUES[segmentCount];
    }

    private static int getStringPrefixCharCount(int radix) {
        if (radix == 10) {
            return 0;
        }
        if (radix == 16) {
            return 2;
        }
        return 1;
    }

    private static int getMaxIPv4StringLength(int additionalSegmentsCovered, int radix) {
        try {
            return MAX_IPv4_STRING_LEN[radix >>> 1][additionalSegmentsCovered];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    private static long switchValue8(long currentHexValue, int digitCount) {
        long result = 7L & currentHexValue;
        int shift = 0;
        while (--digitCount > 0) {
            result |= (7L & (currentHexValue >>>= 4)) << (shift += 3);
        }
        return result;
    }

    private static int parse10(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result * 10 + charArray[s.charAt(start)];
        }
        return result;
    }

    private static long switchValue10(long currentHexValue, int digitCount) {
        long result = 0xFL & currentHexValue;
        int factor = 1;
        while (--digitCount > 0) {
            result += (0xFL & (currentHexValue >>>= 4)) * (long)(factor *= 10);
        }
        return result;
    }

    private static long parseLong8(CharSequence s, int start, int end) {
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result << 3 | (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong10(CharSequence s, int start, int end) {
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result * 10L + (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong16(CharSequence s, int start, int end) {
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result << 4 | (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static BigInteger parseBig85(CharSequence s, int start, int end) {
        boolean last;
        int[] charArray = extendedChars;
        BigInteger result = BigInteger.ZERO;
        do {
            int power;
            int partialEnd;
            int left;
            if (last = (left = end - start) <= 9) {
                partialEnd = end;
                power = left;
            } else {
                partialEnd = start + 9;
                power = 9;
            }
            long partialResult = charArray[s.charAt(start)];
            while (++start < partialEnd) {
                int next = charArray[s.charAt(start)];
                partialResult = partialResult * 85L + (long)next;
            }
            result = result.multiply(BASE_85_POWERS[power]).add(BigInteger.valueOf(partialResult));
            start = partialEnd;
        } while (!last);
        return result;
    }

    static ParsedHost validateHostImpl(HostName fromHost) throws HostNameException {
        String str = fromHost.toString();
        HostNameParameters validationOptions = fromHost.getValidationOptions();
        return Validator.validateHost(fromHost, str, validationOptions);
    }

    private static ParsedHost validateHost(HostName fromHost, String str, HostNameParameters validationOptions) throws HostNameException {
        int addrLen = str.length();
        if (addrLen > 253) {
            throw new HostNameException(str, "ipaddress.host.error.invalid.length");
        }
        int lastSeparatorIndex = -1;
        int index = -1;
        int qualifierIndex = -1;
        int isSpecialOnlyIndex = -1;
        int labelCount = 0;
        int maxLocalLabels = 6;
        int[] separatorIndices = null;
        boolean[] normalizedFlags = null;
        boolean addressIsEmpty = false;
        boolean hasPortOrService = false;
        boolean isPrefixed = false;
        boolean tryIPv4 = false;
        boolean tryIPv6 = false;
        boolean squareBracketed = false;
        boolean isNotNormalized = false;
        boolean segmentUppercase = false;
        boolean isPossiblyIPv4 = true;
        boolean isPossiblyIPv6 = true;
        boolean isAllDigits = true;
        int sep5 = -1;
        int sep4 = -1;
        int sep3 = -1;
        int sep2 = -1;
        int sep1 = -1;
        int sep0 = -1;
        boolean upper5 = false;
        boolean upper4 = false;
        boolean upper3 = false;
        boolean upper2 = false;
        boolean upper1 = false;
        boolean upper0 = false;
        while (++index <= addrLen) {
            int currentChar;
            if (index == addrLen) {
                boolean segmentCountMatchesIPv4;
                if (index == 0) {
                    addressIsEmpty = true;
                    break;
                }
                boolean bl = segmentCountMatchesIPv4 = isPossiblyIPv4 && labelCount + 1 == 4 || labelCount + 1 < 4 && isSpecialOnlyIndex >= 0 || labelCount + 1 < 4 && validationOptions.addressOptions.getIPv4Parameters().inet_aton_joinedSegments || labelCount == 0 && validationOptions.addressOptions.allowSingleSegment;
                if (isAllDigits) {
                    if (isPossiblyIPv4 && segmentCountMatchesIPv4) {
                        tryIPv4 = true;
                        break;
                    }
                    isPossiblyIPv4 = false;
                    if (hasPortOrService && isPossiblyIPv6) {
                        tryIPv6 = true;
                        break;
                    }
                    throw new HostNameException(str, "ipaddress.host.error.invalid");
                }
                isPossiblyIPv4 &= segmentCountMatchesIPv4;
                currentChar = 46;
            } else {
                currentChar = str.charAt(index);
            }
            if (currentChar >= 97 && currentChar <= 122) {
                if (currentChar > 102) {
                    isPossiblyIPv6 = false;
                    isPossiblyIPv4 &= currentChar == 120 && validationOptions.addressOptions.getIPv4Parameters().inet_aton_hex;
                } else {
                    isPossiblyIPv4 = false;
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar >= 48 && currentChar <= 57) continue;
            if (currentChar >= 65 && currentChar <= 90) {
                if (currentChar > 70) {
                    isPossiblyIPv6 = false;
                }
                segmentUppercase = true;
                isPossiblyIPv4 = false;
                isAllDigits = false;
                continue;
            }
            if (currentChar == 46) {
                int len = index - lastSeparatorIndex - 1;
                if (len > 63) {
                    throw new HostNameException(str, "ipaddress.error.segment.too.long");
                }
                if (len == 0) {
                    throw new HostNameException(str, "ipaddress.host.error.segment.too.short");
                }
                if (labelCount < maxLocalLabels) {
                    if (labelCount < 3) {
                        if (labelCount == 0) {
                            sep0 = index;
                            upper0 = segmentUppercase;
                        } else if (labelCount == 1) {
                            sep1 = index;
                            upper1 = segmentUppercase;
                        } else {
                            sep2 = index;
                            upper2 = segmentUppercase;
                        }
                    } else if (labelCount == 3) {
                        sep3 = index;
                        upper3 = segmentUppercase;
                    } else if (labelCount == 4) {
                        sep4 = index;
                        upper4 = segmentUppercase;
                    } else {
                        sep5 = index;
                        upper5 = segmentUppercase;
                    }
                    ++labelCount;
                } else if (labelCount == maxLocalLabels) {
                    separatorIndices = new int[128];
                    separatorIndices[labelCount] = index;
                    if (validationOptions.normalizeToLowercase) {
                        normalizedFlags = new boolean[128];
                        normalizedFlags[labelCount] = !segmentUppercase;
                        isNotNormalized |= segmentUppercase;
                    }
                    ++labelCount;
                } else {
                    separatorIndices[labelCount] = index;
                    if (normalizedFlags != null) {
                        normalizedFlags[labelCount] = !segmentUppercase;
                        isNotNormalized |= segmentUppercase;
                    }
                    if (++labelCount > 127) {
                        throw new HostNameException(str, "ipaddress.host.error.too.many.segments");
                    }
                }
                lastSeparatorIndex = index;
                segmentUppercase = false;
                isPossiblyIPv6 &= index == addrLen;
                continue;
            }
            if (currentChar == 95) {
                isAllDigits = false;
                continue;
            }
            if (currentChar == 45) {
                if (index == lastSeparatorIndex + 1 || index == addrLen - 1 || str.charAt(index + 1) == '.') {
                    throw new HostNameException(str, index);
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar == 91) {
                if (index == 0 && labelCount == 0 && addrLen > 2) {
                    squareBracketed = true;
                    break;
                }
                throw new HostNameException(str, index);
            }
            if (currentChar == 47) {
                isPrefixed = true;
                qualifierIndex = index + 1;
                addrLen = index--;
                isNotNormalized = true;
                continue;
            }
            boolean b = false;
            if (currentChar == 42 || (b = currentChar == 37)) {
                IPAddressStringParameters addressOptions = validationOptions.addressOptions;
                if (b && addressOptions.getIPv6Parameters().allowZone) {
                    if (isPossiblyIPv6 && labelCount < 8) {
                        tryIPv6 = true;
                        isPossiblyIPv4 = false;
                        break;
                    }
                    throw new HostNameException(str, index);
                }
                if (isPossiblyIPv4 && addressOptions.getIPv4Parameters().rangeOptions.allowsWildcard()) {
                    if (isSpecialOnlyIndex < 0) {
                        isSpecialOnlyIndex = index;
                    }
                } else {
                    isPossiblyIPv4 = false;
                }
                if (isPossiblyIPv6 && addressOptions.getIPv6Parameters().rangeOptions.allowsWildcard()) {
                    if (isSpecialOnlyIndex < 0) {
                        isSpecialOnlyIndex = index;
                    }
                } else {
                    if (!isPossiblyIPv4) {
                        throw new HostNameException(str, index);
                    }
                    isPossiblyIPv6 = false;
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar == 58) {
                if (validationOptions.allowPort || validationOptions.allowService) {
                    hasPortOrService = true;
                    qualifierIndex = index + 1;
                    addrLen = index--;
                    isNotNormalized = true;
                    continue;
                }
                isPossiblyIPv4 = false;
                if (isPossiblyIPv6) {
                    tryIPv6 = true;
                    break;
                }
                throw new HostNameException(str, index);
            }
            if (currentChar == 187) {
                isAllDigits = false;
                continue;
            }
            throw new HostNameException(str, index);
        }
        IPAddressStringParameters addressOptions = validationOptions.addressOptions;
        try {
            ParsedHost parsedHost;
            block127: {
                boolean isIPAddress;
                boolean bl = isIPAddress = squareBracketed || tryIPv4 || tryIPv6;
                if (!validationOptions.allowIPAddress) {
                    if (isIPAddress) {
                        throw new HostNameException(str, "ipaddress.host.error.ipaddress");
                    }
                } else if (isIPAddress || isPossiblyIPv4 || isPossiblyIPv6) {
                    try {
                        ParsedIPAddress pa = new ParsedIPAddress(fromHost, str, addressOptions);
                        ParsedHostIdentifierStringQualifier addrQualifier = null;
                        ParsedHostIdentifierStringQualifier hostQualifier = ParsedHost.NO_QUALIFIER;
                        if (squareBracketed) {
                            boolean endsWithQualifier;
                            int endIndex = addrLen - 1;
                            boolean bl2 = endsWithQualifier = str.charAt(endIndex) != ']';
                            if (endsWithQualifier) {
                                while (str.charAt(--endIndex) != ']') {
                                    if (endIndex != 1) continue;
                                    throw new HostNameException(str, "ipaddress.host.error.bracketed.missing.end");
                                }
                            }
                            int startIndex = 1;
                            if (str.startsWith("IPv6:", 1)) {
                                startIndex = 6;
                            } else {
                                char firstChar = str.charAt(1);
                                if (firstChar == 'v' || firstChar == IPvFUTURE_UPPERCASE) {
                                    throw new HostNameException(str, "ipaddress.host.error.invalid.mechanism");
                                }
                            }
                            Validator.validateIPAddress(addressOptions, str, startIndex, endIndex, pa, false);
                            if (endsWithQualifier) {
                                int prefixIndex = endIndex + 1;
                                char prefixChar = str.charAt(prefixIndex);
                                if (prefixChar == '/') {
                                    isPrefixed = true;
                                } else if (prefixChar == ':') {
                                    hasPortOrService = true;
                                } else {
                                    throw new HostNameException(str, prefixIndex);
                                }
                                qualifierIndex = prefixIndex + 1;
                                endIndex = str.length();
                                AddressParseData addressParseData = pa.getAddressParseData();
                                ParsedHostIdentifierStringQualifier parsedHostQualifier = Validator.parseHostNameQualifier(str, addressOptions, validationOptions, isPrefixed, hasPortOrService, addressParseData.isProvidingEmpty(), qualifierIndex, endIndex, pa.getProviderIPVersion());
                                int insideBracketsQualifierIndex = pa.getQualifierIndex();
                                if (pa.isZoned() && str.charAt(insideBracketsQualifierIndex) == '2' && str.charAt(insideBracketsQualifierIndex + 1) == '5') {
                                    insideBracketsQualifierIndex += 2;
                                }
                                addrQualifier = Validator.parseHostAddressQualifier(str, addressOptions, null, pa.hasPrefixSeparator(), false, pa, insideBracketsQualifierIndex, prefixIndex - 1);
                                if (isPrefixed) {
                                    if (addrQualifier == ParsedHost.NO_QUALIFIER) {
                                        addrQualifier = parsedHostQualifier;
                                    } else {
                                        IPAddress two;
                                        Integer hostPrefLength;
                                        Integer addPrefLength = addrQualifier.getEquivalentPrefixLength();
                                        if (addPrefLength != null && (hostPrefLength = parsedHostQualifier.getEquivalentPrefixLength()) != null && addPrefLength.intValue() != hostPrefLength.intValue()) {
                                            throw new HostNameException(str, "ipaddress.host.error.bracketed.conflicting.prefix.length");
                                        }
                                        IPAddress one = addrQualifier.getMask();
                                        if (one != null && (two = parsedHostQualifier.getMask()) != null && !one.equals(two)) {
                                            throw new HostNameException(str, "ipaddress.host.error.bracketed.conflicting.mask");
                                        }
                                        addrQualifier.mergePrefix(parsedHostQualifier);
                                    }
                                } else {
                                    hostQualifier = parsedHostQualifier;
                                }
                            } else {
                                qualifierIndex = pa.getQualifierIndex();
                                isPrefixed = pa.hasPrefixSeparator();
                                hasPortOrService = false;
                                if (pa.isZoned() && str.charAt(qualifierIndex) == '2' && str.charAt(qualifierIndex + 1) == '5') {
                                    qualifierIndex += 2;
                                }
                                addrQualifier = Validator.parseHostAddressQualifier(str, addressOptions, validationOptions, isPrefixed, hasPortOrService, pa, qualifierIndex, endIndex);
                            }
                            IPAddress.IPVersion version = pa.getProviderIPVersion();
                            if (version != IPAddress.IPVersion.IPV6 && !validationOptions.allowBracketedIPv4) {
                                throw new HostNameException(str, "ipaddress.host.error.bracketed.not.ipv6");
                            }
                        } else {
                            int endIndex;
                            boolean firstTrySucceeded;
                            block126: {
                                boolean isPotentiallyIPv6;
                                firstTrySucceeded = false;
                                boolean hasAddressPortOrService = false;
                                int addressQualifierIndex = -1;
                                boolean bl3 = isPotentiallyIPv6 = isPossiblyIPv6 || tryIPv6;
                                if (isPotentiallyIPv6) {
                                    if (!isPrefixed && (validationOptions.allowPort || validationOptions.allowService)) {
                                        for (int j = str.length() - 1; j >= 0; --j) {
                                            char c = str.charAt(j);
                                            if (c == ':') {
                                                hasAddressPortOrService = true;
                                                addressQualifierIndex = j + 1;
                                            } else if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '*') {
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                } else {
                                    hasAddressPortOrService = hasPortOrService;
                                    addressQualifierIndex = qualifierIndex;
                                }
                                if (hasAddressPortOrService) {
                                    try {
                                        ParsedHostIdentifierStringQualifier hostPortQualifier = hostQualifier = Validator.parsePortOrService(str, null, validationOptions, addressQualifierIndex, str.length());
                                        if (isPotentiallyIPv6) {
                                            boolean expectPort = validationOptions.expectPort;
                                            try {
                                                if (expectPort) {
                                                    endIndex = addressQualifierIndex - 1;
                                                } else {
                                                    endIndex = str.length();
                                                    hostQualifier = ParsedHost.NO_QUALIFIER;
                                                }
                                                Validator.validateIPAddress(addressOptions, str, 0, endIndex, pa, false);
                                                addrQualifier = Validator.parseAddressQualifier(str, addressOptions, null, pa, endIndex);
                                                firstTrySucceeded = true;
                                            }
                                            catch (AddressStringException e) {
                                                pa = new ParsedIPAddress(fromHost, str, addressOptions);
                                                if (expectPort) {
                                                    hostQualifier = ParsedHost.NO_QUALIFIER;
                                                    endIndex = str.length();
                                                    break block126;
                                                }
                                                hostQualifier = hostPortQualifier;
                                                endIndex = addressQualifierIndex - 1;
                                            }
                                            break block126;
                                        }
                                        endIndex = addressQualifierIndex - 1;
                                    }
                                    catch (AddressStringException e) {
                                        if (!isPotentiallyIPv6) {
                                            throw e;
                                        }
                                        hostQualifier = ParsedHost.NO_QUALIFIER;
                                        endIndex = str.length();
                                    }
                                } else {
                                    endIndex = str.length();
                                }
                            }
                            if (!firstTrySucceeded) {
                                Validator.validateIPAddress(addressOptions, str, 0, endIndex, pa, false);
                                addrQualifier = Validator.parseAddressQualifier(str, addressOptions, null, pa, endIndex);
                            }
                        }
                        IPAddressProvider provider = Validator.chooseProvider(fromHost, str, addressOptions, pa, addrQualifier);
                        return new ParsedHost(str, provider, hostQualifier);
                    }
                    catch (AddressStringException e) {
                        if (!isIPAddress) break block127;
                        throw e;
                    }
                }
            }
            ParsedHostIdentifierStringQualifier qualifier = Validator.parseHostNameQualifier(str, addressOptions, validationOptions, isPrefixed, hasPortOrService, addressIsEmpty, qualifierIndex, str.length(), null);
            if (addressIsEmpty) {
                if (!validationOptions.allowEmpty) {
                    throw new HostNameException(str, "ipaddress.host.error.empty");
                }
                parsedHost = qualifier == ParsedHost.NO_QUALIFIER ? DEFAULT_EMPTY_HOST : new ParsedHost(str, EMPTY_INDICES, null, qualifier);
            } else {
                ParsedHostIdentifierStringQualifier hostQualifier;
                ParsedHostIdentifierStringQualifier addrQualifier;
                if (labelCount <= maxLocalLabels) {
                    maxLocalLabels = labelCount;
                    separatorIndices = new int[maxLocalLabels];
                    if (validationOptions.normalizeToLowercase) {
                        normalizedFlags = new boolean[labelCount];
                    }
                } else if (labelCount != separatorIndices.length) {
                    int[] trimmedSeparatorIndices = new int[labelCount];
                    System.arraycopy(separatorIndices, maxLocalLabels, trimmedSeparatorIndices, maxLocalLabels, labelCount - maxLocalLabels);
                    separatorIndices = trimmedSeparatorIndices;
                    if (normalizedFlags != null) {
                        boolean[] trimmedNormalizedFlags = new boolean[labelCount];
                        System.arraycopy(normalizedFlags, maxLocalLabels, trimmedNormalizedFlags, maxLocalLabels, labelCount - maxLocalLabels);
                        normalizedFlags = trimmedNormalizedFlags;
                    }
                }
                for (int i = 0; i < maxLocalLabels; ++i) {
                    boolean isUpper;
                    int nextSep;
                    if (i < 2) {
                        if (i == 0) {
                            nextSep = sep0;
                            isUpper = upper0;
                        } else {
                            nextSep = sep1;
                            isUpper = upper1;
                        }
                    } else if (i < 4) {
                        if (i == 2) {
                            nextSep = sep2;
                            isUpper = upper2;
                        } else {
                            nextSep = sep3;
                            isUpper = upper3;
                        }
                    } else if (i == 4) {
                        nextSep = sep4;
                        isUpper = upper4;
                    } else {
                        nextSep = sep5;
                        isUpper = upper5;
                    }
                    separatorIndices[i] = nextSep;
                    if (normalizedFlags == null) continue;
                    normalizedFlags[i] = !isUpper;
                    isNotNormalized |= isUpper;
                }
                if (isPrefixed) {
                    addrQualifier = qualifier;
                    hostQualifier = ParsedHost.NO_QUALIFIER;
                } else {
                    hostQualifier = qualifier;
                    addrQualifier = ParsedHost.NO_QUALIFIER;
                }
                ParsedHost.EmbeddedAddress addr = Validator.checkSpecialHosts(str, addrLen, addrQualifier);
                AddressStringException embeddedException = null;
                if (isSpecialOnlyIndex >= 0 && (addr == null || (embeddedException = addr.addressStringException) != null)) {
                    if (embeddedException != null) {
                        throw new HostNameException(str, isSpecialOnlyIndex, embeddedException);
                    }
                    throw new HostNameException(str, isSpecialOnlyIndex);
                }
                parsedHost = new ParsedHost(str, separatorIndices, normalizedFlags, addr == null ? qualifier : hostQualifier, addr);
                if (!isNotNormalized && addr == null) {
                    parsedHost.host = str;
                }
            }
            return parsedHost;
        }
        catch (AddressStringException e) {
            throw new HostNameException(str, e, "ipaddress.host.error.invalid");
        }
    }

    private static ParsedHost.EmbeddedAddress checkSpecialHosts(String str, int addrLen, ParsedHostIdentifierStringQualifier hostQualifier) {
        ParsedHost.EmbeddedAddress emb = null;
        try {
            String suffix3;
            int suffixStartIndex;
            String suffix = ".ipv6-literal.net";
            if (addrLen > suffix.length() && str.regionMatches(true, suffixStartIndex = addrLen - suffix.length(), suffix, 0, suffix.length())) {
                IPAddressProvider provider;
                ParsedHostIdentifierStringQualifier qual;
                StringBuilder builder = new StringBuilder(str.substring(0, suffixStartIndex));
                for (int i = 0; i < builder.length(); ++i) {
                    char c = builder.charAt(i);
                    if (c == '-') {
                        builder.setCharAt(i, ':');
                        continue;
                    }
                    if (c == '\u00bb') {
                        builder.setCharAt(i, '-');
                        continue;
                    }
                    if (c != 's') continue;
                    builder.setCharAt(i, '%');
                }
                emb = new ParsedHost.EmbeddedAddress();
                emb.isUNCIPv6Literal = true;
                IPAddressStringParameters params = DEFAULT_UNC_OPTS;
                ParsedIPAddress pa = new ParsedIPAddress(null, str, params);
                Validator.validateIPAddress(params, builder, 0, builder.length(), pa, false);
                ParsedHostIdentifierStringQualifier addrQualifier = Validator.parseAddressQualifier(builder, DEFAULT_UNC_OPTS, null, pa, builder.length());
                if (addrQualifier == ParsedHost.NO_QUALIFIER) {
                    qual = hostQualifier;
                } else if (hostQualifier == ParsedHost.NO_QUALIFIER) {
                    qual = addrQualifier;
                } else {
                    addrQualifier.mergePrefix(hostQualifier);
                    qual = addrQualifier;
                }
                emb.addressProvider = provider = Validator.chooseProvider(null, builder, params, pa, qual);
            }
            if (addrLen > (suffix3 = ".ip6.int").length()) {
                suffix = ".in-addr.arpa";
                String suffix2 = ".ip6.arpa";
                suffixStartIndex = addrLen - suffix.length();
                boolean isIPv4 = str.regionMatches(true, suffixStartIndex, suffix, 0, suffix.length());
                if (isIPv4 || addrLen > suffix2.length() && str.regionMatches(true, suffixStartIndex = addrLen - suffix2.length(), suffix2, 0, suffix2.length()) || addrLen > suffix3.length() && str.regionMatches(true, suffixStartIndex = addrLen - suffix3.length(), suffix3, 0, suffix3.length())) {
                    IPAddressProvider provider;
                    IPAddressStringParameters params;
                    CharSequence sequence;
                    emb = new ParsedHost.EmbeddedAddress();
                    emb.isReverseDNS = true;
                    if (isIPv4) {
                        sequence = Validator.convertReverseDNSIPv4(str, suffixStartIndex);
                        params = REVERSE_DNS_IPV4_OPTS;
                    } else {
                        sequence = Validator.convertReverseDNSIPv6(str, suffixStartIndex);
                        params = REVERSE_DNS_IPV6_OPTS;
                    }
                    ParsedIPAddress pa = new ParsedIPAddress(null, sequence, params);
                    Validator.validateIPAddress(params, sequence, 0, sequence.length(), pa, false);
                    emb.addressProvider = provider = Validator.chooseProvider(null, sequence, params, pa, hostQualifier != null ? hostQualifier : ParsedHost.NO_QUALIFIER);
                }
            }
        }
        catch (AddressStringException e) {
            emb.addressStringException = e;
        }
        return emb;
    }

    private static CharSequence convertReverseDNSIPv4(String str, int suffixStartIndex) throws AddressStringException {
        StringBuilder builder = new StringBuilder(suffixStartIndex);
        int segCount = 0;
        int j = suffixStartIndex;
        for (int i = suffixStartIndex - 1; i > 0; --i) {
            char c1 = str.charAt(i);
            if (c1 != '.') continue;
            if (j - i <= 1) {
                throw new AddressStringException((CharSequence)str, i);
            }
            for (int k = i + 1; k < j; ++k) {
                builder.append(str.charAt(k));
            }
            builder.append(c1);
            j = i;
            ++segCount;
        }
        for (int k = 0; k < j; ++k) {
            builder.append(str.charAt(k));
        }
        if (segCount + 1 != 4) {
            throw new AddressStringException((CharSequence)str, 0);
        }
        return builder;
    }

    private static CharSequence convertReverseDNSIPv6(String str, int suffixStartIndex) throws AddressStringException {
        StringBuilder builder = new StringBuilder(suffixStartIndex);
        StringBuilder low = new StringBuilder();
        StringBuilder high = new StringBuilder();
        int segCount = 0;
        int i = suffixStartIndex - 1;
        while (i >= 0) {
            boolean isRange = false;
            for (int j = 0; j < 4; ++j) {
                char c1 = str.charAt(i--);
                if (i >= 0) {
                    char c2;
                    if ((c2 = str.charAt(i--)) == '.') {
                        if (c1 == '*') {
                            isRange = true;
                            low.append('0');
                            high.append('f');
                            continue;
                        }
                        if (isRange) {
                            throw new AddressStringException((CharSequence)str, i + 1);
                        }
                        low.append(c1);
                        high.append(c1);
                        continue;
                    }
                    if (c2 == '-') {
                        high.append(c1);
                        if (i >= 1) {
                            boolean isFullRange;
                            c2 = str.charAt(i--);
                            low.append(c2);
                            boolean bl = isFullRange = c2 == '0' && c1 == 'f';
                            if (isRange && !isFullRange) {
                                throw new AddressStringException((CharSequence)str, i + 1);
                            }
                            if ((c2 = str.charAt(i--)) != '.') {
                                throw new AddressStringException((CharSequence)str, i + 1);
                            }
                        } else {
                            throw new AddressStringException((CharSequence)str, i);
                        }
                        isRange = true;
                        continue;
                    }
                    throw new AddressStringException((CharSequence)str, i + 1);
                }
                if (j < 3) {
                    throw new AddressStringException((CharSequence)str, i + 1);
                }
                if (c1 == '*') {
                    isRange = true;
                    low.append('0');
                    high.append('f');
                    continue;
                }
                if (isRange) {
                    throw new AddressStringException((CharSequence)str, 0);
                }
                low.append(c1);
                high.append(c1);
            }
            ++segCount;
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append((CharSequence)low);
            if (isRange) {
                builder.append('-').append((CharSequence)high);
            }
            low.setLength(0);
            high.setLength(0);
        }
        if (segCount != 8) {
            throw new AddressStringException((CharSequence)str, 0);
        }
        return builder;
    }

    static {
        int i;
        extendedChars = new int[128];
        char[] extendedDigits = IPAddressLargeDivision.EXTENDED_DIGITS;
        for (i = 0; i < extendedDigits.length; ++i) {
            Validator.extendedChars[extendedDigits[i]] = i;
        }
        int[] charArray = chars = new int[128];
        i = 0;
        int c = 48;
        while (i < 10) {
            charArray[c] = i++;
            c = (char)(c + 1);
        }
        c = 97;
        int c2 = 65;
        while (i < 26) {
            charArray[c] = charArray[c2] = i++;
            c = (char)(c + 1);
            c2 = (char)(c2 + 1);
        }
        IPvFUTURE_UPPERCASE = Character.toUpperCase('v');
        EMPTY_INDICES = new int[0];
        PREFIX_CACHE = new ParsedHostIdentifierStringQualifier[129];
        MASK_CACHE = new IPAddressProvider.MaskCreator[3][];
        LOOPBACK_CACHE = new IPAddressProvider.LoopbackCreator(IPAddressString.DEFAULT_VALIDATION_OPTIONS);
        DEFAULT_EMPTY_HOST = new ParsedHost("", EMPTY_INDICES, null, ParsedHost.NO_QUALIFIER);
        DEFAULT_PREFIX_OPTIONS = new IPAddressStringParameters.Builder().toParams();
        VALIDATOR = new Validator();
        DEFAULT_UNC_OPTS = new IPAddressStringParameters.Builder().allowIPv4(false).allowEmpty(false).allowMask(false).allowPrefixOnly(false).allowPrefix(false).toParams();
        REVERSE_DNS_IPV4_OPTS = new IPAddressStringParameters.Builder().allowIPv6(false).allowEmpty(false).allowMask(false).allowPrefixOnly(false).allowPrefix(false).getIPv4AddressParametersBuilder().allow_inet_aton(false).getParentBuilder().toParams();
        REVERSE_DNS_IPV6_OPTS = new IPAddressStringParameters.Builder().allowIPv4(false).allowEmpty(false).allowMask(false).allowPrefixOnly(false).allowPrefix(false).getIPv6AddressParametersBuilder().allowMixed(false).allowZone(false).getParentBuilder().toParams();
        BASE_85_POWERS = new BigInteger[10];
        LOW_BITS_MASK = BigInteger.valueOf(-1L);
        MAX_VALUES = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL};
        MAX_IPv4_STRING_LEN = new int[][]{{3, 6, 8, 11}, new int[0], new int[0], new int[0], {3, 6, 8, 11}, {3, 5, 8, 10}, new int[0], new int[0], {2, 4, 6, 8}};
        BigInteger eightyFive = BigInteger.valueOf(85L);
        Validator.BASE_85_POWERS[0] = BigInteger.ONE;
        for (i = 1; i < BASE_85_POWERS.length; ++i) {
            Validator.BASE_85_POWERS[i] = BASE_85_POWERS[i - 1].multiply(eightyFive);
        }
    }
}

