/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IPAddressString
implements HostIdentifierString,
Comparable<IPAddressString> {
    private static final long serialVersionUID = 4L;
    public static final IPAddressStringParameters DEFAULT_VALIDATION_OPTIONS = new IPAddressStringParameters.Builder().toParams();
    private static final AddressStringException IS_IPV6_EXCEPTION = new AddressStringException("ipaddress.error.address.is.ipv6");
    private static final AddressStringException IS_IPV4_EXCEPTION = new AddressStringException("ipaddress.error.address.is.ipv4");
    final IPAddressStringParameters validationOptions;
    final String fullAddr;
    private AddressStringException ipv6Exception;
    private AddressStringException ipv4Exception;
    private IPAddressProvider addressProvider = IPAddressProvider.NO_TYPE_PROVIDER;

    public IPAddressString(String addr) {
        this(addr, DEFAULT_VALIDATION_OPTIONS);
    }

    public IPAddressString(String addr, IPAddressStringParameters valOptions) {
        if (addr == null) {
            addr = "";
            this.fullAddr = "";
        } else {
            this.fullAddr = addr = addr.trim();
        }
        this.validationOptions = valOptions;
    }

    IPAddressString(IPAddress address, IPAddressStringParameters valOptions) {
        this.validationOptions = valOptions;
        this.fullAddr = address.toCanonicalString();
        this.initByAddress(address);
    }

    void cacheAddress(IPAddress address) {
        if (this.addressProvider == IPAddressProvider.NO_TYPE_PROVIDER) {
            this.initByAddress(address);
        }
    }

    void initByAddress(IPAddress address) {
        IPAddressProvider provider = address.getProvider();
        if (provider.isProvidingIPv4()) {
            this.ipv6Exception = IS_IPV4_EXCEPTION;
        } else if (provider.isProvidingIPv6()) {
            this.ipv4Exception = IS_IPV6_EXCEPTION;
        }
        this.addressProvider = provider;
    }

    public IPAddressStringParameters getValidationOptions() {
        return this.validationOptions;
    }

    public boolean isPrefixed() {
        return this.getNetworkPrefixLength() != null;
    }

    public Integer getNetworkPrefixLength() {
        if (this.isValid()) {
            return this.addressProvider.getProviderNetworkPrefixLength();
        }
        return null;
    }

    public boolean isIPAddress() {
        return this.isValid() && this.addressProvider.isProvidingIPAddress();
    }

    public boolean isAllAddresses() {
        return this.isValid() && this.addressProvider.isProvidingAllAddresses();
    }

    public boolean isPrefixOnly() {
        return this.isValid() && this.addressProvider.isProvidingPrefixOnly();
    }

    public boolean isEmpty() {
        return this.isValid() && this.addressProvider.isProvidingEmpty();
    }

    public boolean isIPv4() {
        return this.isValid() && this.addressProvider.isProvidingIPv4();
    }

    public boolean isIPv6() {
        return this.isValid() && this.addressProvider.isProvidingIPv6();
    }

    public boolean isMixedIPv6() {
        return this.isIPv6() && this.addressProvider.isProvidingMixedIPv6();
    }

    public boolean isBase85IPv6() {
        return this.isIPv6() && this.addressProvider.isProvidingBase85IPv6();
    }

    public IPAddress.IPVersion getIPVersion() {
        if (this.isValid()) {
            return this.addressProvider.getProviderIPVersion();
        }
        return null;
    }

    public boolean isLoopback() {
        IPAddress val = this.getAddress();
        return val != null && val.isLoopback();
    }

    public boolean isZero() {
        IPAddress value = this.getAddress();
        return value != null && value.isZero();
    }

    public boolean isValid() {
        if (this.addressProvider.isUninitialized()) {
            try {
                this.validate();
                return true;
            }
            catch (AddressStringException e) {
                return false;
            }
        }
        return !this.addressProvider.isInvalid();
    }

    public void validateIPv4() throws AddressStringException {
        this.validate(IPAddress.IPVersion.IPV4);
        this.checkIPv4Exception();
    }

    public void validateIPv6() throws AddressStringException {
        this.validate(IPAddress.IPVersion.IPV6);
        this.checkIPv6Exception();
    }

    @Override
    public void validate() throws AddressStringException {
        this.validate(null);
    }

    private void checkIPv4Exception() throws AddressStringException {
        if (this.ipv4Exception != null) {
            if (this.ipv4Exception == IS_IPV6_EXCEPTION) {
                this.ipv4Exception = new AddressStringException("ipaddress.error.address.is.ipv6");
            }
            throw this.ipv4Exception;
        }
    }

    private void checkIPv6Exception() throws AddressStringException {
        if (this.ipv6Exception != null) {
            if (this.ipv6Exception == IS_IPV4_EXCEPTION) {
                this.ipv6Exception = new AddressStringException("ipaddress.error.address.is.ipv4");
            }
            throw this.ipv6Exception;
        }
    }

    private boolean isValidated(IPAddress.IPVersion version) throws AddressStringException {
        if (this.addressProvider != IPAddressProvider.NO_TYPE_PROVIDER) {
            if (version == null) {
                if (this.ipv6Exception != null && this.ipv4Exception != null) {
                    throw this.ipv4Exception;
                }
            } else if (version.isIPv4()) {
                this.checkIPv4Exception();
            } else if (version.isIPv6()) {
                this.checkIPv6Exception();
            }
            return true;
        }
        return false;
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(IPAddress.IPVersion version) throws AddressStringException {
        if (this.isValidated(version)) {
            return;
        }
        IPAddressString iPAddressString = this;
        synchronized (iPAddressString) {
            if (this.isValidated(version)) {
                return;
            }
            try {
                IPAddressProvider valueCreator = this.getValidator().validateAddress(this);
                IPAddress.IPVersion createdVersion = valueCreator.getProviderIPVersion();
                if (createdVersion != null) {
                    if (createdVersion.isIPv4()) {
                        this.ipv6Exception = IS_IPV4_EXCEPTION;
                    } else if (createdVersion.isIPv6()) {
                        this.ipv4Exception = IS_IPV6_EXCEPTION;
                    }
                }
                this.addressProvider = valueCreator;
            }
            catch (AddressStringException e) {
                this.ipv6Exception = this.ipv4Exception = e;
                this.addressProvider = IPAddressProvider.INVALID_PROVIDER;
                throw e;
            }
        }
    }

    public static int validateNetworkPrefixLength(IPAddress.IPVersion ipVersion, CharSequence networkPrefixLength) throws PrefixLenException {
        try {
            return Validator.VALIDATOR.validatePrefix(networkPrefixLength, ipVersion);
        }
        catch (AddressStringException e) {
            throw new PrefixLenException(networkPrefixLength, ipVersion, e);
        }
    }

    public static void validateNetworkPrefix(IPAddress.IPVersion ipVersion, int networkPrefixLength, boolean allowPrefixesBeyondAddressSize) throws PrefixLenException {
        boolean asIPv4 = ipVersion != null && ipVersion.isIPv4();
        if (networkPrefixLength > (asIPv4 ? 32 : 128)) {
            throw new PrefixLenException(networkPrefixLength, ipVersion);
        }
    }

    public int hashCode() {
        if (this.isValid()) {
            return this.addressProvider.hashCode();
        }
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(IPAddressString other) {
        if (this == other) {
            return 0;
        }
        boolean isValid = this.isValid();
        boolean otherIsValid = other.isValid();
        if (!isValid && !otherIsValid) {
            return this.toString().compareTo(other.toString());
        }
        return this.addressProvider.providerCompare(other.addressProvider);
    }

    public boolean prefixEquals(IPAddressString other) {
        Boolean directResult;
        Integer prefixLength = this.getNetworkPrefixLength();
        if (prefixLength == null) {
            return false;
        }
        if (other == this && !this.isPrefixOnly()) {
            return true;
        }
        if (other.addressProvider == IPAddressProvider.NO_TYPE_PROVIDER && (directResult = this.addressProvider.prefixEquals(other.fullAddr)) != null) {
            return directResult;
        }
        if (other.isValid()) {
            directResult = this.addressProvider.prefixEquals(other.addressProvider);
            if (directResult != null) {
                return directResult;
            }
            IPAddress thisAddress = this.getAddress();
            IPAddress otherAddress = other.getAddress();
            if (thisAddress != null) {
                return otherAddress != null && prefixLength <= otherAddress.getBitCount() && thisAddress.toPrefixBlock().equals(otherAddress.toPrefixBlock(prefixLength));
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddressString) {
            IPAddressString other = (IPAddressString)o;
            if (this.toString().equals(other.toString())) {
                return true;
            }
            if (this.isValid() && other.isValid()) {
                Boolean directResult = this.addressProvider.parsedEquals(other.addressProvider);
                if (directResult != null) {
                    return directResult;
                }
                return this.addressProvider.equalsProvider(other.addressProvider);
            }
        }
        return false;
    }

    public boolean contains(IPAddressString other) {
        if (this.isValid()) {
            Boolean directResult;
            if (other == this) {
                return true;
            }
            if (other.addressProvider == IPAddressProvider.NO_TYPE_PROVIDER && (directResult = this.addressProvider.contains(other.fullAddr)) != null) {
                return directResult;
            }
            if (other.isValid()) {
                IPAddress otherAddress;
                directResult = this.addressProvider.contains(other.addressProvider);
                if (directResult != null) {
                    return directResult;
                }
                IPAddress addr = this.getAddress();
                if (addr != null && (otherAddress = other.getAddress()) != null) {
                    return addr.contains(otherAddress);
                }
            }
        }
        return false;
    }

    public IPAddress getHostAddress() {
        if (!this.addressProvider.isInvalid()) {
            try {
                return this.toHostAddress();
            }
            catch (AddressStringException addressStringException) {
                // empty catch block
            }
        }
        return null;
    }

    public IPAddress getAddress(IPAddress.IPVersion version) {
        if (!this.addressProvider.isInvalid()) {
            try {
                return this.toAddress(version);
            }
            catch (AddressStringException addressStringException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IPAddress getAddress() {
        if (!this.addressProvider.isInvalid()) {
            try {
                return this.toAddress();
            }
            catch (AddressStringException addressStringException) {
                // empty catch block
            }
        }
        return null;
    }

    public IPAddress toHostAddress() throws AddressStringException, IncompatibleAddressException {
        this.validate();
        return this.addressProvider.getProviderHostAddress();
    }

    public IPAddress toAddress(IPAddress.IPVersion version) throws AddressStringException, IncompatibleAddressException {
        this.validate();
        return this.addressProvider.getProviderAddress(version);
    }

    @Override
    public IPAddress toAddress() throws AddressStringException, IncompatibleAddressException {
        this.validate();
        return this.addressProvider.getProviderAddress();
    }

    public IPAddressString adjustPrefixBySegment(boolean nextSegment) {
        if (this.isPrefixOnly()) {
            int newBits;
            int bitsPerSegment = 8;
            int existingPrefixLength = this.getNetworkPrefixLength();
            if (nextSegment) {
                int adjustment = existingPrefixLength % bitsPerSegment;
                newBits = Math.min(128, existingPrefixLength + bitsPerSegment - adjustment);
            } else {
                int adjustment = (existingPrefixLength - 1) % bitsPerSegment + 1;
                newBits = Math.max(0, existingPrefixLength - adjustment);
            }
            return new IPAddressString(IPAddressNetwork.getPrefixString(newBits), this.validationOptions);
        }
        IPAddress address = this.getAddress();
        if (address == null) {
            return null;
        }
        Integer prefix = address.getNetworkPrefixLength();
        if (!nextSegment && prefix != null && prefix == 0 && address.isMultiple() && address.isPrefixBlock()) {
            return new IPAddressString(IPAddress.SEGMENT_WILDCARD_STR, this.validationOptions);
        }
        return address.adjustPrefixBySegment(nextSegment).toAddressString();
    }

    public IPAddressString adjustPrefixLength(int adjustment) {
        if (this.isPrefixOnly()) {
            int newBits = adjustment > 0 ? Math.min(128, this.getNetworkPrefixLength() + adjustment) : Math.max(0, this.getNetworkPrefixLength() + adjustment);
            return new IPAddressString(IPAddressNetwork.getPrefixString(newBits), this.validationOptions);
        }
        IPAddress address = this.getAddress();
        if (address == null) {
            return null;
        }
        if (adjustment == 0) {
            return this;
        }
        Integer prefix = address.getNetworkPrefixLength();
        if (prefix != null && prefix + adjustment < 0 && address.isPrefixBlock()) {
            return new IPAddressString(IPAddress.SEGMENT_WILDCARD_STR, this.validationOptions);
        }
        return address.adjustPrefixLength(adjustment).toAddressString();
    }

    public static int countDelimitedAddresses(String str) {
        int segDelimitedCount = 0;
        int result = 1;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (IPAddressString.isDelimitedBoundary(c)) {
                if (segDelimitedCount > 0) {
                    result *= segDelimitedCount + 1;
                    segDelimitedCount = 0;
                }
            } else if (c == ',') {
                ++segDelimitedCount;
            }
            ++i;
        }
        if (segDelimitedCount > 0) {
            result *= segDelimitedCount + 1;
        }
        return result;
    }

    private static boolean isDelimitedBoundary(char c) {
        return c == '.' || c == ':' || c == '-' || c == '|';
    }

    public static Iterator<String> parseDelimitedSegments(final String str) {
        ArrayList<List<String>> parts = null;
        int lastSegmentStartIndex = 0;
        int lastPartIndex = 0;
        int lastDelimiterIndex = 0;
        boolean anyDelimited = false;
        ArrayList<String> delimitedList = null;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (IPAddressString.isDelimitedBoundary(c)) {
                if (delimitedList != null) {
                    if (parts == null) {
                        parts = new ArrayList(8);
                    }
                    IPAddressString.addParts(str, parts, lastSegmentStartIndex, lastPartIndex, lastDelimiterIndex, delimitedList, i);
                    lastPartIndex = i;
                    delimitedList = null;
                }
                lastSegmentStartIndex = lastDelimiterIndex = i + 1;
            } else if (c == ',') {
                anyDelimited = true;
                if (delimitedList == null) {
                    delimitedList = new ArrayList<String>();
                }
                String sub = str.substring(lastDelimiterIndex, i);
                delimitedList.add(sub);
                lastDelimiterIndex = i + 1;
            }
            ++i;
        }
        if (anyDelimited) {
            if (delimitedList != null) {
                if (parts == null) {
                    parts = new ArrayList<List<String>>(8);
                }
                IPAddressString.addParts(str, parts, lastSegmentStartIndex, lastPartIndex, lastDelimiterIndex, delimitedList, str.length());
            } else {
                parts.add(Arrays.asList(str.substring(lastPartIndex, str.length())));
            }
            return IPAddressString.iterator(parts);
        }
        return new Iterator<String>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public String next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return str;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator<String> iterator(final List<List<String>> parts) {
        return new Iterator<String>(){
            private boolean done;
            final int partCount;
            private final Iterator<String>[] variations;
            private String[] nextSet;
            {
                this.partCount = list.size();
                this.variations = new Iterator[this.partCount];
                this.nextSet = new String[this.partCount];
                this.updateVariations(0);
            }

            private void updateVariations(int start) {
                int i = start;
                while (i < this.partCount) {
                    this.variations[i] = ((List)parts.get(i)).iterator();
                    this.nextSet[i] = this.variations[i].next();
                    ++i;
                }
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public String next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                StringBuilder result = new StringBuilder();
                int i = 0;
                while (i < this.partCount) {
                    result.append(this.nextSet[i]);
                    ++i;
                }
                this.increment();
                return result.toString();
            }

            private void increment() {
                int j = this.partCount - 1;
                while (j >= 0) {
                    if (this.variations[j].hasNext()) {
                        this.nextSet[j] = this.variations[j].next();
                        this.updateVariations(j + 1);
                        return;
                    }
                    --j;
                }
                this.done = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static void addParts(String str, List<List<String>> parts, int lastSegmentStartIndex, int lastPartIndex, int lastDelimiterIndex, List<String> delimitedList, int i) {
        String sub = str.substring(lastDelimiterIndex, i);
        delimitedList.add(sub);
        if (lastPartIndex != lastSegmentStartIndex) {
            parts.add(Arrays.asList(str.substring(lastPartIndex, lastSegmentStartIndex)));
        }
        parts.add(delimitedList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertToPrefixLength() throws AddressStringException {
        Integer prefix;
        IPAddress address = this.toAddress();
        if (address == null) {
            if (!this.isPrefixOnly()) return null;
            prefix = this.getNetworkPrefixLength();
            return IPAddressSegment.toUnsignedString(prefix, 10, new StringBuilder(IPAddressSegment.toUnsignedStringLength(prefix, 10) + 1).append('/')).toString();
        } else {
            prefix = address.getBlockMaskPrefixLength(true);
            if (prefix != null) return IPAddressSegment.toUnsignedString(prefix, 10, new StringBuilder(IPAddressSegment.toUnsignedStringLength(prefix, 10) + 1).append('/')).toString();
            return null;
        }
    }

    private static String toNormalizedString(IPAddressProvider addressProvider) {
        String result = addressProvider.isProvidingAllAddresses() ? IPAddress.SEGMENT_WILDCARD_STR : (addressProvider.isProvidingEmpty() ? "" : (addressProvider.isProvidingPrefixOnly() ? IPAddressNetwork.getPrefixString(addressProvider.getProviderNetworkPrefixLength()) : (addressProvider.isProvidingIPAddress() ? addressProvider.getProviderAddress().toNormalizedString() : null)));
        return result;
    }

    @Override
    public String toNormalizedString() {
        String result = this.isValid() ? IPAddressString.toNormalizedString(this.addressProvider) : this.toString();
        return result;
    }

    public String toString() {
        return this.fullAddr;
    }
}

