/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.MACAddressString;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.MACAddressParseData;
import inet.ipaddr.format.validate.MACAddressProvider;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;

class ParsedMACAddress
extends MACAddressParseData
implements MACAddressProvider {
    private static final long serialVersionUID = 4L;
    private final MACAddressString originator;
    private MACAddress address;

    ParsedMACAddress(MACAddressString from, CharSequence addressString) {
        super(addressString);
        this.originator = from;
    }

    private MACAddressNetwork.MACAddressCreator getMACAddressCreator() {
        return this.originator.getValidationOptions().getNetwork().getAddressCreator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MACAddress getAddress() {
        if (this.address == null) {
            ParsedMACAddress parsedMACAddress = this;
            synchronized (parsedMACAddress) {
                if (this.address == null) {
                    this.address = this.createAddress();
                    this.releaseSegmentData();
                }
            }
        }
        return this.address;
    }

    MACAddress createAddress() {
        MACAddressNetwork.MACAddressCreator creator = this.getMACAddressCreator();
        return (MACAddress)creator.createAddressInternal(this.createSection(), (HostIdentifierString)this.originator);
    }

    /*
     * Unable to fully structure code
     */
    private MACAddressSection createSection() {
        addressString = this.str;
        addressParseData = this.getAddressParseData();
        actualInitialSegmentCount = addressParseData.getSegmentCount();
        creator = this.getMACAddressCreator();
        format = this.getFormat();
        if (format == null) {
            finalSegmentCount = this.isExtended() != false ? 8 : 6;
            initialSegmentCount = finalSegmentCount;
        } else if (format == MACAddressParseData.MACFormat.DOTTED) {
            v0 = initialSegmentCount = this.isExtended() != false ? 4 : 3;
            finalSegmentCount = actualInitialSegmentCount <= 3 && !this.isExtended() ? 6 : 8;
        } else {
            finalSegmentCount = addressParseData.isSingleSegment() != false || this.isDoubleSegment() != false ? (this.isExtended() != false ? 8 : 6) : (actualInitialSegmentCount <= 6 && this.isExtended() == false ? 6 : 8);
            initialSegmentCount = finalSegmentCount;
        }
        missingCount = initialSegmentCount - actualInitialSegmentCount;
        expandedSegments = missingCount <= 0;
        segments = creator.createSegmentArray(finalSegmentCount);
        i = 0;
        normalizedSegmentIndex = 0;
        while (i < actualInitialSegmentCount) {
            block22: {
                lower = addressParseData.getValue(i, 2);
                upper = addressParseData.getValue(i, 4);
                if (format != MACAddressParseData.MACFormat.DOTTED) break block22;
                lowerHalfLower = (int)lower >>> 8;
                lowerHalfUpper = (int)upper >>> 8;
                adjustedLower2 = (int)lower & 255;
                adjustedUpper2 = (int)upper & 255;
                if (lowerHalfLower != lowerHalfUpper && adjustedUpper2 - adjustedLower2 != 255) {
                    throw new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges");
                }
                segments[normalizedSegmentIndex++] = this.createSegment(addressString, lowerHalfLower, lowerHalfUpper, false, addressParseData, i, creator);
                segments[normalizedSegmentIndex] = this.createSegment(addressString, adjustedLower2, adjustedUpper2, false, addressParseData, i, creator);
                ** GOTO lbl65
            }
            if (addressParseData.isSingleSegment() || this.isDoubleSegment()) {
                useStringIndicators = true;
                count = i == actualInitialSegmentCount - 1 ? missingCount : 2;
                missingCount -= count;
                isRange = lower != upper;
                previousAdjustedWasRange = false;
                while (count >= 0) {
                    if (isRange) {
                        segmentMask = 255;
                        shift = count << 3;
                        newLower = (int)(lower >>> shift) & segmentMask;
                        newUpper = (int)(upper >>> shift) & segmentMask;
                        if (previousAdjustedWasRange && newUpper - newLower != 255) {
                            throw new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges");
                        }
                        v1 = previousAdjustedWasRange = newLower != newUpper;
                        if (count == 0 && (long)newLower == lower) {
                            if ((long)newUpper != upper) {
                                addressParseData.setFlag(i, 8, false);
                            }
                        } else {
                            useStringIndicators = false;
                        }
                    } else {
                        newLower = newUpper = (int)(lower >> (count << 3)) & 255;
                        if (count != 0 || (long)newLower != lower) {
                            useStringIndicators = false;
                        }
                    }
                    segments[normalizedSegmentIndex] = this.createSegment(addressString, newLower, newUpper, useStringIndicators, addressParseData, i, creator);
                    ++normalizedSegmentIndex;
                    --count;
                }
            } else {
                segments[normalizedSegmentIndex] = this.createSegment(addressString, (int)lower, (int)upper, true, addressParseData, i, creator);
lbl65:
                // 2 sources

                if (!expandedSegments && addressParseData.isWildcard(i)) {
                    expandSegments = true;
                    j = i + 1;
                    while (j < actualInitialSegmentCount) {
                        if (addressParseData.isWildcard(j)) {
                            expandSegments = false;
                            break;
                        }
                        ++j;
                    }
                    if (expandSegments) {
                        expandedSegments = true;
                        count = missingCount;
                        while (count-- > 0) {
                            if (format == MACAddressParseData.MACFormat.DOTTED) {
                                seg = this.createSegment(addressString, 0, 255, false, addressParseData, i, creator);
                                segments[++normalizedSegmentIndex] = seg;
                                segments[++normalizedSegmentIndex] = seg;
                                continue;
                            }
                            segments[++normalizedSegmentIndex] = this.createSegment(addressString, 0, 255, false, addressParseData, i, creator);
                        }
                    }
                }
                ++normalizedSegmentIndex;
            }
            ++i;
        }
        addressCreator = creator;
        result = (MACAddressSection)addressCreator.createSectionInternal(segments);
        return result;
    }

    private <S extends MACAddressSegment> S createSegment(CharSequence addressString, int val, int upperVal, boolean useFlags, AddressParseData parseData, int parsedSegIndex, ParsedAddressCreator<?, ?, ?, S> creator) {
        if (val != upperVal) {
            return this.createRangeSegment(addressString, val, upperVal, useFlags, parseData, parsedSegIndex, creator);
        }
        MACAddressSegment result = !useFlags ? (MACAddressSegment)creator.createSegment(val, val, null) : (MACAddressSegment)creator.createSegmentInternal(val, null, addressString, val, parseData.getFlag(parsedSegIndex, 4), parseData.getIndex(parsedSegIndex, 11), parseData.getIndex(parsedSegIndex, 12));
        return (S)result;
    }

    private <S extends MACAddressSegment> S createRangeSegment(CharSequence addressString, int lower, int upper, boolean useFlags, AddressParseData parseData, int parsedSegIndex, ParsedAddressCreator<?, ?, ?, S> creator) {
        MACAddressSegment result = !useFlags ? (MACAddressSegment)creator.createSegment(lower, upper, null) : (MACAddressSegment)creator.createSegmentInternal(lower, upper, null, addressString, lower, upper, parseData.getFlag(parsedSegIndex, 4), parseData.getFlag(parsedSegIndex, 8), parseData.getIndex(parsedSegIndex, 11), parseData.getIndex(parsedSegIndex, 12), parseData.getIndex(parsedSegIndex, 15));
        return (S)result;
    }
}

