/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import java.io.Serializable;
import java.math.BigInteger;

class AddressParseData
implements Serializable {
    private static final long serialVersionUID = 4L;
    public static final int KEY_WILDCARD = 1;
    public static final int KEY_SINGLE_WILDCARD = 2;
    public static final int KEY_STANDARD_STR = 4;
    public static final int KEY_STANDARD_RANGE_STR = 8;
    public static final int KEY_LOWER = 2;
    public static final int KEY_UPPER = 4;
    public static final int KEY_EXTENDED_LOWER = 6;
    public static final int KEY_EXTENDED_UPPER = 8;
    public static final int KEY_LOWER_RADIX = 0;
    public static final int KEY_UPPER_RADIX = 16;
    public static final int KEY_LOWER_STR_DIGITS_INDEX = 10;
    public static final int KEY_LOWER_STR_START_INDEX = 11;
    public static final int KEY_LOWER_STR_END_INDEX = 12;
    public static final int KEY_UPPER_STR_DIGITS_INDEX = 13;
    public static final int KEY_UPPER_STR_START_INDEX = 14;
    public static final int KEY_UPPER_STR_END_INDEX = 15;
    private static final int FLAGS_INDEX = 0;
    private static final int RADIX_INDEX = 1;
    private static final int SEGMENT_DATA_SIZE = 16;
    private static final int IPV4_SEGMENT_DATA_SIZE = 64;
    private static final int IPV6_SEGMENT_DATA_SIZE = 128;
    private int[] segmentData;
    private int segmentCount;
    private boolean anyWildcard;
    private boolean isEmpty;
    private boolean isAll;
    private boolean isSingleSegment;
    private int consecutiveSepIndex = -1;
    private int consecutiveSepSegmentIndex = -1;
    private int addressEndIndex;
    protected final CharSequence str;
    static int totalCount;
    public static long averageT;

    AddressParseData(CharSequence str) {
        this.str = str;
    }

    CharSequence getString() {
        return this.str;
    }

    void initSegmentData(int segmentCapacity) {
        int dataSize = segmentCapacity == 4 ? 64 : (segmentCapacity == 8 ? 128 : (segmentCapacity == 1 ? 16 : segmentCapacity * 16));
        this.segmentData = new int[dataSize];
    }

    void releaseSegmentData() {
        this.segmentData = null;
    }

    int[] getSegmentData() {
        return this.segmentData;
    }

    void incrementSegmentCount() {
        ++this.segmentCount;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    int getConsecutiveSeparatorSegmentIndex() {
        return this.consecutiveSepSegmentIndex;
    }

    void setConsecutiveSeparatorSegmentIndex(int val) {
        this.consecutiveSepSegmentIndex = val;
    }

    int getConsecutiveSeparatorIndex() {
        return this.consecutiveSepIndex;
    }

    void setConsecutiveSeparatorIndex(int val) {
        this.consecutiveSepIndex = val;
    }

    public boolean isProvidingEmpty() {
        return this.isEmpty;
    }

    void setEmpty(boolean val) {
        this.isEmpty = val;
    }

    boolean isAll() {
        return this.isAll;
    }

    void setAll(boolean val) {
        this.isAll = val;
    }

    int getAddressEndIndex() {
        return this.addressEndIndex;
    }

    void setAddressEndIndex(int val) {
        this.addressEndIndex = val;
    }

    void setSingleSegment(boolean val) {
        this.isSingleSegment = val;
    }

    boolean isSingleSegment() {
        return this.isSingleSegment;
    }

    void setHasWildcard(boolean val) {
        this.anyWildcard = val;
    }

    boolean hasWildcard() {
        return this.anyWildcard;
    }

    void setFlag(int segmentIndex, int flagIndicator, boolean value) {
        int index = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        if (value) {
            int n = index;
            segmentData[n] = segmentData[n] | flagIndicator;
        } else {
            int n = index;
            segmentData[n] = segmentData[n] & ~flagIndicator;
        }
    }

    boolean getFlag(int segmentIndex, int flagIndicator) {
        int[] segmentData = this.getSegmentData();
        return (segmentData[segmentIndex << 4] & flagIndicator) != 0;
    }

    void setRadix(int segmentIndex, int indexIndicator, int value) {
        int[] segmentData = this.getSegmentData();
        int radixData = segmentData[segmentIndex << 4 | 1];
        segmentData[(segmentIndex << 4) + 1] = radixData = radixData & ~(65535 << indexIndicator) | (0xFFFF & value) << indexIndicator;
    }

    void setRadix(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1) {
        int radixData = (0xFFFF & value0) << indexIndicator0 | (0xFFFF & value1) << indexIndicator1;
        int[] segmentData = this.getSegmentData();
        segmentData[(segmentIndex << 4) + 1] = radixData;
    }

    int getRadix(int segmentIndex, int indexIndicator) {
        int[] segmentData = this.getSegmentData();
        int radixData = segmentData[segmentIndex << 4 | 1];
        return 0xFFFF & radixData >>> indexIndicator;
    }

    void setIndex(int segmentIndex, int indexIndicator, int value) {
        int[] segmentData = this.getSegmentData();
        segmentData[segmentIndex << 4 | indexIndicator] = value;
    }

    void setIndex(int segmentIndex, int indexIndicator0, int value0, int indexIndicator1, int value1, int indexIndicator2, int value2, int indexIndicator3, int value3, int indexIndicator4, int value4, int indexIndicator5, int value5) {
        int baseIndex = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        segmentData[baseIndex | indexIndicator0] = value0;
        segmentData[baseIndex | indexIndicator1] = value1;
        segmentData[baseIndex | indexIndicator2] = value2;
        segmentData[baseIndex | indexIndicator3] = value3;
        segmentData[baseIndex | indexIndicator4] = value4;
        segmentData[baseIndex | indexIndicator5] = value5;
    }

    int getIndex(int segmentIndex, int indexIndicator) {
        return AddressParseData.getIndex(segmentIndex, indexIndicator, this.getSegmentData());
    }

    static int getIndex(int segmentIndex, int indexIndicator, int[] segmentData) {
        return segmentData[segmentIndex << 4 | indexIndicator];
    }

    void setValue(int segmentIndex, int indexIndicator0, long value0, int indexIndicator1, long value1) {
        int baseIndex = segmentIndex << 4;
        int index = baseIndex | indexIndicator0;
        int[] segmentData = this.getSegmentData();
        segmentData[index] = (int)(value0 >>> 32);
        segmentData[index + 1] = (int)(value0 & 0xFFFFFFFFFFFFFFFFL);
        index = baseIndex | indexIndicator1;
        segmentData[index] = (int)(value1 >>> 32);
        segmentData[index + 1] = (int)(value1 & 0xFFFFFFFFFFFFFFFFL);
    }

    void setValue(int segmentIndex, int indexIndicator0, long value0, int indexIndicator1, long value1, int indexIndicator2, long value2, int indexIndicator3, long value3) {
        int baseIndex = segmentIndex << 4;
        int[] segmentData = this.getSegmentData();
        int index = baseIndex | indexIndicator0;
        segmentData[index] = (int)(value0 >>> 32);
        segmentData[index + 1] = (int)(value0 & 0xFFFFFFFFFFFFFFFFL);
        index = baseIndex | indexIndicator1;
        segmentData[index] = (int)(value1 >>> 32);
        segmentData[index + 1] = (int)(value1 & 0xFFFFFFFFFFFFFFFFL);
        index = baseIndex | indexIndicator2;
        segmentData[index] = (int)(value2 >>> 32);
        segmentData[index + 1] = (int)(value2 & 0xFFFFFFFFFFFFFFFFL);
        index = baseIndex | indexIndicator3;
        segmentData[index] = (int)(value3 >>> 32);
        segmentData[index + 1] = (int)(value3 & 0xFFFFFFFFFFFFFFFFL);
    }

    void setValue(int segmentIndex, int indexIndicator, long value) {
        int index = segmentIndex << 4 | indexIndicator;
        int upperValue = (int)(value >>> 32);
        int lowerValue = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        int[] segmentData = this.getSegmentData();
        segmentData[index] = upperValue;
        segmentData[index + 1] = lowerValue;
    }

    long getValue(int segmentIndex, int indexIndicator) {
        return AddressParseData.getValue(segmentIndex, indexIndicator, this.getSegmentData());
    }

    protected static long getValue(int segmentIndex, int indexIndicator, int[] segmentData) {
        int index = segmentIndex << 4 | indexIndicator;
        long upperValue = segmentData[index];
        long lowerValue = 0xFFFFFFFFL & (long)segmentData[index + 1];
        long value = upperValue << 32 | lowerValue;
        return value;
    }

    boolean isWildcard(int index) {
        return this.getFlag(index, 1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        CharSequence str = this.getString();
        builder.append("address string: ").append(str).append('\n');
        int addressEndIndex = this.getAddressEndIndex();
        if (addressEndIndex > 0 && addressEndIndex < str.length()) {
            builder.append("address end: ").append(str.subSequence(addressEndIndex, str.length())).append('\n');
        }
        int segmentCount = this.getSegmentCount();
        builder.append("segment count: ").append(segmentCount).append('\n');
        if (segmentCount > 0) {
            int i = 0;
            while (i < segmentCount) {
                builder.append("segment ").append(i).append(":\n");
                boolean isWildcard = this.isWildcard(i);
                if (isWildcard) {
                    builder.append("\tis wildcard").append('\n');
                } else {
                    BigInteger lowerResult;
                    BigInteger notExtended;
                    BigInteger shiftMore;
                    BigInteger extended;
                    long lower = this.getValue(i, 2);
                    long upper = this.getValue(i, 4);
                    long extendedUpper = this.getValue(i, 8);
                    long extendedLower = this.getValue(i, 6);
                    if (extendedLower != 0L) {
                        extended = BigInteger.valueOf(extendedLower);
                        shiftMore = extended.shiftLeft(64);
                        notExtended = BigInteger.valueOf(lower);
                        lowerResult = shiftMore.or(notExtended);
                        builder.append("\tvalue: ").append(lowerResult).append('\n');
                        builder.append("\tvalue in hex: ").append(lowerResult.toString(16)).append('\n');
                    } else {
                        builder.append("\tvalue: ").append(lower).append('\n');
                        builder.append("\tvalue in hex: ").append(Long.toHexString(lower)).append('\n');
                        lowerResult = null;
                    }
                    builder.append("\tstring: ").append(str.subSequence(this.getIndex(i, 11), this.getIndex(i, 12))).append('\n');
                    builder.append("\tradix: ").append(this.getIndex(i, 0)).append('\n');
                    builder.append("\tis standard: ").append(this.getFlag(i, 4)).append('\n');
                    if (extendedUpper != 0L) {
                        extended = BigInteger.valueOf(extendedUpper);
                        shiftMore = extended.shiftLeft(64);
                        BigInteger result = shiftMore.or(notExtended = BigInteger.valueOf(upper));
                        if (!result.equals(lowerResult)) {
                            builder.append("\tupper value: ").append(result).append('\n');
                            builder.append("\tupper value in hex: ").append(result.toString(16)).append('\n');
                            builder.append("\tupper string: ").append(str.subSequence(this.getIndex(i, 14), this.getIndex(i, 15))).append('\n');
                            builder.append("\tupper radix: ").append(this.getIndex(i, 16)).append('\n');
                            builder.append("\tis standard range: ").append(this.getFlag(i, 8)).append('\n');
                        }
                    } else if (upper != lower) {
                        builder.append("\tupper value: ").append(upper).append('\n');
                        builder.append("\tupper value in hex: ").append(Long.toHexString(upper)).append('\n');
                        builder.append("\tupper string: ").append(str.subSequence(this.getIndex(i, 14), this.getIndex(i, 15))).append('\n');
                        builder.append("\tupper radix: ").append(this.getIndex(i, 16)).append('\n');
                        builder.append("\tis standard range: ").append(this.getFlag(i, 8)).append('\n');
                    }
                    if (this.getFlag(i, 2)) {
                        builder.append("\thas single wildcard: ").append('\n');
                    }
                }
                ++i;
            }
            builder.append("has a wildcard segment: ").append(this.hasWildcard()).append('\n');
            int consecutiveSepIndex = this.getConsecutiveSeparatorIndex();
            if (consecutiveSepIndex >= 0) {
                builder.append("has compressed segment(s) at character ").append(consecutiveSepIndex + 1).append('\n');
            }
            if (this.isSingleSegment()) {
                builder.append("is single segment").append('\n');
            }
        } else if (this.isProvidingEmpty()) {
            builder.append("is empty").append('\n');
        } else if (this.isAll()) {
            builder.append("is all addresses").append('\n');
        }
        return builder.toString();
    }
}

