/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;

public class MACAddressNetwork
extends AddressNetwork<MACAddressSegment> {
    private static final long serialVersionUID = 4L;
    private static AddressNetwork.PrefixConfiguration defaultPrefixConfiguration = AddressNetwork.getDefaultPrefixConfiguration();
    private static final MACAddressSegment[] EMPTY_SEGMENTS = new MACAddressSegment[0];
    private MACAddressCreator creator = this.createAddressCreator();

    protected MACAddressCreator createAddressCreator() {
        return new MACAddressCreator();
    }

    public MACAddressCreator getAddressCreator() {
        return this.creator;
    }

    @Override
    public AddressNetwork.PrefixConfiguration getPrefixConfiguration() {
        return defaultPrefixConfiguration;
    }

    public static void setDefaultPrefixConfiguration(AddressNetwork.PrefixConfiguration config) {
        defaultPrefixConfiguration = config;
    }

    public static AddressNetwork.PrefixConfiguration getDefaultPrefixConfiguration() {
        return defaultPrefixConfiguration;
    }

    public class MACAddressCreator
    extends AddressCreator<MACAddress, MACAddressSection, MACAddressSection, MACAddressSegment>
    implements AddressNetwork.AddressSegmentCreator<MACAddressSegment> {
        private static final long serialVersionUID = 4L;
        private transient MACAddressSegment ALL_RANGE_SEGMENT;
        private transient MACAddressSegment[] segmentCache;

        @Override
        public void clearCaches() {
            this.segmentCache = null;
        }

        public MACAddressNetwork getNetwork() {
            return MACAddressNetwork.this;
        }

        public MACAddressSegment[] createSegmentArray(int length) {
            if (length == 0) {
                return EMPTY_SEGMENTS;
            }
            return new MACAddressSegment[length];
        }

        @Override
        public MACAddressSegment createSegment(int value) {
            if (value >= 0 && value <= 255) {
                MACAddressSegment result;
                MACAddressSegment[] cache = this.segmentCache;
                if (cache == null) {
                    this.segmentCache = cache = new MACAddressSegment[256];
                    cache[value] = result = new MACAddressSegment(value);
                } else {
                    result = cache[value];
                    if (result == null) {
                        cache[value] = result = new MACAddressSegment(value);
                    }
                }
                return result;
            }
            return new MACAddressSegment(value);
        }

        @Override
        public MACAddressSegment createSegment(int value, Integer segmentPrefixLength) {
            if (segmentPrefixLength != null && this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                if (segmentPrefixLength == 0) {
                    MACAddressSegment result = this.ALL_RANGE_SEGMENT;
                    if (result == null) {
                        this.ALL_RANGE_SEGMENT = result = new MACAddressSegment(0, 255);
                    }
                    return result;
                }
                int mask = -1 << 8 - segmentPrefixLength;
                int newLower = value & mask;
                int newUpper = value | ~mask;
                return this.createRangeSegment(newLower, newUpper);
            }
            return this.createSegment(value);
        }

        public MACAddressSegment createRangeSegment(int lower, int upper) {
            if (lower != upper) {
                if (lower == 0 && upper == 255) {
                    MACAddressSegment result = this.ALL_RANGE_SEGMENT;
                    if (result == null) {
                        this.ALL_RANGE_SEGMENT = result = new MACAddressSegment(0, upper);
                    }
                    return result;
                }
                return new MACAddressSegment(lower, upper);
            }
            return this.createSegment(lower);
        }

        @Override
        public MACAddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            if (segmentPrefixLength == null) {
                return this.createRangeSegment(lower, upper);
            }
            if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                if (segmentPrefixLength == 0) {
                    MACAddressSegment result = this.ALL_RANGE_SEGMENT;
                    if (result == null) {
                        this.ALL_RANGE_SEGMENT = result = new MACAddressSegment(0, 255);
                    }
                    return result;
                }
                int max = 255;
                int mask = -1 << 8 - segmentPrefixLength & max;
                int newLower = lower & mask;
                int newUpper = upper | ~mask & max;
                return this.createRangeSegment(newLower, newUpper);
            }
            return this.createRangeSegment(lower, upper);
        }

        @Override
        protected MACAddressSegment createSegmentInternal(int value, Integer segmentPrefixLength, CharSequence addressStr, int originalVal, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex) {
            MACAddressSegment segment = this.createSegment(value, segmentPrefixLength);
            segment.setString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            return segment;
        }

        @Override
        protected MACAddressSegment createSegmentInternal(int lower, int upper, Integer segmentPrefixLength, CharSequence addressStr, int originalLower, int originalUpper, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex) {
            MACAddressSegment segment = this.createSegment(lower, upper, segmentPrefixLength);
            segment.setString(addressStr, isStandardRangeString, lowerStringStartIndex, upperStringEndIndex, originalLower, originalUpper);
            return segment;
        }

        MACAddressSection createSection(long bytes, int startIndex, boolean extended, Integer prefixLength) {
            MACAddressSection result = new MACAddressSection(bytes, startIndex, extended);
            if (prefixLength != null) {
                result = result.applyPrefixLength(prefixLength);
            }
            return result;
        }

        MACAddressSection createSection(byte[] bytes, int startIndex, boolean extended, Integer prefixLength) {
            MACAddressSection result = new MACAddressSection(bytes, startIndex, extended);
            if (prefixLength != null) {
                result = result.applyPrefixLength(prefixLength);
            }
            return result;
        }

        MACAddressSection createSection(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int startIndex, boolean extended, Integer prefixLength) {
            MACAddressSection result = new MACAddressSection(lowerValueProvider, upperValueProvider, startIndex, extended);
            if (prefixLength != null) {
                result = result.applyPrefixLength(prefixLength);
            }
            return result;
        }

        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments) {
            return new MACAddressSection(false, segments, 0, segments.length > 6);
        }

        protected MACAddressSection createPrefixedSectionInternal(MACAddressSegment[] segments, Integer prefixLength, boolean singleOnly) {
            return this.createPrefixedSectionInternal(segments, prefixLength);
        }

        protected MACAddressSection createPrefixedSectionInternal(MACAddressSegment[] segments, Integer prefixLength) {
            MACAddressSection result = new MACAddressSection(false, segments, 0, segments.length > 6);
            if (prefixLength != null) {
                result = result.applyPrefixLength(prefixLength);
            }
            return result;
        }

        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments, boolean extended) {
            return new MACAddressSection(false, segments, 0, extended);
        }

        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments, int startIndex, boolean extended) {
            return new MACAddressSection(false, segments, startIndex, extended);
        }

        MACAddressSection createSection(MACAddressSegment[] segments, boolean extended, Integer prefixLength) {
            MACAddressSection result = new MACAddressSection(segments, 0, extended);
            if (prefixLength != null) {
                result = result.applyPrefixLength(prefixLength);
            }
            return result;
        }

        @Override
        protected MACAddress createAddressInternal(byte[] bytes, CharSequence zone) {
            MACAddressSection section = new MACAddressSection(bytes, 0, bytes.length > 6, false);
            return this.createAddress(section);
        }

        protected MACAddress createAddressInternal(MACAddressSegment[] segments) {
            return this.createAddress(this.createSectionInternal(segments));
        }

        protected MACAddress createAddressInternal(MACAddressSegment[] segments, Integer prefix) {
            return this.createAddress(this.createPrefixedSectionInternal(segments, prefix));
        }

        protected MACAddress createAddressInternal(MACAddressSegment[] segments, Integer prefix, boolean singleOnly) {
            return this.createAddressInternal(segments, prefix);
        }

        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, HostIdentifierString from) {
            MACAddress result = this.createAddress(section);
            result.cache(from);
            return result;
        }

        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, CharSequence zone, HostIdentifierString from) {
            MACAddress result = this.createAddress(section);
            result.cache(from);
            return result;
        }

        @Override
        public MACAddress createAddress(MACAddressSection section) {
            return new MACAddress(section);
        }
    }
}

