/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import java.net.Inet4Address;
import java.util.Iterator;

public class IPv4Address
extends IPAddress
implements Iterable<IPv4Address> {
    private static final long serialVersionUID = 3L;
    public static final char SEGMENT_SEPARATOR = '.';
    public static final int BITS_PER_SEGMENT = 8;
    public static final int BYTES_PER_SEGMENT = 1;
    public static final int SEGMENT_COUNT = 4;
    public static final int BYTE_COUNT = 4;
    public static final int BIT_COUNT = 32;
    public static final int DEFAULT_TEXTUAL_RADIX = 10;
    public static final int MAX_VALUE_PER_SEGMENT = 255;
    public static final String REVERSE_DNS_SUFFIX = ".in-addr.arpa";
    protected static IPv4AddressNetwork network = new IPv4AddressNetwork();
    transient IPv4AddressSection.AddressCache sectionCache;

    public IPv4Address(IPv4AddressSegment[] segments, Integer networkPrefixLength) {
        this(IPv4Address.network().getAddressCreator().createSection(segments, networkPrefixLength));
    }

    public IPv4Address(IPv4AddressSegment[] segments) {
        this(IPv4Address.network().getAddressCreator().createSection(segments));
    }

    public IPv4Address(IPv4AddressSection section) {
        super(section);
        if (section.getSegmentCount() != 4) {
            throw new IllegalArgumentException(String.valueOf(IPv4Address.getMessage("ipaddress.error.ipv4.invalid.segment.count")) + ' ' + section.getSegmentCount());
        }
    }

    public IPv4Address(int address) {
        this(address, null);
    }

    public IPv4Address(int address, Integer networkPrefixLength) {
        super(IPv4Address.getAddressCreator().createSectionInternal(address, networkPrefixLength));
    }

    public IPv4Address(byte[] bytes) {
        this(bytes, null);
    }

    public IPv4Address(byte[] bytes, Integer networkPrefixLength) {
        super(IPv4Address.getAddressCreator().createSection(bytes, networkPrefixLength));
        if (bytes.length != 4) {
            throw new IllegalArgumentException(String.valueOf(IPv4Address.getMessage("ipaddress.error.ipv4.invalid.byte.count")) + ' ' + bytes.length);
        }
    }

    public IPv4Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer networkPrefixLength) {
        super(IPv4Address.getAddressCreator().createSection(lowerValueProvider, upperValueProvider, networkPrefixLength));
    }

    public IPv4Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider) {
        this(lowerValueProvider, upperValueProvider, null);
    }

    @Override
    public IPv4AddressSection getSection() {
        return (IPv4AddressSection)super.getSection();
    }

    @Override
    public IPv4AddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public IPv4AddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    @Override
    public IPv4AddressSegment getSegment(int index) {
        return this.getSection().getSegment(index);
    }

    public IPv4AddressSegment[] getSegments() {
        return this.getSection().getSegments();
    }

    @Override
    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv4AddressSection.IPv4StringBuilderOptions.from(options));
    }

    public IPAddressStringDivisionSeries[] getParts(IPv4AddressSection.IPv4StringBuilderOptions options) {
        IPAddressStringDivisionSeries[] parts = this.getSection().getParts(options);
        IPv6Address ipv6Addr = this.getConverted(options);
        if (ipv6Addr != null) {
            IPAddressStringDivisionSeries[] ipv6Parts = ipv6Addr.getParts(options.ipv6ConverterOptions);
            IPAddressStringDivisionSeries[] tmp = parts;
            parts = new IPAddressStringDivisionSeries[tmp.length + ipv6Parts.length];
            System.arraycopy(tmp, 0, parts, 0, tmp.length);
            System.arraycopy(ipv6Parts, 0, parts, tmp.length, ipv6Parts.length);
        }
        return parts;
    }

    @Override
    public int getSegmentCount() {
        return 4;
    }

    @Override
    public int getByteCount() {
        return 4;
    }

    @Override
    public int getBitCount() {
        return 32;
    }

    @Override
    public IPv4Address toIPv4() {
        return this;
    }

    @Override
    public boolean isIPv4Convertible() {
        return true;
    }

    public IPv6Address getIPv4MappedAddress() {
        return IPv6Address.toIPv4Mapped(this);
    }

    @Override
    public boolean isIPv6Convertible() {
        IPAddressConverter conv = addressConverter;
        return conv != null && conv.isIPv6Convertible(this);
    }

    @Override
    public IPv6Address toIPv6() {
        IPAddressConverter conv = addressConverter;
        if (conv != null) {
            return conv.toIPv6(this);
        }
        return null;
    }

    private IPv4Address getLowestOrHighest(boolean lowest) {
        return this.getSection().getLowestOrHighest(this, lowest);
    }

    @Override
    public IPv4Address getLower() {
        return this.getLowestOrHighest(true);
    }

    @Override
    public IPv4Address getUpper() {
        return this.getLowestOrHighest(false);
    }

    @Override
    public IPv4Address reverseBits(boolean perByte) {
        return this.checkIdentity(this.getSection().reverseBits(perByte));
    }

    @Override
    public IPv4Address reverseBytes() {
        return this.checkIdentity(this.getSection().reverseBytes());
    }

    @Override
    public IPv4Address reverseBytesPerSegment() {
        return this;
    }

    @Override
    public IPv4Address reverseSegments() {
        return this.checkIdentity(this.getSection().reverseSegments());
    }

    private IPv4Address checkIdentity(IPv4AddressSection newSection) {
        IPv4AddressSection section = this.getSection();
        if (newSection == section) {
            return this;
        }
        return IPv4Address.getAddressCreator().createAddress(newSection);
    }

    @Override
    public IPv4Address adjustPrefixBySegment(boolean nextSegment) {
        return this.checkIdentity(this.getSection().adjustPrefixBySegment(nextSegment));
    }

    @Override
    public IPv4Address adjustPrefixLength(int adjustment) {
        return this.checkIdentity(this.getSection().adjustPrefixLength(adjustment));
    }

    @Override
    public IPv4Address setPrefixLength(int prefixLength) {
        return this.setPrefixLength(prefixLength, true);
    }

    @Override
    public IPv4Address setPrefixLength(int prefixLength, boolean zeroed) {
        return this.checkIdentity(this.getSection().setPrefixLength(prefixLength, zeroed));
    }

    @Override
    public Iterator<IPv4Address> iterator() {
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.getAddressCreator();
        return this.getSection().iterator(this, creator);
    }

    public Iterable<IPv4Address> getIterable() {
        return this;
    }

    public static IPv4AddressNetwork network() {
        return network;
    }

    private static IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return IPv4Address.network().getAddressCreator();
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return IPv4Address.network();
    }

    public static IPv4Address getLoopback() {
        return (IPv4Address)IPv4Address.network().getLoopback();
    }

    public static String[] getStandardLoopbackStrings() {
        return IPv4Address.network().getStandardLoopbackStrings();
    }

    private IPv4Address convertArg(IPAddress arg) {
        IPv4Address converted = arg.toIPv4();
        if (converted == null) {
            throw new AddressTypeException(this, "ipaddress.error.prefix.mask.mismatch");
        }
        return converted;
    }

    public IPv4Address[] subtract(IPAddress other) {
        IPv4AddressSection thisSection = this.getSection();
        IPv4AddressSection[] sections = thisSection.subtract(this.convertArg(other).getSection());
        if (sections == null) {
            return null;
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.getAddressCreator();
        IPv4Address[] result = new IPv4Address[sections.length];
        int i = 0;
        while (i < result.length) {
            result[i] = creator.createAddress(sections[i]);
            ++i;
        }
        return result;
    }

    @Override
    public IPv4Address applyPrefixLength(int networkPrefixLength) throws AddressTypeException {
        return this.checkIdentity(this.getSection().applyPrefixLength(networkPrefixLength));
    }

    @Override
    protected IPAddress removePrefixLength(boolean zeroed, boolean onlyPrefixZeroed) {
        return this.checkIdentity(this.getSection().removePrefixLength(zeroed, onlyPrefixZeroed));
    }

    @Override
    public IPv4Address removePrefixLength(boolean zeroed) {
        return this.checkIdentity(this.getSection().removePrefixLength(zeroed));
    }

    @Override
    public IPv4Address removePrefixLength() {
        return this.removePrefixLength(true);
    }

    @Override
    public IPv4Address mask(IPAddress mask) throws AddressTypeException {
        return this.checkIdentity(this.getSection().mask(this.convertArg(mask).getSection()));
    }

    @Override
    public IPv4Address maskNetwork(IPAddress mask, int networkPrefixLength) throws AddressTypeException {
        return this.checkIdentity(this.getSection().maskNetwork(this.convertArg(mask).getSection(), networkPrefixLength));
    }

    @Override
    public IPv4Address bitwiseOr(IPAddress mask) throws AddressTypeException {
        return this.checkIdentity(this.getSection().bitwiseOr(this.convertArg(mask).getSection()));
    }

    @Override
    public IPv4Address bitwiseOrNetwork(IPAddress mask, int networkPrefixLength) throws AddressTypeException {
        return this.checkIdentity(this.getSection().bitwiseOrNetwork(this.convertArg(mask).getSection(), networkPrefixLength));
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength) {
        return this.getSection().getNetworkSection(networkPrefixLength);
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        return this.getSection().getNetworkSection(networkPrefixLength, withPrefixLength);
    }

    @Override
    public IPv4AddressSection getNetworkSection() {
        if (this.isPrefixed()) {
            return this.getNetworkSection(this.getNetworkPrefixLength(), true);
        }
        return this.getNetworkSection(this.getBitCount(), true);
    }

    @Override
    public IPv4AddressSection getHostSection(int networkPrefixLength) {
        return this.getSection().getHostSection(networkPrefixLength);
    }

    @Override
    public IPv4AddressSection getHostSection() {
        if (this.isPrefixed()) {
            return this.getHostSection(this.getNetworkPrefixLength());
        }
        return this.getHostSection(0);
    }

    @Override
    public Inet4Address toInetAddress() {
        return (Inet4Address)super.toInetAddress();
    }

    @Override
    public boolean isLinkLocal() {
        return this.getSegment(0).matches(169) && this.getSegment(1).matches(254);
    }

    @Override
    public boolean isSiteLocal() {
        IPv4AddressSegment seg0 = this.getSegment(0);
        IPv4AddressSegment seg1 = this.getSegment(1);
        return seg0.matches(10) || seg0.matches(172) && seg1.matchesWithPrefix(16, (Integer)4) || seg0.matches(192) && seg1.matches(168);
    }

    @Override
    public boolean isMulticast() {
        return this.getSegment(0).matchesWithPrefix(255, (Integer)4);
    }

    @Override
    public boolean isLoopback() {
        return this.getSegment(0).matches(127);
    }

    public String toInetAtonString(inet_aton_radix radix) {
        return this.getSection().toInetAtonString(radix);
    }

    public String toInetAtonString(inet_aton_radix radix, int joinedCount) {
        return this.getSection().toInetAtonString(radix, joinedCount);
    }

    @Override
    public String toUNCHostName() {
        return super.toCanonicalString();
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions.from(opts));
    }

    private IPv6Address getConverted(IPv4AddressSection.IPv4StringBuilderOptions opts) {
        if (opts.includes(65536)) {
            IPv6Address.IPv6AddressConverter converter = opts.converter;
            return converter.toIPv6(this);
        }
        return null;
    }

    public IPAddressPartStringCollection toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions opts) {
        IPv4AddressSection.IPv4StringCollection coll = new IPv4AddressSection.IPv4StringCollection();
        IPAddressPartStringCollection sectionColl = this.getSection().toStringCollection(opts);
        coll.addAll(sectionColl);
        IPv6Address ipv6Addr = this.getConverted(opts);
        if (ipv6Addr != null) {
            IPAddressPartStringCollection ipv6StringCollection = ipv6Addr.toStringCollection(opts.ipv6ConverterOptions);
            coll.addAll(ipv6StringCollection);
        }
        return coll;
    }

    public Iterator<IPv4AddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    public static interface IPv4AddressConverter {
        public IPv4Address toIPv4(IPAddress var1);
    }

    public static enum inet_aton_radix {
        OCTAL,
        HEX,
        DECIMAL;


        int getRadix() {
            if (this == OCTAL) {
                return 8;
            }
            if (this == HEX) {
                return 16;
            }
            return 10;
        }

        String getSegmentStrPrefix() {
            if (this == OCTAL) {
                return "0";
            }
            if (this == HEX) {
                return "0x";
            }
            return null;
        }
    }
}

