/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.IPAddressDivision;

public class AddressTypeException
extends RuntimeException {
    private static final long serialVersionUID = 3L;
    private static String errorMessage = AddressTypeException.getMessage("ipaddress.address.error");

    static String getMessage(String key) {
        return AddressStringException.getMessage(key);
    }

    public AddressTypeException(Address one, String key) {
        super(one + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(AddressSection one, String key) {
        super(one + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(CharSequence one, String key) {
        super(one + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(long lower, long upper, String key) {
        super(String.valueOf(lower) + "-" + upper + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(IPAddressSection one, int prefixLength, String key) {
        super(one + " /" + prefixLength + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(IPAddressDivision one, int prefixLength, String key) {
        super(one + " /" + prefixLength + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(AddressDivisionBase one, String key) {
        super(one + " , " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(int prefixLength, IPAddress.IPVersion version, String key) {
        super((Object)((Object)version) + " /" + prefixLength + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(int prefixLength, String key) {
        super(String.valueOf(prefixLength) + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(CharSequence prefixLength, IPAddress.IPVersion version, String key, Throwable cause) {
        super((Object)((Object)version) + " /" + prefixLength + ", " + errorMessage + " " + AddressTypeException.getMessage(key), cause);
    }

    public AddressTypeException(AddressDivisionBase one, int oneIndex, AddressDivisionBase two, int twoIndex, String key) {
        super(String.valueOf(oneIndex + 1) + ":" + one + ", " + (twoIndex + 1) + ":" + two + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(AddressSegment one, AddressSegment two, String key) {
        super(one + ", " + two + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }

    public AddressTypeException(AddressSection one, AddressSection two, String key) {
        super(one + ", " + two + ", " + errorMessage + " " + AddressTypeException.getMessage(key));
    }
}

