/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.format.validate.ParsedAddress;
import java.io.Serializable;

class ParsedAddressQualifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Integer networkPrefixLength;
    private final ParsedAddress mask;
    private final String zone;

    ParsedAddressQualifier() {
        this(null, null, null);
    }

    ParsedAddressQualifier(Integer networkPrefixLength) {
        this(networkPrefixLength, null, null);
    }

    ParsedAddressQualifier(ParsedAddress mask) {
        this(null, mask, null);
    }

    ParsedAddressQualifier(String zone) {
        this(null, null, zone);
    }

    private ParsedAddressQualifier(Integer networkPrefixLength, ParsedAddress mask, String zone) {
        this.networkPrefixLength = networkPrefixLength;
        this.mask = mask;
        this.zone = zone;
    }

    IPAddress getMask() {
        if (this.mask != null) {
            return this.mask.createAddresses().getAddress();
        }
        return null;
    }

    String getZone() {
        return this.zone;
    }

    Integer getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    IPAddress.IPVersion inferVersion(IPAddressStringParameters validationOptions) {
        if (this.networkPrefixLength != null) {
            if (this.networkPrefixLength > IPAddress.bitCount(IPAddress.IPVersion.IPV4) && !validationOptions.getIPv4Parameters().allowPrefixesBeyondAddressSize) {
                return IPAddress.IPVersion.IPV6;
            }
        } else if (this.mask != null) {
            if (this.mask.isIPv6()) {
                return IPAddress.IPVersion.IPV6;
            }
            if (this.mask.isIPv4()) {
                return IPAddress.IPVersion.IPV4;
            }
        } else if (this.zone != null) {
            return IPAddress.IPVersion.IPV6;
        }
        return null;
    }
}

