/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import java.util.Objects;

public class IPv6AddressStringParameters
extends IPAddressStringParameters.IPVersionAddressStringParameters
implements Comparable<IPv6AddressStringParameters> {
    private static final long serialVersionUID = 1L;
    public static final boolean DEFAULT_ALLOW_MIXED = true;
    public static final boolean DEFAULT_ALLOW_ZONE = true;
    public final boolean allowMixed;
    public final boolean allowZone;
    private IPAddressStringParameters embeddedIPv4Options;

    public Builder toBuilder(boolean isMixed) {
        Builder builder = new Builder();
        builder.allowMixed = this.allowMixed;
        builder.allowZone = this.allowZone;
        if (!isMixed) {
            builder.embeddedIPv4OptionsBuilder = this.embeddedIPv4Options.toBuilder(true);
        }
        return (Builder)this.toBuilder(builder);
    }

    public IPv6AddressStringParameters(boolean allowLeadingZeros, boolean allowCIDRPrefixLeadingZeros, boolean allowUnlmitedLeadingZeros, boolean allowMixed, IPAddressStringParameters mixedOptions, boolean allowZone, IPAddressStringParameters.RangeParameters rangeOptions, boolean allowWildcardedSeparator, boolean allowPrefixesBeyondAddressSize) {
        super(allowLeadingZeros, allowCIDRPrefixLeadingZeros, allowUnlmitedLeadingZeros, rangeOptions, allowWildcardedSeparator, allowPrefixesBeyondAddressSize);
        this.allowMixed = allowMixed;
        this.allowZone = allowZone;
        this.embeddedIPv4Options = mixedOptions;
    }

    public IPv6AddressStringParameters clone() {
        try {
            IPv6AddressStringParameters result = (IPv6AddressStringParameters)super.clone();
            result.embeddedIPv4Options = this.embeddedIPv4Options.clone();
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public IPAddressStringParameters getMixedParameters() {
        return this.embeddedIPv4Options;
    }

    @Override
    public int compareTo(IPv6AddressStringParameters o) {
        int result = super.compareTo(o);
        if (result == 0 && (result = this.embeddedIPv4Options.getIPv4Parameters().compareTo(o.embeddedIPv4Options.getIPv4Parameters())) == 0 && (result = Boolean.compare(this.allowMixed, o.allowMixed)) == 0) {
            result = Boolean.compare(this.allowZone, o.allowZone);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IPv6AddressStringParameters && super.equals(o)) {
            IPv6AddressStringParameters other = (IPv6AddressStringParameters)o;
            return Objects.equals(this.embeddedIPv4Options.getIPv4Parameters(), other.embeddedIPv4Options.getIPv4Parameters()) && this.allowMixed == other.allowMixed && this.allowZone == other.allowZone;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash |= this.embeddedIPv4Options.getIPv4Parameters().hashCode() << 6;
        if (this.allowMixed) {
            hash |= 0x8000;
        }
        if (this.allowZone) {
            hash |= 0x10000;
        }
        return hash;
    }

    public static class Builder
    extends IPAddressStringParameters.IPVersionAddressStringParameters.BuilderBase {
        private boolean allowMixed = true;
        private boolean allowZone = true;
        private IPAddressStringParameters.Builder embeddedIPv4OptionsBuilder;
        private static IPAddressStringParameters DEFAULT_MIXED_OPTS = new IPAddressStringParameters.Builder().allowEmpty(false).allowPrefix(false).allowMask(false).allowPrefixOnly(false).allowAll(false).getIPv6AddressParametersBuilder().allowMixed(false).getParentBuilder().toParams();

        public Builder allowZone(boolean allow) {
            this.getEmbeddedIPv4ParametersBuilder().getIPv6AddressParametersBuilder().allowZone = allow;
            this.allowZone = allow;
            return this;
        }

        public Builder allow_mixed_inet_aton(boolean allow) {
            if (allow) {
                this.allowMixed(allow);
            }
            this.getEmbeddedIPv4ParametersBuilder().getIPv4AddressParametersBuilder().allow_inet_aton(allow);
            return this;
        }

        public Builder allowMixed(boolean allow) {
            this.allowMixed = allow;
            return this;
        }

        public IPv4AddressStringParameters.Builder getEmbeddedIPv4AddressParametersBuilder() {
            return this.getEmbeddedIPv4ParametersBuilder().getIPv4AddressParametersBuilder();
        }

        IPAddressStringParameters.Builder getEmbeddedIPv4ParametersBuilder() {
            if (this.embeddedIPv4OptionsBuilder == null) {
                this.embeddedIPv4OptionsBuilder = new IPAddressStringParameters.Builder().allowEmpty(false).allowPrefix(false).allowMask(false).allowPrefixOnly(false).allowAll(false);
                this.embeddedIPv4OptionsBuilder.getIPv6AddressParametersBuilder().allowZone = this.allowZone;
            }
            Builder.setMixedParent(this.embeddedIPv4OptionsBuilder, this);
            return this.embeddedIPv4OptionsBuilder;
        }

        @Override
        public Builder allowWildcardedSeparator(boolean allow) {
            this.getEmbeddedIPv4AddressParametersBuilder().allowWildcardedSeparator(allow);
            super.allowWildcardedSeparator(allow);
            return this;
        }

        @Override
        public Builder allowLeadingZeros(boolean allow) {
            this.getEmbeddedIPv4AddressParametersBuilder().allowLeadingZeros(allow);
            super.allowLeadingZeros(allow);
            return this;
        }

        @Override
        public Builder allowUnlimitedLeadingZeros(boolean allow) {
            this.getEmbeddedIPv4AddressParametersBuilder().allowUnlimitedLeadingZeros(allow);
            super.allowUnlimitedLeadingZeros(allow);
            return this;
        }

        @Override
        public Builder setRangeOptions(IPAddressStringParameters.RangeParameters rangeOptions) {
            this.getEmbeddedIPv4ParametersBuilder().getIPv4AddressParametersBuilder().setRangeOptions(rangeOptions);
            super.setRangeOptions(rangeOptions);
            return this;
        }

        @Override
        public Builder allowPrefixesBeyondAddressSize(boolean allow) {
            super.allowPrefixesBeyondAddressSize(allow);
            return this;
        }

        @Override
        public Builder allowPrefixLengthLeadingZeros(boolean allow) {
            super.allowPrefixLengthLeadingZeros(allow);
            return this;
        }

        public IPv6AddressStringParameters toParams() {
            IPAddressStringParameters mixedOptions = this.embeddedIPv4OptionsBuilder == null ? DEFAULT_MIXED_OPTS : this.embeddedIPv4OptionsBuilder.toParams();
            return new IPv6AddressStringParameters(this.allowLeadingZeros, this.allowPrefixLengthLeadingZeros, this.allowUnlimitedLeadingZeros, this.allowMixed, mixedOptions, this.allowZone, this.rangeOptions, this.allowWildcardedSeparator, this.allowPrefixesBeyondAddressSize);
        }
    }
}

