/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import java.util.Iterator;

public class IPv4AddressSegment
extends IPAddressSegment {
    private static final long serialVersionUID = 1L;
    public static final int MAX_CHARS = 3;
    static final IPv4AddressSegment ZERO_SEGMENT = IPv4AddressSegment.getSegmentCreator().createSegment(0);
    static final IPv4AddressSegment ZERO_PREFIX_SEGMENT = new IPv4AddressSegment(0, 0);
    static final IPv4AddressSegment ALL_RANGE_SEGMENT = new IPv4AddressSegment(0, 255, null);

    public IPv4AddressSegment(int value) {
        super(value);
    }

    public IPv4AddressSegment(int value, Integer segmentPrefixLength) {
        super(value, segmentPrefixLength == null ? null : Integer.valueOf(Math.min(8, segmentPrefixLength)));
    }

    public IPv4AddressSegment(int lower, int upper, Integer segmentPrefixLength) {
        super(lower, upper, segmentPrefixLength == null ? null : Integer.valueOf(Math.min(8, segmentPrefixLength)));
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    @Override
    protected int getSegmentNetworkMask(int bits) {
        return IPv4Address.network().getSegmentNetworkMask(bits);
    }

    @Override
    protected int getSegmentHostMask(int bits) {
        return IPv4Address.network().getSegmentHostMask(bits);
    }

    @Override
    public int getMaxSegmentValue() {
        return IPv4AddressSegment.getMaxSegmentValue(IPAddress.IPVersion.IPV4);
    }

    @Override
    public IPv4AddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        return this.toNetworkSegment(segmentPrefixLength, true);
    }

    @Override
    public IPv4AddressSegment toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength) {
        if (this.isNetworkChangedByPrefix(segmentPrefixLength, withPrefixLength)) {
            return super.toNetworkSegment(segmentPrefixLength, withPrefixLength, IPv4AddressSegment.getSegmentCreator());
        }
        return this;
    }

    @Override
    public IPv4AddressSegment toHostSegment(Integer bits) {
        if (this.isHostChangedByPrefix(bits)) {
            return super.toHostSegment(bits, IPv4AddressSegment.getSegmentCreator());
        }
        return this;
    }

    @Override
    public IPv4AddressSegment toMaskedSegment(IPAddressSegment maskSegment, Integer segmentPrefixLength) throws IPAddressTypeException {
        if (this.isChangedByMask(maskSegment, segmentPrefixLength)) {
            if (!this.isMaskCompatibleWithRange(maskSegment, segmentPrefixLength)) {
                throw new IPAddressTypeException(this, maskSegment, "ipaddress.error.maskMismatch");
            }
            return IPv4AddressSegment.getSegmentCreator().createSegment(this.getLowerSegmentValue() & maskSegment.getLowerSegmentValue(), this.getUpperSegmentValue() & maskSegment.getLowerSegmentValue(), segmentPrefixLength);
        }
        return this;
    }

    protected boolean isChangedByMask(IPAddressSegment maskSegment, Integer segmentPrefixLength) throws IPAddressTypeException {
        if (!(maskSegment instanceof IPv4AddressSegment)) {
            throw new IPAddressTypeException(this, maskSegment, "ipaddress.error.typeMismatch");
        }
        return super.isChangedByMask(maskSegment.getLowerSegmentValue(), segmentPrefixLength);
    }

    @Override
    public IPv4AddressSegment getLower() {
        return IPv4AddressSegment.getLowestOrHighest(this, IPv4AddressSegment.getSegmentCreator(), true);
    }

    @Override
    public IPv4AddressSegment getUpper() {
        return IPv4AddressSegment.getLowestOrHighest(this, IPv4AddressSegment.getSegmentCreator(), false);
    }

    public static IPv4AddressNetwork.IPv4AddressCreator getSegmentCreator() {
        return IPv4Address.network().getAddressCreator();
    }

    public Iterator<IPv4AddressSegment> iterator() {
        return IPv4AddressSegment.iterator(this, IPv4AddressSegment.getSegmentCreator());
    }

    static IPv4AddressSegment getZeroSegment() {
        return ZERO_SEGMENT;
    }

    @Override
    protected int getLeadingZerosAdjustment() {
        return 56;
    }

    @Override
    public int getBitCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 10;
    }

    @Override
    public int getDefaultMaxChars() {
        return 3;
    }

    @Override
    public boolean contains(IPAddressSegment other) {
        return other.isIPv4() && super.contains(other);
    }

    public boolean equals(Object other) {
        return other instanceof IPv4AddressSegment && this.isSameValues((IPv4AddressSegment)other);
    }
}

