/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.HostNameParameters;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import inet.ipaddr.ipv6.IPv6AddressStringParameters;
import java.io.Serializable;

public class IPAddressStringParameters
implements Cloneable,
Comparable<IPAddressStringParameters>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean DEFAULT_ALLOW_LEADING_ZEROS = true;
    public static final boolean DEFAULT_ALLOW_PREFIX_LENGTH_LEADING_ZEROS = true;
    public static final boolean DEFAULT_ALLOW_UNLIMITED_LEADING_ZEROS = true;
    public static final boolean DEFAULT_ALLOW_EMPTY = true;
    public static final boolean DEFAULT_EMPTY_IS_LOOPBACK = true;
    public static final boolean DEFAULT_ALLOW_PREFIX = true;
    public static final boolean DEFAULT_ALLOW_MASK = true;
    public static final boolean DEFAULT_ALLOW_PREFIX_ONLY = true;
    public static final boolean DEFAULT_ALLOW_ALL = true;
    public static final boolean DEFAULT_ALLOW_WILDCARDED_SEPARATOR = true;
    public static final boolean DEFAULT_ALLOW_PREFIX_BEYOND_ADDRESS_SIZE = false;
    public static final RangeParameters DEFAULT_RANGE_OPTIONS = RangeParameters.WILDCARD_AND_RANGE;
    public final boolean allowEmpty;
    public final boolean allowPrefixOnly;
    public final boolean allowAll;
    public final boolean emptyIsLoopback;
    public final boolean allowPrefix;
    public final boolean allowMask;
    private IPv6AddressStringParameters ipv6Options;
    private IPv4AddressStringParameters ipv4Options;

    public Builder toBuilder() {
        return this.toBuilder(false);
    }

    public Builder toBuilder(boolean isMixed) {
        Builder builder = new Builder();
        builder.allowAll = this.allowAll;
        builder.allowPrefixOnly = this.allowPrefixOnly;
        builder.allowEmpty = this.allowEmpty;
        builder.emptyIsLoopback = this.emptyIsLoopback;
        builder.allowPrefix = this.allowPrefix;
        builder.allowMask = this.allowMask;
        builder.ipv4Builder = this.ipv4Options.toBuilder();
        builder.ipv6Builder = this.ipv6Options.toBuilder(isMixed);
        return builder;
    }

    public IPAddressStringParameters(boolean allowEmpty, boolean allowAll, boolean emptyIsLoopback, boolean allowPrefix, boolean allowMask, boolean allowPrefixOnly, IPv4AddressStringParameters ipv4Options, IPv6AddressStringParameters ipv6Options) {
        this.allowEmpty = allowEmpty;
        this.allowAll = allowAll;
        this.allowPrefixOnly = allowPrefixOnly;
        this.emptyIsLoopback = emptyIsLoopback;
        this.allowPrefix = allowPrefix;
        this.allowMask = allowMask;
        this.ipv6Options = ipv6Options;
        this.ipv4Options = ipv4Options;
    }

    public IPv6AddressStringParameters getIPv6Parameters() {
        return this.ipv6Options;
    }

    public IPv4AddressStringParameters getIPv4Parameters() {
        return this.ipv4Options;
    }

    public IPAddressStringParameters clone() {
        try {
            IPAddressStringParameters result = (IPAddressStringParameters)super.clone();
            result.ipv4Options = this.ipv4Options.clone();
            result.ipv6Options = this.ipv6Options.clone();
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int compareTo(IPAddressStringParameters o) {
        int result = this.ipv4Options.compareTo(o.ipv4Options);
        if (result == 0 && (result = this.ipv6Options.compareTo(o.ipv6Options)) == 0 && (result = Boolean.compare(this.allowEmpty, o.allowEmpty)) == 0 && (result = Boolean.compare(this.emptyIsLoopback, o.emptyIsLoopback)) == 0 && (result = Boolean.compare(this.allowPrefix, o.allowPrefix)) == 0) {
            result = Boolean.compare(this.allowMask, o.allowMask);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof IPAddressStringParameters) {
            IPAddressStringParameters other = (IPAddressStringParameters)o;
            return this.ipv4Options.equals(other.ipv4Options) && this.ipv6Options.equals(other.ipv6Options) && this.allowEmpty == other.allowEmpty && this.emptyIsLoopback == other.emptyIsLoopback && this.allowPrefix == other.allowPrefix && this.allowMask == other.allowMask;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.ipv4Options.hashCode();
        hash |= this.ipv6Options.hashCode() << 9;
        if (this.allowEmpty) {
            hash |= 0x4000000;
        }
        if (this.emptyIsLoopback) {
            hash |= 0x8000000;
        }
        if (this.allowPrefix) {
            hash |= 0x10000000;
        }
        if (this.allowMask) {
            hash |= 0x20000000;
        }
        return hash;
    }

    public static class Builder {
        private boolean allowEmpty = true;
        private boolean emptyIsLoopback = true;
        private boolean allowPrefix = true;
        private boolean allowMask = true;
        private boolean allowPrefixOnly = true;
        private boolean allowAll = true;
        IPv4AddressStringParameters.Builder ipv4Builder;
        private static IPv4AddressStringParameters DEFAULT_IPV4_OPTS = new IPv4AddressStringParameters.Builder().toParams();
        IPv6AddressStringParameters.Builder ipv6Builder;
        private static IPv6AddressStringParameters DEFAULT_IPV6_OPTS = new IPv6AddressStringParameters.Builder().toParams();
        HostNameParameters.Builder parent;
        IPv6AddressStringParameters.Builder mixedParent;

        public HostNameParameters.Builder getParentBuilder() {
            return this.parent;
        }

        public Builder allowEmpty(boolean allow) {
            this.allowEmpty = allow;
            return this;
        }

        public Builder setEmptyAsLoopback(boolean bool) {
            this.emptyIsLoopback = bool;
            return this;
        }

        public Builder allowPrefix(boolean allow) {
            this.allowPrefix = allow;
            return this;
        }

        public Builder allowMask(boolean allow) {
            this.allowMask = allow;
            return this;
        }

        public Builder allowPrefixOnly(boolean allow) {
            this.allowPrefixOnly = allow;
            return this;
        }

        public Builder allowAll(boolean allow) {
            this.allowAll = allow;
            return this;
        }

        public Builder setRangeParameters(RangeParameters rangeOptions) {
            this.getIPv4AddressParametersBuilder().setRangeOptions(rangeOptions);
            this.getIPv6AddressParametersBuilder().setRangeOptions(rangeOptions);
            return this;
        }

        public Builder allow_inet_aton(boolean allow) {
            this.getIPv4AddressParametersBuilder().allow_inet_aton(allow);
            this.getIPv6AddressParametersBuilder().allow_mixed_inet_aton(allow);
            return this;
        }

        public IPv6AddressStringParameters.Builder getIPv6AddressParametersBuilder() {
            if (this.ipv6Builder == null) {
                this.ipv6Builder = new IPv6AddressStringParameters.Builder();
            }
            this.ipv6Builder.parent = this;
            return this.ipv6Builder;
        }

        public IPv4AddressStringParameters.Builder getIPv4AddressParametersBuilder() {
            if (this.ipv4Builder == null) {
                this.ipv4Builder = new IPv4AddressStringParameters.Builder();
            }
            this.ipv4Builder.parent = this;
            return this.ipv4Builder;
        }

        public IPAddressStringParameters toParams() {
            IPv4AddressStringParameters ipv4Opts = this.ipv4Builder == null ? DEFAULT_IPV4_OPTS : this.ipv4Builder.toParams();
            IPv6AddressStringParameters ipv6Opts = this.ipv6Builder == null ? DEFAULT_IPV6_OPTS : this.ipv6Builder.toParams();
            return new IPAddressStringParameters(this.allowEmpty, this.allowAll, this.emptyIsLoopback, this.allowPrefix, this.allowMask, this.allowPrefixOnly, ipv4Opts, ipv6Opts);
        }
    }

    public static class IPVersionAddressStringParameters
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final RangeParameters rangeOptions;
        public final boolean allowPrefixesBeyondAddressSize;
        public final boolean allowWildcardedSeparator;
        public final boolean allowLeadingZeros;
        public final boolean allowUnlimitedLeadingZeros;
        public final boolean allowPrefixLengthLeadingZeros;

        public IPVersionAddressStringParameters(boolean allowLeadingZeros, boolean allowPrefixLengthLeadingZeros, boolean allowUnlimitedLeadingZeros, RangeParameters rangeOptions, boolean allowWildcardedSeparator, boolean allowPrefixesBeyondAddressSize) {
            this.rangeOptions = rangeOptions;
            if (rangeOptions == null) {
                throw new NullPointerException();
            }
            this.allowPrefixLengthLeadingZeros = allowPrefixLengthLeadingZeros;
            this.allowWildcardedSeparator = allowWildcardedSeparator;
            this.allowPrefixesBeyondAddressSize = allowPrefixesBeyondAddressSize;
            this.allowLeadingZeros = allowLeadingZeros;
            this.allowUnlimitedLeadingZeros = allowUnlimitedLeadingZeros;
        }

        protected BuilderBase toBuilder(BuilderBase builder) {
            builder.allowPrefixLengthLeadingZeros = this.allowPrefixLengthLeadingZeros;
            builder.allowUnlimitedLeadingZeros = this.allowUnlimitedLeadingZeros;
            builder.rangeOptions = this.rangeOptions;
            builder.allowPrefixesBeyondAddressSize = this.allowPrefixesBeyondAddressSize;
            builder.allowWildcardedSeparator = this.allowWildcardedSeparator;
            builder.allowLeadingZeros = this.allowLeadingZeros;
            return builder;
        }

        protected int compareTo(IPVersionAddressStringParameters o) {
            int result = this.rangeOptions.compareTo(o.rangeOptions);
            if (result == 0 && (result = Boolean.compare(this.allowPrefixesBeyondAddressSize, o.allowPrefixesBeyondAddressSize)) == 0 && (result = Boolean.compare(this.allowWildcardedSeparator, o.allowWildcardedSeparator)) == 0) {
                result = Boolean.compare(this.allowLeadingZeros, o.allowLeadingZeros);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o instanceof IPVersionAddressStringParameters) {
                IPVersionAddressStringParameters other = (IPVersionAddressStringParameters)o;
                return this.rangeOptions.equals(other.rangeOptions) && this.allowPrefixesBeyondAddressSize == other.allowPrefixesBeyondAddressSize && this.allowWildcardedSeparator == other.allowWildcardedSeparator && this.allowLeadingZeros == other.allowLeadingZeros;
            }
            return false;
        }

        public int hashCode() {
            int hash = this.rangeOptions.hashCode();
            if (this.allowPrefixesBeyondAddressSize) {
                hash |= 8;
            }
            if (this.allowWildcardedSeparator) {
                hash |= 0x10;
            }
            if (this.allowLeadingZeros) {
                hash |= 0x20;
            }
            return hash;
        }

        protected static class BuilderBase {
            protected RangeParameters rangeOptions = DEFAULT_RANGE_OPTIONS;
            protected boolean allowPrefixesBeyondAddressSize = false;
            protected boolean allowWildcardedSeparator = true;
            protected boolean allowLeadingZeros = true;
            protected boolean allowPrefixLengthLeadingZeros = true;
            protected boolean allowUnlimitedLeadingZeros = true;
            Builder parent;

            protected BuilderBase() {
            }

            protected static void setMixedParent(Builder builder, IPv6AddressStringParameters.Builder parent) {
                builder.mixedParent = parent;
            }

            public Builder getParentBuilder() {
                return this.parent;
            }

            public BuilderBase setRangeOptions(RangeParameters rangeOptions) {
                this.rangeOptions = rangeOptions;
                return this;
            }

            public BuilderBase allowPrefixesBeyondAddressSize(boolean allow) {
                this.allowPrefixesBeyondAddressSize = allow;
                return this;
            }

            public BuilderBase allowWildcardedSeparator(boolean allow) {
                this.allowWildcardedSeparator = allow;
                return this;
            }

            public BuilderBase allowLeadingZeros(boolean allow) {
                this.allowLeadingZeros = allow;
                if (!allow) {
                    this.allowUnlimitedLeadingZeros = allow;
                }
                return this;
            }

            public BuilderBase allowPrefixLengthLeadingZeros(boolean allow) {
                this.allowPrefixLengthLeadingZeros = allow;
                return this;
            }

            public BuilderBase allowUnlimitedLeadingZeros(boolean allow) {
                this.allowUnlimitedLeadingZeros = allow;
                if (allow) {
                    this.allowLeadingZeros = allow;
                }
                return this;
            }
        }
    }

    public static class RangeParameters
    implements Comparable<RangeParameters>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean wildcard;
        private final boolean range;
        private final boolean singleWildcard;
        public static RangeParameters NO_RANGE = new RangeParameters(false, false, false);
        public static RangeParameters WILDCARD_ONLY = new RangeParameters(true, false, true);
        public static RangeParameters WILDCARD_AND_RANGE = new RangeParameters(true, true, true);

        public RangeParameters(boolean wildcard, boolean range, boolean singleWildcard) {
            this.wildcard = wildcard;
            this.range = range;
            this.singleWildcard = singleWildcard;
        }

        public boolean isNoRange() {
            return !this.wildcard && !this.range && !this.singleWildcard;
        }

        public boolean allowsWildcard() {
            return this.wildcard;
        }

        public boolean allowsRangeSeparator() {
            return this.range;
        }

        public boolean allowsSingleWildcard() {
            return this.singleWildcard;
        }

        public RangeParameters clone() {
            try {
                return (RangeParameters)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public int hashCode() {
            int result = 0;
            if (this.wildcard) {
                result = 1;
            }
            if (this.range) {
                result |= 2;
            }
            if (this.singleWildcard) {
                result |= 4;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof RangeParameters) {
                RangeParameters other = (RangeParameters)o;
                return this.wildcard == other.wildcard && this.range == other.range && this.singleWildcard == other.singleWildcard;
            }
            return false;
        }

        @Override
        public int compareTo(RangeParameters o) {
            int val = Boolean.compare(this.wildcard, o.wildcard);
            if (val == 0 && (val = Boolean.compare(this.range, o.range)) == 0) {
                val = Boolean.compare(this.singleWildcard, o.singleWildcard);
            }
            return val;
        }
    }
}

