/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;

public class IPv6Address
extends IPAddress
implements Iterable<IPv6Address> {
    private static final long serialVersionUID = 1L;
    public static final char SEGMENT_SEPARATOR = ':';
    public static final char ZONE_SEPARATOR = '%';
    public static final char UNC_SEGMENT_SEPARATOR = '-';
    public static final char UNC_ZONE_SEPARATOR = 's';
    public static final char UNC_RANGE_SEPARATOR = '\u203a';
    public static final String UNC_RANGE_SEPARATOR_STR = String.valueOf('\u203a');
    public static final int BITS_PER_SEGMENT = 16;
    public static final int BYTES_PER_SEGMENT = 2;
    public static final int SEGMENT_COUNT = 8;
    public static final int MIXED_REPLACED_SEGMENT_COUNT = 2;
    public static final int MIXED_ORIGINAL_SEGMENT_COUNT = 6;
    public static final int BYTE_COUNT = 16;
    public static final int BIT_COUNT = 128;
    public static final int DEFAULT_TEXTUAL_RADIX = 16;
    public static final int MAX_STRING_LEN = 50;
    public static final int MAX_VALUE_PER_SEGMENT = 65535;
    private static IPv6AddressNetwork network = new IPv6AddressNetwork();
    private final String zone;
    private transient IPv6AddressSection.IPv6StringCache stringCache;

    public IPv6Address(IPv6AddressSegment[] segments) {
        this(network.getAddressCreator().createSection(segments));
    }

    public IPv6Address(IPv6AddressSegment[] segments, Integer networkPrefixLength) {
        this(network.getAddressCreator().createSection(segments, networkPrefixLength));
    }

    public IPv6Address(IPv6AddressSegment[] segments, CharSequence zone) {
        this(network.getAddressCreator().createSection(segments), zone);
    }

    public IPv6Address(IPv6AddressSection section, CharSequence zone) {
        super(section);
        if (section.getSegmentCount() != 8) {
            throw new IllegalArgumentException();
        }
        this.zone = zone == null ? "" : zone.toString();
    }

    public IPv6Address(IPv6AddressSection section) throws IPAddressTypeException {
        super(section);
        if (section.getSegmentCount() != 8) {
            throw new IllegalArgumentException();
        }
        this.zone = "";
    }

    public IPv6Address(byte[] bytes, CharSequence zone) {
        super(network.getAddressCreator().createSection(bytes, null));
        if (bytes.length != 16) {
            throw new IllegalArgumentException();
        }
        this.zone = zone == null ? "" : zone.toString();
    }

    public IPv6Address(byte[] bytes) {
        this(bytes, (Integer)null);
    }

    public IPv6Address(byte[] bytes, Integer networkPrefixLength) {
        super(network.getAddressCreator().createSection(bytes, networkPrefixLength));
        if (bytes.length != 16) {
            throw new IllegalArgumentException();
        }
        this.zone = "";
    }

    public static IPv6AddressNetwork network() {
        return network;
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return network;
    }

    public static IPv6Address getLoopback() {
        return (IPv6Address)network.getLoopback();
    }

    public static String[] getStandardLoopbackStrings() {
        return network.getStandardLoopbackStrings();
    }

    @Override
    public IPv6AddressSection getSection() {
        return (IPv6AddressSection)super.getSection();
    }

    @Override
    public IPv6AddressSegment getSegment(int index) {
        return this.getSection().getSegment(index);
    }

    @Override
    public IPAddressPart[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv6AddressSection.IPv6StringBuilderOptions.from(options));
    }

    public IPAddressPart[] getParts(IPv6AddressSection.IPv6StringBuilderOptions options) {
        IPAddressPart[] parts = this.getSection().getParts(options);
        IPv4Address ipv4Addr = this.getConverted(options);
        if (ipv4Addr != null) {
            IPAddressPart[] ipv4Parts = ipv4Addr.getParts(options.ipv4ConverterOptions);
            IPAddressPart[] tmp = parts;
            parts = new IPAddressPart[tmp.length + ipv4Parts.length];
            System.arraycopy(tmp, 0, parts, 0, tmp.length);
            System.arraycopy(ipv4Parts, 0, parts, tmp.length, ipv4Parts.length);
        }
        return parts;
    }

    private static IPv6AddressSection createSection(IPv6AddressSegment[] nonMixedSection, IPv4Address mixedSection) throws IPAddressTypeException {
        IPv4AddressSection ipv4Section = mixedSection.getSection();
        IPv6AddressNetwork.IPv6AddressCreator creator = network.getAddressCreator();
        IPv6AddressSegment[] newSegs = creator.createSegmentArray(8);
        newSegs[0] = nonMixedSection[0];
        newSegs[1] = nonMixedSection[1];
        newSegs[2] = nonMixedSection[2];
        newSegs[3] = nonMixedSection[3];
        newSegs[4] = nonMixedSection[4];
        newSegs[5] = nonMixedSection[5];
        newSegs[6] = IPv6AddressSegment.join(ipv4Section.getSegment(0), ipv4Section.getSegment(1));
        newSegs[7] = IPv6AddressSegment.join(ipv4Section.getSegment(2), ipv4Section.getSegment(3));
        IPv6AddressSection result = creator.createSectionInternal(newSegs);
        result.embeddedIPv4Section = ipv4Section;
        return result;
    }

    @Override
    public int getSegmentCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 16;
    }

    @Override
    public int getBitCount() {
        return 128;
    }

    private IPv6Address getLowestOrHighest(boolean lowest) {
        return IPv6Address.getSingle(this, () -> {
            IPv6AddressSection section = this.getSection();
            IPv6AddressSegment[] segs = (IPv6AddressSegment[])IPv6Address.createSingle((IPAddressSection)section, (IPAddressTypeNetwork.IPAddressSegmentCreator)network.getAddressCreator(), (int i) -> {
                IPv6AddressSegment seg = this.getSegment(i);
                return lowest ? seg.getLower() : seg.getUpper();
            });
            return network.getAddressCreator().createAddressInternal(segs, this.zone);
        });
    }

    @Override
    public IPv6Address getLower() {
        return this.getLowestOrHighest(true);
    }

    @Override
    public IPv6Address getUpper() {
        return this.getLowestOrHighest(false);
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        return IPv6Address.iterator(this, this.hasZone() ? network.getAddressCreator() : new IPv6AddressNetwork.IPv6AddressCreator(){

            @Override
            protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments) {
                IPv6AddressNetwork.IPv6AddressCreator creator = network.getAddressCreator();
                return creator.createAddressInternal(segments, IPv6Address.this.zone);
            }
        }, () -> this.getSection().getLowerSegments(), index -> this.getSegment(index).iterator());
    }

    public Iterable<IPv6Address> getAddresses() {
        return this;
    }

    public static IPv6Address from(byte[] bytes, byte[] bytes2, Integer prefix, String zone) {
        return (IPv6Address)IPAddress.from(bytes, bytes2, prefix, zone);
    }

    public static IPv6Address from(byte[] bytes, String zone) {
        return IPv6Address.from(bytes, null, null, zone);
    }

    @Override
    public IPv4Address toIPv4() {
        IPAddressConverter conv = addressConverter;
        if (conv != null && conv.isIPv4Convertible(this)) {
            return conv.toIPv4(this);
        }
        return null;
    }

    @Override
    public IPv6Address toIPv6() {
        return this;
    }

    @Override
    public boolean isIPv4Convertible() {
        IPAddressConverter conv = addressConverter;
        return conv != null && conv.isIPv4Convertible(this);
    }

    @Override
    public boolean isIPv6Convertible() {
        return true;
    }

    public static IPv6Address toIPv4Mapped(IPv4Address addr) throws IPAddressTypeException {
        IPv6AddressSegment zero = IPv6AddressSegment.ZERO_SEGMENT;
        IPv6AddressNetwork.IPv6AddressCreator creator = network.getAddressCreator();
        IPv6AddressSegment[] segs = creator.createSegmentArray(6);
        segs[3] = segs[4] = zero;
        segs[2] = segs[4];
        segs[1] = segs[4];
        segs[0] = segs[4];
        segs[5] = IPv6AddressSegment.ALL_SEGMENT;
        return creator.createAddress(IPv6Address.createSection(segs, addr));
    }

    public IPv4AddressSection toMappedIPv4Segments() {
        if (this.isIPv4Mapped()) {
            return this.getSection().getEmbeddedIPv4AddressSection();
        }
        return null;
    }

    public IPv4Address get6to4IPv4Address() {
        return this.getEmbeddedIPv4Address(2);
    }

    public IPv4Address getEmbeddedIPv4Address() {
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        return creator.createAddress(this.getSection().getEmbeddedIPv4AddressSection());
    }

    public IPv4Address getEmbeddedIPv4Address(int byteIndex) {
        if (byteIndex == 12) {
            return this.getEmbeddedIPv4Address();
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        return creator.createAddress(this.getSection().getEmbeddedIPv4AddressSection(byteIndex, byteIndex + 4));
    }

    @Override
    public boolean isLinkLocal() {
        return this.getSegment(0).matchesWithPrefix(65152, (Integer)10);
    }

    @Override
    public boolean isSiteLocal() {
        return this.getSegment(0).matchesWithPrefix(65216, (Integer)10);
    }

    public boolean isUniqueLocal() {
        return this.getSegment(0).matchesWithPrefix(64512, (Integer)7);
    }

    public boolean isIPv4Mapped() {
        if (this.getSegment(5).matches(IPv6AddressSegment.ALL_SEGMENT.getLowerSegmentValue())) {
            int i = 0;
            while (i < 5) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isIPv4Compatible() {
        return this.getSegment(0).isZero() && this.getSegment(1).isZero() && this.getSegment(2).isZero() && this.getSegment(3).isZero() && this.getSegment(4).isZero() && this.getSegment(5).isZero();
    }

    public boolean is6To4() {
        return this.getSegment(0).matches(8194);
    }

    public boolean is6Over4() {
        return this.getSegment(4).isZero() && this.getSegment(5).isZero();
    }

    public boolean isTeredo() {
        return this.getSegment(0).matches(8193) && this.getSegment(1).isZero();
    }

    public boolean isIsatap() {
        return this.getSegment(4).isZero() && this.getSegment(5).matches(24318);
    }

    public boolean isIPv4Translatable() {
        if (this.getSegment(4).matches(65535) && this.getSegment(5).isZero()) {
            int i = 0;
            while (i < 3) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isWellKnownIPv4Translatable() {
        if (this.getSegment(0).matches(100) && this.getSegment(1).matches(65435)) {
            int i = 2;
            while (i <= 5) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMulticast() {
        return this.getSegment(0).matchesWithPrefix(255, (Integer)8);
    }

    @Override
    public boolean isLoopback() {
        int i = 0;
        while (i < this.getSegmentCount() - 1) {
            if (!this.getSegment(i).isZero()) {
                return false;
            }
            ++i;
        }
        return this.getSegment(i).matches(1);
    }

    public IPv6Address[] subtract(IPAddress other) {
        IPv6AddressSection thisSection = this.getSection();
        IPv6AddressSection[] sections = thisSection.subtract(other.getSection());
        if (sections == null) {
            return null;
        }
        IPv6Address[] result = new IPv6Address[sections.length];
        int i = 0;
        while (i < result.length) {
            result[i] = network.getAddressCreator().createAddress(sections[i], this.zone);
            ++i;
        }
        return result;
    }

    @Override
    public IPv6Address toSubnet(int networkPrefixLength) throws IPAddressTypeException {
        IPv6AddressSection subnetSection;
        IPv6AddressSection thisSection = this.getSection();
        if (thisSection == (subnetSection = thisSection.toSubnet(networkPrefixLength))) {
            return this;
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = network.getAddressCreator();
        return creator.createAddress(subnetSection);
    }

    @Override
    public IPv6Address toSubnet(IPAddress mask) throws IPAddressTypeException {
        return this.toSubnet(mask, null);
    }

    @Override
    public IPv6Address toSubnet(IPAddress mask, Integer networkPrefixLength) throws IPAddressTypeException {
        IPv6AddressSection subnetSection;
        IPv6AddressSection thisSection = this.getSection();
        if (thisSection == (subnetSection = thisSection.toSubnet(mask.getSection(), networkPrefixLength))) {
            return this;
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = network.getAddressCreator();
        return creator.createAddress(subnetSection);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        return this.getSection().getNetworkSection(networkPrefixLength, withPrefixLength);
    }

    @Override
    public IPv6AddressSection getNetworkSection() {
        if (this.isPrefixed()) {
            return this.getNetworkSection(this.getNetworkPrefixLength(), true);
        }
        return this.getNetworkSection(this.getBitCount(), true);
    }

    @Override
    public IPv6AddressSection getHostSection(int networkPrefixLength) {
        return this.getSection().getHostSection(networkPrefixLength);
    }

    @Override
    public IPv6AddressSection getHostSection() {
        if (this.isPrefixed()) {
            return this.getHostSection(this.getNetworkPrefixLength());
        }
        return this.getHostSection(0);
    }

    public boolean hasZone() {
        return this.zone.length() > 0;
    }

    public String getZone() {
        return this.zone;
    }

    public IPv6Address removeZone() {
        return network.getAddressCreator().createAddress(this.getSection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Inet6Address toInetAddress() {
        Inet6Address result = (Inet6Address)this.inetAddress;
        if (result == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                result = (Inet6Address)this.inetAddress;
                if (result == null) {
                    byte[] bytes = this.getBytes();
                    try {
                        if (this.hasZone()) {
                            try {
                                int scopeId = Integer.valueOf(this.zone);
                                result = Inet6Address.getByAddress(null, bytes, scopeId);
                            }
                            catch (NumberFormatException e) {
                                result = (Inet6Address)InetAddress.getByName(this.toNormalizedString());
                            }
                        } else {
                            result = (Inet6Address)InetAddress.getByAddress(bytes);
                        }
                    }
                    catch (UnknownHostException e) {
                        result = null;
                    }
                    this.inetAddress = result;
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.hasZone()) {
            result *= this.zone.hashCode();
        }
        return result;
    }

    @Override
    public boolean isSameAddress(IPAddress other) {
        if (super.isSameAddress(other)) {
            IPv6Address otherIPv6Address = other.toIPv6();
            String otherZone = otherIPv6Address.zone;
            return this.zone.equals(otherZone);
        }
        return false;
    }

    @Override
    public boolean contains(IPAddress other) {
        if (super.contains(other)) {
            if (other != this) {
                IPv6Address otherIPv6Address = other.toIPv6();
                String otherZone = otherIPv6Address.zone;
                return this.zone.equals(otherZone);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                block6: {
                    if (this.stringCache != null) break block6;
                    if (!this.hasZone()) {
                        IPv6AddressSection section = this.getSection();
                        boolean result = section.hasNoStringCache();
                        this.stringCache = section.stringCache;
                        return result;
                    }
                    this.stringCache = new IPv6AddressSection.IPv6StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    public String toMixedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.mixedString) == null) {
            if (this.hasZone()) {
                this.stringCache.mixedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.mixedParams);
            } else {
                result = this.getSection().toMixedString();
            }
        }
        return result;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.canonicalParams);
            } else {
                result = this.getSection().toCanonicalString();
            }
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.fullString) == null) {
            if (this.hasZone()) {
                this.stringCache.fullString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.fullParams);
            } else {
                result = this.getSection().toFullString();
            }
        }
        return result;
    }

    @Override
    public String toNormalizedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.normalizedParams);
            } else {
                result = this.getSection().toNormalizedString();
            }
        }
        return result;
    }

    @Override
    public String toCompressedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedString) == null) {
            if (this.hasZone()) {
                this.stringCache.compressedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.compressedParams);
            } else {
                result = this.getSection().toCompressedString();
            }
        }
        return result;
    }

    @Override
    public String toSubnetString() {
        return this.toNetworkPrefixLengthString();
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardNormalizedParams);
            } else {
                result = this.getSection().toNormalizedWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toCanonicalWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCanonicalParams);
            } else {
                result = this.getSection().toCanonicalWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toCompressedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.compressedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCompressedParams);
            } else {
                result = this.getSection().toCompressedWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.sqlWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.sqlWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.sqlWildcardParams);
            } else {
                result = this.getSection().toSQLWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toHexString(boolean withPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = withPrefix ? this.stringCache.hexStringPrefixed : this.stringCache.hexString) == null) {
            if (this.hasZone()) {
                result = this.getSection().toHexString(withPrefix, this.zone);
                if (withPrefix) {
                    this.stringCache.hexStringPrefixed = result;
                } else {
                    this.stringCache.hexString = result;
                }
            } else {
                result = this.getSection().toHexString(withPrefix);
            }
        }
        return result;
    }

    @Override
    public String toNetworkPrefixLengthString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.networkPrefixLengthString) == null) {
            if (this.hasZone()) {
                this.stringCache.networkPrefixLengthString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.networkPrefixLengthParams);
            } else {
                result = this.getSection().toNetworkPrefixLengthString();
            }
        }
        return result;
    }

    @Override
    public String toConvertedString() {
        if (this.isIPv4Convertible()) {
            return this.toMixedString();
        }
        return this.toNormalizedString();
    }

    @Override
    public String toNormalizedString(IPAddressSection.StringOptions params) {
        return this.getSection().toNormalizedString(params, this.zone);
    }

    public String toNormalizedString(IPv6AddressSection.IPv6StringOptions params) {
        return this.getSection().toNormalizedString(params, this.zone);
    }

    public String toNormalizedString(boolean keepMixed, IPv6AddressSection.IPv6StringOptions params) {
        if (keepMixed && this.fromString != null && this.fromString.isMixedIPv6() && !params.makeMixed()) {
            params = new IPv6AddressSection.IPv6StringOptions(params.base, params.expandSegments, params.wildcardOptions, params.segmentStrPrefix, true, params.ipv4Opts, params.compressOptions, params.separator, params.zoneSeparator, params.addrPrefix, params.addrSuffix, params.reverse, params.splitDigits, params.uppercase);
        }
        return this.toNormalizedString(params);
    }

    @Override
    public String toUNCHostName() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.uncString) == null) {
            this.stringCache.uncString = result = this.getSection().toNormalizedString(IPv6AddressSection.IPv6StringCache.uncParams, this.zone.replace('%', 's').replace(':', '-'));
        }
        return result;
    }

    @Override
    public String toReverseDNSLookupString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.reverseDNSString) == null) {
            this.stringCache.reverseDNSString = result = this.getSection().toNormalizedString(IPv6AddressSection.IPv6StringCache.reverseDNSParams, "");
        }
        return result;
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.from(opts));
    }

    private IPv4Address getConverted(IPv6AddressSection.IPv6StringBuilderOptions opts) {
        if (!this.hasZone() && opts.includes(65536)) {
            IPv4Address.IPv4AddressConverter converter = opts.converter;
            return converter.toIPv4(this);
        }
        return null;
    }

    public IPAddressPartStringCollection toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions opts) {
        IPv6AddressSection.IPv6StringCollection coll = this.getSection().toStringCollection(opts, this.zone);
        IPv4Address ipv4Addr = this.getConverted(opts);
        if (ipv4Addr != null) {
            IPAddressPartStringCollection ipv4StringCollection = ipv4Addr.toStringCollection(opts.ipv4ConverterOptions);
            coll.addAll(ipv4StringCollection);
        }
        return coll;
    }

    public static /* bridge */ /* synthetic */ IPAddress from(byte[] byArray, byte[] byArray2, Integer n, String string) {
        return IPv6Address.from(byArray, byArray2, n, string);
    }

    public static interface IPv6AddressConverter {
        public IPv6Address toIPv6(IPAddress var1);
    }
}

