/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.util.IPAddressPartStringParams;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.util.sql.SQLStringMatcher;

public class IPAddressPartConfiguredString<T extends IPAddressPart, P extends IPAddressPartStringParams<T>> {
    public final T addr;
    public final P stringParams;
    protected String string;

    public IPAddressPartConfiguredString(T addr, P stringParams) {
        this.stringParams = stringParams;
        this.addr = addr;
    }

    public int getTrailingSeparatorCount() {
        return ((IPAddressPartStringParams)this.stringParams).getTrailingSeparatorCount(this.addr);
    }

    public char getTrailingSegmentSeparator() {
        return ((IPAddressPartStringParams)this.stringParams).getTrailingSegmentSeparator();
    }

    public <S extends IPAddressPartConfiguredString<T, P>> SQLStringMatcher<T, P, S> getNetworkStringMatcher(boolean isEntireAddress, IPAddressSQLTranslator translator) {
        return new SQLStringMatcher(this, isEntireAddress, translator);
    }

    public String getString() {
        if (this.string == null) {
            this.string = ((IPAddressPartStringParams)this.stringParams).toString(this.addr);
        }
        return this.string;
    }

    public String toString() {
        return this.getString();
    }
}

