/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressComparator;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressJoinedSegments;
import inet.ipaddr.format.IPAddressSegmentGrouping;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv4.IPv4JoinedSegments;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;

abstract class BaseComparator
implements IPAddressComparator {
    BaseComparator() {
    }

    @Override
    public int compare(IPAddress one, IPAddress two) {
        if (one == two) {
            return 0;
        }
        if (!one.getIPVersion().equals((Object)two.getIPVersion())) {
            return one.getIPVersion().ordinal() - two.getIPVersion().ordinal();
        }
        int result = this.compare(one.getSection(), two.getSection());
        if (result == 0 && one.isIPv6()) {
            IPv6Address oneIPv6 = (IPv6Address)one;
            IPv6Address twoIPv6 = (IPv6Address)two;
            result = oneIPv6.getZone().compareTo(twoIPv6.getZone());
        }
        return result;
    }

    private static int mapGroupingClass(Class<? extends IPAddressSegmentGrouping> clazz) {
        if (clazz.equals(IPAddressSegmentGrouping.class)) {
            return 1;
        }
        if (clazz.equals(IPv4AddressSection.class)) {
            return 2;
        }
        if (clazz.equals(IPv6AddressSection.IPv6v4MixedAddressSection.class)) {
            return 3;
        }
        if (clazz.equals(IPv6AddressSection.class)) {
            return 4;
        }
        return 0;
    }

    private static int mapDivisionClass(Class<? extends IPAddressDivision> clazz) {
        if (clazz.equals(IPv4JoinedSegments.class)) {
            return 1;
        }
        if (clazz.equals(IPv4AddressSegment.class)) {
            return 2;
        }
        if (clazz.equals(IPv6AddressSegment.class)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int compare(IPAddressSegmentGrouping one, IPAddressSegmentGrouping two) {
        Class<?> twoClass;
        if (one == two) {
            return 0;
        }
        Class<?> oneClass = one.getClass();
        if (!oneClass.equals(twoClass = two.getClass())) {
            return BaseComparator.mapGroupingClass(oneClass) - BaseComparator.mapGroupingClass(twoClass);
        }
        if (one instanceof IPv6AddressSection) {
            IPv6AddressSection o1 = (IPv6AddressSection)one;
            IPv6AddressSection o2 = (IPv6AddressSection)two;
            int result = o2.startIndex - o1.startIndex;
            if (result != 0) {
                return result;
            }
        }
        return this.compareParts(one, two);
    }

    @Override
    public int compare(IPAddressDivision one, IPAddressDivision two) {
        Class<?> twoClass;
        if (one == two) {
            return 0;
        }
        Class<?> oneClass = one.getClass();
        if (!oneClass.equals(twoClass = two.getClass())) {
            return BaseComparator.mapDivisionClass(oneClass) - BaseComparator.mapDivisionClass(twoClass);
        }
        if (one instanceof IPAddressJoinedSegments) {
            IPAddressJoinedSegments o1 = (IPAddressJoinedSegments)one;
            IPAddressJoinedSegments o2 = (IPAddressJoinedSegments)two;
            int result = o1.getJoinedCount() - o2.getJoinedCount();
            if (result != 0) {
                return result;
            }
        }
        return BaseComparator.convertResult(this.compareValues(one.getUpperValue(), one.getLowerValue(), two.getUpperValue(), two.getLowerValue()));
    }

    protected abstract int compareParts(IPAddressSegmentGrouping var1, IPAddressSegmentGrouping var2);

    protected abstract long compareValues(long var1, long var3, long var5, long var7);

    static int convertResult(long v) {
        return v == 0L ? 0 : (v > 0L ? 1 : -1);
    }
}

